/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.search;

import com.ampiere.dto.CodeValue;
import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.struts.common.PopupBaseAction;
import com.ampiere.web.struts.search.LocationActionForm;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.GridField;
import org.compiere.model.MCountry;
import org.compiere.model.MLocation;
import org.compiere.model.MRegion;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

public class LocationAction
extends PopupBaseAction {
    protected CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public ActionForward doExecute(ActionMapping mapping, ActionForm baseForm, HttpServletRequest request, HttpServletResponse response, ActionErrors errors, boolean mochaFlag) throws Exception {
        request.setAttribute("locationInit", (Object)"");
        LocationActionForm locationActionForm = (LocationActionForm)baseForm;
        if (locationActionForm != null) {
            int countryId = locationActionForm.getCountryId();
            String columnName = locationActionForm.getColumnName();
            String locationOption = locationActionForm.getLocationOption();
            locationActionForm.setLocationOption("");
            locationActionForm.setLocationId("");
            locationActionForm.setLocationName("");
            WebSessionCtx wsc = WebSessionCtx.get(request);
            WWindowStatus ws = WWindowStatus.get(request);
            if (wsc != null && columnName != null && ws != null) {
                GridField mField = ws.getCurTab().getField(columnName);
                MLocation location = null;
                Object value = mField.getValue();
                if (value != null && value instanceof Integer) {
                    location = new MLocation(wsc.ctx, (Integer)value, null);
                }
                if (location == null) {
                    location = new MLocation(wsc.ctx, 0, null);
                }
                String postalId = locationActionForm.getPostalId();
                locationActionForm.setPostalId("");
                String fpostal = locationActionForm.getFpostal();
                String fpostalAdd = locationActionForm.getFpostalAdd();
                String faddress2 = locationActionForm.getFaddress2();
                String faddress3 = locationActionForm.getFaddress3();
                String faddress4 = locationActionForm.getFaddress4();
                MCountry.setDisplayLanguage(Env.getAD_Language(wsc.ctx));
                MCountry[] pCountry = MCountry.getCountries(wsc.ctx);
                ArrayList<CodeValue> countryList = new ArrayList<CodeValue>();
                for (int i2 = 0; i2 < pCountry.length; ++i2) {
                    countryList.add(new CodeValue(Integer.toString(pCountry[i2].getC_Country_ID()), pCountry[i2].getName()));
                }
                locationActionForm.setCountryList(countryList);
                MCountry country = null;
                if (countryId != 0) {
                    country = MCountry.get(wsc.ctx, countryId);
                }
                if (country != null) {
                    location.setCountry(country);
                }
                if ("save".equals(locationOption)) {
                    location.setAddress1(locationActionForm.getFaddress1());
                    location.setAddress2(locationActionForm.getFaddress2());
                    location.setAddress3(locationActionForm.getFaddress3());
                    location.setAddress4(locationActionForm.getFaddress4());
                    location.setCity(locationActionForm.getFcity());
                    location.setPostal(locationActionForm.getFpostal());
                    location.setPostal_Add(locationActionForm.getFpostalAdd());
                    location.setCountry(country);
                    if (location.getCountry().isHasRegion()) {
                        MRegion region = MRegion.get(wsc.ctx, Integer.parseInt(locationActionForm.getRegionSelected()));
                        location.setRegion(region);
                    } else {
                        location.setC_Region_ID(0);
                    }
                    location.save();
                    request.setAttribute("locationInit", (Object)"close");
                    locationActionForm.setLocationId(Integer.toString(location.getC_Location_ID()));
                    locationActionForm.setLocationName(location.toString());
                } else {
                    countryId = location.getCountry().getC_Country_ID();
                    locationActionForm.setCountryId(countryId);
                    locationActionForm.setAddressLinesLocalReverse(location.getCountry().isAddressLinesLocalReverse());
                    request.setAttribute("addressLinesLocalReverse", (Object)(location.getCountry().isAddressLinesLocalReverse() ? "true" : "false"));
                    MRegion[] pRegion = MRegion.getRegions(wsc.ctx, countryId);
                    ArrayList<CodeValue> regionList = new ArrayList<CodeValue>();
                    for (int i3 = 0; i3 < pRegion.length; ++i3) {
                        regionList.add(new CodeValue(Integer.toString(pRegion[i3].getC_Region_ID()), pRegion[i3].getName()));
                    }
                    locationActionForm.setRegionList(regionList);
                    if (location.getC_Location_ID() != 0) {
                        locationActionForm.setFaddress1(location.getAddress1());
                        locationActionForm.setFaddress2(location.getAddress2());
                        locationActionForm.setFaddress3(location.getAddress3());
                        locationActionForm.setFaddress4(location.getAddress4());
                        locationActionForm.setFcity(location.getCity());
                        locationActionForm.setFpostal(location.getPostal());
                        locationActionForm.setFpostalAdd(location.getPostal_Add());
                        if (location.getCountry().isHasRegion() && location.getRegion() != null) {
                            locationActionForm.setRegionSelected(Integer.toString(location.getRegion().getC_Region_ID()));
                        }
                    }
                    locationActionForm.setCountrySelected(Integer.toString(countryId));
                    this.setLocationFlags(location.getCountry(), request);
                    if (location.getC_Location_ID() == 0) {
                        locationActionForm.setTitle(Msg.translate(wsc.ctx, "LocationNew"));
                    } else {
                        locationActionForm.setTitle(Msg.translate(wsc.ctx, "LocationUpdate"));
                    }
                    locationActionForm.setCloseBtnTitle(Msg.translate(wsc.ctx, "Cancel"));
                    locationActionForm.setSubmitBtnTitle(Msg.translate(wsc.ctx, "OK"));
                    locationActionForm.setLaddress1(Msg.translate(wsc.ctx, "Address") + " 1");
                    locationActionForm.setLaddress2(Msg.translate(wsc.ctx, "Address") + " 2");
                    locationActionForm.setLaddress3(Msg.translate(wsc.ctx, "Address") + " 3");
                    locationActionForm.setLaddress4(Msg.translate(wsc.ctx, "Address") + " 4");
                    locationActionForm.setLcity(Msg.translate(wsc.ctx, "City"));
                    locationActionForm.setLcountry(Msg.translate(wsc.ctx, "Country"));
                    locationActionForm.setLregion(Msg.translate(wsc.ctx, "Region"));
                    if (location.getCountry().isHasRegion()) {
                        locationActionForm.setLregion(location.getCountry().getRegionName());
                    }
                    locationActionForm.setLpostal(Msg.translate(wsc.ctx, "Postal"));
                    locationActionForm.setLpostalAdd(Msg.translate(wsc.ctx, "PostalAdd"));
                    locationActionForm.setLpostalLookup(Msg.translate(wsc.ctx, "PostalLookup"));
                    if ("change".equals(locationOption)) {
                        locationActionForm.setFpostal(fpostal);
                        locationActionForm.setFpostalAdd(fpostalAdd);
                        locationActionForm.setFaddress2(faddress2);
                        locationActionForm.setFaddress3(faddress3);
                        locationActionForm.setFaddress4(faddress4);
                        if (!this.action_PostalLookup(wsc.ctx, postalId, fpostal, fpostalAdd, locationActionForm, location)) {
                            request.setAttribute("locationInit", (Object)"popup");
                        }
                    }
                }
            }
        }
        return mapping.findForward("success");
    }

    private boolean action_PostalLookup(Properties ctx, String postalId, String fPostal, String fPostalAdd, LocationActionForm locationActionForm, MLocation location) {
        ResultSet rs;
        CPreparedStatement pstmt = null;
        StringBuffer sql = null;
        if (postalId != null && postalId.length() > 0) {
            Integer id = Integer.parseInt(postalId);
            pstmt = null;
            sql = new StringBuffer("SELECT SUBSTR(POSTAL, 1, 3) AS POSTAL, SUBSTR(POSTAL, 4, 4) AS POSTALADD,  C_REGION_ID, X_CITY_NAME, X_ADDRESS FROM X_POSTAL WHERE IsActive='Y' AND C_COUNTRY_ID=" + location.getC_Country_ID());
            sql.append(" AND X_POSTAL_ID=" + id);
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                ResultSet rs2 = pstmt.executeQuery();
                if (rs2.next()) {
                    String x_Postal = rs2.getString(1);
                    String x_PostalAdd = rs2.getString(2);
                    locationActionForm.setFpostal(x_Postal);
                    locationActionForm.setFpostalAdd(x_PostalAdd);
                    int c_Region_ID = rs2.getInt(3);
                    String x_City_Name = rs2.getString(4);
                    String x_Address = rs2.getString(5);
                    MRegion region = MRegion.get(ctx, c_Region_ID);
                    locationActionForm.setRegionSelected(Integer.toString(region.getC_Region_ID()));
                    locationActionForm.setFcity(x_City_Name);
                    String oldAddress = locationActionForm.getFaddress1();
                    if (oldAddress == null || !oldAddress.startsWith(x_Address)) {
                        locationActionForm.setFaddress1(x_Address);
                    }
                }
                rs2.close();
                pstmt.close();
                pstmt = null;
                return true;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), e);
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception pe) {
                    // empty catch block
                }
                pstmt = null;
            }
        }
        fPostal = fPostal.trim();
        fPostalAdd = fPostalAdd.trim();
        String value = fPostal + fPostalAdd;
        int count = 0;
        sql = new StringBuffer("SELECT COUNT(X_POSTAL_ID)  FROM X_POSTAL WHERE IsActive='Y' AND C_COUNTRY_ID=" + location.getC_Country_ID());
        sql.append(" AND POSTAL like '" + value + "%'");
        try {
            pstmt = DB.prepareStatement(sql.toString(), null);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception pe) {
                // empty catch block
            }
            pstmt = null;
        }
        if (count == 1) {
            pstmt = null;
            sql = new StringBuffer("SELECT C_REGION_ID, X_CITY_NAME, X_ADDRESS FROM X_POSTAL WHERE IsActive='Y' AND C_COUNTRY_ID=" + location.getC_Country_ID());
            sql.append(" AND POSTAL like '" + value + "%'");
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    int c_Region_ID = rs.getInt(1);
                    String x_City_Name = rs.getString(2);
                    String x_Address = rs.getString(3);
                    MRegion region = MRegion.get(ctx, c_Region_ID);
                    locationActionForm.setRegionSelected(Integer.toString(region.getC_Region_ID()));
                    locationActionForm.setFcity(x_City_Name);
                    String oldAddress = locationActionForm.getFaddress1();
                    if (oldAddress == null || !oldAddress.startsWith(x_Address)) {
                        locationActionForm.setFaddress1(x_Address);
                    }
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), e);
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception pe) {
                    // empty catch block
                }
                pstmt = null;
            }
            return true;
        }
        return false;
    }

    private void setLocationFlags(MCountry country, HttpServletRequest request) {
        request.setAttribute("city", (Object)"false");
        request.setAttribute("postal", (Object)"false");
        request.setAttribute("postalAdd", (Object)"false");
        request.setAttribute("region", (Object)"false");
        String ds = country.getDisplaySequence();
        if (ds == null || ds.length() == 0) {
            this.log.log(Level.SEVERE, "DisplaySequence empty - " + country);
            ds = "";
        }
        StringTokenizer st = new StringTokenizer(ds, "@", false);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("C")) {
                request.setAttribute("city", (Object)"true");
                continue;
            }
            if (s.startsWith("P")) {
                request.setAttribute("postal", (Object)"true");
                continue;
            }
            if (s.startsWith("A")) {
                request.setAttribute("postalAdd", (Object)"true");
                continue;
            }
            if (!s.startsWith("R") || !country.isHasRegion()) continue;
            request.setAttribute("region", (Object)"true");
        }
    }
}

