/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.ChargeAccountForm;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MForm;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

public class ChargeAccount
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String ACCOUNT_LIST = "accountlist";
    private static final String ACTION_FORM = "ChargeAccountForm";
    private static final String ERROR_FORWARD = "error";
    private static final int FORM_ID = 105;

    public final ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.log.fine("Begin " + ((Object)((Object)this)).getClass().getName() + ";execute");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        MForm form2 = this.getForm(wsc.ctx, 105);
        Env.setContext(wsc.ctx, "FormName", form2.getName());
        ChargeAccountForm myForm = (ChargeAccountForm)request.getAttribute(ACTION_FORM);
        if (myForm == null && (myForm = (ChargeAccountForm)actionForm) == null) {
            myForm = new ChargeAccountForm();
        }
        myForm.setMainWindowTitle(form2.getName() + " - " + wsc.loginInfo);
        myForm.setPageTitle(form2.getName());
        myForm.setChargeNewLabel(Msg.translate(wsc.ctx, "ChargeNewAccount"));
        myForm.setKeyLabel(Msg.translate(wsc.ctx, "Value"));
        myForm.setExpenseLabel(Msg.translate(wsc.ctx, "Expense"));
        myForm.setExpense("on");
        myForm.setNameLabel(Msg.translate(wsc.ctx, "Name"));
        myForm.setGenerateLabel(Msg.translate(wsc.ctx, "Create"));
        myForm.setChargeFromLabel(Msg.translate(wsc.ctx, "ChargeFromAccount"));
        myForm.setAccountList(this.getAccountList(wsc));
        request.setAttribute(ACTION_FORM, (Object)myForm);
        this.log.fine("End " + ((Object)((Object)this)).getClass().getName() + ";execute");
        return mapping.findForward(ACCOUNT_LIST);
    }

    private ArrayList getAccountList(WebSessionCtx wsc) {
        ResultSet rs;
        CPreparedStatement pstmt;
        ArrayList dataList = new ArrayList();
        HashMap<String, Object> data = new HashMap<String, Object>();
        int accountSchemaId = Env.getContextAsInt(wsc.ctx, "$C_AcctSchema_ID");
        int accountElementId = 0;
        String sql = "SELECT C_Element_ID FROM C_AcctSchema_Element WHERE ElementType='AC' AND C_AcctSchema_ID=?";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, accountSchemaId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                accountElementId = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        if (accountElementId == 0) {
            return dataList;
        }
        Env.setContext(wsc.ctx, 0, "AccountElementId", accountElementId);
        data.put("RowType", "title");
        data.put("Select", Msg.getMsg(wsc.ctx, "Select"));
        data.put("Value", Msg.translate(wsc.ctx, "Value"));
        data.put("Name", Msg.translate(wsc.ctx, "Name"));
        data.put("Expense", Msg.getMsg(wsc.ctx, "Expense"));
        dataList.add(data);
        sql = "SELECT C_ElementValue_ID,Value, Name, AccountType FROM C_ElementValue WHERE AccountType IN ('R','E') AND IsSummary='N' AND C_Element_ID=? ORDER BY 2";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, accountElementId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                data = new HashMap();
                data.put("RowType", "data");
                data.put("Select", rs.getInt(1));
                data.put("Value", rs.getInt(2));
                data.put("Name", rs.getString(3));
                data.put("Expense", new Boolean(rs.getString(4).equals("E")));
                dataList.add(data);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        int clientId = Env.getAD_Client_ID(wsc.ctx);
        int taxCategoryId = 0;
        sql = "SELECT C_TaxCategory_ID FROM C_TaxCategory WHERE IsDefault='Y' AND AD_Client_ID=?";
        try {
            CPreparedStatement pstmt2 = DB.prepareStatement(sql, null);
            pstmt2.setInt(1, clientId);
            ResultSet rs2 = pstmt2.executeQuery();
            if (rs2.next()) {
                taxCategoryId = rs2.getInt(1);
            }
            rs2.close();
            pstmt2.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        Env.setContext(wsc.ctx, 0, "TaxCategoryID", taxCategoryId);
        return dataList;
    }

    private MForm getForm(Properties ctx, int formId) {
        boolean trl;
        MForm form2 = new MForm(ctx, formId, null);
        boolean bl = trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help FROM AD_Form f INNER JOIN AD_Form_Trl t ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)WHERE f.AD_Form_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language(ctx));
                    pstmt.setInt(2, formId);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form2.setName(rs.getString(1));
                        form2.setDescription(rs.getString(2));
                        form2.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
        }
        return form2;
    }
}

