/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.button;

import com.ampiere.dto.CodeValue;
import com.ampiere.search.ColBean;
import com.ampiere.web.struts.button.CreateFromBaseForm;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPayment;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateFromStatementForm
extends CreateFromBaseForm {
    private static final long serialVersionUID = -5995431459161202272L;
    protected String bankAccountLabel;
    protected String bankAccountSelected;
    protected List<CodeValue> bankAccountList;

    public void statInit(Properties ctx, Timestamp ts, int maxRecNo) {
        super.statInit(ctx);
        this.setTitle(Msg.translate(ctx, "C_BankStatement_ID") + " .. " + Msg.translate(ctx, "CreateFrom"));
        this.setBankAccountLabel(Msg.translate(ctx, "C_BankAccount_ID"));
        this.bankAccountList = new ArrayList<CodeValue>();
        this.bankAccountList.add(new CodeValue("0", ""));
        int AD_Column_ID = 4917;
        MLookup lookup = MLookupFactory.get(ctx, this.getWindowNo(), 0, AD_Column_ID, 19);
        ArrayList<Object> lst = lookup.getData(true, false, false, false);
        for (int i2 = 0; i2 < lst.size(); ++i2) {
            KeyNamePair knp = (KeyNamePair)lst.get(i2);
            if (knp == null) continue;
            String key = Integer.toString(knp.getKey());
            String name = knp.getName();
            this.bankAccountList.add(new CodeValue(key, name));
        }
        this.bankAccountSelected = "0";
    }

    protected void initBPDetails(int C_BPartner_ID) {
    }

    public List loadBankAccount(int C_BankAccount_ID, Properties ctx, Timestamp ts, int maxRecNo) {
        this.log.config("C_BankAccount_ID=" + C_BankAccount_ID);
        String sql = "SELECT p.DateTrx,p.C_Payment_ID,p.DocumentNo, p.C_Currency_ID,c.ISO_Code, p.PayAmt,currencyConvert(p.PayAmt,p.C_Currency_ID,ba.C_Currency_ID,?,null,p.AD_Client_ID,p.AD_Org_ID), bp.Name FROM C_BankAccount ba INNER JOIN C_Payment_v p ON (p.C_BankAccount_ID=ba.C_BankAccount_ID) INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID) INNER JOIN C_BPartner bp ON (p.C_BPartner_ID=bp.C_BPartner_ID) WHERE p.Processed='Y' AND p.IsReconciled='N' AND p.DocStatus IN ('CO','CL','RE') AND p.PayAmt<>0 AND p.C_BankAccount_ID=? AND NOT EXISTS (SELECT * FROM C_BankStatementLine l WHERE p.C_Payment_ID=l.C_Payment_ID AND l.StmtAmt <> 0)";
        if (ts == null) {
            ts = new Timestamp(System.currentTimeMillis());
        }
        ArrayList<ColBean> resultList = new ArrayList<ColBean>();
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setTimestamp(1, ts);
            pstmt.setInt(2, C_BankAccount_ID);
            ResultSet rs = pstmt.executeQuery();
            int lineCount = 0;
            while (rs.next()) {
                ColBean colBean = new ColBean();
                colBean.setColId(Integer.toString(lineCount));
                int beanOffset = 0;
                if (++lineCount > maxRecNo) break;
                colBean.setColData(beanOffset, "false");
                colBean.setColTitle(beanOffset, Msg.translate(ctx, "Select"));
                colBean.setStyle(beanOffset, "text-align: center;");
                colBean.setColData(++beanOffset, rs.getTimestamp(1));
                colBean.setColTitle(beanOffset, Msg.translate(ctx, "Date"));
                colBean.setStyle(beanOffset, "text-align: left;");
                KeyNamePair pp = new KeyNamePair(rs.getInt(2), rs.getString(3));
                colBean.setColData(++beanOffset, pp);
                colBean.setColTitle(beanOffset, Msg.translate(ctx, "C_Payment_ID"));
                colBean.setStyle(beanOffset, "text-align: left;");
                pp = new KeyNamePair(rs.getInt(4), rs.getString(5));
                colBean.setColData(++beanOffset, pp);
                colBean.setColTitle(beanOffset, Msg.translate(ctx, "C_Currency_ID"));
                colBean.setStyle(beanOffset, "text-align: left;");
                colBean.setColData(++beanOffset, rs.getBigDecimal(6));
                colBean.setColTitle(beanOffset, Msg.translate(ctx, "Amount"));
                colBean.setStyle(beanOffset, "text-align: right;");
                colBean.setColData(++beanOffset, rs.getBigDecimal(7));
                colBean.setColTitle(beanOffset, Msg.translate(ctx, "ConvertedAmount"));
                colBean.setStyle(beanOffset, "text-align: right;");
                colBean.setColData(++beanOffset, rs.getBigDecimal(8));
                colBean.setColTitle(beanOffset, Msg.translate(ctx, "C_BPartner_ID"));
                colBean.setStyle(beanOffset, "text-align: left;");
                ++beanOffset;
                resultList.add(colBean);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return resultList;
    }

    protected boolean save(Properties ctx, int C_BankStatement_ID, List resultList) {
        this.log.config("");
        MBankStatement bs = new MBankStatement(ctx, C_BankStatement_ID, null);
        this.log.config(bs.toString());
        if (this.selectedIndex == null || this.selectedIndex.length() <= 0) {
            return false;
        }
        String[] ppp = this.selectedIndex.split("\\,");
        if (ppp == null || ppp.length <= 0) {
            return false;
        }
        for (int i2 = 0; i2 < ppp.length; ++i2) {
            int idx = Integer.parseInt(ppp[i2]);
            ColBean colBean = (ColBean)resultList.get(idx);
            if (colBean == null) continue;
            Timestamp trxDate = (Timestamp)colBean.getColData(1);
            KeyNamePair pp = (KeyNamePair)colBean.getColData(2);
            int C_Payment_ID = pp.getKey();
            pp = (KeyNamePair)colBean.getColData(3);
            int C_Currency_ID = pp.getKey();
            BigDecimal TrxAmt = (BigDecimal)colBean.getColData(4);
            this.log.fine("Line Date=" + trxDate + ", Payment=" + C_Payment_ID + ", Currency=" + C_Currency_ID + ", Amt=" + TrxAmt);
            MBankStatementLine bsl = new MBankStatementLine(bs);
            bsl.setStatementLineDate(trxDate);
            bsl.setPayment(new MPayment(ctx, C_Payment_ID, null));
            if (bsl.save()) continue;
            this.log.log(Level.SEVERE, "Line not created #" + i2);
        }
        return true;
    }

    public String getBankAccountLabel() {
        return this.bankAccountLabel;
    }

    public void setBankAccountLabel(String bankAccountLabel) {
        this.bankAccountLabel = bankAccountLabel;
    }

    public List<CodeValue> getBankAccountList() {
        return this.bankAccountList;
    }

    public void setBankAccountList(List<CodeValue> bankAccountList) {
        this.bankAccountList = bankAccountList;
    }

    public String getBankAccountSelected() {
        return this.bankAccountSelected;
    }

    public void setBankAccountSelected(String bankAccountSelected) {
        this.bankAccountSelected = bankAccountSelected;
    }
}

