/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.ajax;

import com.ampiere.dto.SimpleBean;
import com.ampiere.util.ajax.AjaxXmlItemBuilder;
import com.ampiere.util.ajax.AjaxXmlMultiItemsBuider;
import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.struts.ajax.BaseAjaxActionEx;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.compiere.util.CLogger;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WLoginAjaxAction
extends BaseAjaxActionEx {
    protected CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public String getXmlContent(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response, Map param) throws Exception {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null || ws == null) {
            // empty if block
        }
        Login login = new Login(wsc.ctx);
        String strRole = WebUtil.getParameter(request, "role");
        String strClient = WebUtil.getParameter(request, "client");
        String strOrg = WebUtil.getParameter(request, "org");
        List listClient = null;
        List listOrg = null;
        List listWarehouse = null;
        if (strRole != null && strRole.length() > 0) {
            KeyNamePair[] clients = this.makeClients(login, strRole);
            listClient = this.makeList(clients);
            KeyNamePair[] orgs = null;
            if (clients == null || clients.length < 1) {
                listOrg = this.makeList(null);
            } else {
                orgs = this.makeOrgs(login, clients[0].getID());
                listOrg = this.makeList(orgs);
            }
            if (orgs == null || orgs.length < 1) {
                listWarehouse = this.makeList(null);
            } else {
                KeyNamePair[] whs = this.makeWarehouses(login, orgs[0].getID());
                listWarehouse = this.makeList(whs);
            }
        } else if (strClient != null && strClient.length() > 0) {
            KeyNamePair[] orgs = this.makeOrgs(login, strClient);
            listOrg = this.makeList(orgs);
            if (orgs == null || orgs.length < 1) {
                listWarehouse = this.makeList(null);
            } else {
                KeyNamePair[] whs = this.makeWarehouses(login, orgs[0].getID());
                listWarehouse = this.makeList(whs);
            }
        } else if (strOrg != null && strOrg.length() > 0) {
            KeyNamePair[] whs = this.makeWarehouses(login, strOrg);
            listWarehouse = this.makeList(whs);
        }
        String strRVal = "";
        try {
            AjaxXmlItemBuilder ajaxBuilder = null;
            AjaxXmlMultiItemsBuider ajaxXmlCalloutBuider = new AjaxXmlMultiItemsBuider();
            if (listClient != null) {
                ajaxBuilder = new AjaxXmlItemBuilder();
                ajaxBuilder.putInfo("tagname", "select");
                ajaxBuilder.putInfo("type", "none");
                ajaxBuilder.putInfo("id", "AD_Client_IDF");
                ajaxBuilder.addItems(listClient, "value", "key");
                ajaxXmlCalloutBuider.addTarget(ajaxBuilder);
            }
            if (listOrg != null) {
                ajaxBuilder = new AjaxXmlItemBuilder();
                ajaxBuilder.putInfo("tagname", "select");
                ajaxBuilder.putInfo("type", "none");
                ajaxBuilder.putInfo("id", "AD_Org_IDF");
                ajaxBuilder.addItems(listOrg, "value", "key");
                ajaxXmlCalloutBuider.addTarget(ajaxBuilder);
            }
            if (listWarehouse != null) {
                ajaxBuilder = new AjaxXmlItemBuilder();
                ajaxBuilder.putInfo("tagname", "select");
                ajaxBuilder.putInfo("type", "none");
                ajaxBuilder.putInfo("id", "M_Warehouse_IDF");
                ajaxBuilder.addItems(listWarehouse, "value", "key");
                ajaxXmlCalloutBuider.addTarget(ajaxBuilder);
            }
            strRVal = ajaxXmlCalloutBuider.toString();
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "On get Organization.", e);
        }
        return strRVal;
    }

    private KeyNamePair[] makeClients(Login login, String strRole) {
        KeyNamePair[] clients = null;
        try {
            clients = login.getClients(new KeyNamePair(Integer.parseInt(strRole), strRole));
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "On get Client. Role=" + strRole, e);
        }
        return clients;
    }

    private KeyNamePair[] makeOrgs(Login login, String strClient) {
        KeyNamePair[] orgs = null;
        try {
            orgs = login.getOrgs(new KeyNamePair(Integer.parseInt(strClient), strClient));
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "On get Org. Client=" + strClient, e);
        }
        return orgs;
    }

    private KeyNamePair[] makeWarehouses(Login login, String strOrg) {
        KeyNamePair[] whs = null;
        try {
            whs = login.getWarehouses(new KeyNamePair(Integer.parseInt(strOrg), strOrg));
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "On get Warehouse. Org=" + strOrg, e);
        }
        return whs;
    }

    private List makeList(KeyNamePair[] pKeyPair) {
        ArrayList<SimpleBean> list = new ArrayList<SimpleBean>();
        if (pKeyPair != null) {
            for (int i2 = 0; i2 < pKeyPair.length; ++i2) {
                KeyNamePair p2 = pKeyPair[i2];
                SimpleBean bean = new SimpleBean(String.valueOf(p2.getKey()), p2.getName());
                list.add(bean);
            }
        }
        return list;
    }
}

