/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AmpiereUtil;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.textarea;
import org.compiere.model.Lookup;
import org.compiere.model.MLocator;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;

public class WebField {
    public static final String C_MANDATORY = "Cmandatory";
    public static final String C_ERROR = "Cerror";
    private WebSessionCtx m_wsc;
    private int m_windowNo;
    private String m_columnName;
    private String m_name;
    private String m_description;
    private int m_displayType;
    private int m_fieldLength;
    private int m_displayLength;
    private boolean m_longField;
    private boolean m_readOnly;
    private boolean m_mandatory;
    private boolean m_error;
    private boolean m_hasDependents;
    private boolean m_hasCallout;
    private int m_processId;
    private boolean m_encryptedField;

    public WebField(int windowNo, WebSessionCtx wsc, String columnName, String name, String description, int displayType, int fieldLength, int displayLength, boolean longField, boolean readOnly, boolean mandatory, boolean error, boolean hasDependents, boolean hasCallout, int AD_Process_ID, boolean encryptedField) {
        this.m_windowNo = windowNo;
        this.m_wsc = wsc;
        this.m_columnName = columnName;
        this.m_name = name == null || name.length() == 0 ? columnName : name;
        if (description != null && description.length() > 0) {
            this.m_description = description;
        }
        this.m_displayType = displayType;
        this.m_fieldLength = fieldLength;
        this.m_displayLength = displayLength;
        if (this.m_displayLength == 0) {
            this.m_displayLength = 160;
        }
        this.m_longField = longField;
        this.m_readOnly = readOnly;
        this.m_mandatory = mandatory;
        this.m_error = error;
        this.m_hasDependents = hasDependents;
        this.m_hasCallout = hasCallout;
        this.m_processId = AD_Process_ID;
        this.m_encryptedField = encryptedField;
    }

    public td getLabel() {
        if (this.m_displayType == 20) {
            return new td(WebEnv.NBSP);
        }
        label myLabel = new label(this.m_columnName + "F", null, Util.maskHTML(this.m_name));
        myLabel.setID(this.m_columnName + "L");
        if (this.m_description != null) {
            myLabel.setTitle(Util.maskHTML(this.m_description));
        }
        td td2 = new td().addElement((Element)myLabel).setAlign("right").setVAlign("top");
        td2.setVAlign("middle");
        td2.setNoWrap(true);
        return td2;
    }

    private td createTD(Element element) {
        td td2 = new td().addElement(element).setAlign("left").setVAlign("top");
        if (this.m_longField) {
            td2.setColSpan(3);
        }
        return td2;
    }

    public td getField(Lookup lookup, Object data, int AD_Column_ID) {
        String dataValue;
        td tdRet = null;
        String string = dataValue = data == null ? "" : data.toString();
        if (this.m_displayType == 30 || this.m_displayType == 21 || this.m_displayType == 25) {
            String dataDisplay = "";
            if (lookup != null && data != null) {
                dataDisplay = lookup.getDisplay(data);
            }
            tdRet = this.getPopupField(dataDisplay, dataValue, AD_Column_ID, lookup);
        } else {
            tdRet = DisplayType.isLookup(this.m_displayType) || this.m_displayType == 31 ? this.getSelectField(lookup, dataValue) : (this.m_displayType == 20 ? this.getCheckField(dataValue) : (this.m_displayType == 28 ? this.getButtonField(dataValue) : (DisplayType.isDate(this.m_displayType) ? this.getDateField(data) : (DisplayType.isNumeric(this.m_displayType) ? this.getNumberField(data) : (this.m_displayType == 14 ? this.getTextField(dataValue, 3) : (this.m_displayType == 36 ? this.getTextField(dataValue, 10) : (this.m_displayType == 34 ? this.getTextField(dataValue, 15) : this.getStringField(dataValue))))))));
        }
        tdRet.setVAlign("middle");
        return tdRet;
    }

    private td getStringField(String data) {
        input string = new input("text", this.m_columnName, AmpiereUtil.maskHtmlCR(data));
        string.setID(this.m_columnName + "F");
        if (this.m_displayLength > 128) {
            string.setSize(128);
        } else {
            string.setSize(this.m_displayLength);
        }
        if (this.m_fieldLength > 0) {
            string.setMaxlength(this.m_fieldLength);
        }
        string.setDisabled(this.m_readOnly);
        if (this.m_error) {
            string.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            string.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            string.setOnChange("startUpdate(this);");
        }
        if (this.m_encryptedField) {
            string.setType("password");
        }
        string.addAttribute("style", "width:" + this.m_displayLength + "px;");
        return this.createTD((Element)string);
    }

    private td getTextField(String data, int rows) {
        textarea text = new textarea(this.m_columnName, rows, this.m_displayLength).addElement(AmpiereUtil.maskHtmlCR(data));
        text.setID(this.m_columnName + "F");
        text.setDisabled(this.m_readOnly);
        if (this.m_error) {
            text.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            text.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            text.setOnChange("startUpdate(this);");
        }
        text.addAttribute("style", "width:" + this.m_displayLength + "px;");
        return this.createTD((Element)text);
    }

    private td getDateField(Object data) {
        String formattedData = "";
        if (data != null) {
            formattedData = this.m_displayType == 16 ? this.m_wsc.dateTimeFormat.format(data) : this.m_wsc.dateFormat.format(data);
        }
        input string = new input("text", this.m_columnName, formattedData);
        string.setID(this.m_columnName + "F");
        string.setSize(this.m_displayLength);
        if (this.m_fieldLength >= 10) {
            string.setMaxlength(this.m_fieldLength);
        }
        string.setDisabled(this.m_readOnly);
        if (this.m_error) {
            string.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            string.setClass(C_MANDATORY);
        }
        string.setOnChange("checkDateValidation(this, paraInvalidDateMsg);startUpdate(this);");
        string.setReadOnly(this.m_readOnly);
        string.addAttribute("style", "width:" + this.m_displayLength + "px;");
        img button2 = null;
        if (!this.m_readOnly) {
            String gif = "Calendar16.gif";
            button2 = new img(WebEnv.getImageDirectory(gif), this.m_columnName);
            button2.setID(this.m_columnName + "B");
            button2.setClass("popupButton");
            String onClick = "recDate_onclick_function('" + this.m_columnName + "F" + "', null, paraMonths, paraShortMonths, paraWeeks, paraShortWeeks, paraDateFormat);";
            button2.setOnClick(onClick + "return false;");
            if (this.m_description != null) {
                button2.setTitle(Util.maskHTML(this.m_description));
            }
        }
        td tdRet = this.createTD((Element)string);
        if (button2 != null) {
            tdRet.addElement(button2);
        }
        return tdRet;
    }

    private td getNumberField(Object data) {
        String formattedData = null;
        DecimalFormat decimalFormat = null;
        if (data == null) {
            formattedData = "";
        } else if (this.m_displayType == 12) {
            decimalFormat = this.m_wsc.amountFormat;
        } else if (this.m_displayType == 22) {
            decimalFormat = this.m_wsc.numberFormat;
        } else if (this.m_displayType == 37) {
            decimalFormat = this.m_wsc.costPriceFormat;
        } else if (this.m_displayType == 29) {
            decimalFormat = this.m_wsc.quantityFormat;
        } else if (this.m_displayType == 11) {
            decimalFormat = this.m_wsc.integerFormat;
        } else {
            formattedData = data.toString();
        }
        if (formattedData == null) {
            BigDecimal bd = new BigDecimal(0);
            try {
                bd = new BigDecimal(data.toString());
            }
            catch (NumberFormatException e) {
                bd = new BigDecimal(0);
            }
            bd = bd.setScale(decimalFormat.getMaximumFractionDigits(), 4);
            formattedData = decimalFormat.format(bd);
        }
        input string = new input("text", this.m_columnName, formattedData);
        string.setID(this.m_columnName + "F");
        string.setSize(this.m_displayLength);
        if (this.m_fieldLength > 0) {
            string.setMaxlength(this.m_fieldLength);
        }
        string.setDisabled(this.m_readOnly);
        if (this.m_error) {
            string.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            string.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            string.setOnChange("startUpdate(this);");
        }
        string.addAttribute("style", "width:" + this.m_displayLength + "px;");
        return this.createTD((Element)string);
    }

    private td getCheckField(String data) {
        boolean check = data != null && (data.equals("true") || data.equals("Y"));
        input cb = new input("checkbox", this.m_columnName, "true").setChecked(check).addElement(this.m_name);
        cb.setID(this.m_columnName + "F");
        cb.setDisabled(this.m_readOnly);
        if (this.m_error) {
            cb.setClass(C_ERROR);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            cb.setOnClick("startUpdate(this);");
        }
        return this.createTD((Element)cb);
    }

    private td getPopupField(String dataDisplay, String dataValue, int AD_Column_ID, Lookup lookup) {
        input hidden = new input("hidden", this.m_columnName, dataValue);
        hidden.setID(this.m_columnName + "D");
        input display = new input("text", this.m_columnName, AmpiereUtil.maskHtmlCR(dataDisplay));
        display.setID(this.m_columnName + "F");
        display.setReadOnly(this.m_readOnly);
        display.setSize(this.m_displayLength);
        display.setDisabled(this.m_readOnly);
        display.addAttribute("style", "width:" + this.m_displayLength + "px;");
        img button2 = null;
        if (!this.m_readOnly) {
            String gif = "PickOpen16.gif";
            if (this.m_displayType == 21) {
                gif = "Location16.gif";
            } else if (this.m_displayType == 25) {
                gif = "Account16.gif";
            } else if (this.m_columnName.equals("C_BPartner_ID")) {
                gif = "BPartner16.gif";
            } else if (this.m_columnName.equals("M_Product_ID")) {
                gif = "Product16.gif";
            }
            button2 = new img(WebEnv.getImageDirectory(gif), this.m_columnName);
            button2.setID(this.m_columnName + "B");
            button2.setClass("popupButton");
            String onClick = "";
            String col = lookup.getColumnName();
            if (col != null && col.indexOf(".") >= 0) {
                col = col.substring(col.indexOf(".") + 1);
            }
            if (this.m_displayType == 21) {
                onClick = "startLocation('" + this.m_columnName + "'," + this.m_windowNo + "," + AD_Column_ID + ",'" + col + "',null);";
                display.setReadOnly(true);
            } else {
                onClick = this.m_displayType == 25 ? "startAccount('" + this.m_columnName + "',null);" : "startLookup('" + this.m_columnName + "'," + this.m_windowNo + "," + AD_Column_ID + ",'" + col + "', 'N',null);";
            }
            button2.setOnClick(onClick + "return false;");
            if (this.m_description != null) {
                button2.setTitle(Util.maskHTML(this.m_description));
            }
        }
        if (this.m_error) {
            display.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            display.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout || !this.m_readOnly) {
            display.setOnChange("startUpdate(this);");
        }
        td tdRet = this.createTD((Element)hidden).addElement((Element)display);
        if (button2 != null) {
            tdRet.addElement((Element)button2);
        }
        return tdRet;
    }

    private td getSelectField(Lookup lookup, String dataValue) {
        select sel = new select(this.m_columnName, this.getOptions(lookup, dataValue));
        sel.setID(this.m_columnName);
        sel.setDisabled(this.m_readOnly);
        if (this.m_error) {
            sel.setClass(C_ERROR);
        } else if (this.m_mandatory) {
            sel.setClass(C_MANDATORY);
        }
        if (this.m_hasDependents || this.m_hasCallout) {
            sel.setOnChange("startUpdate(this);");
        }
        sel.addAttribute("style", "width:" + this.m_displayLength + "px;");
        return this.createTD((Element)sel);
    }

    private option[] getOptions(Lookup lookup, String dataValue) {
        if (lookup == null) {
            return new option[0];
        }
        Object[] list = lookup.getData(this.m_mandatory, true, !this.m_readOnly, false).toArray();
        int size = list.length;
        if (size <= 0) {
            list = lookup.getData(this.m_mandatory, true, true, true).toArray();
            size = list.length;
        }
        option[] options = new option[size];
        for (int i2 = 0; i2 < size; ++i2) {
            NamePair p2;
            String name;
            boolean isNumber = list[0] instanceof KeyNamePair;
            String key = null;
            if (this.m_displayType == 31) {
                MLocator loc = (MLocator)list[i2];
                key = String.valueOf(loc.getM_Locator_ID());
                name = AmpiereUtil.maskHTML(loc.getValue());
                options[i2] = new option(key).addElement(name);
            } else if (isNumber) {
                p2 = (KeyNamePair)list[i2];
                key = String.valueOf(((KeyNamePair)p2).getKey());
                name = AmpiereUtil.maskHTML(p2.getName());
                options[i2] = new option(key).addElement(name);
            } else {
                p2 = (ValueNamePair)list[i2];
                key = ((ValueNamePair)p2).getValue();
                if (key == null || key.length() == 0) {
                    key = "";
                }
                if ((name = p2.getName()) == null || name.length() == 0) {
                    name = " ";
                }
                name = AmpiereUtil.maskHTML(name);
                options[i2] = new option(key).addElement(name);
            }
            if (!dataValue.equals(key)) continue;
            options[i2].setSelected(true);
        }
        return options;
    }

    private td getButtonField(String data) {
        String header = this.m_name;
        if (this.m_columnName.equals("PaymentRule")) {
            header = this.readReferenceName(195, data);
        } else if (this.m_columnName.equals("DocAction")) {
            header = this.readReferenceName(135, data);
        } else if (this.m_columnName.equals("Posted")) {
            header = this.readReferenceName(234, data);
        }
        input button2 = new input("button", this.m_columnName, Util.maskHTML(header));
        button2.setID(this.m_columnName);
        if (this.m_columnName.indexOf("PaymentRule") >= 0) {
            this.m_readOnly = true;
        }
        button2.setDisabled(true);
        int needSave = Env.getContextAsInt(this.m_wsc.ctx, this.m_windowNo, "NeedSave");
        if (!this.m_readOnly && needSave == 0) {
            int AD_Table_ID = Env.getContextAsInt(this.m_wsc.ctx, this.m_windowNo, "BaseTable_ID");
            int record_ID = Env.getContextAsInt(this.m_wsc.ctx, this.m_windowNo, "Record_ID");
            button2.setOnClick("startButton('" + this.m_columnName + "', " + this.m_windowNo + ", " + this.m_processId + ", " + AD_Table_ID + ", " + record_ID + ");");
            button2.setDisabled(false);
        }
        return this.createTD((Element)button2).setAlign("left");
    }

    private String readReferenceName(int AD_Reference_ID, String value) {
        String name = value;
        String SQL = Env.isBaseLanguage(this.m_wsc.ctx, "AD_Ref_List") ? "SELECT Name FROM AD_Ref_List WHERE AD_Reference_ID=? AND VALUE=?" : "SELECT t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language(this.m_wsc.ctx) + "'" + " AND l.AD_Reference_ID=?" + " AND l.VALUE=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, AD_Reference_ID);
            pstmt.setString(2, value);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                name = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return name;
    }
}

