/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.ProcessCtl;
import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.servlet.WebField;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.big;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.small;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.thead;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MCurrency;
import org.compiere.model.MPInstance;
import org.compiere.model.MSession;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WWindow
extends HttpServlet
implements DataStatusListener {
    private static final long serialVersionUID = 5764325063392615769L;
    protected static CLogger log = CLogger.getCLogger(WWindow.class);
    private static int s_WindowNo = 1;
    protected static final String FORM_NAME = "WForm";
    private static final String P_Command = "PCommand";
    private static final String P_Tab = "PTab";
    private static final String P_MR_RowNo = "PMRRowNo";
    private static final String P_ChangedColumn = "ChangedColumn";
    private static final String P_Reserve1 = "Reserve1";
    private static final String P_Reserve2 = "Reserve2";
    private static final String P_Reserve3 = "Reserve3";
    private static final int MAX_LINES = 12;
    private static final String ERROR = " ERROR! ";
    private HttpServletRequest m_request = null;
    private StringBuffer m_popupAlert = null;
    private String m_popupLookup = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WWindow.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Window";
    }

    public void destroy() {
        log.fine("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GridWindowVO mWindowVO;
        this.m_popupAlert = null;
        this.m_popupLookup = null;
        this.m_request = request;
        HttpSession sess = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        int AD_Window_ID = WebUtil.getParameterAsInt(request, "AD_Window_ID");
        int AD_Menu_ID = WebUtil.getParameterAsInt(request, "AD_Menu_ID");
        log.info("AD_Window_ID=" + AD_Window_ID + "; AD_Menu_ID=" + AD_Menu_ID);
        WWindowStatus ws = WWindowStatus.get(request);
        if (ws != null) {
            int WindowNo = ws.mWindow.getWindowNo();
            log.fine("Disposing - WindowNo=" + WindowNo + ", ID=" + ws.mWindow.getAD_Window_ID());
            ws.mWindow.dispose();
            Env.clearWinContext(wsc.ctx, WindowNo);
        }
        if ((mWindowVO = GridWindowVO.create(wsc.ctx, s_WindowNo++, AD_Window_ID, AD_Menu_ID)) == null) {
            String msg = Msg.translate(wsc.ctx, "AD_Window_ID") + " " + Msg.getMsg(wsc.ctx, "NotFound") + ", ID=" + AD_Window_ID + "/" + AD_Menu_ID;
            WebUtil.createErrorPage(request, response, this, msg);
            sess.setAttribute("WWindowStatus", null);
            return;
        }
        ws = new WWindowStatus(mWindowVO);
        sess.setAttribute("WWindowStatus", (Object)ws);
        ws.curTab.query(ws.mWindow.isTransaction());
        ws.curTab.navigate(0);
        this.resetAmountformat(wsc, ws);
        sess.setAttribute("WebSessionCtx", (Object)wsc);
        sess.setAttribute("FieldLookup", null);
        ws.curTab.addDataStatusListener(this);
        WebDoc doc = null;
        doc = ws.curTab.isSingleRow() ? this.getSR_Form(request.getRequestURI(), wsc, ws) : this.getMR_Form(request.getRequestURI(), wsc, ws);
        log.fine("Fini");
        WebUtil.createResponse(request, response, this, null, doc, true);
        log.fine("Closed");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.m_popupAlert = null;
        this.m_popupLookup = null;
        this.m_request = request;
        WebEnv.dump(request);
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null || ws == null) {
            if (wsc == null) {
                WebUtil.createTimeoutPage(request, response, this, "No Context");
            } else {
                this.doGet(request, response);
            }
            return;
        }
        String p_cmd = WebUtil.getParameter(request, P_Command);
        String column = WebUtil.getParameter(request, P_ChangedColumn);
        log.info("Cmd=" + p_cmd + " - ChangedColumn=" + column);
        ws.curTab.addDataStatusListener(this);
        if (column != null && column.length() > 0) {
            if (p_cmd != null && "ButtonCommand".equalsIgnoreCase(p_cmd)) {
                int processId = WebUtil.getParameterAsInt(request, P_Reserve1);
                boolean batch = "true".equalsIgnoreCase(WebUtil.getParameter(request, P_Reserve2));
                String value = WebUtil.getParameter(request, P_Reserve3);
                request.setAttribute(P_Command, (Object)"");
                request.setAttribute(P_ChangedColumn, (Object)"");
                request.setAttribute(P_Reserve1, (Object)"");
                request.setAttribute(P_Reserve2, (Object)"");
                request.setAttribute(P_Reserve3, (Object)"");
                int currentRow = ws.curTab.getCurrentRow();
                int keyId = ws.curTab.getKeyID(currentRow);
                this.actionButton(ws, wsc, column, processId, batch, value);
                ws.curTab.query(ws.mWindow.isTransaction());
                for (int ii = 0; ii < ws.curTab.getRowCount(); ++ii) {
                    if (keyId != ws.curTab.getKeyID(ii)) continue;
                    ws.curTab.navigate(ii);
                    break;
                }
            } else {
                this.updateFields(request, wsc, ws);
            }
        } else {
            if (p_cmd.equals("Exit")) {
                MSession cSession = MSession.get(wsc.ctx, false);
                if (cSession != null) {
                    cSession.logout();
                }
                WebUtil.createLoginPage(request, response, this, ws.ctx, "Exit");
                return;
            }
            this.executeCommand(request, p_cmd, wsc, ws);
        }
        HttpSession sess = request.getSession();
        sess.setAttribute("FieldLookup", null);
        this.resetAmountformat(wsc, ws);
        sess.setAttribute("WebSessionCtx", (Object)wsc);
        WebDoc doc = null;
        doc = ws.curTab.isSingleRow() ? this.getSR_Form(request.getRequestURI(), wsc, ws) : this.getMR_Form(request.getRequestURI(), wsc, ws);
        if (this.m_popupAlert != null && this.m_popupAlert.length() > 0) {
            doc.getBody().setOnLoad("alert('" + this.m_popupAlert.toString() + "');");
        }
        if (this.m_popupLookup != null && this.m_popupLookup.length() > 0) {
            doc.getBody().setOnLoad(this.m_popupLookup);
        }
        log.fine("Fini");
        WebUtil.createResponse(request, response, this, null, doc, true);
        log.fine("Closed");
    }

    private void executeCommand(HttpServletRequest request, String p_cmd, WebSessionCtx wsc, WWindowStatus ws) {
        String p_tab = WebUtil.getParameter(request, P_Tab);
        String p_row = WebUtil.getParameter(request, P_MR_RowNo);
        log.config(p_cmd + " - Tab=" + p_tab + " - Row=" + p_row);
        Env.setContext(wsc.ctx, ws.curTab.getWindowNo(), "NeedSave", 0);
        if (p_row != null && p_row.length() > 0) {
            try {
                int newRowNo = Integer.parseInt(p_row);
                ws.curTab.navigate(newRowNo);
                ws.curTab.setSingleRow(true);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Parse RowNo=" + p_row, e);
            }
        } else if (p_tab != null && p_tab.length() > 0) {
            int newTabNo = 0;
            try {
                newTabNo = Integer.parseInt(p_tab);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Parse TabNo=" + p_tab, e);
            }
            if (newTabNo > ws.curTab.getTabNo()) {
                ws.curTab = ws.mWindow.getTab(newTabNo);
                ws.curTab.query(false);
                ws.curTab.navigate(0);
            } else if (newTabNo < ws.curTab.getTabNo()) {
                ws.curTab = ws.mWindow.getTab(newTabNo);
                ws.curTab.dataRefresh();
            }
        } else if (p_cmd.equals("Multi")) {
            boolean single = ws.curTab.isSingleRow();
            ws.curTab.setSingleRow(!single);
        } else if (p_cmd.equals("First")) {
            ws.curTab.navigate(0);
        } else if (p_cmd.equals("Next")) {
            if (ws.curTab.isSingleRow()) {
                if (ws.curTab.getCurrentRow() < ws.curTab.getRowCount()) {
                    ws.curTab.navigateRelative(1);
                }
            } else if (ws.curTab.getRowCount() - ws.curTab.getCurrentRow() >= 12) {
                ws.curTab.navigateRelative(12);
            }
        } else if (p_cmd.equals("Previous")) {
            if (ws.curTab.isSingleRow()) {
                if (ws.curTab.getCurrentRow() > 0) {
                    ws.curTab.navigateRelative(-1);
                }
            } else if (ws.curTab.getCurrentRow() >= 12) {
                ws.curTab.navigateRelative(-12);
            }
        } else if (p_cmd.equals("Last")) {
            ws.curTab.navigateRelative(999999);
        } else if (!p_cmd.equals("Find")) {
            if (p_cmd.equals("Refresh")) {
                ws.curTab.dataRefreshAll();
            } else if (!p_cmd.equals("Attachment")) {
                if (p_cmd.equals("History")) {
                    if (ws.mWindow.isTransaction() && ws.curTab.getWindowNo() == 0) {
                        ws.curTab.query(!ws.curTab.isOnlyCurrentRows());
                        ws.curTab.navigate(0);
                    }
                } else if (p_cmd.equals("Report")) {
                    Env.setContext(wsc.ctx, ws.curTab.getWindowNo(), "IsReportStart", true);
                } else if (p_cmd.equals("Print")) {
                    Env.setContext(wsc.ctx, ws.curTab.getWindowNo(), "IsPrintStart", true);
                } else if (p_cmd.equals("New")) {
                    ws.curTab.setSingleRow(true);
                    if (!ws.curTab.dataNew(false)) {
                        ws.curTab.dataIgnore();
                    }
                    Env.setContext(wsc.ctx, ws.curTab.getWindowNo(), "NeedSave", 1);
                } else if (p_cmd.equals("Ignore")) {
                    ws.curTab.dataIgnore();
                    ws.curTab.navigate(0);
                } else if (p_cmd.equals("Delete")) {
                    ws.curTab.dataDelete();
                } else if (p_cmd.equals("Save")) {
                    this.executeSave(request, wsc, ws);
                }
            }
        }
    }

    private void executeSave(HttpServletRequest request, WebSessionCtx wsc, WWindowStatus ws) {
        log.info("");
        boolean error = this.updateFields(request, wsc, ws);
        log.fine("Mandatory check");
        int size = ws.curTab.getFieldCount();
        for (int i2 = 0; i2 < size; ++i2) {
            GridField field = ws.curTab.getField(i2);
            if (!field.isMandatory(true)) continue;
            Object value = field.getValue();
            if (value == null || value.toString().length() == 0) {
                field.setInserting(true);
                field.setError(true);
                field.setErrorValue(value == null ? null : value.toString());
                if (!error) {
                    error = true;
                }
                log.info("Mandatory Error: " + field.getColumnName());
                continue;
            }
            field.setError(false);
        }
        if (error) {
            return;
        }
        if (!ws.curTab.dataSave(true)) {
            ws.curTab.dataIgnore();
        }
        Env.setContext(wsc.ctx, ws.curTab.getWindowNo(), "NeedSave", 0);
        log.fine("done");
    }

    private boolean updateFields(HttpServletRequest request, WebSessionCtx wsc, WWindowStatus ws) {
        String value;
        Object newValue;
        GridField mField;
        boolean error = false;
        try {
            String enc = request.getCharacterEncoding();
            if (enc == null) {
                request.setCharacterEncoding("UTF-8");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Set CharacterEndocung=UTF-8", e);
        }
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            GridField mField2;
            String key = (String)en.nextElement();
            if (key == null || key.equals(P_Command) || key.equals(P_ChangedColumn) || key.equals(P_MR_RowNo) || key.equals(P_Tab) || key.equals(P_Reserve1) || key.equals(P_Reserve2) || key.equals(P_Reserve3) || (mField2 = ws.curTab.getField(key)) == null || !mField2.isEditable(true)) continue;
            String value2 = WebUtil.getParameter(request, key);
            Object dbValue = mField2.getValue();
            boolean fieldError = false;
            String columnName = mField2.getColumnName();
            log.finest(columnName + ": " + (dbValue == null ? "null" : dbValue.toString()) + " -> " + (value2 == null ? "null" : value2.toString()));
            if (dbValue == null && value2 == null) continue;
            if (dbValue != null && value2 == null) {
                this.setFieldNewValue(wsc, ws, mField2, null);
            } else if (dbValue == null && value2 != null) {
                fieldError = !this.setFieldValue(wsc, ws, mField2, value2);
            } else {
                if (dbValue.equals(value2)) continue;
                boolean bl = fieldError = !this.setFieldValue(wsc, ws, mField2, value2);
            }
            if (error || !fieldError) continue;
            log.info("Error: " + mField2.getColumnName());
            error = true;
        }
        int fileds = ws.curTab.getFieldCount();
        for (int i2 = 0; i2 < fileds; ++i2) {
            String key;
            mField = ws.curTab.getField(i2);
            if (mField == null || !mField.isEditable(true) || mField.getDisplayType() != 20 || (key = mField.getColumnName()).equals("IsActive")) continue;
            String value3 = WebUtil.getParameter(request, key);
            Object dbValue = mField.getValue();
            if (dbValue == null || value3 != null) continue;
            this.setFieldNewValue(wsc, ws, mField, false);
        }
        String columnName = WebUtil.getParameter(request, P_ChangedColumn);
        if (columnName != null && columnName.length() > 0 && (mField = ws.curTab.getField(columnName)) != null && !ERROR.equals(newValue = this.getFieldValue(wsc, mField, value = WebUtil.getParameter(request, columnName)))) {
            if (newValue == null && mField.getDisplayType() == 20) {
                newValue = "N";
            }
            log.fine("ChangedColumn: " + columnName + "=" + newValue);
            this.setFieldNewValue(wsc, ws, mField, newValue);
        }
        Env.setContext(wsc.ctx, ws.curTab.getWindowNo(), "NeedSave", 1);
        return error;
    }

    private boolean setFieldValue(WebSessionCtx wsc, WWindowStatus ws, GridField mField, String value) {
        Object newValue = this.getFieldValue(wsc, mField, value);
        if (ERROR.equals(newValue)) {
            mField.setErrorValue(value);
            return false;
        }
        Object dbValue = mField.getValue();
        if (newValue == null && dbValue != null || newValue != null && !newValue.equals(dbValue)) {
            this.setFieldNewValue(wsc, ws, mField, newValue);
        }
        return true;
    }

    private Object getFieldValue(WebSessionCtx wsc, GridField mField, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        int dt = mField.getDisplayType();
        String columnName = mField.getColumnName();
        if (DisplayType.isNumeric(dt)) {
            BigDecimal bd = null;
            try {
                Number nn = null;
                nn = dt == 12 ? (Number)wsc.amountFormat.parse(value) : (Number)(dt == 29 ? (Number)wsc.quantityFormat.parse(value) : (Number)wsc.numberFormat.parse(value));
                bd = nn instanceof BigDecimal ? (BigDecimal)nn : new BigDecimal(nn.toString());
            }
            catch (Exception e) {
                log.warning("BigDecimal: " + columnName + "=" + value + ERROR);
                return ERROR;
            }
            log.fine("BigDecimal: " + columnName + "=" + value + " -> " + bd);
            return bd;
        }
        if (DisplayType.isID(dt) && !columnName.equals("AD_Language")) {
            Integer ii = null;
            try {
                ii = new Integer(value);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "ID: " + columnName + "=" + value, e);
                ii = null;
            }
            if (ii != null && ii == -1) {
                ii = null;
            }
            log.fine("ID: " + columnName + "=" + value + " -> " + ii);
            return ii;
        }
        if (DisplayType.isDate(dt)) {
            Timestamp ts = null;
            try {
                Date d = null;
                d = dt == 15 ? wsc.dateFormat.parse(value) : wsc.dateTimeFormat.parse(value);
                ts = new Timestamp(d.getTime());
            }
            catch (Exception e) {
                log.warning("Date: " + columnName + "=" + value + ERROR);
                return ERROR;
            }
            log.fine("Date: " + columnName + "=" + value + " -> " + ts);
            return ts;
        }
        if (dt == 20) {
            Boolean retValue = Boolean.FALSE;
            if (value.equals("true")) {
                retValue = Boolean.TRUE;
            }
            log.fine("YesNo: " + columnName + "=" + value + " -> " + retValue);
            return retValue;
        }
        log.fine(columnName + "=" + value);
        return value;
    }

    private WebDoc getSR_Form(String action, WebSessionCtx wsc, WWindowStatus ws) {
        log.fine("Tab=" + ws.curTab.getTabNo());
        table table2 = new table().setAlign("center");
        table2.setCellSpacing(0);
        table2.setCellPadding(1);
        StringBuffer scriptSrc = new StringBuffer();
        tr line = new tr();
        if (ws.curTab.isDisplayed()) {
            Env.setContext(wsc.ctx, ws.curTab.getWindowNo(), "Record_ID", ws.curTab.getRecord_ID());
            int currentRow = ws.curTab.getCurrentRow();
            int noFields = ws.curTab.getFieldCount();
            for (int i2 = 0; i2 < noFields; ++i2) {
                GridField field = ws.curTab.getField(i2);
                String columnName = field.getColumnName();
                Object oData = ws.curTab.getValue(field);
                if (!field.isSameLine()) {
                    line = new tr();
                }
                if (!field.isDisplayed(true)) continue;
                boolean hasDependents = ws.curTab.hasDependants(columnName);
                boolean readOnly = currentRow == -1 || !field.isEditable(true);
                this.addField(wsc, line, field, oData, hasDependents, readOnly);
                table2.addElement((Element)line);
                String dispLogic = field.getDisplayLogic();
                if (dispLogic == null || dispLogic.length() <= 0) continue;
                dispLogic = dispLogic.replace('\'', '\"');
                dispLogic = dispLogic.replaceAll("\n", "");
                scriptSrc.append("document.").append(FORM_NAME).append(".").append(columnName).append(".displayLogic='").append(dispLogic).append("';\n");
            }
        }
        if (scriptSrc.length() > 0) {
            table2.addElement((Element)new script(scriptSrc.toString()));
        }
        int rowNo = ws.curTab.getCurrentRow();
        String statusDB = String.valueOf(rowNo + 1) + " # " + ws.curTab.getRowCount();
        return WWindow.createLayout(action, table2, wsc, ws, "", statusDB);
    }

    private WebDoc getMR_Form(String action, WebSessionCtx wsc, WWindowStatus ws) {
        log.fine("Tab=" + ws.curTab.getTabNo());
        int oldRow = ws.curTab.getCurrentRow();
        int initRowNo = oldRow / 12 * 12;
        table table2 = new table().setAlign("center");
        table2.setClass("displaytag");
        table2.setBorder(0);
        table2.setCellSpacing(0);
        tr line = new tr();
        line.addElement((Element)new th().addElement(WebEnv.NBSP));
        if (!ws.curTab.isDisplayed()) {
            return WWindow.createLayout(action, table2, wsc, ws, "", "-");
        }
        int noFields = ws.curTab.getFieldCount();
        for (int colNo = 0; colNo < noFields; ++colNo) {
            GridField field = ws.curTab.getField(colNo);
            if (!field.isDisplayed(false)) continue;
            th th2 = new th();
            th2.setNoWrap(true);
            th2.addElement(field.getHeader());
            th2.setAbbr(field.getDescription());
            line.addElement((Element)th2);
        }
        table2.addElement((Element)new thead().addElement((Element)line));
        int lastRow = initRowNo + 12;
        lastRow = Math.min(lastRow, ws.curTab.getRowCount());
        String[] lineClass = new String[]{"odd", "even", "current"};
        for (int lineNo = initRowNo; lineNo < lastRow; ++lineNo) {
            ws.curTab.navigate(lineNo);
            line = new tr();
            if (oldRow == ws.curTab.getCurrentRow()) {
                line.setClass(lineClass[2]);
            } else {
                line.setClass(lineClass[lineNo >= 0 ? lineNo % 2 : 1]);
            }
            String href = "document.WForm.PMRRowNo.value='" + lineNo + "'; " + FORM_NAME + ".submit();";
            img selector = new img(WebEnv.getImageDirectory("Go.gif"));
            selector.setClass("cursorPointer");
            selector.setOnClick(href);
            line.addElement((Element)new td().addElement((Element)selector));
            for (int colNo = 0; colNo < noFields; ++colNo) {
                td td2 = new td();
                GridField field = ws.curTab.getField(colNo);
                if (!field.isDisplayed(false)) continue;
                Object data = ws.curTab.getValue(field.getColumnName());
                String info = null;
                if (data == null) {
                    info = "";
                } else {
                    int dt = field.getDisplayType();
                    switch (dt) {
                        case 15: {
                            info = wsc.dateFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 16: {
                            info = wsc.dateTimeFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 12: {
                            info = wsc.amountFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 22: {
                            info = wsc.numberFormat.format(data);
                            td2.setAlign("right");
                        }
                        case 37: {
                            info = wsc.costPriceFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 29: {
                            info = wsc.quantityFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 11: {
                            info = wsc.integerFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 20: {
                            info = Msg.getMsg(ws.ctx, data.toString());
                            break;
                        }
                        default: {
                            info = DisplayType.isLookup(dt) ? field.getLookup().getDisplay(data) : data.toString();
                        }
                    }
                }
                if (info == null || info.length() == 0 || info.trim().length() == 0) {
                    info = WebEnv.NBSP;
                }
                td2.addElement(info);
                line.addElement((Element)td2);
            }
            table2.addElement((Element)line);
        }
        ws.curTab.navigate(oldRow);
        String statusDB = String.valueOf(initRowNo + 1) + "-" + String.valueOf(lastRow) + " # " + ws.curTab.getRowCount();
        return WWindow.createLayout(action, table2, wsc, ws, "", statusDB);
    }

    private static WebDoc createLayout(String action, table contentTable, WebSessionCtx wsc, WWindowStatus ws, String statusInfo, String statusDB) {
        boolean insertRecord;
        form myForm = null;
        myForm = new form(action);
        myForm.setTarget("WWindow");
        myForm.setID("WWindow" + ws.mWindow.getAD_Window_ID());
        String AD_Language = Env.getAD_Language(ws.ctx);
        myForm.setName(FORM_NAME);
        myForm.addElement((Element)new input("hidden", P_Command, ""));
        myForm.addElement((Element)new input("hidden", P_MR_RowNo, ""));
        myForm.addElement((Element)new input("hidden", P_ChangedColumn, ""));
        myForm.addElement((Element)new input("hidden", P_Reserve1, ""));
        myForm.addElement((Element)new input("hidden", P_Reserve2, ""));
        myForm.addElement((Element)new input("hidden", P_Reserve3, ""));
        String title = ws.mWindow.getName() + " - " + wsc.loginInfo;
        myForm.addElement((Element)new script("top.document.title='" + title + "';"));
        td toolbar = new td(null, "left", "middle", true);
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "MenuOnOff", "MenuOnOff", "menuSwitch();", true, false));
        toolbar.addElement(WebEnv.NBSP);
        boolean needSave = Env.getContextAsInt(wsc.ctx, ws.curTab.getWindowNo(), "NeedSave") != 0;
        boolean bl = insertRecord = !ws.curTab.isReadOnly();
        if (insertRecord) {
            insertRecord = ws.curTab.isInsertRecord();
        }
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Ignore", "Ignore"));
        toolbar.addElement(WebEnv.NBSP);
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Help", "Help", "startPopup('WHelp?AD_Window_ID=" + ws.mWindow.getAD_Window_ID() + "');", true, false));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "New", "New", null, !needSave && insertRecord, false));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Delete", "Delete", "if (confirm(deleteText)) WForm.submit();", !needSave && insertRecord, false));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Save", "Save", "beforeSave(document.WForm);", true, false));
        toolbar.addElement(WebEnv.NBSP);
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Find", "Find", "openFindWindow('/compiere/ampiere/WFind', '" + ws.curTab.getTableName() + "' );", true, false));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Refresh", "Refresh", null, !needSave, false));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Attachment", "Attachment", "startPopup('WAttachment');", ws.curTab.getCurrentRow() != -1 && ws.curTab.canHaveAttachment(), ws.curTab.hasAttachment()));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Multi", "Multi", null, true, !ws.curTab.isSingleRow()));
        toolbar.addElement(WebEnv.NBSP);
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "History", "History", "openHistoryWindow('/compiere/ampiere/WHistory', '" + ws.curTab.getTableName() + "' );", ws.mWindow.isTransaction() && ws.curTab.getTabNo() == 0, !ws.curTab.isOnlyCurrentRows()));
        toolbar.addElement(WebEnv.NBSP);
        boolean isFirst = ws.curTab.getCurrentRow() < 1;
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "First", "First", null, !isFirst, false));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Previous", "Previous", null, !isFirst, false));
        boolean isLast = ws.curTab.getCurrentRow() + 1 == ws.curTab.getRowCount();
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Next", "Next", null, !isLast, false));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Last", "Last", null, !isLast, false));
        toolbar.addElement(WebEnv.NBSP);
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Report", "Report"));
        boolean isPrint = false;
        isPrint = ws.curTab.getAD_Process_ID() != 0;
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Print", "Print", null, isPrint, false));
        toolbar.addElement(WebEnv.NBSP);
        String popupProduct = "startLookup('M_Product_ID'," + ws.mWindow.getWindowNo() + ", 3840, 'M_Product_ID', 'Y','');";
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Product", "Product", popupProduct, true, false));
        toolbar.addElement(WebEnv.NBSP);
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Exit", "Exit"));
        td tabbar = new td("tabHeader", "left", "bottom", false);
        tabbar.addElement((Element)new input("hidden", P_Tab, ""));
        table tabTable = new table("0", "0", "0", null, null);
        tr tabTr = new tr();
        boolean currentTab = false;
        for (int i2 = 0; i2 < ws.mWindow.getTabCount(); ++i2) {
            GridTab tab = ws.mWindow.getTab(i2);
            if (tab.isSortTab()) continue;
            String tabMouseOver = "";
            String tabMouseOut = "";
            String tabLeftId = "tabLeftId_" + Integer.toString(i2);
            String tabRightId = "tabRightId_" + Integer.toString(i2);
            String tabLeftClass = "tabLeft";
            String tabRightClass = "tabRight";
            big big2 = new big(tab.getName());
            if (ws.curTab.getTabNo() == i2) {
                big2.setClass("tabSelected");
                tabLeftClass = tabLeftClass + "Sel";
                tabRightClass = tabRightClass + "Sel";
                currentTab = true;
            } else if (tab.getTabLevel() <= ws.curTab.getTabLevel() || currentTab && tab.getTabLevel() == ws.curTab.getTabLevel() + 1) {
                big2.setClass("tab");
                big2.setOnClick("document.WForm.PTab.value='" + i2 + "';" + FORM_NAME + ".submit();");
                tabMouseOver = "tabMouseOver('" + tabLeftId + "', '" + tabRightId + "');";
                tabMouseOut = "tabMouseOut('" + tabLeftId + "', '" + tabRightId + "');";
            } else {
                big2.setClass("tabDisabled");
                tabLeftClass = tabLeftClass + "Dis";
                tabRightClass = tabRightClass + "Dis";
            }
            if (ws.curTab.getTabNo() != i2 && currentTab && tab.getTabLevel() <= ws.curTab.getTabLevel()) {
                currentTab = false;
            }
            td tabTdLeft = new td(WebEnv.NBSP);
            tabTdLeft.setClass(tabLeftClass);
            tabTdLeft.setAlign("center");
            tabTdLeft.setVAlign("middle");
            tabTdLeft.setNoWrap(false);
            td tabTdRight = new td(tabRightClass, "center", "middle", false);
            tabTdLeft.setID(tabLeftId);
            tabTdRight.setID(tabRightId);
            if (tab.getDescription().length() > 0) {
                tabMouseOver = tabMouseOver + "status='" + tab.getDescription() + "';return true;";
            }
            if (tabMouseOver != null && !"".equals(tabMouseOver)) {
                big2.setOnMouseOver(tabMouseOver);
            }
            if (tabMouseOut != null && !"".equals(tabMouseOut)) {
                tabMouseOut = tabMouseOut + "status='" + ws.curTab.getName() + "';return true;";
                big2.setOnMouseOut(tabMouseOut);
            }
            tabTdLeft.setStyle("");
            tabTr.addElement((Element)tabTdLeft);
            tabTdRight.addElement((Element)big2);
            tabTdRight.setStyle("");
            tabTr.addElement((Element)tabTdRight);
        }
        tabTable.addElement((Element)tabTr);
        tabbar.addElement((Element)tabTable);
        table topTable = new table("0", "0", "5", "100%", null);
        topTable.setID("WWindow.topTable");
        topTable.addElement((Element)new tr((Element)toolbar));
        topTable.addElement((Element)new tr((Element)tabbar));
        myForm.addElement((Element)topTable);
        myForm.addElement((Element)contentTable);
        table statusTable = new table("0", "0", "0", "100%", null);
        topTable.setID("WWindow.statusLine");
        tr statusLine = new tr();
        statusLine.addElement((Element)new td().setWidth("85%").setAlign("left").addElement(statusInfo));
        statusLine.addElement((Element)new td().setWidth("10%").setAlign("right").addElement((Element)new small(statusDB)));
        statusLine.addElement((Element)new td().setWidth("5%").setAlign("right").addElement((Element)WWindow.createImage(AD_Language, "Save", "Save2", "beforeSave(document.WForm);", true, false)));
        statusTable.addElement((Element)statusLine).setClass("windowCenter");
        myForm.addElement((Element)statusTable);
        WebDoc doc = WWindow.createPage(ws, wsc);
        doc.getBody().setOnUnload("closeMyChildren();");
        doc.getTable().addElement((Element)new tr().addElement((Element)new td(null, "center", "middle", true, (Element)myForm).setColSpan(2)));
        return doc;
    }

    private static WebDoc createPage(WWindowStatus ws, WebSessionCtx wsc) {
        WebDoc doc = WebDoc.createWindow(ws.mWindow.getName());
        doc.getHead().addElement((Element)new link("css/displaytag.css", "stylesheet", "text/css"));
        AmpiereUtil.addDatePicker(doc.getHead(), wsc);
        if ("Y".equals(Env.getContext(ws.ctx, ws.mWindow.getWindowNo(), "IsPrintStart"))) {
            Env.setContext(wsc.ctx, ws.curTab.getWindowNo(), "IsPrintStart", false);
            MPInstance pInstance = new MPInstance(ws.ctx, ws.curTab.getAD_Process_ID(), ws.curTab.getRecord_ID());
            if (!pInstance.save()) {
                log.log(Level.SEVERE, "Instance run error.");
            }
            Env.setContext(wsc.ctx, "AD_Process_ID", ws.curTab.getAD_Process_ID());
            Env.setContext(wsc.ctx, "AD_PInstance_ID", pInstance.getAD_PInstance_ID());
            StringBuffer sb = new StringBuffer();
            sb.append("openReportWindow(").append("\"/compiere/ampiere/WPrint\",").append("\"WPrint\" );");
            doc.getHead().addElement((Element)new script(sb.toString()));
        } else if ("Y".equals(Env.getContext(ws.ctx, ws.curTab.getWindowNo(), "IsReportStart"))) {
            Env.setContext(wsc.ctx, ws.curTab.getWindowNo(), "IsReportStart", false);
            StringBuffer sb = new StringBuffer();
            sb.append("openReportWindow(").append("\"/compiere/ampiere/WReport\",").append("\"WReport\" );");
            doc.getHead().addElement((Element)new script(sb.toString()));
        }
        doc.getBody().addElement((Element)new script("deleteText='" + Msg.getMsg(ws.ctx, "DeleteRecord?") + "';")).addElement((Element)new script("saveErrorText='" + Msg.getMsg(ws.ctx, "SaveError") + "';"));
        return doc;
    }

    private static img createImage(String AD_Language, String name, String id, String js_command, boolean enabled, boolean pressed) {
        StringBuffer imgName = new StringBuffer(name);
        if (!enabled) {
            imgName.append("D");
        } else if (pressed) {
            imgName.append("X");
        }
        imgName.append("24.gif");
        img img2 = new img(WebEnv.getImageDirectory(imgName.toString()), name);
        if (enabled) {
            img2.setAlt(Msg.getMsg(AD_Language, name));
        }
        if (enabled) {
            if (!pressed) {
                img2.setClass("imgButton");
            } else {
                img2.setClass("imgButtonPressed");
            }
            img2.setOnMouseOver("btnMouseOver('" + id + "');");
            img2.setOnMouseOut("btnMouseOut('" + id + "');");
        } else {
            img2.setClass("imgButtonD");
        }
        img2.setID(id);
        img2.setStyle("");
        if (js_command == null) {
            js_command = "WForm.submit();";
        }
        if (js_command.length() > 0 && enabled) {
            img2.setOnClick("document.WForm.PCommand.value='" + name + "';" + js_command);
        }
        return img2;
    }

    private static img createImage(String AD_Language, String name, String id) {
        return WWindow.createImage(AD_Language, name, id, null, true, false);
    }

    private void addField(WebSessionCtx wsc, tr line, GridField field, Object oData, boolean hasDependents, boolean readOnly) {
        String columnName = field.getColumnName();
        boolean error = field.isErrorValue();
        if (error) {
            oData = field.getErrorValue();
        }
        int dt = field.getDisplayType();
        boolean hasCallout = field.getCallout().length() > 0;
        WebField wField = new WebField(field.getWindowNo(), wsc, columnName, field.getHeader(), field.getDescription(), dt, field.getFieldLength(), field.getDisplayLength() * 8, field.isLongField(), readOnly, field.isMandatory(false), error, hasDependents, hasCallout, field.getAD_Process_ID(), field.isEncryptedField());
        line.addElement((Element)wField.getLabel()).addElement((Element)wField.getField(field.getLookup(), oData, field.getAD_Column_ID()));
    }

    private void actionButton(WWindowStatus ws, WebSessionCtx wsc, String columnName, int processId, boolean batch, String value) {
        log.info("Process button : " + columnName + "  ProcessID : " + processId + "  Value : " + value);
        if (ws.curTab.needSave(true, false) && !ws.curTab.dataSave(true)) {
            ws.curTab.dataIgnore();
            log.log(Level.INFO, "Data save has been ignored.");
            return;
        }
        int table_ID = ws.curTab.getAD_Table_ID();
        int record_ID = ws.curTab.getRecord_ID();
        if (record_ID == -1 && ws.curTab.getKeyColumnName().equals("AD_Language")) {
            record_ID = Env.getContextAsInt(wsc.ctx, ws.mWindow.getWindowNo(), "AD_Language_ID");
        }
        if (record_ID == -1 && (processId == 306 || processId == 307)) {
            Integer id = (Integer)ws.curTab.getValue("AD_ChangeLog_ID");
            record_ID = id;
        }
        if (record_ID == -1 && ws.curTab.getKeyColumnName().endsWith("_ID")) {
            log.log(Level.SEVERE, "SaveErrorRowNotFound");
            return;
        }
        log.config("Process_ID=" + processId + ", Record_ID=" + record_ID);
        if (processId == 0) {
            return;
        }
        if ("DocAction".equalsIgnoreCase(columnName)) {
            log.config("DocAction=" + value);
            Object orgValue = ws.curTab.getValue("DocAction");
            if (!value.equals(orgValue)) {
                ws.curTab.setValue("DocAction", (Object)value);
                if (ws.curTab.needSave(true, false)) {
                    ws.curTab.dataSave(false);
                }
            }
        }
        String title = columnName;
        ProcessInfo pi = new ProcessInfo(title, processId, table_ID, record_ID);
        pi.setAD_User_ID(Env.getAD_User_ID(wsc.ctx));
        pi.setAD_Client_ID(Env.getAD_Client_ID(wsc.ctx));
        pi.setIsBatch(batch);
        ProcessCtl processCtrl = ProcessCtl.getProcessInstance(ws.mWindow.getWindowNo(), pi, null, wsc.ctx);
        processCtrl.run();
        String summary = pi.getSummary();
        if (summary != null && summary.indexOf("@") != -1) {
            summary = Msg.parseTranslation(wsc.ctx, summary);
        }
        if (pi.isError()) {
            this.m_popupAlert = new StringBuffer();
            this.m_popupAlert.append(summary);
        }
    }

    public void dataStatusChanged(DataStatusEvent e) {
        if (this.m_request == null) {
            return;
        }
        if ((e.isError() || e.isWarning()) && !e.isConfirmed()) {
            WebSessionCtx wsc = WebSessionCtx.get(this.m_request);
            StringBuffer sb = new StringBuffer();
            String msg = null;
            if (e.getAD_Message() != null || e.getInfo() != null) {
                int pos;
                String info;
                msg = Msg.translate(wsc.ctx, e.getAD_Message());
                if (msg != null) {
                    sb.append(msg);
                }
                if ((info = e.getInfo()) != null && info.length() > 0) {
                    if (sb.length() > 0 && !sb.toString().trim().endsWith(":")) {
                        sb.append(": ");
                    }
                    sb.append(info);
                }
                if (sb.length() > 0 && (pos = sb.indexOf("\n")) != -1) {
                    sb.replace(pos, pos + 1, " - ");
                }
            }
            if (sb.length() > 0) {
                if (this.m_popupAlert != null) {
                    if (msg != null && this.m_popupAlert.indexOf(msg) == -1) {
                        this.m_popupAlert.append("\\n" + sb.toString());
                    }
                } else {
                    this.m_popupAlert = new StringBuffer();
                    this.m_popupAlert.append(sb.toString());
                }
            }
            e.setConfirmed(true);
        }
    }

    private void setFieldNewValue(WebSessionCtx wsc, WWindowStatus ws, GridField mField, Object newValue) {
        if (mField.getDisplayType() == 30) {
            boolean popup = true;
            String columnName = mField.getColumnName();
            String[] values = this.m_request.getParameterValues(columnName);
            if (values != null && values.length == 2 && values[1].length() > 0) {
                ResultSet rs;
                String text;
                NamePair np = null;
                if (values[0] != null && values[0].length() > 0) {
                    try {
                        int key = Integer.parseInt(values[0]);
                        np = mField.getLookup().get(new Integer(key));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                String name = text = values[1].toUpperCase();
                log.config(columnName + " - " + text);
                CPreparedStatement pstmt = null;
                String finalSQL = Msg.parseTranslation(wsc.ctx, AmpiereUtil.getDirectAccessSQL(wsc.ctx, mField.getLookup(), columnName, text));
                int id = -3;
                try {
                    pstmt = DB.prepareStatement(finalSQL, null);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        id = rs.getInt(1);
                        if (rs.next()) {
                            id = -1;
                        }
                    }
                    rs.close();
                    pstmt.close();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, finalSQL, e);
                    id = -2;
                }
                if (id == -3 && !text.endsWith("%")) {
                    text = text + "%";
                    finalSQL = Msg.parseTranslation(wsc.ctx, AmpiereUtil.getDirectAccessSQL(wsc.ctx, mField.getLookup(), columnName, text));
                    try {
                        pstmt = DB.prepareStatement(finalSQL, null);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            id = rs.getInt(1);
                            if (rs.next()) {
                                id = -1;
                            }
                        }
                        rs.close();
                        pstmt.close();
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, finalSQL, e);
                        id = -2;
                    }
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (id <= 0 && np != null && np.getName().equalsIgnoreCase(name)) {
                    id = Integer.parseInt(np.getID());
                }
                if (id <= 0) {
                    if (id == -3) {
                        log.fine(columnName + " - Not Found - " + finalSQL);
                    } else {
                        log.fine(columnName + " - Not Unique - " + finalSQL);
                    }
                } else {
                    log.fine(columnName + " - Unique ID=" + id);
                    ws.curTab.setValue(mField, (Object)new Integer(id));
                    popup = false;
                }
                if (popup) {
                    String col = mField.getLookup().getColumnName();
                    if (col != null && col.indexOf(".") >= 0) {
                        col = col.substring(col.indexOf(".") + 1);
                    }
                    String s = "startLookup('" + columnName + "'," + mField.getWindowNo() + "," + mField.getAD_Column_ID() + ",'" + col + "', 'N','" + values[1] + "');";
                    this.m_popupLookup = s + "return false;";
                }
            }
        } else {
            ws.curTab.setValue(mField, newValue);
        }
    }

    private void resetAmountformat(WebSessionCtx wsc, WWindowStatus ws) {
        MCurrency mCurrency;
        GridField[] fields = ws.mWindow.getTab(0).getFields();
        int currencyId = 0;
        for (int i2 = 0; i2 < fields.length; ++i2) {
            String fieldName = fields[i2].getColumnName();
            if (!fieldName.equals("C_Currency_ID")) continue;
            if (fields[i2].getValue() == null) break;
            currencyId = new Integer(fields[i2].getValue().toString());
            break;
        }
        if (currencyId == 0) {
            currencyId = Env.getContextAsInt(wsc.ctx, "$C_Currency_ID");
        }
        if ((mCurrency = new MCurrency(wsc.ctx, currencyId, null)) != null) {
            wsc.amountFormat.setMinimumFractionDigits(mCurrency.getStdPrecision());
            wsc.costPriceFormat.setMinimumFractionDigits(mCurrency.getStdPrecision());
        }
    }
}

