/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.servlet.WWindowStatus;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WReport
extends HttpServlet {
    private static final long serialVersionUID = -66341541642842506L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WPrintWindow.init");
        }
    }

    public final String getServletInfo() {
        return "Ampiere Web Report Window";
    }

    public final void destroy() {
        this.log.info("destroy");
        super.destroy();
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        int tableId = 0;
        WWindowStatus ws = WWindowStatus.get(request);
        if (ws != null) {
            tableId = ws.curTab.getAD_Table_ID();
        }
        String title = Msg.getMsg(wsc.ctx, "Report") + ": " + Msg.getElement(wsc.ctx, ws.getCurTab().getKeyColumnName());
        WebDoc doc = WebDoc.createWindow(title);
        doc.getBody().addElement((Element)new script("top.document.title='" + title + "';"));
        AmpiereUtil.addDatePicker(doc.getHead(), wsc);
        td center = doc.addWindowCenter(false);
        form myForm = new form("WReport").setName("WReport");
        table myTable = new table("0", "0", "5", "100%", null);
        myTable.setID("WReport");
        tr line = new tr();
        line.addElement((Element)new td().addElement(Msg.translate(wsc.ctx, "AD_PrintFormat_ID")).setAlign("right"));
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        String sql = MRole.getDefault().addAccessSQL("SELECT AD_PrintFormat_ID, Name, AD_Client_ID FROM AD_PrintFormat WHERE AD_Table_ID=? AND IsTableBased='Y' ORDER BY AD_Client_ID DESC, IsDefault DESC, Name", "AD_PrintFormat", false, false);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, tableId);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                ids.add(rs.getString(1));
                names.add(rs.getString(2));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        option[] options = new option[ids.size()];
        for (int i2 = 0; i2 < ids.size(); ++i2) {
            options[i2] = new option((String)ids.get(i2)).addElement((String)names.get(i2));
        }
        line.addElement((Element)new td().addElement(new select("PrintFormat", options).setID("PrintFormat")));
        myTable.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement(Msg.translate(wsc.ctx, "Export")).setAlign("right"));
        options = new option[7];
        options[0] = new option("ps").addElement(Msg.getMsg(wsc.ctx, "FilePS"));
        options[1] = new option("xml").addElement(Msg.getMsg(wsc.ctx, "FileXML"));
        options[2] = new option("pdf").addElement(Msg.getMsg(wsc.ctx, "FilePDF"));
        options[2].setSelected(true);
        options[3] = new option("html").addElement(Msg.getMsg(wsc.ctx, "FileHTML"));
        options[4] = new option("txt").addElement(Msg.getMsg(wsc.ctx, "FileTXT"));
        options[5] = new option("ssv").addElement(Msg.getMsg(wsc.ctx, "FileSSV"));
        options[6] = new option("csv").addElement(Msg.getMsg(wsc.ctx, "FileCSV"));
        line.addElement((Element)new td().addElement(new select("FileFormat", options).setID("FileFormat")));
        myTable.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td(WebEnv.NBSP).setColSpan(2));
        myTable.addElement((Element)line);
        line = new tr();
        input bt = new input("button", "Export", Msg.translate(wsc.ctx, "Start"));
        StringBuffer sb = new StringBuffer();
        sb.append("openPrintWindow('/compiere/ampiere/WPrintWindow");
        sb.append("?PrintFormat='+document.WReport.PrintFormat.value+");
        sb.append("'&FileFormat='+document.WReport.FileFormat.value");
        sb.append(",'' );");
        bt.setOnClick(sb.toString());
        line.addElement((Element)new td(null, "center", "middle", false, (Element)bt).setColSpan(2));
        myTable.addElement((Element)line);
        myForm.addElement((Element)myTable);
        center.addElement((Element)myForm);
        doc.getBody().setOnUnload("closeMyChildren();");
        WebUtil.createResponse(request, response, this, null, doc, true);
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doPost");
    }
}

