/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.web.servlet.WWindowStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.compiere.model.GridField;
import org.compiere.model.MQuery;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WPrintWindow
extends HttpServlet {
    private static final long serialVersionUID = 9003001336699200370L;
    private static final int BUFFER_SIZE = 1024;
    private static final int MAX_RECORD = 500;
    private final CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WPrintWindow.init");
        }
    }

    public final String getServletInfo() {
        return "Ampiere Web Print Window";
    }

    public final void destroy() {
        this.log.info("destroy");
        super.destroy();
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WWindowStatus ws = WWindowStatus.get(request);
        int tableId = ws.curTab.getAD_Table_ID();
        MQuery query = ws.getCurTab().getQuery().deepCopy();
        query.addRestriction(ws.getCurTab().getWhereClause());
        String queryColumn = ws.curTab.getLinkColumnName();
        String infoName = null;
        String infoDisplay = null;
        for (int i = 0; i < ws.curTab.getFieldCount(); ++i) {
            GridField field = ws.curTab.getField(i);
            if (field.isKey()) {
                infoName = field.getHeader();
            }
            if ((field.getColumnName().equals("Name") || field.getColumnName().equals("DocumentNo")) && field.getValue() != null) {
                infoDisplay = field.getValue().toString();
            }
            if (infoName != null && infoDisplay != null) break;
        }
        if (queryColumn.length() != 0) {
            String value = Env.getContext(ws.ctx, ws.mWindow.getWindowNo(), ws.curTab.getTabNo(), queryColumn);
            query.addRestriction(queryColumn, "=", value, infoName, infoDisplay);
        }
        MPrintFormat printFormat = null;
        if (request.getParameter("PrintFormat").equals("")) {
            printFormat = MPrintFormat.createFromTable(ws.ctx, tableId);
        } else {
            int pfId = new Integer(request.getParameter("PrintFormat"));
            printFormat = MPrintFormat.get(wsc.ctx, pfId, false);
        }
        printFormat.setLanguage(wsc.language);
        printFormat.setTranslationLanguage(wsc.language);
        PrintInfo printInfo = new PrintInfo(printFormat.getName(), printFormat.getAD_Table_ID(), ws.curTab.getRecord_ID());
        printInfo.setDescription(query.getInfo());
        ReportEngine re = new ReportEngine(wsc.ctx, printFormat, query, printInfo);
        if (re.getRowCount() > 500) {
            WebUtil.createErrorPage(request, response, this, Msg.getMsg(ws.ctx, "Can not create report for over 500 records!!!"));
        } else {
            boolean result = this.makeDownloadFile(re, request, response, wsc.language);
            if (!result) {
                WebUtil.createErrorPage(request, response, this, Msg.getMsg(ws.ctx, "Can not create report !!!"));
            }
        }
        re = null;
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doPost");
    }

    private boolean makeDownloadFile(ReportEngine reportEngine, HttpServletRequest request, HttpServletResponse response, Language language) {
        boolean result = true;
        try {
            if (request.getParameter("FileFormat").equals("ps")) {
                int len;
                response.setContentType("application/postscript");
                response.setHeader("Content-Disposition", "inline; filename=" + reportEngine.getName() + ".ps");
                response.setHeader("Content-Description", "File download for PS.");
                File f = File.createTempFile("ReportEngine", ".ps");
                reportEngine.createPS(f);
                FileInputStream fis = new FileInputStream(f);
                ServletOutputStream ouputStream = response.getOutputStream();
                byte[] buf = new byte[1024];
                while ((len = fis.read(buf)) != -1) {
                    ouputStream.write(buf, 0, len);
                }
                fis.close();
                f.delete();
                ouputStream.flush();
                ouputStream.close();
            } else if (request.getParameter("FileFormat").equals("xml")) {
                response.setContentType("application/xml;charset=UTF8");
                response.setHeader("Content-Disposition", "inline; filename=" + reportEngine.getName() + ".xml");
                response.setHeader("Content-Description", "File download for XML.");
                PrintWriter writer = response.getWriter();
                reportEngine.createXML(writer);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            } else if (request.getParameter("FileFormat").equals("pdf")) {
                response.setContentType("application/pdf");
                response.setHeader("Content-Disposition", "inline; filename=" + reportEngine.getName() + ".pdf");
                response.setHeader("Content-Description", "File download for PDF.");
                ServletOutputStream ouputStream = response.getOutputStream();
                ouputStream.write(reportEngine.createPDFData());
                ouputStream.flush();
                ouputStream.close();
            } else if (request.getParameter("FileFormat").equals("html")) {
                response.setContentType("text/html");
                response.setHeader("Content-Disposition", "inline; filename=" + reportEngine.getName() + ".html");
                response.setHeader("Content-Description", "File download for HTML.");
                PrintWriter writer = response.getWriter();
                reportEngine.createHTML(writer, false, language);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            } else if (request.getParameter("FileFormat").equals("txt")) {
                response.setContentType("text/plain;charset=" + this.getCharSet(request.getLocale().getLanguage()));
                response.setHeader("Content-Disposition", "inline; filename=" + reportEngine.getName() + ".txt");
                response.setHeader("Content-Description", "File download for TXT.");
                PrintWriter writer = response.getWriter();
                reportEngine.createCSV(writer, '\t', language);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            } else if (request.getParameter("FileFormat").equals("ssv")) {
                response.setContentType("text/plain;charset=" + this.getCharSet(request.getLocale().getLanguage()));
                response.setHeader("Content-Disposition", "inline; filename=" + reportEngine.getName() + ".ssv");
                response.setHeader("Content-Description", "File download for SSV.");
                PrintWriter writer = response.getWriter();
                reportEngine.createCSV(writer, ';', language);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            } else if (request.getParameter("FileFormat").equals("csv")) {
                response.setContentType("application/vnd.ms-excel;charset=" + this.getCharSet(request.getLocale().getLanguage()));
                response.setHeader("Content-Disposition", "inline; filename=" + reportEngine.getName() + ".csv");
                response.setHeader("Content-Description", "File download for CSV.");
                PrintWriter writer = response.getWriter();
                reportEngine.createCSV(writer, ',', language);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            } else {
                result = false;
            }
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "ReportEngine", e);
            result = false;
        }
        return result;
    }

    private String getCharSet(String local) {
        String charset = "UTF8";
        charset = local.equals("ar") ? "ISO-8859-6" : (local.equals("be") ? "ISO-8859-5" : (local.equals("bg") ? "ISO-8859-5" : (local.equals("ca") ? "ISO-8859-1" : (local.equals("cs") ? "ISO-8859-2" : (local.equals("da") ? "ISO-8859-1" : (local.equals("de") ? "ISO-8859-1" : (local.equals("el") ? "ISO-8859-7" : (local.equals("en") ? "ISO-8859-1" : (local.equals("es") ? "ISO-8859-1" : (local.equals("et") ? "ISO-8859-1" : (local.equals("fi") ? "ISO-8859-1" : (local.equals("fr") ? "ISO-8859-1" : (local.equals("hr") ? "ISO-8859-2" : (local.equals("hu") ? "ISO-8859-2" : (local.equals("is") ? "ISO-8859-1" : (local.equals("it") ? "ISO-8859-1" : (local.equals("iw") ? "ISO-8859-8" : (local.equals("ja") ? "Shift_JIS" : (local.equals("ko") ? "EUC-KR" : (local.equals("lt") ? "ISO-8859-2" : (local.equals("lv") ? "ISO-8859-2" : (local.equals("mk") ? "ISO-8859-5" : (local.equals("nl") ? "ISO-8859-1" : (local.equals("no") ? "ISO-8859-1" : (local.equals("pl") ? "ISO-8859-2" : (local.equals("pt") ? "ISO-8859-1" : (local.equals("ro") ? "ISO-8859-2" : (local.equals("ru") ? "ISO-8859-5" : (local.equals("sh") ? "ISO-8859-5" : (local.equals("sk") ? "ISO-8859-2" : (local.equals("sl") ? "ISO-8859-2" : (local.equals("sq") ? "ISO-8859-2" : (local.equals("sr") ? "ISO-8859-5" : (local.equals("sv") ? "ISO-8859-1" : (local.equals("tr") ? "ISO-8859-9" : (local.equals("uk") ? "ISO-8859-5" : (local.equals("zh") ? "GB2312" : (local.equals("zh_TW") ? "Big5" : "UTF8"))))))))))))))))))))))))))))))))))))));
        return charset;
    }
}

