/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.tree.TreeNode;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.base;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.cite;
import org.apache.ecs.xhtml.head;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MForm;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.X_AD_Menu;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WMenu
extends HttpServlet {
    private static final long serialVersionUID = 69175041285196528L;
    protected CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WMenu.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Menu";
    }

    public void destroy() {
        this.log.fine("destroy");
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.fine("doGet - Process Menu Request");
        if (WebUtil.getParameter(request, "Exit") != null) {
            WebUtil.createLoginPage(request, response, this, null, "Exit");
            return;
        }
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc.ctx == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        int AD_Window_ID = WebUtil.getParameterAsInt(request, "AD_Window_ID");
        if (AD_Window_ID != 0) {
            this.log.fine("doGet - AD_Window_ID=" + AD_Window_ID);
            String url = WebEnv.getBaseDirectory("WWindow?AD_Window_ID=" + AD_Window_ID);
            this.log.fine("doGet - Forward to=" + url);
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(url);
            rd.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        WebUtil.createErrorPage(request, response, this, "NotImplemented");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.fine("doPost - Create Menu");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        String role = WebUtil.getParameter(request, "AD_Role_ID");
        String client = WebUtil.getParameter(request, "AD_Client_ID");
        String org = WebUtil.getParameter(request, "AD_Org_ID");
        String wh = WebUtil.getParameter(request, "M_Warehouse_ID");
        if (wh == null) {
            wh = "";
        }
        if (role == null || client == null || org == null) {
            WebUtil.createTimeoutPage(request, response, this, Msg.getMsg(wsc.ctx, "ParameterMissing"));
            return;
        }
        int AD_User_ID = Env.getAD_User_ID(wsc.ctx);
        int AD_Role_ID = Env.getAD_Role_ID(wsc.ctx);
        int AD_Client_ID = Env.getAD_Client_ID(wsc.ctx);
        int AD_Org_ID = -1;
        int M_Warehouse_ID = -1;
        try {
            int req_role = Integer.parseInt(role);
            if (req_role != AD_Role_ID) {
                this.log.fine("doPost - AD_Role_ID - changed from " + AD_Role_ID);
                AD_Role_ID = req_role;
                Env.setContext(wsc.ctx, "#AD_Role_ID", AD_Role_ID);
            }
            this.log.fine("doPost - AD_Role_ID = " + AD_Role_ID);
            int req_client = Integer.parseInt(client);
            if (req_client != AD_Client_ID) {
                this.log.fine("doPost - AD_Client_ID - changed from " + AD_Client_ID);
                AD_Client_ID = req_client;
                Env.setContext(wsc.ctx, "#AD_Client_ID", AD_Client_ID);
            }
            this.log.fine("doPost - AD_Client_ID = " + AD_Client_ID);
            AD_Org_ID = Integer.parseInt(org);
            this.log.fine("doPost - AD_Org_ID = " + AD_Org_ID);
            if (wh.length() > 0) {
                M_Warehouse_ID = Integer.parseInt(wh);
                this.log.fine("doPost - M_Warehouse_ID = " + M_Warehouse_ID);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "doPost - Parameter", e);
            WebUtil.createTimeoutPage(request, response, this, Msg.getMsg(wsc.ctx, "ParameterMissing"));
            return;
        }
        wsc.loginInfo = this.checkLogin(wsc.ctx, AD_User_ID, AD_Role_ID, AD_Client_ID, AD_Org_ID, M_Warehouse_ID);
        if (wsc.loginInfo == null) {
            WebUtil.createErrorPage(request, response, this, Msg.getMsg(wsc.ctx, "RoleInconsistent"));
            return;
        }
        Properties cProp = WebUtil.getCookieProprties(request);
        cProp.setProperty("AD_Role_ID", String.valueOf(AD_Role_ID));
        cProp.setProperty("AD_Client_ID", String.valueOf(AD_Client_ID));
        cProp.setProperty("AD_Org_ID", String.valueOf(AD_Org_ID));
        if (M_Warehouse_ID == -1) {
            cProp.setProperty("M_Warehouse_ID", "");
        } else {
            cProp.setProperty("M_Warehouse_ID", String.valueOf(M_Warehouse_ID));
        }
        Timestamp ts = WebUtil.getParameterAsDate(request, "Date", wsc.language);
        if (ts == null) {
            ts = new Timestamp(System.currentTimeMillis());
        }
        Env.setContext(wsc.ctx, "#Date", ts);
        Env.setContext(wsc.ctx, "#ShowAcct", true);
        Env.setContext(wsc.ctx, "CacheWindow", false);
        Ini.setProperty("CacheWindow", false);
        if (!cProp.getProperty("SaveCookie", "N").equals("Y")) {
            cProp.clear();
        }
        WebDoc doc = this.createPage(request, wsc, AD_Role_ID);
        WebUtil.createResponse(request, response, this, cProp, doc, true);
    }

    private String checkLogin(Properties ctx, int AD_User_ID, int AD_Role_ID, int AD_Client_ID, int AD_Org_ID, int M_Warehouse_ID) {
        String loginInfo = null;
        String sql = "SELECT u.Name || '@' || c.Name || '.' || o.Name || ' [' || INITCAP(USER) || ']' AS Text FROM AD_User u, AD_Client c, AD_Org o, AD_User_Roles ur WHERE u.AD_User_ID=? AND c.AD_Client_ID=? AND o.AD_Org_ID=? AND ur.AD_Role_ID=? AND ur.AD_User_ID=u.AD_User_ID AND (o.AD_Client_ID = 0 OR o.AD_Client_ID=c.AD_Client_ID) AND c.AD_Client_ID IN (SELECT AD_Client_ID FROM AD_Role_OrgAccess ca WHERE ca.AD_Role_ID=ur.AD_Role_ID) AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_Role_OrgAccess ca WHERE ca.AD_Role_ID=ur.AD_Role_ID)";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_User_ID);
            pstmt.setInt(2, AD_Client_ID);
            pstmt.setInt(3, AD_Org_ID);
            pstmt.setInt(4, AD_Role_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                loginInfo = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        if (loginInfo == null) {
            return null;
        }
        KeyNamePair org = new KeyNamePair(AD_Org_ID, String.valueOf(AD_Org_ID));
        KeyNamePair wh = null;
        if (M_Warehouse_ID > 0) {
            wh = new KeyNamePair(M_Warehouse_ID, String.valueOf(M_Warehouse_ID));
        }
        Timestamp date = null;
        String printer = null;
        Login login = new Login(ctx);
        login.loadPreferences(org, wh, date, printer);
        Env.setContext(ctx, "#ShowAcct", "N");
        Env.setContext(ctx, "#ShowTrl", "N");
        return loginInfo;
    }

    private WebDoc createPage(HttpServletRequest request, WebSessionCtx wsc, int AD_Role_ID) {
        String windowTitle = Msg.getMsg(wsc.ctx, "Menu");
        WebDoc doc = WebDoc.create(windowTitle);
        head head2 = doc.getHead();
        head2.addElement((Element)new base().setTarget("WWindow"));
        head2.addElement((Element)new link(WebEnv.getBaseDirectory("css/menu.css"), "stylesheet", "text/css"));
        head2.addElement((Element)new script((Element)null, WebEnv.getBaseDirectory("js/menu.js")));
        String statusMessage = Msg.getMsg(wsc.ctx, "SelectMenuItem");
        String scriptTxt = "top.document.title='" + windowTitle + " - " + wsc.loginInfo + "'; " + "var defaultStatus='" + statusMessage + "';";
        head2.addElement((Element)new script(scriptTxt));
        body body2 = doc.getBody();
        body2.setTitle(statusMessage);
        body2.addElement((Element)WebUtil.getClearFrame("WWindow"));
        table table2 = doc.getTable();
        doc.setClasses("menuTable", "menuHeader");
        doc.getTopLeft().addElement((Element)new cite(wsc.loginInfo));
        int AD_Tree_ID = DB.getSQLValue(null, "SELECT COALESCE(r.AD_Tree_Menu_ID, ci.AD_Tree_Menu_ID)FROM AD_ClientInfo ci INNER JOIN AD_Role r ON (ci.AD_Client_ID=r.AD_Client_ID) WHERE AD_Role_ID=?", AD_Role_ID);
        if (AD_Tree_ID <= 0) {
            AD_Tree_ID = 10;
        }
        this.log.fine("doPost - AD_Tree_ID=" + AD_Tree_ID + " - " + Env.getAD_Language(wsc.ctx));
        MTree tree = new MTree(wsc.ctx, AD_Tree_ID, false, false, null);
        MTreeNode root = tree.getRoot();
        Enumeration<TreeNode> en = root.preorderEnumeration();
        while (en.hasMoreElements()) {
            MTreeNode nd = (MTreeNode)en.nextElement();
            if (!nd.isTask() && !nd.isWorkbench() && !nd.isWorkFlow() && nd.getNode_ID() != 383) continue;
            MTreeNode parent = (MTreeNode)nd.getParent();
            parent.remove(nd);
        }
        tree.trimTree();
        StringBuffer buf = new StringBuffer();
        en = root.preorderEnumeration();
        int oldLevel = 0;
        while (en.hasMoreElements()) {
            MTreeNode nd = (MTreeNode)en.nextElement();
            int level = nd.getLevel();
            if (level == 0) continue;
            while (oldLevel < level) {
                if (level == 1) {
                    buf.append("<ul id=\"main\">\n");
                } else {
                    buf.append("<ul style=\"display:none\">\n");
                }
                ++oldLevel;
            }
            while (oldLevel > level) {
                if (--oldLevel == 1) {
                    buf.append("</ul>\n");
                    continue;
                }
                buf.append("</ul></li>\n");
            }
            buf.append(this.printNode(nd, wsc.ctx));
        }
        while (oldLevel > 0) {
            if (--oldLevel == 1) {
                buf.append("</ul>\n");
                continue;
            }
            buf.append("</ul></li>\n");
        }
        td td2 = new td().setColSpan(2).setNoWrap(true);
        td2.setClass("menuCenter");
        td2.addElement(buf.toString());
        table2.addElement((Element)new tr().addElement((Element)td2));
        td2 = new td().setColSpan(2);
        td2.setClass("menuFooter");
        String url = request.getRequestURI() + "?Exit=true";
        td2.addElement((Element)new a(url, Msg.getMsg(wsc.ctx, "Exit")));
        table2.addElement((Element)new tr().addElement((Element)td2));
        input t = new input("hidden", "MenuOnOff", "MenuOn");
        t.setID("MenuOnOff");
        table2.addElement((Element)t);
        return doc;
    }

    private StringBuffer printNode(MTreeNode node, Properties ctx) {
        StringBuffer sb = new StringBuffer();
        if (!node.isSummary()) {
            MForm form2;
            String cssClassName = "";
            String servletName = "";
            if (node.isWindow()) {
                cssClassName = "menuWindow";
                servletName = "WWindow";
            } else if (node.isForm()) {
                cssClassName = "menuWindow";
                servletName = "WFormWindow";
            } else if (node.isReport()) {
                cssClassName = "menuReport";
                servletName = "WProcess";
            } else if (node.isProcess()) {
                cssClassName = "menuProcess";
                servletName = "WProcess";
            } else if (node.isWorkFlow()) {
                cssClassName = "menuWorkflow";
                servletName = "WWorkflow";
            } else if (node.isTask()) {
                cssClassName = "menuProcess";
                servletName = "WTask";
            } else {
                servletName = "WError";
            }
            String name = node.getName().replace('\'', ' ').replace('\"', ' ');
            String description = node.getDescription().replace('\'', ' ').replace('\"', ' ');
            sb.append("<li class=\"" + cssClassName + "\" id=\"" + node.getNode_ID() + "\"><a href=\"");
            boolean standardURL = true;
            if (node.isForm() && (form2 = new MForm(ctx, new X_AD_Menu(ctx, node.getNode_ID(), null).getAD_Form_ID(), null)).getJSPURL() != null && form2.getJSPURL().length() > 0) {
                sb.append(form2.getJSPURL());
                standardURL = false;
            }
            if (standardURL) {
                sb.append(WebEnv.getBaseDirectory(servletName));
            }
            sb.append("?AD_Menu_ID=");
            sb.append(node.getNode_ID());
            sb.append("\" onMouseOver=\"status='" + description + "';\" onClick=\"showLoadingWindow('" + WebEnv.getBaseDirectory("") + "')\">").append(name).append("</a></li>\n");
        } else {
            String name = node.getName().replace('\'', ' ').replace('\"', ' ');
            sb.append("\n<li class=\"menuSummary\" id=\"" + node.getNode_ID() + "\" onClick=\"changeMenu(event);\">").append(name).append("\n");
        }
        return sb;
    }
}

