/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.web.servlet.WWindowStatus;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WHistory
extends HttpServlet {
    private static final long serialVersionUID = 6617424544044122702L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WProcess.init");
        }
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.fine("doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WebDoc doc = this.createFindPage(request);
        if (doc == null) {
            doc = WebDoc.createWindow("Error");
        }
        doc.getBody().setOnUnload("closeMyChildren();");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.fine("doPost");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        if (WebUtil.getParameter(request, "All") != null) {
            ws.curTab.query(false, 0);
        } else if (WebUtil.getParameter(request, "Year") != null) {
            ws.curTab.query(false, 365);
        } else if (WebUtil.getParameter(request, "Month") != null) {
            ws.curTab.query(false, 31);
        } else if (WebUtil.getParameter(request, "Week") != null) {
            ws.curTab.query(false, 7);
        } else if (WebUtil.getParameter(request, "Day") != null) {
            ws.curTab.query(true, 0);
        }
        WebDoc doc = WebDoc.createWindow(ws.curTab.getTableName());
        doc.getBody().addElement(ws.curTab.getQuery().getWhereClause());
        StringBuffer sb = new StringBuffer();
        sb.append("<script language='javascript'>");
        sb.append("   opener.document.WForm.PCommand.value='Refresh';");
        sb.append("   opener.document.WForm.submit();");
        sb.append("   window.close();");
        sb.append("</script>");
        doc.getBody().addElement(sb.toString());
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    private WebDoc createFindPage(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        WebDoc doc = WebDoc.createWindow(Msg.getMsg(ws.ctx, "VOnlyCurrentDays", true));
        form myForm = new form(request.getRequestURI());
        myForm.setID("WHistory");
        table myTable = new table();
        myTable.setAlign("CENTER");
        myTable.addElement((Element)new tr().addElement((Element)new td(null, "center", "middle", false, (Element)new input("submit", "Day", Msg.translate(wsc.ctx, "Day")))).addElement((Element)new td(null, "center", "middle", false, (Element)new input("submit", "Week", Msg.translate(wsc.ctx, "Week")))).addElement((Element)new td(null, "center", "middle", false, (Element)new input("submit", "Month", Msg.translate(wsc.ctx, "Month")))).addElement((Element)new td(null, "center", "middle", false, (Element)new input("submit", "Year", Msg.translate(wsc.ctx, "Year")))).addElement((Element)new td(null, "center", "middle", false, (Element)new input("submit", "All", Msg.translate(wsc.ctx, "All")))));
        myForm.addElement((Element)myTable);
        doc.getBody().addElement((Element)myForm);
        return doc;
    }
}

