/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.servlet.WebField;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.GridField;
import org.compiere.model.MQuery;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WFind
extends HttpServlet {
    private static final long serialVersionUID = 6617424544044122702L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WProcess.init");
        }
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WebDoc doc = this.createFindPage(request);
        if (doc == null) {
            doc = WebDoc.createWindow("Error");
        }
        doc.getBody().setOnUnload("closeMyChildren();");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        MQuery query = new MQuery(ws.curTab.getTableName());
        GridField[] findFields = GridField.createFields(ws.ctx, ws.curTab.getWindowNo(), 0, ws.curTab.getAD_Tab_ID());
        for (int i = 0; i < findFields.length; ++i) {
            String value;
            String columnName = findFields[i].getColumnName();
            if (columnName.equals("Value")) {
                value = WebUtil.getParameter(request, columnName).toUpperCase();
                if (value.equals("") || value.equals("%")) continue;
                if (!value.endsWith("%")) {
                    value = value + "%";
                }
                query.addRestriction("UPPER(Value)", " LIKE ", value);
                continue;
            }
            if (columnName.equals("Name")) {
                value = WebUtil.getParameter(request, columnName).toUpperCase();
                if (value.equals("") || value.equals("%")) continue;
                if (!value.endsWith("%")) {
                    value = value + "%";
                }
                query.addRestriction("UPPER(Name)", " LIKE ", value);
                continue;
            }
            if (columnName.equals("DocumentNo")) {
                value = WebUtil.getParameter(request, columnName).toUpperCase();
                if (value.equals("") || value.equals("%")) continue;
                if (!value.endsWith("%")) {
                    value = value + "%";
                }
                query.addRestriction("UPPER(DocumentNo)", " LIKE ", value);
                continue;
            }
            if (!columnName.equals("Description") || (value = WebUtil.getParameter(request, columnName).toUpperCase()).equals("") || value.equals("%")) continue;
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            query.addRestriction("UPPER(Description)", " LIKE ", value);
        }
        ws.curTab.setQuery(query);
        ws.curTab.query(ws.curTab.isOnlyCurrentRows(), 0);
        WebDoc doc = WebDoc.createWindow(ws.curTab.getTableName());
        doc.getBody().addElement(ws.curTab.getQuery().getWhereClause());
        StringBuffer sb = new StringBuffer();
        sb.append("<script language='javascript'>");
        sb.append("   opener.document.WForm.PCommand.value='Refresh';");
        sb.append("   opener.document.WForm.submit();");
        sb.append("   window.close();");
        sb.append("</script>");
        doc.getBody().addElement(sb.toString());
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    private WebDoc createFindPage(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        WebDoc doc = WebDoc.createWindow(ws.curTab.getTableName());
        AmpiereUtil.addDatePicker(doc.getHead(), wsc);
        form myForm = new form(request.getRequestURI());
        myForm.setID("WFind");
        table myTable = new table();
        myTable.setAlign("CENTER");
        GridField[] findFields = GridField.createFields(ws.ctx, ws.curTab.getWindowNo(), 0, ws.curTab.getAD_Tab_ID());
        for (int i = 0; i < findFields.length; ++i) {
            tr myTr = new tr();
            String columnName = findFields[i].getColumnName();
            if (columnName.equals("Value")) {
                this.addField(wsc, myTr, findFields[i], findFields[i].getDefault(), false, false);
                myTable.addElement((Element)myTr);
                continue;
            }
            if (columnName.equals("Name")) {
                this.addField(wsc, myTr, findFields[i], findFields[i].getDefault(), false, false);
                myTable.addElement((Element)myTr);
                continue;
            }
            if (columnName.equals("DocumentNo")) {
                this.addField(wsc, myTr, findFields[i], findFields[i].getDefault(), false, false);
                myTable.addElement((Element)myTr);
                continue;
            }
            if (!columnName.equals("Description")) continue;
            this.addField(wsc, myTr, findFields[i], findFields[i].getDefault(), false, false);
            myTable.addElement((Element)myTr);
        }
        tr myTr = new tr((Element)new td("&nbsp;"));
        myTable.addElement((Element)myTr);
        myTable.addElement((Element)new tr().addElement((Element)new td(null, "left", "middle", false, (Element)new input("reset", "Reset", Msg.translate(wsc.ctx, "Reset")))).addElement((Element)new td(null, "center", "middle", false, null)).addElement((Element)new td(null, "right", "middle", false, (Element)new input("submit", "Submit", Msg.translate(wsc.ctx, "Start")))));
        myForm.addElement((Element)myTable);
        doc.getBody().addElement((Element)myForm);
        return doc;
    }

    private void addField(WebSessionCtx wsc, tr line, GridField field, Object oData, boolean hasDependents, boolean readOnly) {
        String columnName = field.getColumnName();
        Object data = oData;
        boolean error = field.isErrorValue();
        if (error) {
            this.log.log(Level.SEVERE, oData.toString());
            data = field.getErrorValue();
        }
        int dt = field.getDisplayType();
        boolean hasCallout = field.getCallout().length() > 0;
        WebField wField = new WebField(field.getWindowNo(), wsc, columnName, field.getHeader(), field.getDescription(), dt, field.getFieldLength(), field.getDisplayLength() * 8, field.isLongField(), readOnly, field.isMandatory(false), error, hasDependents, hasCallout, field.getAD_Process_ID(), field.isEncryptedField());
        line.addElement((Element)wField.getLabel());
        line.addElement((Element)wField.getField(field.getLookup(), data, field.getAD_Column_ID()));
    }
}

