/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.web.servlet.WWindowStatus;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.button;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.util.CLogger;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WAccount
extends HttpServlet {
    private static final long serialVersionUID = -6348547380305885368L;
    private static CLogger log = CLogger.getCLogger(WAccount.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WAccount.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.config("WAccount.doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null || ws == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        String columnName = WebUtil.getParameter(request, "columnName");
        GridField mField = ws.curTab.getField(columnName);
        log.config("ColumnName=" + columnName + ", MField=" + mField.toString());
        if (mField == null || columnName == null || columnName.equals("")) {
            WebUtil.createTimeoutPage(request, response, this, Msg.getMsg(wsc.ctx, "ParameterMissing"));
            return;
        }
        String target = columnName;
        WebDoc doc = WebDoc.create(mField.getHeader());
        doc.getHead().addElement((Element)new script((Element)null, "js/window.js"));
        StringBuffer sb = new StringBuffer();
        sb.append("function selectAccount(columnName, key, value) {\n").append("    if (! checkParent(window)) {\n").append("        window.close();\n").append("\t\treturn;\n").append("\t}\n").append("    var targetObj = null;\n").append("    var updateObj = null;\n").append("    if (window.opener.top.WWindow) {\n").append("    \ttargetObj = (window.opener.top.WWindow.document.getElementById(columnName + 'D'));\n").append("    \tupdateObj = (window.opener.top.WWindow.document.getElementById(columnName + 'F'));\n").append("    } else {\n").append("\t    targetObj = (window.opener.top.document.getElementById(columnName + 'D'));\n").append("\t    updateObj = (window.opener.top.document.getElementById(columnName + 'F'));\n").append("    }\n").append("    if (targetObj != null && updateObj != null) {\n").append("        targetObj.value = key;\n").append("        updateObj.value = value;\n").append("        startUpdate(updateObj);\n").append("    }\n").append("    window.close();\n").append("    window.opener.focus();\n").append("}\n");
        doc.getHead().addElement((Element)new script(sb.toString()));
        sb = new StringBuffer();
        sb.append("function resetAccount(columnName) {\n").append("    selectAccount(columnName, '', '');\n").append("}\n");
        doc.getHead().addElement((Element)new script(sb.toString()));
        body body2 = doc.getBody();
        body2.setOnBlur("self.focus();");
        body2.addElement((Element)this.fillTable(ws, mField, target));
        button reset = new button();
        reset.addElement("Reset");
        reset.setOnClick("resetAccount('" + target + "');");
        button cancel = new button();
        cancel.addElement("Cancel");
        cancel.setOnClick("window.close();");
        body2.addElement((Element)new p("right").addElement((Element)reset).addElement("&nbsp").addElement((Element)cancel));
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.config("WAccount.doPost");
        this.doGet(request, response);
    }

    private table fillTable(WWindowStatus ws, GridField mField, String target) {
        table table2 = new table("1");
        tr line = new tr();
        line.addElement((Element)new th("&nbsp")).addElement((Element)new th(Msg.translate(ws.ctx, "Name")));
        table2.addElement((Element)line);
        Lookup lookup = mField.getLookup();
        lookup.fillComboBox(mField.isMandatory(false), true, true, true);
        int size = lookup.getSize();
        for (int i = 0; i < size; ++i) {
            Object lValue = lookup.getElementAt(i);
            if (lValue == null || !(lValue instanceof KeyNamePair)) continue;
            KeyNamePair np = (KeyNamePair)lValue;
            button button2 = new button();
            button2.addElement("&gt;");
            StringBuffer script2 = new StringBuffer("selectAccount('" + target + "', '" + np.getKey() + "', '" + np.getName() + "');");
            button2.setOnClick(script2.toString());
            line = new tr();
            line.addElement((Element)new td((Element)button2));
            String name = np.getName();
            if (name == null || name.length() == 0) {
                name = "&nbsp";
            }
            line.addElement((Element)new td(name));
            table2.addElement((Element)line);
        }
        lookup.fillComboBox(true);
        return table2;
    }
}

