/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.util;

import java.io.InvalidClassException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.model.MPInstance;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWorkflow;

public class ProcessCtl
extends Thread {
    private ProcessInfo m_pi;
    private Trx m_trx;
    private Properties m_ctx;
    private boolean m_IsServerProcess = false;
    private static CLogger log = CLogger.getCLogger(ProcessCtl.class);

    public static ProcessCtl process(ASyncProcess parent, int WindowNo, ProcessInfo pi, Trx trx, Properties ctx) {
        log.fine("WindowNo=" + WindowNo + " - " + pi);
        MPInstance instance = new MPInstance(ctx, pi.getAD_Process_ID(), pi.getRecord_ID());
        if (!instance.save()) {
            pi.setSummary(Msg.getMsg(ctx, "ProcessNoInstance"));
            pi.setError(true);
            return null;
        }
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        ProcessCtl worker = new ProcessCtl(parent, pi, trx, ctx);
        worker.start();
        return worker;
    }

    public static ProcessCtl getProcessInstance(int WindowNo, ProcessInfo pi, Trx trx, Properties ctx) {
        log.fine("WindowNo=" + WindowNo + " - " + pi);
        MPInstance instance = new MPInstance(ctx, pi.getAD_Process_ID(), pi.getRecord_ID());
        if (!instance.save()) {
            pi.setSummary(Msg.getMsg(ctx, "ProcessNoInstance"));
            pi.setError(true);
            return null;
        }
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        return new ProcessCtl(null, pi, trx, ctx);
    }

    public ProcessCtl(ASyncProcess parent, ProcessInfo pi, Trx trx, Properties ctx) {
        this.m_pi = pi;
        this.m_trx = trx;
        this.m_ctx = ctx;
    }

    public void run() {
        log.fine("AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID() + ", Record_ID=" + this.m_pi.getRecord_ID());
        String ProcedureName = "";
        int AD_ReportView_ID = 0;
        int AD_Workflow_ID = 0;
        boolean IsReport = false;
        String sql = "SELECT p.Name, p.ProcedureName,p.ClassName, p.AD_Process_ID, p.isReport,p.IsDirectPrint,p.AD_ReportView_ID,p.AD_Workflow_ID, CASE WHEN COALESCE(p.Statistic_Count,0)=0 THEN 0 ELSE p.Statistic_Seconds/p.Statistic_Count END CASE, p.IsServerProcess FROM AD_Process p INNER JOIN AD_PInstance i ON (p.AD_Process_ID=i.AD_Process_ID) WHERE p.IsActive='Y' AND i.AD_PInstance_ID=?";
        if (!Env.isBaseLanguage(this.m_ctx, "AD_Process")) {
            sql = "SELECT t.Name, p.ProcedureName,p.ClassName, p.AD_Process_ID, p.isReport, p.IsDirectPrint,p.AD_ReportView_ID,p.AD_Workflow_ID, CASE WHEN COALESCE(p.Statistic_Count,0)=0 THEN 0 ELSE p.Statistic_Seconds/p.Statistic_Count END CASE, p.IsServerProcess FROM AD_Process p INNER JOIN AD_PInstance i ON (p.AD_Process_ID=i.AD_Process_ID)  INNER JOIN AD_Process_Trl t ON (p.AD_Process_ID=t.AD_Process_ID AND t.AD_Language='" + Env.getAD_Language(this.m_ctx) + "') " + "WHERE p.IsActive='Y'" + " AND i.AD_PInstance_ID=?";
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, 1003, 1007, null);
            pstmt.setInt(1, this.m_pi.getAD_PInstance_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_pi.setTitle(rs.getString(1));
                ProcedureName = rs.getString(2);
                this.m_pi.setClassName(rs.getString(3));
                this.m_pi.setAD_Process_ID(rs.getInt(4));
                if ("Y".equals(rs.getString(5))) {
                    IsReport = true;
                }
                AD_ReportView_ID = rs.getInt(7);
                AD_Workflow_ID = rs.getInt(8);
                int estimate = rs.getInt(9);
                if (estimate != 0) {
                    this.m_pi.setEstSeconds(estimate + 1);
                }
                this.m_IsServerProcess = "Y".equals(rs.getString(10));
            } else {
                log.log(Level.SEVERE, "No AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID());
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.m_pi.setSummary(Msg.getMsg(this.m_ctx, "ProcessNoProcedure") + " " + e.getLocalizedMessage(), true);
            log.log(Level.SEVERE, "run", e);
            return;
        }
        if (ProcedureName == null) {
            ProcedureName = "";
        }
        if (AD_Workflow_ID > 0) {
            this.startWorkflow(AD_Workflow_ID);
            return;
        }
        if (this.m_pi.getClassName() != null) {
            if (!this.startProcess()) {
                return;
            }
            if (!IsReport && ProcedureName.length() == 0) {
                return;
            }
            if (IsReport && AD_ReportView_ID == 0) {
                return;
            }
        }
        if (!IsReport && ProcedureName.length() == 0) {
            this.m_pi.setSummary(Msg.getMsg(this.m_ctx, "ProcessNoProcedure"), true);
            return;
        }
        if (IsReport) {
            if (ProcedureName.length() > 0 && !this.startDBProcess(ProcedureName)) {
                return;
            }
        } else {
            if (!this.startDBProcess(ProcedureName)) {
                return;
            }
            ProcessInfoUtil.setSummaryFromDB(this.m_pi);
        }
    }

    private boolean startWorkflow(int AD_Workflow_ID) {
        log.fine(AD_Workflow_ID + " - " + this.m_pi);
        boolean started = false;
        if (DB.isRemoteProcess()) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    this.m_pi = server.workflow(this.m_ctx, this.m_pi, AD_Workflow_ID);
                    log.finest("server => " + this.m_pi);
                    started = true;
                }
            }
            catch (RemoteException ex) {
                log.log(Level.SEVERE, "AppsServer error", ex);
                started = false;
            }
        }
        if (!started && !this.m_IsServerProcess) {
            MWorkflow wf = MWorkflow.get(this.m_ctx, AD_Workflow_ID);
            MWFProcess wfProcess = null;
            wfProcess = this.m_pi.isBatch() ? wf.start(this.m_pi) : wf.startWait(this.m_pi);
            started = wfProcess != null;
        }
        return started;
    }

    private boolean startProcess() {
        log.fine(this.m_pi.toString());
        boolean started = false;
        if (DB.isRemoteProcess()) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    this.m_pi = server.process(this.m_ctx, this.m_pi);
                    log.finest("server => " + this.m_pi);
                    started = true;
                }
            }
            catch (UndeclaredThrowableException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof InvalidClassException) {
                        log.log(Level.SEVERE, "Version Server <> Client: " + cause.toString() + " - " + this.m_pi, ex);
                    } else {
                        log.log(Level.SEVERE, "AppsServer error(1b): " + cause.toString() + " - " + this.m_pi, ex);
                    }
                } else {
                    log.log(Level.SEVERE, " AppsServer error(1) - " + this.m_pi, ex);
                }
                started = false;
            }
            catch (RemoteException ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                log.log(Level.SEVERE, "AppsServer error - " + this.m_pi, cause);
                started = false;
            }
        }
        if (!started && !this.m_IsServerProcess) {
            ProcessCall myObject = null;
            try {
                Class<?> myClass = Class.forName(this.m_pi.getClassName());
                myObject = (ProcessCall)myClass.newInstance();
                if (myObject == null) {
                    this.m_pi.setSummary("No Instance for " + this.m_pi.getClassName(), true);
                } else {
                    myObject.startProcess(this.m_ctx, this.m_pi, this.m_trx);
                }
                if (this.m_trx != null) {
                    this.m_trx.commit();
                    this.m_trx.close();
                }
            }
            catch (Exception e) {
                if (this.m_trx != null) {
                    this.m_trx.rollback();
                    this.m_trx.close();
                }
                this.m_pi.setSummary("Error starting Class " + this.m_pi.getClassName(), true);
                log.log(Level.SEVERE, this.m_pi.getClassName(), e);
            }
        }
        return !this.m_pi.isError();
    }

    private boolean startDBProcess(String ProcedureName) {
        log.fine(ProcedureName + "(" + this.m_pi.getAD_PInstance_ID() + ")");
        String sql = "{call " + ProcedureName + "(?)}";
        try {
            CallableStatement cstmt = DB.prepareCall(sql);
            cstmt.setInt(1, this.m_pi.getAD_PInstance_ID());
            cstmt.executeUpdate();
            cstmt.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
            this.m_pi.setSummary(Msg.getMsg(this.m_ctx, "ProcessRunError") + " " + e.getLocalizedMessage());
            this.m_pi.setError(true);
            return false;
        }
        return true;
    }
}

