/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.util;

import com.ampiere.web.struts.common.PopupBaseForm;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.head;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.td;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;

public class AmpiereUtil {
    private static CLogger log = CLogger.getCLogger(AmpiereUtil.class);
    public static final int MAX_RECORD_NUM = 1000;

    public static String maskHTML(String content) {
        String s = Util.maskHTML(content);
        if (WebEnv.NBSP.equalsIgnoreCase(s) || "&nbsp".equalsIgnoreCase(s)) {
            return "";
        }
        return s;
    }

    public static String maskHtmlCR(String content) {
        String s = AmpiereUtil.maskHTML(content);
        s = s.replaceAll("\n", WebEnv.NBSP);
        return s;
    }

    public static int getFixedColumnID(String columnName) {
        if (columnName == null) {
            return 0;
        }
        int AD_Column_ID = 0;
        if (columnName.indexOf("BPartner") >= 0) {
            AD_Column_ID = 3499;
        } else if (columnName.indexOf("Product") >= 0) {
            AD_Column_ID = 3840;
        } else if (columnName.indexOf("Invoice") >= 0) {
            AD_Column_ID = 5355;
        } else if (columnName.indexOf("Asset") >= 0) {
            AD_Column_ID = 271;
        } else if (columnName.indexOf("Order") >= 0) {
            AD_Column_ID = 12925;
        } else if (columnName.indexOf("InOut") < 0) {
            if (columnName.indexOf("Payment") >= 0) {
                AD_Column_ID = 4884;
            } else if (columnName.indexOf("CashLine") < 0) {
                if (columnName.indexOf("ResourceAssigment") >= 0) {
                    AD_Column_ID = 6851;
                } else if (columnName.indexOf("Currency") >= 0) {
                    AD_Column_ID = 3505;
                } else if (columnName.indexOf("User") >= 0) {
                    AD_Column_ID = 10510;
                }
            }
        }
        return AD_Column_ID;
    }

    public static String getFixedColumnName(String columnName) {
        String id = "General";
        if (columnName == null) {
            return id;
        }
        if (columnName.indexOf("BPartner") >= 0) {
            id = "BPartner";
        } else if (columnName.indexOf("Product") >= 0) {
            id = "Product";
        } else if (columnName.indexOf("Invoice") >= 0) {
            id = "Invoice";
        } else if (columnName.indexOf("Asset") >= 0) {
            id = "Asset";
        } else if (columnName.indexOf("Order") >= 0) {
            id = "Order";
        } else if (columnName.indexOf("InOut") >= 0) {
            id = "InOut";
        } else if (columnName.indexOf("Payment") >= 0) {
            id = "Payment";
        } else if (columnName.indexOf("CashLine") >= 0) {
            id = "CashLine";
        } else if (columnName.indexOf("ResourceAssignment") >= 0) {
            id = "Assignment";
        }
        return id;
    }

    public static String getMonths(Locale loc) {
        SimpleDateFormat formatDate = (SimpleDateFormat)DateFormat.getDateInstance(1, loc);
        return AmpiereUtil.generateJavascriptArray(formatDate.getDateFormatSymbols().getMonths());
    }

    public static String getShortMonths(Locale loc) {
        SimpleDateFormat formatDate = (SimpleDateFormat)DateFormat.getDateInstance(1, loc);
        return AmpiereUtil.generateJavascriptArray(formatDate.getDateFormatSymbols().getShortMonths());
    }

    public static String getWeeks(Locale loc) {
        SimpleDateFormat formatDate = (SimpleDateFormat)DateFormat.getDateInstance(1, loc);
        String[] wk = formatDate.getDateFormatSymbols().getWeekdays();
        String[] weekss = new String[7];
        for (int i = 1; i < wk.length; ++i) {
            weekss[i - 1] = wk[i];
        }
        return AmpiereUtil.generateJavascriptArray(weekss);
    }

    public static String getShortWeeks(Locale loc) {
        SimpleDateFormat formatDate = (SimpleDateFormat)DateFormat.getDateInstance(1, loc);
        String[] swk = formatDate.getDateFormatSymbols().getShortWeekdays();
        String[] shortWeekss = new String[7];
        for (int i = 1; i < swk.length; ++i) {
            shortWeekss[i - 1] = swk[i];
        }
        return AmpiereUtil.generateJavascriptArray(shortWeekss);
    }

    public static String generateJavascriptArray(String[] p) {
        String s = "new Array(";
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == null || p[i].length() <= 0) continue;
            s = s + "\"" + p[i] + "\",";
        }
        s = s.substring(0, s.length() - 1);
        s = s + ")";
        return s;
    }

    public static head addDatePicker(head hd, WebSessionCtx wsc) {
        hd.addElement((Element)new script((Element)null, "js/DatePicker.js"));
        hd.addElement((Element)new script("var paraMonths = " + AmpiereUtil.getMonths(wsc.language.getLocale()) + ";"));
        hd.addElement((Element)new script("var paraShortMonths = " + AmpiereUtil.getShortMonths(wsc.language.getLocale()) + ";"));
        hd.addElement((Element)new script("var paraWeeks = " + AmpiereUtil.getWeeks(wsc.language.getLocale()) + ";"));
        hd.addElement((Element)new script("var paraShortWeeks = " + AmpiereUtil.getShortWeeks(wsc.language.getLocale()) + ";"));
        hd.addElement((Element)new script("var paraDateFormat = \"" + wsc.dateFormat.toPattern() + "\"" + ";"));
        hd.addElement((Element)new script("var paraInvalidDateMsg = \"" + Msg.translate(wsc.ctx, "InvalidDate") + "\"" + ";"));
        return hd;
    }

    public static td createButtons(Properties ctx, boolean hasSubmit) {
        td tdButton = new td("", "right", "middle", false);
        tdButton.addElement((Element)AmpiereUtil.createImageButton(ctx, "Cancel", "window.close();"));
        if (hasSubmit) {
            tdButton.addElement((Element)AmpiereUtil.createImageButton(ctx, "Ok", "this.form.submit();"));
        }
        return tdButton;
    }

    public static input createImageButton(Properties ctx, String name, String script2) {
        input imgButton = new input("image", name, name);
        imgButton.setID("Popup" + name);
        imgButton.setOnClick(script2);
        imgButton.setSrc(WebEnv.getImageDirectory(name + "24.gif"));
        imgButton.setAlt(Msg.translate(ctx, name));
        return imgButton;
    }

    public static int setLargeRecordMsg(Properties ctx, PopupBaseForm form, int rowNum) {
        if (rowNum > 1000) {
            MessageFormat mf = null;
            try {
                mf = new MessageFormat(Msg.getMsg(Env.getAD_Language(ctx), "LargeRecords"));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "LargeRecords=" + Msg.getMsg(Env.getAD_Language(ctx), "LargeRecords"), e);
            }
            Object[] arguments = new Object[]{new Integer(rowNum), new Integer(1000)};
            form.setLargeRecords(mf.format(arguments));
            return 1000;
        }
        form.setLargeRecords("");
        return rowNum;
    }

    public static String getDirectAccessSQL(Properties ctx, Lookup lookup, String columnName, String text) {
        int AD_Reference_ID;
        StringBuffer sql = new StringBuffer();
        String tableName = columnName.substring(0, columnName.length() - 3);
        String keyColumnName = columnName;
        if (columnName.equals("M_Product_ID")) {
            Env.setContext(ctx, 1113, 1113, "M_Product_ID", "0");
            Env.setContext(ctx, 1113, 1113, "M_AttributeSetInstance_ID", "0");
            sql.append("SELECT M_Product_ID FROM M_Product WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING(text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING(text)).append(" OR UPC LIKE ").append(DB.TO_STRING(text)).append(")");
        } else if (columnName.equals("C_BPartner_ID")) {
            sql.append("SELECT C_BPartner_ID FROM C_BPartner WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING(text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING(text)).append(")");
        } else if (columnName.equals("C_Order_ID")) {
            sql.append("SELECT C_Order_ID FROM C_Order WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
        } else if (columnName.equals("C_Invoice_ID")) {
            sql.append("SELECT C_Invoice_ID FROM C_Invoice WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
        } else if (columnName.equals("M_InOut_ID")) {
            sql.append("SELECT M_InOut_ID FROM M_InOut WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
        } else if (columnName.equals("C_Payment_ID")) {
            sql.append("SELECT C_Payment_ID FROM C_Payment WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
        } else if (columnName.equals("GL_JournalBatch_ID")) {
            sql.append("SELECT GL_JournalBatch_ID FROM GL_JournalBatch WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
        } else if (columnName.equals("SalesRep_ID")) {
            sql.append("SELECT AD_User_ID FROM AD_User WHERE UPPER(Name) LIKE ").append(DB.TO_STRING(text));
            tableName = "AD_User";
            keyColumnName = "AD_User_ID";
        }
        if (sql.length() > 0) {
            String wc = AmpiereUtil.getWhereClause(ctx, lookup, columnName);
            if (wc != null && wc.length() > 0) {
                sql.append(" AND ").append(wc);
            }
            sql.append(" AND IsActive='Y'");
            log.finest(columnName + " (predefined) " + sql.toString());
            return MRole.getDefault().addAccessSQL(sql.toString(), tableName, false, false);
        }
        if (lookup != null && lookup instanceof MLookup && (AD_Reference_ID = ((MLookup)lookup).getAD_Reference_Value_ID()) != 0) {
            String query = "SELECT kc.ColumnName, dc.ColumnName, t.TableName FROM AD_Ref_Table rt INNER JOIN AD_Column kc ON (rt.AD_Key=kc.AD_Column_ID) INNER JOIN AD_Column dc ON (rt.AD_Display=dc.AD_Column_ID) INNER JOIN AD_Table t ON (rt.AD_Table_ID=t.AD_Table_ID) WHERE rt.AD_Reference_ID=?";
            String displayColumnName = null;
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(query, null);
                pstmt.setInt(1, AD_Reference_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    keyColumnName = rs.getString(1);
                    displayColumnName = rs.getString(2);
                    tableName = rs.getString(3);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, query, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            if (displayColumnName != null) {
                sql = new StringBuffer();
                sql.append("SELECT ").append(keyColumnName).append(" FROM ").append(tableName).append(" WHERE UPPER(").append(displayColumnName).append(") LIKE ").append(DB.TO_STRING(text)).append(" AND IsActive='Y'");
                String wc = AmpiereUtil.getWhereClause(ctx, lookup, columnName);
                if (wc != null && wc.length() > 0) {
                    sql.append(" AND ").append(wc);
                }
                log.finest(columnName + " (Table) " + sql.toString());
                return MRole.getDefault().addAccessSQL(sql.toString(), tableName, false, false);
            }
        }
        String query = "SELECT t.TableName, c.ColumnName FROM AD_Column c  INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID AND t.IsView='N') WHERE (c.ColumnName IN ('DocumentNo', 'Value', 'Name') OR c.IsIdentifier='Y') AND c.AD_Reference_ID IN (10,14) AND EXISTS (SELECT * FROM AD_Column cc WHERE cc.AD_Table_ID=t.AD_Table_ID AND cc.IsKey='Y' AND cc.ColumnName=?)";
        keyColumnName = columnName;
        sql = new StringBuffer();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(query, null);
            pstmt.setString(1, keyColumnName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (sql.length() != 0) {
                    sql.append(" OR ");
                }
                tableName = rs.getString(1);
                sql.append("UPPER(").append(rs.getString(2)).append(") LIKE ").append(DB.TO_STRING(text));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, query, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        if (sql.length() == 0) {
            log.log(Level.SEVERE, columnName + " (TableDir) - no standard/identifier columns");
            return "";
        }
        StringBuffer retValue = new StringBuffer("SELECT ").append(columnName).append(" FROM ").append(tableName).append(" WHERE ").append(sql).append(" AND IsActive='Y'");
        String wc = AmpiereUtil.getWhereClause(ctx, lookup, columnName);
        if (wc != null && wc.length() > 0) {
            retValue.append(" AND ").append(wc);
        }
        log.finest(columnName + " (TableDir) " + sql.toString());
        return MRole.getDefault().addAccessSQL(retValue.toString(), tableName, false, false);
    }

    public static String getWhereClause(Properties ctx, Lookup lookup, String columnName) {
        String validation;
        String whereClause = "";
        if (lookup == null) {
            return "";
        }
        if (lookup.getZoomQuery() != null) {
            whereClause = lookup.getZoomQuery().getWhereClause();
        }
        if ((validation = lookup.getValidation()) == null) {
            validation = "";
        }
        if (whereClause.length() == 0) {
            whereClause = validation;
        } else if (validation.length() > 0) {
            whereClause = whereClause + " AND " + validation;
        }
        if (whereClause.indexOf(64) != -1) {
            String validated = Env.parseContext(ctx, lookup.getWindowNo(), whereClause, false);
            if (validated.length() == 0) {
                log.severe(columnName + " - Cannot Parse=" + whereClause);
            } else {
                log.fine(columnName + " - Parsed: " + validated);
                return validated;
            }
        }
        return whereClause;
    }

    public static int getOnly_Warehouse_ID(Properties ctx, int windowNo) {
        String only_Warehouse = Env.getContext(ctx, windowNo, "M_Warehouse_ID", true);
        int only_Warehouse_ID = 0;
        try {
            if (only_Warehouse != null && only_Warehouse.length() > 0) {
                only_Warehouse_ID = Integer.parseInt(only_Warehouse);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return only_Warehouse_ID;
    }
}

