/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.search;

import com.ampiere.search.IDColumn;
import com.ampiere.search.Info;
import com.ampiere.search.Info_Column;
import com.ampiere.web.struts.search.InfoProductForm;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public final class InfoProduct
extends Info {
    private static final String s_productFrom = "M_Product p LEFT OUTER JOIN M_ProductPrice pr ON (p.M_Product_ID=pr.M_Product_ID AND pr.IsActive='Y') LEFT OUTER JOIN M_AttributeSet pa ON (p.M_AttributeSet_ID=pa.M_AttributeSet_ID)";
    private Info_Column[] s_productLayout = null;
    private String fieldValue = "";
    private String fieldName = "";
    private String fieldUPC = "";
    private String fieldSKU = "";
    private String pickWarehouse = "";
    private String pickPriceList = "";
    private String m_pAttributeWhere = null;

    public InfoProduct(int WindowNo, int M_Warehouse_ID, int M_PriceList_ID, String value, boolean multiSelection, String whereClause, Properties ctx) {
        super(WindowNo, "p", "M_Product_ID", multiSelection, whereClause, ctx);
        this.log.info(value + ", Wh=" + M_Warehouse_ID + ", PL=" + M_PriceList_ID + ", WHERE=" + whereClause);
        this.initInfo(value, M_Warehouse_ID, M_PriceList_ID, ctx);
        this.p_loadedOK = true;
    }

    private void initInfo(String value, int M_Warehouse_ID, int M_PriceList_ID, Properties ctx) {
        if (value.startsWith("@") && value.endsWith("@")) {
            this.fieldName = value.substring(1, value.length() - 1);
        } else {
            this.fieldValue = value;
        }
        StringBuffer where = new StringBuffer();
        where.append("p.IsActive='Y'");
        if (M_Warehouse_ID != 0) {
            where.append(" AND p.IsSummary='N'");
        }
        if (this.p_whereClause != null && this.p_whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace(this.p_whereClause, "M_Product.", "p."));
        }
        this.prepareTable(this.getProductLayout(ctx), s_productFrom, where.toString(), "QtyAvailable DESC, Margin DESC");
    }

    String getSQLWhere() {
        String sku;
        String upc;
        String name;
        StringBuffer where = new StringBuffer();
        int M_PriceList_Version_ID = 0;
        if (this.pickPriceList != null && !"".equals(this.pickPriceList)) {
            M_PriceList_Version_ID = Integer.parseInt(this.pickPriceList);
        }
        if (M_PriceList_Version_ID != 0) {
            where.append(" AND pr.M_PriceList_Version_ID=?");
        }
        if (this.m_pAttributeWhere != null) {
            where.append(this.m_pAttributeWhere);
            return where.toString();
        }
        String value = this.fieldValue.toUpperCase();
        if (!value.equals("") && !value.equals("%")) {
            where.append(" AND UPPER(p.Value) LIKE ?");
        }
        if (!(name = this.fieldName.toUpperCase()).equals("") && !name.equals("%")) {
            where.append(" AND UPPER(p.Name) LIKE ?");
        }
        if (!(upc = this.fieldUPC.toUpperCase()).equals("") && !upc.equals("%")) {
            where.append(" AND UPPER(p.UPC) LIKE ?");
        }
        if (!(sku = this.fieldSKU.toUpperCase()).equals("") && !sku.equals("%")) {
            where.append(" AND UPPER(p.SKU) LIKE ?");
        }
        return where.toString();
    }

    void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        String sku;
        String upc;
        String name;
        String value;
        int index = 1;
        if (!forCount) {
            int M_Warehouse_ID = 0;
            if (this.pickWarehouse != null && !"".equals(this.pickWarehouse)) {
                M_Warehouse_ID = Integer.parseInt(this.pickWarehouse);
            }
            for (int i = 0; i < this.p_layout.length; ++i) {
                if (this.p_layout[i].getColSQL().indexOf("?") == -1) continue;
                pstmt.setInt(index++, M_Warehouse_ID);
            }
            this.log.fine("M_Warehouse_ID=" + M_Warehouse_ID + " (" + (index - 1) + "*)");
        }
        int M_PriceList_Version_ID = 0;
        if (this.pickPriceList != null && !"".equals(this.pickPriceList)) {
            M_PriceList_Version_ID = Integer.parseInt(this.pickPriceList);
        }
        if (M_PriceList_Version_ID != 0) {
            pstmt.setInt(index++, M_PriceList_Version_ID);
            this.log.fine("M_PriceList_Version_ID=" + M_PriceList_Version_ID);
        }
        if (!(value = this.fieldValue.toUpperCase()).equals("") && !value.equals("%")) {
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            pstmt.setString(index++, value);
            this.log.fine("Value: " + value);
        }
        if (!(name = this.fieldName.toUpperCase()).equals("") && !name.equals("%")) {
            if (!name.endsWith("%")) {
                name = name + "%";
            }
            pstmt.setString(index++, name);
            this.log.fine("Name: " + name);
        }
        if (!(upc = this.fieldUPC.toUpperCase()).equals("") && !upc.equals("%")) {
            if (!upc.endsWith("%")) {
                upc = upc + "%";
            }
            pstmt.setString(index++, upc);
            this.log.fine("UPC: " + upc);
        }
        if (!(sku = this.fieldSKU.toUpperCase()).equals("") && !sku.equals("%")) {
            if (!sku.endsWith("%")) {
                sku = sku + "%";
            }
            pstmt.setString(index++, sku);
            this.log.fine("SKU: " + sku);
        }
    }

    private Info_Column[] getProductLayout(Properties ctx) {
        if (this.s_productLayout != null) {
            return this.s_productLayout;
        }
        MClient client = MClient.get(ctx);
        if ("FRIE".equals(client.getValue())) {
            Info_Column[] frieLayout = new Info_Column[]{new Info_Column(Msg.translate(ctx, "Select"), "p.M_Product_ID", IDColumn.class), new Info_Column(Msg.translate(ctx, "Name"), "p.Name", String.class), new Info_Column(Msg.translate(ctx, "QtyAvailable"), "bomQtyAvailable(p.M_Product_ID,?,0) AS QtyAvailable", Double.class, true, true, null), new Info_Column(Msg.translate(ctx, "PriceList"), "bomPriceList(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceList", BigDecimal.class), new Info_Column(Msg.translate(ctx, "PriceStd"), "bomPriceStd(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceStd", BigDecimal.class), new Info_Column("Einzel MWSt", "pr.PriceStd * 1.16", BigDecimal.class), new Info_Column("Einzel kompl", "(pr.PriceStd+13) * 1.16", BigDecimal.class), new Info_Column("Satz kompl", "((pr.PriceStd+13) * 1.16) * 4", BigDecimal.class), new Info_Column(Msg.translate(ctx, "QtyOnHand"), "bomQtyOnHand(p.M_Product_ID,?,0) AS QtyOnHand", Double.class), new Info_Column(Msg.translate(ctx, "QtyReserved"), "bomQtyReserved(p.M_Product_ID,?,0) AS QtyReserved", Double.class), new Info_Column(Msg.translate(ctx, "QtyOrdered"), "bomQtyOrdered(p.M_Product_ID,?,0) AS QtyOrdered", Double.class), new Info_Column(Msg.translate(ctx, "Discontinued").substring(0, 1), "p.Discontinued", Boolean.class), new Info_Column(Msg.translate(ctx, "Margin"), "bomPriceStd(p.M_Product_ID, pr.M_PriceList_Version_ID)-bomPriceLimit(p.M_Product_ID, pr.M_PriceList_Version_ID) AS Margin", BigDecimal.class), new Info_Column(Msg.translate(ctx, "PriceLimit"), "bomPriceLimit(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceLimit", BigDecimal.class), new Info_Column(Msg.translate(ctx, "IsInstanceAttribute"), "pa.IsInstanceAttribute", Boolean.class)};
            this.s_productLayout = frieLayout;
            this.m_keyColumnIndex = 0;
            return this.s_productLayout;
        }
        if (this.s_productLayout == null) {
            ArrayList<Info_Column> list = new ArrayList<Info_Column>();
            list.add(new Info_Column(Msg.translate(ctx, "Select"), "p.M_Product_ID", IDColumn.class));
            list.add(new Info_Column(Msg.translate(ctx, "Discontinued").substring(0, 1), "p.Discontinued", Boolean.class));
            list.add(new Info_Column(Msg.translate(ctx, "Value"), "p.Value", String.class));
            list.add(new Info_Column(Msg.translate(ctx, "Name"), "p.Name", String.class));
            list.add(new Info_Column(Msg.translate(ctx, "QtyAvailable"), "bomQtyAvailable(p.M_Product_ID,?,0) AS QtyAvailable", Double.class, true, true, null));
            list.add(new Info_Column(Msg.translate(ctx, "PriceList"), "bomPriceList(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceList", BigDecimal.class));
            list.add(new Info_Column(Msg.translate(ctx, "PriceStd"), "bomPriceStd(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceStd", BigDecimal.class));
            list.add(new Info_Column(Msg.translate(ctx, "QtyOnHand"), "bomQtyOnHand(p.M_Product_ID,?,0) AS QtyOnHand", Double.class));
            list.add(new Info_Column(Msg.translate(ctx, "QtyReserved"), "bomQtyReserved(p.M_Product_ID,?,0) AS QtyReserved", Double.class));
            list.add(new Info_Column(Msg.translate(ctx, "QtyOrdered"), "bomQtyOrdered(p.M_Product_ID,?,0) AS QtyOrdered", Double.class));
            if (this.isUnconfirmed(ctx)) {
                list.add(new Info_Column(Msg.translate(ctx, "QtyUnconfirmed"), "(SELECT SUM(c.TargetQty) FROM M_InOutLineConfirm c INNER JOIN M_InOutLine il ON (c.M_InOutLine_ID=il.M_InOutLine_ID) INNER JOIN M_InOut i ON (il.M_InOut_ID=i.M_InOut_ID) WHERE c.Processed='N' AND i.M_Warehouse_ID=? AND il.M_Product_ID=p.M_Product_ID) AS QtyUnconfirmed", Double.class));
                list.add(new Info_Column(Msg.translate(ctx, "QtyUnconfirmedMove"), "(SELECT SUM(c.TargetQty) FROM M_MovementLineConfirm c INNER JOIN M_MovementLine ml ON (c.M_MovementLine_ID=ml.M_MovementLine_ID) INNER JOIN M_Locator l ON (ml.M_LocatorTo_ID=l.M_Locator_ID) WHERE c.Processed='N' AND l.M_Warehouse_ID=? AND ml.M_Product_ID=p.M_Product_ID) AS QtyUnconfirmedMove", Double.class));
            }
            list.add(new Info_Column(Msg.translate(ctx, "Margin"), "bomPriceStd(p.M_Product_ID, pr.M_PriceList_Version_ID)-bomPriceLimit(p.M_Product_ID, pr.M_PriceList_Version_ID) AS Margin", BigDecimal.class));
            list.add(new Info_Column(Msg.translate(ctx, "PriceLimit"), "bomPriceLimit(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceLimit", BigDecimal.class));
            list.add(new Info_Column(Msg.translate(ctx, "IsInstanceAttribute"), "pa.IsInstanceAttribute", Boolean.class));
            this.s_productLayout = new Info_Column[list.size()];
            list.toArray(this.s_productLayout);
            this.m_keyColumnIndex = 0;
        }
        return this.s_productLayout;
    }

    private boolean isUnconfirmed(Properties ctx) {
        int no = DB.getSQLValue(null, "SELECT COUNT(*) FROM M_InOutLineConfirm WHERE AD_Client_ID=?", Env.getAD_Client_ID(ctx));
        if (no > 0) {
            return true;
        }
        no = DB.getSQLValue(null, "SELECT COUNT(*) FROM M_MovementLineConfirm WHERE AD_Client_ID=?", Env.getAD_Client_ID(ctx));
        return no > 0;
    }

    public void setQueryParas(InfoProductForm searchInfoForm, String attributeWhere) {
        this.pickWarehouse = searchInfoForm.getWarehouse() == null ? "" : searchInfoForm.getWarehouse();
        String string = this.pickPriceList = searchInfoForm.getPriceListVersion() == null ? "" : searchInfoForm.getPriceListVersion();
        if (attributeWhere != null && attributeWhere.length() > 0) {
            this.m_pAttributeWhere = attributeWhere;
        } else {
            this.m_pAttributeWhere = null;
            this.fieldValue = searchInfoForm.getValue() == null ? "" : searchInfoForm.getValue();
            this.fieldName = searchInfoForm.getName() == null ? "" : searchInfoForm.getName();
            this.fieldSKU = searchInfoForm.getSku() == null ? "" : searchInfoForm.getSku();
            this.fieldUPC = searchInfoForm.getUpc() == null ? "" : searchInfoForm.getUpc();
        }
    }
}

