/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.search;

import com.ampiere.search.ComponentBean;
import com.ampiere.search.IDColumn;
import com.ampiere.search.Info;
import com.ampiere.search.Info_Column;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class InfoPayment
extends Info {
    private Info_Column[] s_paymentLayout = null;

    protected InfoPayment(int WindowNo, String value, boolean multiSelection, String whereClause, Properties ctx) {
        super(WindowNo, "p", "C_Payment_ID", multiSelection, whereClause, ctx);
        this.log.info("InfoPayment");
        this.title = Msg.translate(ctx, "InfoPayment");
        int i = 0;
        this.s_paymentLayout = new Info_Column[12];
        this.columnAttrList = new ArrayList();
        this.s_paymentLayout[i++] = new Info_Column(Msg.translate(ctx, "Select"), "p.C_Payment_ID", IDColumn.class);
        this.columnAttrList.add(1);
        this.s_paymentLayout[i++] = new Info_Column(Msg.translate(ctx, "C_BankAccount_ID"), "(SELECT b.Name || ' ' || ba.AccountNo FROM C_Bank b, C_BankAccount ba WHERE b.C_Bank_ID=ba.C_Bank_ID AND ba.C_BankAccount_ID=p.C_BankAccount_ID)", String.class);
        this.columnAttrList.add(1);
        this.s_paymentLayout[i++] = new Info_Column(Msg.translate(ctx, "C_BPartner_ID"), "(SELECT Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=p.C_BPartner_ID)", String.class);
        this.columnAttrList.add(1);
        this.s_paymentLayout[i++] = new Info_Column(Msg.translate(ctx, "DateTrx"), "p.DateTrx", Timestamp.class);
        this.columnAttrList.add(1);
        this.s_paymentLayout[i++] = new Info_Column(Msg.translate(ctx, "DocumentNo"), "p.DocumentNo", String.class);
        this.columnAttrList.add(1);
        this.s_paymentLayout[i++] = new Info_Column(Msg.translate(ctx, "IsReceipt"), "p.IsReceipt", Boolean.class);
        this.columnAttrList.add(0);
        this.s_paymentLayout[i++] = new Info_Column(Msg.translate(ctx, "C_Currency_ID"), "(SELECT ISO_Code FROM C_Currency c WHERE c.C_Currency_ID=p.C_Currency_ID)", String.class);
        this.columnAttrList.add(0);
        this.s_paymentLayout[i++] = new Info_Column(Msg.translate(ctx, "PayAmt"), "p.PayAmt", BigDecimal.class);
        this.columnAttrList.add(0);
        this.s_paymentLayout[i++] = new Info_Column(Msg.translate(ctx, "ConvertedAmount"), "currencyBase(p.PayAmt,p.C_Currency_ID,p.DateTrx, p.AD_Client_ID,p.AD_Org_ID)", BigDecimal.class);
        this.columnAttrList.add(0);
        this.s_paymentLayout[i++] = new Info_Column(Msg.translate(ctx, "DiscountAmt"), "p.DiscountAmt", BigDecimal.class);
        this.columnAttrList.add(0);
        this.s_paymentLayout[i++] = new Info_Column(Msg.translate(ctx, "WriteOffAmt"), "p.WriteOffAmt", BigDecimal.class);
        this.columnAttrList.add(0);
        this.s_paymentLayout[i++] = new Info_Column(Msg.translate(ctx, "IsAllocated"), "p.IsAllocated", Boolean.class);
        this.columnAttrList.add(0);
        try {
            String s = "";
            if (value != null && value.length() > 0) {
                s = value;
            }
            this.statInit(ctx, s);
            this.p_loadedOK = this.initInfo();
        }
        catch (Exception e) {
            return;
        }
    }

    private void statInit(Properties ctx, String value) throws Exception {
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "DocumentNo"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("DocumentNo", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 3, value, "left", "middle", "", 220));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "BPartner"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("C_BPartner_ID", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("C_BPartner_ID", 7, "", "left", "middle", "", 198));
        String isSOTrx = "N".equals(Env.getContext(ctx, this.p_WindowNo, "IsSOTrx")) ? "N" : "Y";
        this.componentMapping.put("IsReceipt", new Integer(this.componentList.size()));
        ComponentBean bean = new ComponentBean(Msg.translate(ctx, "IsReceipt"), 6, isSOTrx, "left", "middle", "", 0);
        bean.setColSpan(2);
        this.componentList.add(bean);
        this.componentList.add(new ComponentBean(0));
        this.componentList.add(new ComponentBean(1));
        this.componentList.add(new ComponentBean(1));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "DateTrx"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("DateFrom", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "DateFrom"), 5, "", "left", "middle", "", 198));
        this.componentList.add(new ComponentBean("-", 1, "", "center", "middle", "", 0));
        this.componentMapping.put("DateTo", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "DateTo"), 5, "", "left", "middle", "", 198));
        this.componentList.add(new ComponentBean(0));
        this.componentList.add(new ComponentBean(1));
        this.componentList.add(new ComponentBean(1));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "PayAmt"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("AmtFrom", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "AmtFrom"), 3, "", "left", "middle", "", 220));
        this.componentList.add(new ComponentBean("-", 1, "", "center", "middle", "", 0));
        this.componentMapping.put("AmtTo", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "AmtTo"), 3, "", "left", "middle", "", 220));
    }

    private boolean initInfo() {
        StringBuffer where = new StringBuffer("p.IsActive='Y'");
        if (this.p_whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace(this.p_whereClause, "C_Payment.", "p."));
        }
        this.prepareTable(this.s_paymentLayout, " C_Payment_v p", where.toString(), "2,3,4");
        return true;
    }

    protected String createQuery(Hashtable valueMapping, SimpleDateFormat dateFormat) {
        StringBuffer sql = new StringBuffer();
        String s = this.getComponetValue(valueMapping, "DocumentNo");
        if (s != null) {
            if (!(s = s.toUpperCase()).endsWith("%")) {
                s = s + "%";
            }
            sql.append(" AND UPPER(p.DocumentNo) LIKE ");
            sql.append(DB.TO_STRING(s));
        }
        if ((s = this.getComponetValue(valueMapping, "C_BPartner_ID")) != null) {
            sql.append(" AND p.C_BPartner_ID=");
            sql.append(Integer.parseInt(s));
        }
        String from = this.getComponetValue(valueMapping, "DateFrom");
        String to = this.getComponetValue(valueMapping, "DateTo");
        if (from != null || to != null) {
            Timestamp fromT = null;
            Timestamp toT = null;
            try {
                Date d;
                if (from != null) {
                    d = dateFormat.parse(from);
                    fromT = new Timestamp(d.getTime());
                }
                if (to != null) {
                    d = dateFormat.parse(to);
                    toT = new Timestamp(d.getTime());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "InfoInOut : createQuery : Date convert error ", e);
            }
            if (fromT == null && toT != null) {
                sql.append(" AND TRUNC(p.DateTrx) <= ");
                sql.append(DB.TO_DATE(toT, true));
            } else if (fromT != null && toT == null) {
                sql.append(" AND TRUNC(p.DateTrx) >= ");
                sql.append(DB.TO_DATE(fromT, true));
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(p.DateTrx) BETWEEN ");
                sql.append(DB.TO_DATE(fromT, true));
                sql.append(" AND ");
                sql.append(DB.TO_DATE(toT, true));
            }
        }
        from = this.getComponetValue(valueMapping, "AmtFrom");
        to = this.getComponetValue(valueMapping, "AmtTo");
        if (from != null || to != null) {
            BigDecimal fromB = null;
            BigDecimal toB = null;
            try {
                fromB = new BigDecimal(from);
                toB = new BigDecimal(to);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "InfoPayment : createQuery : To BigDecimal ", e);
            }
            if (fromB == null && toB != null) {
                sql.append(" AND p.PayAmt <= ");
                sql.append(toB);
            } else if (from != null && to == null) {
                sql.append(" AND p.PayAmt >= ");
                sql.append(fromB);
            } else if (from != null && to != null) {
                sql.append(" AND p.PayAmt BETWEEN ");
                sql.append(fromB);
                sql.append(" AND ");
                sql.append(toB);
            }
        }
        if ((s = this.getComponetValue(valueMapping, "IsReceipt")) != null) {
            s = s.toUpperCase();
            sql.append(" AND p.IsReceipt=");
            sql.append("'" + s + "'");
        }
        this.log.fine(sql.toString());
        return sql.toString();
    }

    void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
    }

    protected String getSQLWhere() {
        if (this.p_sqlWhere != null && this.p_sqlWhere.length() > 0) {
            return this.p_sqlWhere;
        }
        return "";
    }
}

