/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.search;

import com.ampiere.search.ComponentBean;
import com.ampiere.search.IDColumn;
import com.ampiere.search.Info;
import com.ampiere.search.Info_Column;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class InfoInOut
extends Info {
    private Info_Column[] s_inoutLayout = null;

    protected InfoInOut(int WindowNo, String value, boolean multiSelection, String whereClause, Properties ctx) {
        super(WindowNo, "i", "M_InOut_ID", multiSelection, whereClause, ctx);
        this.log.info("InfoInOut");
        this.title = Msg.translate(ctx, "InfoInOut");
        int i = 0;
        this.s_inoutLayout = new Info_Column[7];
        this.columnAttrList = new ArrayList();
        this.s_inoutLayout[i++] = new Info_Column(Msg.translate(ctx, "Select"), "i.M_InOut_ID", IDColumn.class);
        this.columnAttrList.add(1);
        this.s_inoutLayout[i++] = new Info_Column(Msg.translate(ctx, "C_BPartner_ID"), "(SELECT Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=i.C_BPartner_ID)", String.class);
        this.columnAttrList.add(1);
        this.s_inoutLayout[i++] = new Info_Column(Msg.translate(ctx, "MovementDate"), "i.MovementDate", Timestamp.class);
        this.columnAttrList.add(1);
        this.s_inoutLayout[i++] = new Info_Column(Msg.translate(ctx, "DocumentNo"), "i.DocumentNo", String.class);
        this.columnAttrList.add(1);
        this.s_inoutLayout[i++] = new Info_Column(Msg.translate(ctx, "Description"), "i.Description", String.class);
        this.columnAttrList.add(0);
        this.s_inoutLayout[i++] = new Info_Column(Msg.translate(ctx, "POReference"), "i.POReference", String.class);
        this.columnAttrList.add(0);
        this.s_inoutLayout[i++] = new Info_Column(Msg.translate(ctx, "IsSOTrx"), "i.IsSOTrx", Boolean.class);
        this.columnAttrList.add(0);
        try {
            String s = "";
            if (value != null && value.length() > 0) {
                s = value;
            }
            this.statInit(ctx, s);
            this.p_loadedOK = this.initInfo();
        }
        catch (Exception e) {
            return;
        }
    }

    private void statInit(Properties ctx, String value) throws Exception {
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "DocumentNo"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("DocumentNo", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 3, value, "left", "middle", "", 220));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "BPartner"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("C_BPartner_ID", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("C_BPartner_ID", 7, "", "left", "middle", "", 198));
        String isSOTrx = "N".equals(Env.getContext(ctx, this.p_WindowNo, "IsSOTrx")) ? "N" : "Y";
        this.componentMapping.put("IsSOTrx", new Integer(this.componentList.size()));
        ComponentBean bean = new ComponentBean(Msg.translate(ctx, "IsSOTrx"), 6, isSOTrx, "left", "middle", "", 0);
        bean.setColSpan(2);
        this.componentList.add(bean);
        this.componentList.add(new ComponentBean(0));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "Description"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("Description", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 3, "", "left", "middle", "", 220));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "MovementDate"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("DateFrom", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "DateFrom"), 5, "", "left", "middle", "", 198));
        this.componentList.add(new ComponentBean("-", 1, "", "center", "middle", "", 0));
        this.componentMapping.put("DateTo", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "DateTo"), 5, "", "left", "middle", "", 198));
        this.componentList.add(new ComponentBean(0));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "POReference"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("POReference", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 3, "", "left", "middle", "", 220));
    }

    private boolean initInfo() {
        StringBuffer where = new StringBuffer("i.IsActive='Y'");
        if (this.p_whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace(this.p_whereClause, "M_InOut.", "i."));
        }
        this.prepareTable(this.s_inoutLayout, " M_InOut i", where.toString(), "2,3,4");
        return true;
    }

    protected String createQuery(Hashtable valueMapping, SimpleDateFormat dateFormat) {
        StringBuffer sql = new StringBuffer();
        String s = this.getComponetValue(valueMapping, "DocumentNo");
        if (s != null) {
            if (!(s = s.toUpperCase()).endsWith("%")) {
                s = s + "%";
            }
            sql.append(" AND UPPER(i.DocumentNo) LIKE ");
            sql.append(DB.TO_STRING(s));
        }
        if ((s = this.getComponetValue(valueMapping, "Description")) != null) {
            if (!(s = s.toUpperCase()).endsWith("%")) {
                s = s + "%";
            }
            sql.append(" AND UPPER(i.Description) LIKE ");
            sql.append(DB.TO_STRING(s));
        }
        if ((s = this.getComponetValue(valueMapping, "POReference")) != null) {
            if (!(s = s.toUpperCase()).endsWith("%")) {
                s = s + "%";
            }
            sql.append(" AND UPPER(i.POReference) LIKE ");
            sql.append(DB.TO_STRING(s));
        }
        if ((s = this.getComponetValue(valueMapping, "C_BPartner_ID")) != null) {
            sql.append(" AND i.C_BPartner_ID=");
            sql.append(Integer.parseInt(s));
        }
        String from = this.getComponetValue(valueMapping, "DateFrom");
        String to = this.getComponetValue(valueMapping, "DateTo");
        if (from != null || to != null) {
            Timestamp fromT = null;
            Timestamp toT = null;
            try {
                Date d;
                if (from != null) {
                    d = dateFormat.parse(from);
                    fromT = new Timestamp(d.getTime());
                }
                if (to != null) {
                    d = dateFormat.parse(to);
                    toT = new Timestamp(d.getTime());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "InfoInOut : createQuery : Date convert error ", e);
            }
            if (fromT == null && toT != null) {
                sql.append(" AND TRUNC(i.MovementDate) <= ");
                sql.append(DB.TO_DATE(toT, true));
            } else if (fromT != null && toT == null) {
                sql.append(" AND TRUNC(i.MovementDate) >= ");
                sql.append(DB.TO_DATE(fromT, true));
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(i.MovementDate) BETWEEN ");
                sql.append(DB.TO_DATE(fromT, true));
                sql.append(" AND ");
                sql.append(DB.TO_DATE(toT, true));
            }
        }
        if ((s = this.getComponetValue(valueMapping, "IsSOTrx")) != null) {
            s = s.toUpperCase();
            sql.append(" AND i.IsSOTrx=");
            sql.append("'" + s + "'");
        }
        return sql.toString();
    }

    void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
    }

    protected String getSQLWhere() {
        if (this.p_sqlWhere != null && this.p_sqlWhere.length() > 0) {
            return this.p_sqlWhere;
        }
        return "";
    }
}

