/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.search;

import com.ampiere.dto.CodeValue;
import com.ampiere.search.ColBean;
import com.ampiere.search.ComponentBean;
import com.ampiere.search.IDColumn;
import com.ampiere.search.InfoAsset;
import com.ampiere.search.InfoAssignment;
import com.ampiere.search.InfoBPartner;
import com.ampiere.search.InfoCashLine;
import com.ampiere.search.InfoGeneral;
import com.ampiere.search.InfoInOut;
import com.ampiere.search.InfoInvoice;
import com.ampiere.search.InfoOrder;
import com.ampiere.search.InfoPayment;
import com.ampiere.search.InfoProduct;
import com.ampiere.search.Info_Column;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.Lookup;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Info {
    protected int p_WindowNo;
    protected String p_tableName;
    protected String p_keyColumn;
    protected boolean p_multiSelection;
    protected String p_whereClause = "";
    protected String p_sqlWhere = "";
    protected int m_keyColumnIndex;
    private boolean m_ok = false;
    private boolean m_cancel = false;
    private ArrayList<Integer> m_results = new ArrayList(3);
    protected Info_Column[] p_layout;
    private String m_sqlMain;
    private String m_sqlCount;
    private String m_sqlOrder;
    protected boolean p_loadedOK = false;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    protected ArrayList<Integer> columnAttrList = new ArrayList();
    protected String title;
    protected ArrayList<ComponentBean> componentList = new ArrayList();
    protected Hashtable<String, Integer> componentMapping = new Hashtable();

    protected Info(int windowNo, String tableName, String keyColumn, boolean multiSelection, String whereClause, Properties ctx) {
        this.p_WindowNo = windowNo;
        this.p_tableName = tableName;
        this.p_keyColumn = keyColumn;
        this.p_multiSelection = multiSelection;
        if (whereClause == null || whereClause.indexOf(64) == -1) {
            this.p_whereClause = whereClause;
        } else {
            this.p_whereClause = Env.parseContext(ctx, this.p_WindowNo, whereClause, false, false);
            if (this.p_whereClause.length() == 0) {
                this.log.log(Level.SEVERE, "Cannot parse context= " + whereClause);
            }
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "Info", ex);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public ArrayList<ComponentBean> getComponentList() {
        return this.componentList;
    }

    public static Info create(int WindowNo, String tableName, String keyColumn, String value, boolean multiSelection, String whereClause, Properties ctx) {
        Info info = null;
        info = tableName.equals("C_BPartner") ? new InfoBPartner(WindowNo, value, !Env.getContext(ctx, "IsSOTrx").equals("N"), multiSelection, whereClause, ctx) : (tableName.equals("M_Product") ? new InfoProduct(WindowNo, 0, 0, value, multiSelection, whereClause, ctx) : (tableName.equals("C_Invoice") ? new InfoInvoice(WindowNo, value, multiSelection, whereClause, ctx) : (tableName.equals("A_Asset") ? new InfoAsset(WindowNo, 0, value, multiSelection, whereClause, ctx) : (tableName.equals("C_Order") ? new InfoOrder(WindowNo, value, multiSelection, whereClause, ctx) : (tableName.equals("M_InOut") ? new InfoInOut(WindowNo, value, multiSelection, whereClause, ctx) : (tableName.equals("C_Payment") ? new InfoPayment(WindowNo, value, multiSelection, whereClause, ctx) : (tableName.equals("C_CashLine") ? new InfoCashLine(WindowNo, value, multiSelection, whereClause, ctx) : (tableName.equals("S_ResourceAssignment") ? new InfoAssignment(WindowNo, value, multiSelection, whereClause, ctx) : new InfoGeneral(WindowNo, value, tableName, keyColumn, multiSelection, whereClause, ctx)))))))));
        return info;
    }

    protected void jbInit() throws Exception {
    }

    public boolean loadedOK() {
        return this.p_loadedOK;
    }

    public void setStatusLine(String text, boolean error) {
    }

    public void setStatusDB(String text) {
    }

    protected void prepareTable(Info_Column[] layout, String from, String staticWhere, String orderBy) {
        this.p_layout = layout;
        StringBuffer sql = new StringBuffer("SELECT ");
        for (int i = 0; i < layout.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(layout[i].getColSQL());
            if (layout[i].isIDcol()) {
                sql.append(",").append(layout[i].getIDcolSQL());
            }
            if (this.m_keyColumnIndex >= 0 || layout[i].getColClass() != IDColumn.class) continue;
            this.m_keyColumnIndex = i;
        }
        sql.append(" FROM ").append(from);
        sql.append(" WHERE ").append(staticWhere);
        this.m_sqlMain = sql.toString();
        this.m_sqlCount = "SELECT COUNT(*) FROM " + from + " WHERE " + staticWhere;
        this.m_sqlOrder = "";
        if (orderBy != null && orderBy.length() > 0) {
            this.m_sqlOrder = " ORDER BY " + orderBy;
        }
        if (this.m_keyColumnIndex == -1) {
            this.log.log(Level.SEVERE, "No KeyColumn - " + sql);
        }
    }

    protected void saveSelection() {
    }

    protected Integer getSelectedRowKey() {
        return null;
    }

    public Object[] getSelectedKeys() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results.toArray();
    }

    public Object getSelectedKey() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results.get(0);
    }

    public boolean isCancelled() {
        return this.m_cancel;
    }

    public String getSelectedSQL() {
        Object[] keys = this.getSelectedKeys();
        if (keys == null || keys.length == 0) {
            this.log.config("No Results - OK=" + this.m_ok + ", Cancel=" + this.m_cancel);
            return "";
        }
        StringBuffer sb = new StringBuffer(this.getKeyColumn());
        if (keys.length > 1) {
            sb.append(" IN (");
        } else {
            sb.append("=");
        }
        for (int i = 0; i < keys.length; ++i) {
            if (this.getKeyColumn().endsWith("_ID")) {
                sb.append(keys[i].toString()).append(",");
                continue;
            }
            sb.append("'").append(keys[i].toString()).append("',");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        if (keys.length > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean ok) {
        this.log.config("OK=" + ok);
        this.m_ok = ok;
    }

    String getTableName() {
        return this.p_tableName;
    }

    String getKeyColumn() {
        return this.p_keyColumn;
    }

    abstract String getSQLWhere();

    abstract void setParameters(PreparedStatement var1, boolean var2) throws SQLException;

    void doReset() {
    }

    boolean hasReset() {
        return false;
    }

    void showHistory() {
    }

    boolean hasHistory() {
        return false;
    }

    void customize() {
    }

    boolean hasCustomize() {
        return false;
    }

    void zoom() {
    }

    boolean hasZoom() {
        return false;
    }

    void saveSelectionDetail() {
    }

    public int testCount(Properties ctx) {
        long start = System.currentTimeMillis();
        String dynWhere = this.getSQLWhere();
        StringBuffer sql = new StringBuffer(this.m_sqlCount);
        if (dynWhere.length() > 0) {
            sql.append(dynWhere);
        }
        String countSql = Msg.parseTranslation(ctx, sql.toString());
        countSql = MRole.getDefault().addAccessSQL(countSql, this.getTableName(), true, false);
        this.log.finer(countSql);
        int no = -1;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(countSql, null);
            this.setParameters(pstmt, true);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                no = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, countSql, e);
            no = -2;
        }
        this.log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
        return no;
    }

    public ArrayList executeQuery(Properties ctx, int maxRecNo, Lookup lookup) {
        long start = System.currentTimeMillis();
        String dynWhere = this.getSQLWhere();
        StringBuffer sql = new StringBuffer(this.m_sqlMain);
        if (dynWhere.length() > 0) {
            sql.append(dynWhere);
        }
        sql.append(this.m_sqlOrder);
        String dataSql = Msg.parseTranslation(ctx, sql.toString());
        dataSql = MRole.getDefault().addAccessSQL(dataSql, this.getTableName(), true, false);
        this.log.finer(dataSql);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(dataSql, null);
            this.setParameters(pstmt, false);
            this.log.fine("Start query - " + (System.currentTimeMillis() - start) + "ms");
            ResultSet rs = pstmt.executeQuery();
            this.log.fine("End query - " + (System.currentTimeMillis() - start) + "ms");
            ArrayList<ColBean> resultList = new ArrayList<ColBean>();
            int count = 0;
            while (rs.next() && ++count <= maxRecNo) {
                ColBean colBean = new ColBean();
                int colOffset = 1;
                int beanOffset = 0;
                for (int col = 0; col < this.p_layout.length; ++col) {
                    Object data = null;
                    Class c = this.p_layout[col].getColClass();
                    int colIndex = col + colOffset;
                    String style = "";
                    if (c == IDColumn.class) {
                        data = new Integer(rs.getInt(colIndex));
                    } else if (c == Boolean.class) {
                        data = rs.getString(colIndex);
                        if (data == null || "".equals(data)) {
                            data = "N";
                        }
                        style = style + "text-align: center;";
                    } else if (c == Timestamp.class) {
                        data = rs.getTimestamp(colIndex);
                        style = style + "white-space: nowrap;";
                    } else if (c == BigDecimal.class) {
                        data = rs.getBigDecimal(colIndex);
                        style = style + "text-align: right;";
                    } else if (c == Double.class) {
                        data = new Double(rs.getDouble(colIndex));
                        style = style + "text-align: right;";
                    } else if (c == Integer.class) {
                        data = new Integer(rs.getInt(colIndex));
                        style = style + "text-align: right;";
                    } else if (c == KeyNamePair.class) {
                        data = rs.getString(colIndex);
                        ++colOffset;
                    } else {
                        data = rs.getString(colIndex);
                    }
                    colBean.setColData(beanOffset, data);
                    colBean.setColTitle(beanOffset, this.p_layout[col].getColHeader());
                    colBean.setStyle(beanOffset, style);
                    if (col == this.m_keyColumnIndex) {
                        NamePair pair;
                        colBean.setColId(data.toString());
                        String colName = data.toString();
                        if (lookup != null && (pair = lookup.getDirect(data, false, true)) != null) {
                            colName = pair.getName();
                        }
                        colBean.setColName(colName);
                    }
                    ++beanOffset;
                }
                resultList.add(colBean);
            }
            rs.close();
            pstmt.close();
            return resultList;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, dataSql, e);
            return null;
        }
    }

    public void createWhereClause(String where, SimpleDateFormat dateFormat) {
        int i;
        this.p_sqlWhere = "";
        if (where == null || where.length() == 0) {
            return;
        }
        String[] p = where.split(";");
        if (p == null || p.length == 0) {
            return;
        }
        Hashtable<Integer, String> valueMapping = new Hashtable<Integer, String>();
        Hashtable<Integer, String> valueMapping2 = new Hashtable<Integer, String>();
        for (i = 0; i < p.length; ++i) {
            String[] pp = p[i].split(",");
            if (pp == null || pp.length != 2) continue;
            try {
                if (pp[1] != null && pp[1].split(":") != null) {
                    String[] ppp = pp[1].split(":");
                    valueMapping.put(new Integer(Integer.parseInt(pp[0])), ppp[0]);
                } else {
                    valueMapping.put(new Integer(Integer.parseInt(pp[0])), pp[1]);
                }
                valueMapping2.put(new Integer(Integer.parseInt(pp[0])), pp[1]);
                continue;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "InfoPAttribute : getWhereClause", e);
            }
        }
        block9: for (i = 0; i < this.componentList.size(); ++i) {
            ComponentBean bean = this.componentList.get(i);
            String s = this.getValue(valueMapping2, i);
            switch (bean.getType()) {
                case 2: 
                case 3: 
                case 5: {
                    bean.setContent(s);
                    continue block9;
                }
                case 6: {
                    if (s == null) continue block9;
                    if ("Y".equalsIgnoreCase(s)) {
                        bean.setContent("Y");
                        continue block9;
                    }
                    bean.setContent("N");
                    continue block9;
                }
                case 4: {
                    bean.setLabel(s);
                    continue block9;
                }
                case 7: {
                    if (s != null && s.length() > 0) {
                        bean.setContent(s);
                        continue block9;
                    }
                    bean.setContent("");
                }
            }
        }
        this.p_sqlWhere = this.createQuery(valueMapping, dateFormat);
        this.log.config(this.p_sqlWhere);
    }

    protected String createQuery(Hashtable valueMapping, SimpleDateFormat dateFormat) {
        return "";
    }

    protected String getValue(Hashtable valueMapping, int idx) {
        String s = (String)valueMapping.get(idx);
        if (s != null && s.length() > 0) {
            return s;
        }
        return null;
    }

    protected String getComponetValue(Hashtable valueMapping, String key) {
        Integer idx = this.componentMapping.get(key);
        if (idx != null && valueMapping.get(idx) != null) {
            return this.getValue(valueMapping, idx);
        }
        return null;
    }

    public ArrayList getColumnAttrList() {
        return this.columnAttrList;
    }

    protected ArrayList<CodeValue> getTableDirectList(Lookup lookup) {
        ArrayList<Object> dataList;
        ArrayList<CodeValue> list = new ArrayList<CodeValue>();
        list.add(new CodeValue("", ""));
        if (lookup != null && (dataList = lookup.getData(false, false, false, false)) != null) {
            for (int i = 0; i < dataList.size(); ++i) {
                NamePair pair = (NamePair)dataList.get(i);
                if (pair == null) continue;
                list.add(new CodeValue(pair.getID(), pair.getName()));
            }
        }
        return list;
    }
}

