/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.grid.ed;

import com.ampiere.util.AmpiereUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.GridTab;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWFActivity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WDocAction {
    private int m_WindowNo = 0;
    private int m_AD_Table_ID;
    private GridTab m_mTab;
    private String[] s_value = null;
    private String[] s_name;
    private String[] s_description;
    private static CLogger log = CLogger.getCLogger(WDocAction.class);
    private String actionLabel = "";
    private ArrayList<String> actionCombo = new ArrayList();
    private ArrayList<String> actionComboDesc = new ArrayList();
    private ArrayList<String> actionComboValue = new ArrayList();
    private String actionComboSelected = "";
    private String actionComboDescSelected = "";
    private String batchButton = "";

    public WDocAction(int WindowNo, GridTab mTab, int Record_ID, Properties ctx) {
        log.config("");
        this.m_WindowNo = WindowNo;
        this.m_mTab = mTab;
        this.m_AD_Table_ID = Env.getContextAsInt(ctx, WindowNo, "BaseTable_ID");
        if (this.s_value == null) {
            this.readReference(ctx);
        }
        this.dynInit(Record_ID, ctx);
    }

    private void dynInit(int Record_ID, Properties ctx) {
        this.actionLabel = Msg.translate(ctx, "DocAction");
        this.batchButton = Msg.getMsg(ctx, "StartBackground");
        String DocStatus = (String)this.m_mTab.getValue("DocStatus");
        String DocAction = (String)this.m_mTab.getValue("DocAction");
        Object Processing = this.m_mTab.getValue("Processing");
        String OrderType = Env.getContext(ctx, this.m_WindowNo, "OrderType");
        String IsSOTrx = Env.getContext(ctx, this.m_WindowNo, "IsSOTrx");
        if (DocStatus == null) {
            log.log(Level.SEVERE, "***ERROR***");
            return;
        }
        log.fine("DocStatus=" + DocStatus + ", DocAction=" + DocAction + ", OrderType=" + OrderType + ", IsSOTrx=" + IsSOTrx + ", Processing=" + Processing + ", AD_Table_ID=" + this.m_AD_Table_ID + ", Record_ID=" + Record_ID);
        String[] options = new String[this.s_value.length];
        int index = 0;
        String wfStatus = MWFActivity.getActiveInfo(ctx, this.m_AD_Table_ID, Record_ID);
        if (wfStatus != null) {
            log.log(Level.SEVERE, "WFActiveForRecord");
            return;
        }
        if (!this.checkStatus(this.m_mTab.getTableName(), Record_ID, DocStatus)) {
            log.log(Level.SEVERE, "DocumentStatusChanged");
            return;
        }
        if (Processing != null) {
            boolean locked = "Y".equals(Processing);
            if (!locked && Processing instanceof Boolean) {
                locked = (Boolean)Processing;
            }
            if (locked) {
                options[index++] = "XL";
            }
        }
        if (DocStatus.equals("NA")) {
            options[index++] = "PR";
            options[index++] = "VO";
        } else if (DocStatus.equals("DR") || DocStatus.equals("IN")) {
            options[index++] = "CO";
            options[index++] = "VO";
        } else if (DocStatus.equals("IP") || DocStatus.equals("AP")) {
            options[index++] = "CO";
            options[index++] = "VO";
        } else if (DocStatus.equals("CO")) {
            options[index++] = "CL";
        } else if (DocStatus.equals("WP") || DocStatus.equals("WC")) {
            options[index++] = "VO";
            options[index++] = "PR";
        } else if (DocStatus.equals("CL") || DocStatus.equals("VO") || DocStatus.equals("RE")) {
            return;
        }
        if (this.m_AD_Table_ID == 259) {
            if (DocStatus.equals("DR") || DocStatus.equals("IP") || DocStatus.equals("IN")) {
                options[index++] = "PR";
                options[index++] = "CL";
                if ("Y".equals(IsSOTrx) && ("OB".equals(OrderType) || "ON".equals(OrderType))) {
                    DocAction = "PR";
                }
            } else if (DocStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
            } else if (DocStatus.equals("WP")) {
                options[index++] = "RE";
                options[index++] = "CL";
            }
        } else if (this.m_AD_Table_ID == 319) {
            if (DocStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
            }
        } else if (this.m_AD_Table_ID == 318) {
            if (DocStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
            }
        } else if (this.m_AD_Table_ID == 335) {
            if (DocStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
            }
        } else if (this.m_AD_Table_ID == 224 || this.m_AD_Table_ID == 225) {
            if (DocStatus.equals("CO")) {
                options[index++] = "RC";
                options[index++] = "RA";
            }
        } else if (this.m_AD_Table_ID == 735) {
            if (DocStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
            }
        } else if (this.m_AD_Table_ID == 392) {
            if (DocStatus.equals("CO")) {
                options[index++] = "VO";
            }
        } else if ((this.m_AD_Table_ID == 323 || this.m_AD_Table_ID == 321) && DocStatus.equals("CO")) {
            options[index++] = "VO";
            options[index++] = "RC";
        }
        for (int i = 0; i < index; ++i) {
            boolean added = false;
            for (int j = 0; j < this.s_value.length && !added; ++j) {
                if (!options[i].equals(this.s_value[j])) continue;
                this.actionCombo.add(this.s_name[j]);
                this.actionComboDesc.add(this.s_description[j]);
                this.actionComboValue.add(this.s_value[j]);
                added = true;
            }
        }
        if (DocAction.equals("--")) {
            DocAction = "CL";
        }
        String defaultV = "";
        String defaultDesc = "";
        for (int i = 0; i < this.s_value.length && defaultV.equals(""); ++i) {
            if (!DocAction.equals(this.s_value[i])) continue;
            defaultV = this.s_name[i];
            defaultDesc = this.s_description[i];
        }
        if (!defaultV.equals("")) {
            this.actionComboSelected = defaultV;
            this.actionComboDescSelected = defaultDesc;
        }
    }

    private boolean checkStatus(String TableName, int Record_ID, String DocStatus) {
        String sql = "SELECT 2 FROM " + TableName + " WHERE " + TableName + "_ID=" + Record_ID + " AND DocStatus='" + DocStatus + "'";
        int result = DB.getSQLValue(null, sql);
        return result == 2;
    }

    public int getNumberOfOptions() {
        return this.actionCombo.size();
    }

    private void readReference(Properties ctx) {
        String sql = Env.isBaseLanguage(ctx, "AD_Ref_List") ? "SELECT Value, Name, Description FROM AD_Ref_List WHERE AD_Reference_ID=135 ORDER BY Name" : "SELECT l.Value, t.Name, t.Description FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language(ctx) + "'" + " AND l.AD_Reference_ID=135 ORDER BY t.Name";
        ArrayList<String> v_value = new ArrayList<String>();
        ArrayList<String> v_name = new ArrayList<String>();
        ArrayList<String> v_description = new ArrayList<String>();
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String value = rs.getString(1);
                String name = rs.getString(2);
                String description = rs.getString(3);
                if (description == null) {
                    description = "";
                }
                v_value.add(value);
                v_name.add(name);
                v_description.add(description);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        int size = v_value.size();
        this.s_value = new String[size];
        this.s_name = new String[size];
        this.s_description = new String[size];
        for (int i = 0; i < size; ++i) {
            this.s_value[i] = (String)v_value.get(i);
            this.s_name[i] = (String)v_name.get(i);
            this.s_description[i] = (String)v_description.get(i);
        }
    }

    public ArrayList<String> getActionCombo() {
        return this.actionCombo;
    }

    public String getActionComboDescArray() {
        if (this.actionComboDesc.size() > 0) {
            String[] p = new String[this.actionComboDesc.size()];
            for (int i = 0; i < this.actionComboDesc.size(); ++i) {
                p[i] = this.actionComboDesc.get(i);
            }
            return AmpiereUtil.generateJavascriptArray(p);
        }
        return null;
    }

    public String getActionComboValueArray() {
        if (this.actionComboValue.size() > 0) {
            String[] p = new String[this.actionComboValue.size()];
            for (int i = 0; i < this.actionComboValue.size(); ++i) {
                p[i] = this.actionComboValue.get(i);
            }
            return AmpiereUtil.generateJavascriptArray(p);
        }
        return null;
    }

    public String getActionComboDescSelected() {
        return this.actionComboDescSelected;
    }

    public String getActionComboSelected() {
        return this.actionComboSelected;
    }

    public String getActionLabel() {
        return this.actionLabel;
    }

    public String getBatchButton() {
        return this.batchButton;
    }
}

