/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.acct;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.report.core.RColumn;
import org.compiere.report.core.RModel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class AccountViewerData {
    public Properties Ctx;
    public int WindowNo;
    public int AD_Client_ID;
    public MAcctSchema[] ASchemas = null;
    public MAcctSchema ASchema = null;
    public boolean documentQuery = false;
    public int C_AcctSchema_ID = 0;
    public String PostingType = "";
    public int AD_Org_ID = 0;
    public Timestamp DateFrom = null;
    public Timestamp DateTo = null;
    public int AD_Table_ID;
    public int Record_ID;
    public HashMap<String, String> whereInfo = new HashMap();
    public HashMap<String, Integer> tableInfo = new HashMap();
    public boolean displayQty = false;
    public boolean displaySourceAmt = false;
    public boolean displayDocumentInfo = false;
    public String sortBy1 = "";
    public String sortBy2 = "";
    public String sortBy3 = "";
    public String sortBy4 = "";
    public boolean group1 = false;
    public boolean group2 = false;
    public boolean group3 = false;
    public boolean group4 = false;
    private int m_leadingColumns = 0;
    private static CLogger log = CLogger.getCLogger(AccountViewerData.class);

    public AccountViewerData(Properties ctx, int windowNo, int ad_Client_ID, int ad_Table_ID) {
        this.Ctx = ctx;
        this.WindowNo = windowNo;
        this.AD_Client_ID = ad_Client_ID;
        if (this.AD_Client_ID == 0) {
            this.AD_Client_ID = Env.getContextAsInt(this.Ctx, this.WindowNo, "AD_Client_ID");
        }
        if (this.AD_Client_ID == 0) {
            this.AD_Client_ID = Env.getContextAsInt(this.Ctx, "AD_Client_ID");
        }
        this.AD_Table_ID = ad_Table_ID;
        this.ASchemas = MAcctSchema.getClientAcctSchema(ctx, this.AD_Client_ID);
        this.ASchema = this.ASchemas[0];
    }

    public void dispose() {
        this.ASchemas = null;
        this.ASchema = null;
        this.whereInfo.clear();
        this.whereInfo = null;
        Env.clearWinContext(this.WindowNo);
    }

    public RModel query() {
        StringBuffer whereClause = new StringBuffer();
        if (this.C_AcctSchema_ID != 0) {
            whereClause.append("zz").append(".C_AcctSchema_ID=").append(this.C_AcctSchema_ID);
        }
        if (this.PostingType != null && this.PostingType.length() > 0) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("zz").append(".PostingType='").append(this.PostingType).append("'");
        }
        if (this.documentQuery) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("zz").append(".AD_Table_ID=").append(this.AD_Table_ID).append(" AND ").append("zz").append(".Record_ID=").append(this.Record_ID);
        } else {
            for (String where : this.whereInfo.values()) {
                if (where == null || where.length() <= 0) continue;
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                whereClause.append("zz").append(".").append(where);
            }
            if (this.DateFrom != null || this.DateTo != null) {
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                if (this.DateFrom != null && this.DateTo != null) {
                    whereClause.append("TRUNC(").append("zz").append(".DateAcct) BETWEEN ").append(DB.TO_DATE(this.DateFrom)).append(" AND ").append(DB.TO_DATE(this.DateTo));
                } else if (this.DateFrom != null) {
                    whereClause.append("TRUNC(").append("zz").append(".DateAcct) >= ").append(DB.TO_DATE(this.DateFrom));
                } else {
                    whereClause.append("TRUNC(").append("zz").append(".DateAcct) <= ").append(DB.TO_DATE(this.DateTo));
                }
            }
            if (this.AD_Org_ID != 0) {
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                whereClause.append("zz").append(".AD_Org_ID=").append(this.AD_Org_ID);
            }
        }
        StringBuffer orderClause = new StringBuffer();
        if (this.sortBy1.length() > 0) {
            orderClause.append("zz").append(".").append(this.sortBy1);
        }
        if (this.sortBy2.length() > 0) {
            if (orderClause.length() > 0) {
                orderClause.append(",");
            }
            orderClause.append("zz").append(".").append(this.sortBy2);
        }
        if (this.sortBy3.length() > 0) {
            if (orderClause.length() > 0) {
                orderClause.append(",");
            }
            orderClause.append("zz").append(".").append(this.sortBy3);
        }
        if (this.sortBy4.length() > 0) {
            if (orderClause.length() > 0) {
                orderClause.append(",");
            }
            orderClause.append("zz").append(".").append(this.sortBy4);
        }
        if (orderClause.length() == 0) {
            orderClause.append("zz").append(".Fact_Acct_ID");
        }
        RModel rm = this.getRModel();
        if (this.group1 && this.sortBy1.length() > 0) {
            rm.setGroup(this.sortBy1);
        }
        if (this.group2 && this.sortBy2.length() > 0) {
            rm.setGroup(this.sortBy2);
        }
        if (this.group3 && this.sortBy3.length() > 0) {
            rm.setGroup(this.sortBy3);
        }
        if (this.group4 && this.sortBy4.length() > 0) {
            rm.setGroup(this.sortBy4);
        }
        rm.setFunction("AmtAcctDr", "Sum");
        rm.setFunction("AmtAcctCr", "Sum");
        rm.query(this.Ctx, whereClause.toString(), orderClause.toString());
        return rm;
    }

    private RModel getRModel() {
        String column;
        int i;
        Properties ctx = this.Ctx;
        RModel rm = new RModel("Fact_Acct");
        ArrayList keys = this.createKeyColumns();
        int max = this.m_leadingColumns;
        if (max == 0) {
            max = keys.size();
        }
        for (i = 0; i < max; ++i) {
            column = (String)keys.get(i);
            if (column != null && column.startsWith("Date")) {
                rm.addColumn(new RColumn(ctx, column, 15));
                continue;
            }
            if (column == null || !column.endsWith("_ID")) continue;
            rm.addColumn(new RColumn(ctx, column, 19));
        }
        rm.addColumn(new RColumn(ctx, "AmtAcctDr", 12));
        rm.addColumn(new RColumn(ctx, "AmtAcctCr", 12));
        if (this.displaySourceAmt) {
            if (!keys.contains("DateTrx")) {
                rm.addColumn(new RColumn(ctx, "DateTrx", 15));
            }
            rm.addColumn(new RColumn(ctx, "C_Currency_ID", 19));
            rm.addColumn(new RColumn(ctx, "AmtSourceDr", 12));
            rm.addColumn(new RColumn(ctx, "AmtSourceCr", 12));
            rm.addColumn(new RColumn(ctx, "Rate", 12, "CASE WHEN (AmtSourceDr + AmtSourceCr) = 0 THEN 0 ELSE (AmtAcctDr + AmtAcctCr) / (AmtSourceDr + AmtSourceCr) END"));
        }
        for (i = max; i < keys.size(); ++i) {
            column = (String)keys.get(i);
            if (column != null && column.startsWith("Date")) {
                rm.addColumn(new RColumn(ctx, column, 15));
                continue;
            }
            if (column == null || !column.endsWith("_ID")) continue;
            rm.addColumn(new RColumn(ctx, column, 19));
        }
        if (!keys.contains("DateAcct")) {
            rm.addColumn(new RColumn(ctx, "DateAcct", 15));
        }
        if (!keys.contains("C_Period_ID")) {
            rm.addColumn(new RColumn(ctx, "C_Period_ID", 19));
        }
        if (this.displayQty) {
            rm.addColumn(new RColumn(ctx, "C_UOM_ID", 19));
            rm.addColumn(new RColumn(ctx, "Qty", 29));
        }
        if (this.displayDocumentInfo) {
            rm.addColumn(new RColumn(ctx, "AD_Table_ID", 19));
            rm.addColumn(new RColumn(ctx, "Record_ID", 13));
            rm.addColumn(new RColumn(ctx, "Description", 10));
        }
        if (this.PostingType == null || this.PostingType.length() == 0) {
            rm.addColumn(new RColumn(ctx, "PostingType", 17, 125));
        }
        return rm;
    }

    private ArrayList createKeyColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        this.m_leadingColumns = 0;
        columns.add(this.sortBy1);
        if (!columns.contains(this.sortBy2)) {
            columns.add(this.sortBy2);
        }
        if (!columns.contains(this.sortBy3)) {
            columns.add(this.sortBy3);
        }
        if (!columns.contains(this.sortBy4)) {
            columns.add(this.sortBy4);
        }
        MAcctSchemaElement[] elements = this.ASchema.getAcctSchemaElements();
        for (int i = 0; i < elements.length; ++i) {
            MAcctSchemaElement ase;
            String columnName;
            if (this.m_leadingColumns == 0 && columns.contains("AD_Org_ID") && columns.contains("Account_ID")) {
                this.m_leadingColumns = columns.size();
            }
            if (columns.contains(columnName = (ase = elements[i]).getColumnName())) continue;
            columns.add(columnName);
        }
        if (this.m_leadingColumns == 0 && columns.contains("AD_Org_ID") && columns.contains("Account_ID")) {
            this.m_leadingColumns = columns.size();
        }
        return columns;
    }
}

