/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.install.Config;
import org.compiere.install.ConfigDB2;
import org.compiere.install.ConfigJBoss;
import org.compiere.install.ConfigOracle;
import org.compiere.install.ConfigTomcat;
import org.compiere.install.ConfigVMMac;
import org.compiere.install.ConfigVMSun;
import org.compiere.install.ConfigurationPanel;
import org.compiere.install.KeyStoreMgt;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.EMail;
import org.compiere.util.EMailAuthenticator;
import org.compiere.util.Ini;

public class ConfigurationData {
    protected ConfigurationPanel p_panel = null;
    protected Properties p_properties = new Properties();
    private File m_compiereHome;
    static CLogger log = CLogger.getCLogger(ConfigurationData.class);
    public static final String COMPIERE_ENV_FILE = "CompiereEnv.properties";
    public static final String COMPIERE_HOME = "COMPIERE_HOME";
    public static final String JAVA_HOME = "JAVA_HOME";
    public static final String JAVA_TYPE = "COMPIERE_JAVA_TYPE";
    public static final String COMPIERE_JAVA_OPTIONS = "COMPIERE_JAVA_OPTIONS";
    public static final String KEYSTORE_PASSWORD = "myPassword";
    public static final String COMPIERE_APPS_TYPE = "COMPIERE_APPS_TYPE";
    public static final String COMPIERE_APPS_SERVER = "COMPIERE_APPS_SERVER";
    public static final String COMPIERE_APPS_DEPLOY = "COMPIERE_APPS_DEPLOY";
    public static final String COMPIERE_JNP_PORT = "COMPIERE_JNP_PORT";
    public static final String COMPIERE_WEB_PORT = "COMPIERE_WEB_PORT";
    public static final String COMPIERE_SSL_PORT = "COMPIERE_SSL_PORT";
    public static final String COMPIERE_WEB_ALIAS = "COMPIERE_WEB_ALIAS";
    public static final String COMPIERE_KEYSTORE = "COMPIERE_KEYSTORE";
    public static final String COMPIERE_KEYSTOREPASS = "COMPIERE_KEYSTOREPASS";
    public static final String COMPIERE_KEYSTORECODEALIAS = "COMPIERE_KEYSTORECODEALIAS";
    public static final String COMPIERE_KEYSTOREWEBALIAS = "COMPIERE_KEYSTOREWEBALIAS";
    public static final String COMPIERE_DB_TYPE = "COMPIERE_DB_TYPE";
    public static final String COMPIERE_DB_SERVER = "COMPIERE_DB_SERVER";
    public static final String COMPIERE_DB_PORT = "COMPIERE_DB_PORT";
    public static final String COMPIERE_DB_NAME = "COMPIERE_DB_NAME";
    public static final String COMPIERE_DB_URL = "COMPIERE_DB_URL";
    public static final String COMPIERE_DB_USER = "COMPIERE_DB_USER";
    public static final String COMPIERE_DB_PASSWORD = "COMPIERE_DB_PASSWORD";
    public static final String COMPIERE_DB_SYSTEM = "COMPIERE_DB_SYSTEM";
    public static final String COMPIERE_MAIL_SERVER = "COMPIERE_MAIL_SERVER";
    public static final String COMPIERE_MAIL_USER = "COMPIERE_MAIL_USER";
    public static final String COMPIERE_MAIL_PASSWORD = "COMPIERE_MAIL_PASSWORD";
    public static final String COMPIERE_ADMIN_EMAIL = "COMPIERE_ADMIN_EMAIL";
    public static final String COMPIERE_MAIL_UPDATED = "COMPIERE_MAIL_UPDATED";
    public static final String COMPIERE_FTP_SERVER = "COMPIERE_FTP_SERVER";
    public static final String COMPIERE_FTP_USER = "COMPIERE_FTP_USER";
    public static final String COMPIERE_FTP_PASSWORD = "COMPIERE_FTP_PASSWORD";
    public static final String COMPIERE_FTP_PREFIX = "COMPIERE_FTP_PREFIX";
    public static final String COMPIERE_WEBSTORES = "COMPIERE_WEBSTORES";
    private static String JAVATYPE_SUN = "sun";
    private static String JAVATYPE_MAC = "mac";
    private static String JAVATYPE_IBM = "<ibm>";
    static String[] JAVATYPE = new String[]{JAVATYPE_SUN, JAVATYPE_MAC, JAVATYPE_IBM};
    private Config[] m_javaConfig = new Config[]{new ConfigVMSun(this), new ConfigVMMac(this), null};
    protected static String APPSTYPE_JBOSS = "jboss";
    protected static String APPSTYPE_TOMCAT = "tomcatOnly";
    private static String APPSTYPE_GERONIMO = "<geronimo>";
    private static String APPSTYPE_IBM = "<ibmWS>";
    private static String APPSTYPE_ORACLE = "<oracleAS>";
    static String[] APPSTYPE = new String[]{APPSTYPE_JBOSS, APPSTYPE_TOMCAT, APPSTYPE_GERONIMO, APPSTYPE_IBM, APPSTYPE_ORACLE};
    private Config[] m_appsConfig = new Config[]{new ConfigJBoss(this), new ConfigTomcat(this), null, null, null};
    private static String DBTYPE_ORACLE = "oracle";
    private static String DBTYPE_DB2 = "<db2>";
    private static String DBTYPE_MS = "<sqlServer>";
    private static String DBTYPE_DERBY = "<derby>";
    static String[] DBTYPE = new String[]{DBTYPE_ORACLE, DBTYPE_DB2, DBTYPE_MS, DBTYPE_DERBY};
    private Config[] m_databaseConfig = new Config[]{new ConfigOracle(this), new ConfigDB2(this), null, null};

    public ConfigurationData(ConfigurationPanel panel) {
        this.p_panel = panel;
    }

    public boolean load() {
        String compiereHome = System.getProperty(COMPIERE_HOME);
        if (compiereHome == null || compiereHome.length() == 0) {
            compiereHome = System.getProperty("user.dir");
        }
        boolean envLoaded = false;
        String fileName = compiereHome + File.separator + COMPIERE_ENV_FILE;
        File env = new File(fileName);
        if (env.exists()) {
            try {
                FileInputStream fis = new FileInputStream(env);
                this.p_properties.load(fis);
                fis.close();
            }
            catch (Exception e) {
                log.severe(e.toString());
            }
            log.info(env.toString());
            if (this.p_properties.size() > 5) {
                envLoaded = true;
            }
            this.setJavaType((String)this.p_properties.get(JAVA_TYPE));
            this.initJava();
            this.setJavaHome((String)this.p_properties.get(JAVA_HOME));
            this.setCompiereHome((String)this.p_properties.get(COMPIERE_HOME));
            String s = (String)this.p_properties.get(COMPIERE_KEYSTOREPASS);
            if (s == null || s.length() == 0) {
                s = KEYSTORE_PASSWORD;
            }
            this.setKeyStore(s);
            this.setAppsServerType((String)this.p_properties.get(COMPIERE_APPS_TYPE));
            this.initAppsServer();
            this.setAppsServer((String)this.p_properties.get(COMPIERE_APPS_SERVER));
            this.setAppsServerDeployDir((String)this.p_properties.get(COMPIERE_APPS_DEPLOY));
            this.setAppsServerJNPPort((String)this.p_properties.get(COMPIERE_JNP_PORT));
            this.setAppsServerWebPort((String)this.p_properties.get(COMPIERE_WEB_PORT));
            this.setAppsServerSSLPort((String)this.p_properties.get(COMPIERE_SSL_PORT));
            this.setDatabaseType((String)this.p_properties.get(COMPIERE_DB_TYPE));
            this.initDatabase((String)this.p_properties.get(COMPIERE_DB_NAME));
            this.setDatabaseDiscovered((String)this.p_properties.get(COMPIERE_DB_NAME));
            this.setDatabaseServer((String)this.p_properties.get(COMPIERE_DB_SERVER));
            this.setDatabasePort((String)this.p_properties.get(COMPIERE_DB_PORT));
            this.setDatabaseName((String)this.p_properties.get(COMPIERE_DB_NAME));
            this.setDatabaseUser((String)this.p_properties.get(COMPIERE_DB_USER));
            this.setDatabasePassword((String)this.p_properties.get(COMPIERE_DB_PASSWORD));
            this.setDatabaseSystemPassword((String)this.p_properties.get(COMPIERE_DB_SYSTEM));
            this.p_panel.fMailServer.setText((String)this.p_properties.get(COMPIERE_MAIL_SERVER));
            this.p_panel.fMailUser.setText((String)this.p_properties.get(COMPIERE_MAIL_USER));
            this.p_panel.fMailPassword.setText((String)this.p_properties.get(COMPIERE_MAIL_PASSWORD));
            this.p_panel.fAdminEMail.setText((String)this.p_properties.get(COMPIERE_ADMIN_EMAIL));
        }
        InetAddress localhost = null;
        String hostName = "unknown";
        try {
            localhost = InetAddress.getLocalHost();
            hostName = localhost.getHostName();
        }
        catch (Exception e) {
            log.severe("Cannot get local host name");
        }
        if (!envLoaded) {
            log.info("Defaults");
            this.initJava();
            this.setCompiereHome(compiereHome);
            this.setKeyStore(KEYSTORE_PASSWORD);
            this.initAppsServer();
            this.setAppsServer(hostName);
            this.initDatabase("");
            this.setDatabaseName(this.getDatabaseDiscovered());
            this.setDatabaseSystemPassword("");
            this.setDatabaseServer(hostName);
            this.setDatabaseUser("compiere");
            this.setDatabasePassword("compiere");
            this.p_panel.fMailServer.setText(hostName);
            this.p_panel.fMailUser.setText("info");
            this.p_panel.fMailPassword.setText("");
            this.p_panel.fAdminEMail.setText("info@" + hostName);
        }
        if (!this.p_properties.containsKey(COMPIERE_FTP_SERVER)) {
            this.p_properties.setProperty(COMPIERE_FTP_SERVER, "localhost");
            this.p_properties.setProperty(COMPIERE_FTP_USER, "anonymous");
            this.p_properties.setProperty(COMPIERE_FTP_PASSWORD, "user@host.com");
            this.p_properties.setProperty(COMPIERE_FTP_PREFIX, "my");
        }
        if (!this.p_properties.containsKey(COMPIERE_JAVA_OPTIONS)) {
            this.p_properties.setProperty(COMPIERE_JAVA_OPTIONS, "-Xms64M -Xmx512M");
        }
        if (!this.p_properties.containsKey(COMPIERE_WEB_ALIAS) && localhost != null) {
            this.p_properties.setProperty(COMPIERE_WEB_ALIAS, localhost.getCanonicalHostName());
        }
        if (!this.p_properties.containsKey(COMPIERE_KEYSTORECODEALIAS)) {
            this.p_properties.setProperty(COMPIERE_KEYSTORECODEALIAS, "compiere");
        }
        if (!this.p_properties.containsKey(COMPIERE_KEYSTOREWEBALIAS)) {
            this.p_properties.setProperty(COMPIERE_KEYSTOREWEBALIAS, "compiere");
        }
        return true;
    }

    public boolean test() {
        String error = this.testJava();
        if (error != null) {
            log.severe(error);
            return false;
        }
        error = this.testCompiere();
        if (error != null) {
            log.severe(error);
            return false;
        }
        this.p_panel.setStatusBar(this.p_panel.lAppsServer.getText());
        error = this.testAppsServer();
        if (error != null) {
            log.severe(error);
            return false;
        }
        this.p_panel.setStatusBar(this.p_panel.lDatabaseServer.getText());
        error = this.testDatabase();
        if (error != null) {
            log.severe(error);
            return false;
        }
        this.p_panel.setStatusBar(this.p_panel.lMailServer.getText());
        error = this.testMail();
        if (error != null) {
            log.severe(error);
            return false;
        }
        return true;
    }

    private String testCompiere() {
        this.m_compiereHome = new File(this.getCompiereHome());
        boolean pass = this.m_compiereHome.exists();
        String error = "Not found: CompiereHome = " + this.m_compiereHome;
        this.p_panel.signalOK(this.p_panel.okCompiereHome, "ErrorCompiereHome", pass, true, error);
        if (!pass) {
            return error;
        }
        log.info("OK: CompiereHome = " + this.m_compiereHome);
        this.p_properties.setProperty(COMPIERE_HOME, this.m_compiereHome.getAbsolutePath());
        System.setProperty(COMPIERE_HOME, this.m_compiereHome.getAbsolutePath());
        String fileName = KeyStoreMgt.getKeystoreFileName(this.m_compiereHome.getAbsolutePath());
        this.p_properties.setProperty(COMPIERE_KEYSTORE, fileName);
        String pw = new String(this.p_panel.fKeyStore.getPassword());
        pass = pw != null && pw.length() > 0;
        error = "Invalid Key Store Password = " + pw;
        this.p_panel.signalOK(this.p_panel.okKeyStore, "KeyStorePassword", pass, true, error);
        if (!pass) {
            return error;
        }
        this.p_properties.setProperty(COMPIERE_KEYSTOREPASS, pw);
        KeyStoreMgt ks = new KeyStoreMgt(fileName, this.p_panel.fKeyStore.getPassword());
        error = ks.verify((JFrame)SwingUtilities.getWindowAncestor((Component)((Object)this.p_panel)));
        pass = error == null;
        this.p_panel.signalOK(this.p_panel.okKeyStore, "KeyStorePassword", pass, true, error);
        if (!pass) {
            return error;
        }
        log.info("OK: KeyStore = " + fileName);
        return null;
    }

    private String testMail() {
        String server = this.p_panel.fMailServer.getText();
        boolean pass = server != null && server.length() > 0 && server.toLowerCase().indexOf("localhost") == -1 && !server.equals("127.0.0.1");
        String error = "Error Mail Server = " + server;
        InetAddress mailServer = null;
        try {
            if (pass) {
                mailServer = InetAddress.getByName(server);
            }
        }
        catch (Exception e) {
            error = error + " - " + e.getMessage();
            pass = false;
        }
        this.p_panel.signalOK(this.p_panel.okMailServer, "ErrorMailServer", pass, true, error);
        if (!pass) {
            this.p_properties.setProperty(COMPIERE_MAIL_SERVER, "");
            return error;
        }
        this.p_properties.setProperty(COMPIERE_MAIL_SERVER, mailServer.getHostName());
        String mailUser = this.p_panel.fMailUser.getText();
        String mailPassword = new String(this.p_panel.fMailPassword.getPassword());
        String adminEMailString = this.p_panel.fAdminEMail.getText();
        InternetAddress adminEMail = null;
        try {
            adminEMail = new InternetAddress(adminEMailString);
        }
        catch (Exception e) {
            error = "Not valid: " + adminEMailString + " - " + e.getMessage();
            pass = false;
        }
        if (pass) {
            error = "Not verified EMail = " + adminEMail;
            pass = this.testMailServer(mailServer, adminEMail, mailUser, mailPassword);
        }
        this.p_panel.signalOK(this.p_panel.okMailUser, "ErrorMail", pass, false, error);
        if (pass) {
            log.info("OK: EMail = " + adminEMail);
            this.p_properties.setProperty(COMPIERE_ADMIN_EMAIL, adminEMail.toString());
            this.p_properties.setProperty(COMPIERE_MAIL_USER, mailUser);
            this.p_properties.setProperty(COMPIERE_MAIL_PASSWORD, mailPassword);
            this.p_properties.setProperty(COMPIERE_MAIL_UPDATED, "No");
        } else {
            log.warning(error);
            this.p_properties.setProperty(COMPIERE_ADMIN_EMAIL, "");
            this.p_properties.setProperty(COMPIERE_MAIL_USER, "");
            this.p_properties.setProperty(COMPIERE_MAIL_PASSWORD, "");
            this.p_properties.setProperty(COMPIERE_MAIL_UPDATED, "");
        }
        return null;
    }

    private boolean testMailServer(InetAddress mailServer, InternetAddress adminEMail, String mailUser, String mailPassword) {
        boolean smtpOK = false;
        boolean imapOK = false;
        if (this.testPort(mailServer, 25, true)) {
            log.config("OK: SMTP Server contacted");
            smtpOK = true;
        } else {
            log.info("SMTP Server NOT available");
        }
        if (this.testPort(mailServer, 110, true)) {
            log.config("OK: POP3 Server contacted");
        } else {
            log.info("POP3 Server NOT available");
        }
        if (this.testPort(mailServer, 143, true)) {
            log.config("OK: IMAP4 Server contacted");
            imapOK = true;
        } else {
            log.info("IMAP4 Server NOT available");
        }
        if (!smtpOK) {
            String error = "No active Mail Server";
            this.p_panel.signalOK(this.p_panel.okMailServer, "ErrorMailServer", false, false, error);
            log.warning(error);
            return false;
        }
        try {
            EMail email = new EMail(new Properties(), mailServer.getHostName(), adminEMail.toString(), adminEMail.toString(), "Compiere Server Setup Test", "Test: " + this.getProperties());
            email.createAuthenticator(mailUser, mailPassword);
            if ("OK".equals(email.send())) {
                log.info("OK: Send Test Email to " + adminEMail);
            } else {
                log.warning("Could NOT send Email to " + adminEMail);
            }
        }
        catch (Exception ex) {
            log.severe(ex.getLocalizedMessage());
            return false;
        }
        if (!imapOK) {
            return false;
        }
        Properties props = new Properties();
        props.put("mail.store.protocol", "smtp");
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.host", mailServer.getHostName());
        props.put("mail.user", mailUser);
        props.put("mail.smtp.auth", "true");
        log.config("Connecting to " + mailServer.getHostName());
        Session session = null;
        Store store = null;
        try {
            EMailAuthenticator auth = new EMailAuthenticator(mailUser, mailPassword);
            session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
            session.setDebug(CLogMgt.isLevelFinest());
            log.config("Session=" + session);
            store = session.getStore("imap");
            log.config("Store=" + store);
        }
        catch (NoSuchProviderException nsp) {
            log.warning("Mail IMAP Provider - " + nsp.getMessage());
            return false;
        }
        catch (Exception e) {
            log.warning("Mail IMAP - " + e.getMessage());
            return false;
        }
        try {
            store.connect(mailServer.getHostName(), mailUser, mailPassword);
            log.config("Store - connected");
            Folder folder = store.getDefaultFolder();
            Folder inbox = folder.getFolder("INBOX");
            log.info("OK: Mail Connect to " + inbox.getFullName() + " #Msg=" + inbox.getMessageCount());
            store.close();
        }
        catch (MessagingException mex) {
            log.severe("Mail Connect " + mex.getMessage());
            return false;
        }
        return true;
    }

    protected boolean testPort(String protocol, String server, int port, String file) {
        URL url = null;
        try {
            url = new URL(protocol, server, port, file);
        }
        catch (MalformedURLException ex) {
            log.severe("No URL for Protocol=" + protocol + ", Server=" + server + ": " + ex.getMessage());
            return false;
        }
        try {
            URLConnection c = url.openConnection();
            Object o = c.getContent();
            log.severe("In use=" + url);
        }
        catch (Exception ex) {
            log.fine("Not used=" + url);
            return false;
        }
        return true;
    }

    protected boolean testServerPort(int port) {
        try {
            ServerSocket ss = new ServerSocket(port);
            log.fine(ss.getInetAddress() + ":" + ss.getLocalPort() + " - created");
            ss.close();
        }
        catch (Exception ex) {
            log.severe("Port " + port + ": " + ex.getMessage());
            return false;
        }
        return true;
    }

    protected boolean testPort(InetAddress host, int port, boolean shouldBeUsed) {
        Socket pingSocket = null;
        try {
            pingSocket = new Socket(host, port);
        }
        catch (Exception e) {
            if (shouldBeUsed) {
                log.severe("Open Socket " + host + ":" + port + " - " + e.getMessage());
            } else {
                log.fine(host + ":" + port + " - " + e.getMessage());
            }
            return false;
        }
        if (!shouldBeUsed) {
            log.severe("Open Socket " + host + ":" + port + " - " + pingSocket);
        }
        log.fine(host + ":" + port + " - " + pingSocket);
        if (pingSocket == null) {
            return false;
        }
        try {
            pingSocket.close();
        }
        catch (IOException e) {
            log.severe("close socket=" + e.toString());
        }
        return true;
    }

    public boolean save() {
        this.p_properties.setProperty("COMPIERE_MAIN_VERSION", "Release 2.5.3c");
        this.p_properties.setProperty("COMPIERE_DATE_VERSION", "2006-02-22");
        this.p_properties.setProperty("COMPIERE_DB_VERSION", "2006-02-22");
        log.finest(this.p_properties.toString());
        Ini.setClient((boolean)false);
        String fileName = this.m_compiereHome.getAbsolutePath() + File.separator + "Compiere.properties";
        Ini.loadProperties((String)fileName);
        fileName = this.m_compiereHome.getAbsolutePath() + File.separator + COMPIERE_ENV_FILE;
        try {
            FileOutputStream fos = new FileOutputStream(new File(fileName));
            this.p_properties.store(fos, COMPIERE_ENV_FILE);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            log.severe("Cannot save Properties to " + fileName + " - " + e.toString());
            JOptionPane.showConfirmDialog((Component)((Object)this.p_panel), ConfigurationPanel.res.getString("ErrorSave"), ConfigurationPanel.res.getString("CompiereServerSetup"), -1, 0);
            return false;
        }
        catch (Throwable t) {
            log.severe("Cannot save Properties to " + fileName + " - " + t.toString());
            JOptionPane.showConfirmDialog((Component)((Object)this.p_panel), ConfigurationPanel.res.getString("ErrorSave"), ConfigurationPanel.res.getString("CompiereServerSetup"), -1, 0);
            return false;
        }
        log.info(fileName);
        return this.saveIni();
    }

    private boolean saveIni() {
        Ini.setCompiereHome((String)this.m_compiereHome.getAbsolutePath());
        String ccType = Database.DB_ORACLE;
        if (this.getDatabaseType().equals(DBTYPE_MS)) {
            ccType = Database.DB_MSSQLServer;
        } else if (this.getDatabaseType().equals(DBTYPE_DB2)) {
            ccType = Database.DB_DB2;
        } else if (this.getDatabaseType().equals(DBTYPE_DERBY)) {
            ccType = Database.DB_DERBY;
        }
        CConnection cc = null;
        try {
            cc = CConnection.get((String)ccType, (String)this.getDatabaseServer(), (int)this.getDatabasePort(), (String)this.getDatabaseName(), (String)this.getDatabaseUser(), (String)this.getDatabasePassword());
            cc.setAppsHost(this.p_panel.fAppsServer.getText());
            cc.setConnectionProfile("L");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "connection", (Throwable)e);
            return false;
        }
        if (cc == null) {
            log.severe("No Connection");
            return false;
        }
        Ini.setProperty((String)"Connection", (String)cc.toStringLong());
        Ini.saveProperties((boolean)false);
        return true;
    }

    Properties getProperties() {
        return this.p_properties;
    }

    public String getCompiereHome() {
        return this.p_panel.fCompiereHome.getText();
    }

    public void setCompiereHome(String compiereHome) {
        this.p_panel.fCompiereHome.setText(compiereHome);
    }

    public String getKeyStore() {
        char[] pw = this.p_panel.fKeyStore.getPassword();
        if (pw != null) {
            return new String(pw);
        }
        return "";
    }

    public void setKeyStore(String password) {
        this.p_panel.fKeyStore.setText(password);
    }

    public void initJava() {
        int index = this.p_panel.fJavaType.getSelectedIndex();
        if (index < 0 || index >= JAVATYPE.length) {
            log.warning("JavaType Index invalid: " + index);
        } else if (this.m_javaConfig[index] == null) {
            log.warning("JavaType Config missing: " + JAVATYPE[index]);
            this.p_panel.fJavaType.setSelectedIndex(0);
        } else {
            this.m_javaConfig[index].init();
        }
    }

    public String testJava() {
        int index = this.p_panel.fJavaType.getSelectedIndex();
        if (index < 0 || index >= JAVATYPE.length) {
            return "JavaType Index invalid: " + index;
        }
        if (this.m_javaConfig[index] == null) {
            return "JavaType Config class missing: " + index;
        }
        return this.m_javaConfig[index].test();
    }

    public void setJavaType(String javaType) {
        int index = -1;
        for (int i = 0; i < JAVATYPE.length; ++i) {
            if (!JAVATYPE[i].equals(javaType)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = 0;
            log.warning("Invalid JavaType=" + javaType);
        }
        this.p_panel.fJavaType.setSelectedIndex(index);
    }

    public String getJavaType() {
        return (String)this.p_panel.fJavaType.getSelectedItem();
    }

    public String getJavaHome() {
        return this.p_panel.fJavaHome.getText();
    }

    public void setJavaHome(String javaHome) {
        this.p_panel.fJavaHome.setText(javaHome);
    }

    public void initAppsServer() {
        int index = this.p_panel.fAppsType.getSelectedIndex();
        if (index < 0 || index >= APPSTYPE.length) {
            log.warning("AppsServerType Index invalid: " + index);
        } else if (this.m_appsConfig[index] == null) {
            log.warning("AppsServerType Config missing: " + APPSTYPE[index]);
            this.p_panel.fAppsType.setSelectedIndex(0);
        } else {
            this.m_appsConfig[index].init();
        }
    }

    public String testAppsServer() {
        int index = this.p_panel.fAppsType.getSelectedIndex();
        if (index < 0 || index >= APPSTYPE.length) {
            return "AppsServerType Index invalid: " + index;
        }
        if (this.m_appsConfig[index] == null) {
            return "AppsServerType Config class missing: " + index;
        }
        return this.m_appsConfig[index].test();
    }

    public void setAppsServerType(String appsType) {
        int index = -1;
        for (int i = 0; i < APPSTYPE.length; ++i) {
            if (!APPSTYPE[i].equals(appsType)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = 0;
            log.warning("Invalid AppsType=" + appsType);
        }
        this.p_panel.fAppsType.setSelectedIndex(index);
    }

    public String getAppsServerType() {
        return (String)this.p_panel.fAppsType.getSelectedItem();
    }

    public String getAppsServer() {
        return this.p_panel.fAppsServer.getText();
    }

    public void setAppsServer(String appsServer) {
        this.p_panel.fAppsServer.setText(appsServer);
    }

    public String getAppsServerDeployDir() {
        return this.p_panel.fDeployDir.getText();
    }

    public void setAppsServerDeployDir(String appsServerDeployDir) {
        this.p_panel.fDeployDir.setText(appsServerDeployDir);
    }

    public void setAppsServerDeployDir(boolean enable) {
        this.p_panel.fDeployDir.setEnabled(enable);
        this.p_panel.bDeployDir.setEnabled(enable);
    }

    public int getAppsServerJNPPort() {
        try {
            return Integer.parseInt(this.p_panel.fJNPPort.getText());
        }
        catch (Exception e) {
            this.setAppsServerJNPPort("0");
            return 0;
        }
    }

    public void setAppsServerJNPPort(String appsServerJNPPort) {
        this.p_panel.fJNPPort.setText(appsServerJNPPort);
    }

    public void setAppsServerJNPPort(boolean enable) {
        this.p_panel.fJNPPort.setEnabled(enable);
    }

    public int getAppsServerSSLPort() {
        try {
            return Integer.parseInt(this.p_panel.fSSLPort.getText());
        }
        catch (Exception e) {
            this.setAppsServerSSLPort("0");
            return 0;
        }
    }

    public void setAppsServerSSLPort(String appsServerSSLPort) {
        this.p_panel.fSSLPort.setText(appsServerSSLPort);
    }

    public void setAppsServerSSLPort(boolean enable) {
        this.p_panel.fSSLPort.setEnabled(enable);
    }

    public int getAppsServerWebPort() {
        try {
            return Integer.parseInt(this.p_panel.fWebPort.getText());
        }
        catch (Exception e) {
            this.setAppsServerWebPort("0");
            return 0;
        }
    }

    public void setAppsServerWebPort(String appsServerWebPort) {
        this.p_panel.fWebPort.setText(appsServerWebPort);
    }

    public void setAppsServerWebPort(boolean enable) {
        this.p_panel.fWebPort.setEnabled(enable);
    }

    public void initDatabase(String selected) {
        int index = this.p_panel.fDatabaseType.getSelectedIndex();
        if (index < 0 || index >= DBTYPE.length) {
            log.warning("DatabaseType Index invalid: " + index);
        } else if (this.m_databaseConfig[index] == null) {
            log.warning("DatabaseType Config missing: " + DBTYPE[index]);
            this.p_panel.fDatabaseType.setSelectedIndex(0);
        } else {
            this.m_databaseConfig[index].init();
            String[] databases = this.m_databaseConfig[index].discoverDatabases(selected);
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(databases);
            this.p_panel.fDatabaseDiscovered.setModel(model);
            this.p_panel.fDatabaseDiscovered.setEnabled(databases.length != 0);
        }
    }

    public String testDatabase() {
        int index = this.p_panel.fDatabaseType.getSelectedIndex();
        if (index < 0 || index >= DBTYPE.length) {
            return "DatabaseType Index invalid: " + index;
        }
        if (this.m_databaseConfig[index] == null) {
            return "DatabaseType Config class missing: " + index;
        }
        return this.m_databaseConfig[index].test();
    }

    public void setDatabaseType(String databaseType) {
        int index = -1;
        for (int i = 0; i < DBTYPE.length; ++i) {
            if (!DBTYPE[i].equals(databaseType)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = 0;
            log.warning("Invalid DatabaseType=" + databaseType);
        }
        this.p_panel.fDatabaseType.setSelectedIndex(index);
    }

    public String getDatabaseType() {
        return (String)this.p_panel.fDatabaseType.getSelectedItem();
    }

    public String getDatabaseDiscovered() {
        return (String)this.p_panel.fDatabaseDiscovered.getSelectedItem();
    }

    public void setDatabaseDiscovered(String databaseDiscovered) {
        this.p_panel.fDatabaseDiscovered.setSelectedItem((Object)databaseDiscovered);
    }

    public String getDatabaseName() {
        return this.p_panel.fDatabaseName.getText();
    }

    public void setDatabaseName(String databaseName) {
        this.p_panel.fDatabaseName.setText(databaseName);
    }

    public String getDatabasePassword() {
        char[] pw = this.p_panel.fDatabasePassword.getPassword();
        if (pw != null) {
            return new String(pw);
        }
        return "";
    }

    public void setDatabasePassword(String databasePassword) {
        this.p_panel.fDatabasePassword.setText(databasePassword);
    }

    public int getDatabasePort() {
        try {
            return Integer.parseInt(this.p_panel.fDatabasePort.getText());
        }
        catch (Exception e) {
            this.setDatabasePort("0");
            return 0;
        }
    }

    public void setDatabasePort(String databasePort) {
        this.p_panel.fDatabasePort.setText(databasePort);
    }

    public String getDatabaseServer() {
        return this.p_panel.fDatabaseServer.getText();
    }

    public void setDatabaseServer(String databaseServer) {
        this.p_panel.fDatabaseServer.setText(databaseServer);
    }

    public String getDatabaseSystemPassword() {
        char[] pw = this.p_panel.fSystemPassword.getPassword();
        if (pw != null) {
            return new String(pw);
        }
        return "";
    }

    public void setDatabaseSystemPassword(String databaseSystemPassword) {
        this.p_panel.fSystemPassword.setText(databaseSystemPassword);
    }

    public String getDatabaseUser() {
        return this.p_panel.fDatabaseUser.getText();
    }

    public void setDatabaseUser(String databaseUser) {
        this.p_panel.fDatabaseUser.setText(databaseUser);
    }
}

