/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.io.File;
import java.net.InetAddress;
import org.compiere.install.Config;
import org.compiere.install.ConfigurationData;

public class ConfigTomcat
extends Config {
    public ConfigTomcat(ConfigurationData data) {
        super(data);
    }

    public void init() {
        this.p_data.setAppsServerDeployDir(this.getDeployDir());
        this.p_data.setAppsServerDeployDir(true);
        this.p_data.setAppsServerJNPPort("1099");
        this.p_data.setAppsServerJNPPort(false);
        this.p_data.setAppsServerWebPort("80");
        this.p_data.setAppsServerWebPort(true);
        this.p_data.setAppsServerSSLPort("443");
        this.p_data.setAppsServerSSLPort(true);
    }

    public String getNotes() {
        return "Compiere requires Tomcat 5.5.9\nPlease set the Web Port in $CATALINA_HOME//conf//server.xml\n";
    }

    private String getDeployDir() {
        return "C:" + File.separator + "Program Files" + File.separator + "Apache Software Foundation" + File.separator + "Tomcat 5.5";
    }

    public String test() {
        String server = this.p_data.getAppsServer();
        boolean pass = server != null && server.length() > 0 && server.toLowerCase().indexOf("localhost") == -1 && !server.equals("127.0.0.1");
        InetAddress appsServer = null;
        String error = "Not correct: AppsServer = " + server;
        try {
            if (pass) {
                appsServer = InetAddress.getByName(server);
            }
        }
        catch (Exception e) {
            error = error + " - " + e.getMessage();
            pass = false;
        }
        this.signalOK(this.getPanel().okAppsServer, "ErrorAppsServer", pass, true, error);
        if (!pass) {
            return error;
        }
        log.info("OK: AppsServer = " + appsServer);
        this.setProperty("COMPIERE_APPS_SERVER", appsServer.getHostName());
        this.setProperty("COMPIERE_APPS_TYPE", this.p_data.getAppsServerType());
        File deploy = new File(this.p_data.getAppsServerDeployDir());
        pass = deploy.exists();
        error = "CATALINA_HOME Not found: " + deploy;
        this.signalOK(this.getPanel().okDeployDir, "ErrorDeployDir", pass, true, error);
        if (!pass) {
            return error;
        }
        this.setProperty("COMPIERE_APPS_DEPLOY", this.p_data.getAppsServerDeployDir());
        log.info("OK: Deploy Directory = " + deploy);
        String baseDir = this.p_data.getAppsServerDeployDir();
        if (!baseDir.endsWith(File.separator)) {
            baseDir = baseDir + File.separator;
        }
        String sharedLib = baseDir + "shared" + File.separator + "lib";
        File sharedLibDir = new File(sharedLib);
        pass = sharedLibDir.exists();
        error = "Not found (shared library): " + sharedLib;
        this.signalOK(this.getPanel().okDeployDir, "ErrorDeployDir", pass, true, error);
        if (!pass) {
            return error;
        }
        String webApps = baseDir + "webapps";
        File webAppsDir = new File(webApps);
        pass = webAppsDir.exists();
        error = "Not found (webapps): " + sharedLib;
        this.signalOK(this.getPanel().okDeployDir, "ErrorDeployDir", pass, true, error);
        if (!pass) {
            return error;
        }
        return null;
    }
}

