/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.ByRefInt;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormControlType;
import au.id.jericho.lib.html.SearchCache;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.SpecialTag;
import au.id.jericho.lib.html.Tag;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class StartTag
extends Tag {
    private Attributes attributes;
    private SpecialTag specialTag;
    static final StartTag CACHED_NULL = new StartTag();

    private StartTag(Source source, int n, int n2, String string, SpecialTag specialTag, Attributes attributes) {
        super(source, n, n2, string);
        this.attributes = attributes;
        this.specialTag = specialTag;
    }

    private StartTag() {
    }

    private static StartTag constructWithAttributes(Source source, int n, String string, SpecialTag specialTag) {
        ByRefInt byRefInt = new ByRefInt();
        Attributes attributes = Attributes.construct(source, n, byRefInt, string);
        if (attributes == null) {
            return null;
        }
        String string2 = source.getParseTextLowerCase();
        int n2 = byRefInt.value + (string2.charAt(byRefInt.value) == '>' ? 1 : 2);
        StartTag startTag = new StartTag(source, n, n2, string, specialTag, attributes);
        return startTag;
    }

    public boolean isEndTagForbidden() {
        return this.isEmptyElementTag() || this.specialTag != null && !this.specialTag.hasEndTag() || StartTag.isEndTagForbidden(this.name);
    }

    public boolean isEndTagOptional() {
        return StartTag.isEndTagOptional(this.name);
    }

    public boolean isEndTagRequired() {
        return StartTag.isEndTagRequired(this.name);
    }

    public boolean isEmptyElementTag() {
        return this.source.charAt(this.end - 2) == '/';
    }

    public boolean isComment() {
        return this.specialTag == SpecialTag.COMMENT;
    }

    public boolean isProcessingInstruction() {
        return this.name.charAt(0) == '?';
    }

    public boolean isXMLDeclaration() {
        return this.name == "?xml";
    }

    public boolean isDocTypeDeclaration() {
        return this.name == "!doctype";
    }

    public boolean isServerTag() {
        return this.specialTag != null && this.specialTag.isServerTag();
    }

    public boolean isPHPTag() {
        return this.specialTag == SpecialTag.PHP_TAG;
    }

    public boolean isCommonServerTag() {
        return this.specialTag == SpecialTag.COMMON_SERVER_TAG;
    }

    public boolean isMasonTag() {
        return this.isCommonServerTag() || this.isMasonNamedBlock() || this.isMasonComponentCall() || this.isMasonComponentCalledWithContent();
    }

    public boolean isMasonNamedBlock() {
        return this.specialTag == SpecialTag.MASON_NAMED_BLOCK;
    }

    public boolean isMasonComponentCall() {
        return this.specialTag == SpecialTag.MASON_COMPONENT_CALL;
    }

    public boolean isMasonComponentCalledWithContent() {
        return this.specialTag == SpecialTag.MASON_COMPONENT_CALLED_WITH_CONTENT;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Attributes parseAttributes() {
        return this.parseAttributes(Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int n) {
        if (this.attributes != null) {
            return this.attributes;
        }
        int n2 = this.end - (this.specialTag != null ? this.specialTag.getEndDelimiter().length() : 1);
        int n3 = this.begin + 1 + this.name.length();
        while (!StartTag.isIdentifierStart(this.source.charAt(n3))) {
            if (++n3 != n2) continue;
            return null;
        }
        return Attributes.construct(this.source, this.begin, n3, n2, this.name, n);
    }

    public FormControl getFormControl() {
        return this.getElement().getFormControl();
    }

    public FormControlType getFormControlType() {
        FormControl formControl = this.getFormControl();
        if (formControl == null) {
            return null;
        }
        return formControl.getFormControlType();
    }

    public EndTag findEndTag() {
        return this.getElement().getEndTag();
    }

    public Element getElement() {
        String string = SearchCache.getElementKey(this);
        Element element = this.source.getSearchCache().getElement(string);
        if (element == null) {
            element = new Element(this.source, this, this.findEndTagInternal());
            this.source.getSearchCache().setElement(string, element);
        }
        return element;
    }

    public String regenerateHTML() {
        if (this.attributes == null) {
            return this.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<').append(this.name);
        this.attributes.appendRegeneratedHTML(stringBuffer);
        if (this.isXMLDeclaration()) {
            stringBuffer.append(" ?>");
        } else if (this.isEmptyElementTag() || this.isEndTagForbidden()) {
            stringBuffer.append(" />");
        } else {
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }

    public static String generateHTML(String string, Map map, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        StringBuffer stringBuffer = stringWriter.getBuffer();
        stringBuffer.append('<').append(string);
        try {
            Attributes.appendHTML(stringWriter, map);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            stringBuffer.append(" />");
        } else {
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }

    public String getDebugInfo() {
        if (this == CACHED_NULL) {
            return "CACHED_NULL";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"').append(this.name).append("\" ");
        if (this.specialTag != null) {
            stringBuffer.append('(').append(this.specialTag.getDescription()).append(") ");
        }
        stringBuffer.append(super.getDebugInfo());
        return stringBuffer.toString();
    }

    public Segment getFollowingTextSegment() {
        int n = this.source.getParseTextLowerCase().indexOf(60, this.end);
        if (n == -1) {
            n = this.source.length();
        }
        return new Segment(this.source, this.end, n);
    }

    private EndTag findEndTagInternal() {
        if (this.isEndTagForbidden()) {
            return null;
        }
        Tag.TerminatorSets terminatorSets = this.getOptionalEndTagTerminatorSets();
        if (terminatorSets != null) {
            return this.findOptionalEndTag(terminatorSets);
        }
        String string = this.name == "&|" ? "&" : this.name;
        Segment[] segmentArray = this.findEndTag(this.source.getParseTextLowerCase(), this.source.findNextEndTag(this.end, string));
        if (segmentArray == null) {
            return null;
        }
        return (EndTag)segmentArray[0];
    }

    private EndTag findOptionalEndTag(Tag.TerminatorSets terminatorSets) {
        Iterator iterator = this.source.getNextTagIterator(this.end);
        while (iterator.hasNext()) {
            Set set;
            Tag tag = (Tag)iterator.next();
            if (tag instanceof EndTag) {
                if (tag.name.equals(this.name)) {
                    return (EndTag)tag;
                }
                set = terminatorSets.getEndTagTerminatorSet();
            } else {
                set = terminatorSets.getIgnoredNestedElementSet();
                if (set != null && set.contains(tag.name)) {
                    Element element = ((StartTag)tag).getElement();
                    iterator = this.source.getNextTagIterator(element.end);
                    continue;
                }
                set = terminatorSets.getStartTagTerminatorSet();
            }
            if (set == null || !set.contains(tag.name)) continue;
            return new EndTag(this.source, tag.begin, tag.begin, this.name);
        }
        return new EndTag(this.source, this.source.end, this.source.end, this.name);
    }

    static StartTag findPreviousOrNext(Source source, int n, String string, boolean bl) {
        String string2 = SearchCache.getStartTagKey(n, string, bl);
        StartTag startTag = source.getSearchCache().getStartTag(string2);
        if (startTag == null) {
            Tag tag = source.getSearchCache().getTag(SearchCache.getTagKey(n));
            if (tag instanceof StartTag && (string == null || string.equals(tag.name))) {
                return (StartTag)tag;
            }
            startTag = StartTag.findPreviousOrNextUncached(source, n, string, bl);
            source.getSearchCache().setStartTag(string2, startTag);
            if (startTag != null && string == null) {
                source.getSearchCache().setStartTag(SearchCache.getStartTagKey(n, startTag.name, bl), startTag);
            }
        }
        return startTag == CACHED_NULL ? null : startTag;
    }

    private static StartTag findPreviousOrNextUncached(Source source, int n, String string, boolean bl) {
        String string2;
        SpecialTag specialTag;
        if (string == null) {
            return StartTag.findPreviousOrNext(source, n, bl);
        }
        boolean bl2 = string.charAt(string.length() - 1) == ':';
        SpecialTag specialTag2 = specialTag = bl2 ? null : SpecialTag.get(string);
        if (specialTag != null) {
            string = specialTag.getName();
            string2 = specialTag.getStartDelimiter();
        } else {
            string = string.toLowerCase();
            string2 = '<' + string;
        }
        try {
            String string3 = source.getParseTextLowerCase();
            int n2 = n;
            do {
                int n3;
                int n4 = n2 = bl ? string3.lastIndexOf(string2, n2) : string3.indexOf(string2, n2);
                if (n2 == -1) {
                    return null;
                }
                Segment segment = source.findEnclosingComment(n2 - 1);
                if (segment != null && n2 != segment.end) {
                    if (specialTag == SpecialTag.COMMENT && bl) {
                        return (StartTag)segment;
                    }
                    n2 = bl ? segment.begin - 2 : segment.end;
                    continue;
                }
                int n5 = n2 + string2.length();
                SpecialTag specialTag3 = specialTag;
                String string4 = string;
                if (specialTag == SpecialTag.COMMENT) {
                    n3 = n5;
                } else {
                    n3 = source.getIdentifierEnd(n5, false);
                    if (n3 == -1) {
                        n3 = n5;
                    } else if (n3 != n5) {
                        if (bl2) {
                            string4 = string3.substring(n2 + 1, n3);
                        } else {
                            if (specialTag3 == null || !specialTag3.isIdentifierCharacterAllowedAfterName()) continue;
                            string4 = string3.substring(n2 + 1, n3);
                            specialTag3 = SpecialTag.get(string4);
                            if (specialTag3 == null) {
                                specialTag3 = specialTag;
                            } else {
                                string4 = specialTag3.getName();
                            }
                        }
                    }
                }
                if (specialTag3 != null && specialTag3 != SpecialTag.XML_DECLARATION) {
                    EndTag endTag;
                    int n6;
                    int n7 = source.findEnd(n3, specialTag3);
                    if (specialTag3 == SpecialTag.COMMON_SERVER_TAG && n3 != n5 && (n6 = source.findEnd(n3, SpecialTag.MASON_NAMED_BLOCK)) != -1 && (n7 == -1 || n6 < n7) && (endTag = source.findNextEndTag(n6, string4)) != null) {
                        return new StartTag(source, n2, n6, string4, SpecialTag.MASON_NAMED_BLOCK, null);
                    }
                    if (n7 == -1) {
                        source.log("StartTag", string4, n2, "rejected because it has no matching end delimiter", -1);
                        if (!bl) {
                            return null;
                        }
                        n2 -= 4;
                        continue;
                    }
                    if (specialTag3 == SpecialTag.MASON_NAMED_BLOCK) {
                        EndTag endTag2;
                        if (n3 == n5 || string3.charAt(n7 - 2) == '%' || (endTag2 = source.findNextEndTag(n7, string4)) == null) {
                            continue;
                        }
                    } else if (specialTag3 == SpecialTag.MASON_COMPONENT_CALL && string3.charAt(n3) == '|') {
                        specialTag3 = SpecialTag.MASON_COMPONENT_CALLED_WITH_CONTENT;
                        string4 = specialTag3.getName();
                    }
                    return new StartTag(source, n2, n7, string4, specialTag3, null);
                }
                StartTag startTag = StartTag.constructWithAttributes(source, n2, string4, specialTag3);
                if (startTag == null) continue;
                return startTag;
            } while (StartTag.inRange(source, n2 = bl ? n2 - 2 : n2 + 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StartTag findPreviousOrNext(Source source, int n, boolean bl) {
        try {
            StartTag startTag = source.findPreviousStartTag(n, SpecialTag.COMMENT.getName());
            if (startTag != null) {
                if (startTag.end > n) {
                    if (bl) return startTag;
                    if (n == startTag.begin) {
                        return startTag;
                    }
                    n = startTag.end;
                }
                if (!bl) {
                    startTag = null;
                }
            }
            String string = source.getParseTextLowerCase();
            int n2 = n;
            do {
                int n3 = n2 = bl ? string.lastIndexOf(60, n2) : string.indexOf(60, n2);
                if (n2 == -1) {
                    return null;
                }
                if (startTag != null && startTag.encloses(n2)) {
                    return startTag;
                }
                String string2 = SearchCache.getTagKey(n2);
                Tag tag = source.getSearchCache().getTag(string2);
                if (tag instanceof StartTag) {
                    return (StartTag)tag;
                }
                if (tag != null || string.charAt(n2 + 1) == '/') continue;
                int n4 = n2 + 1;
                String string3 = null;
                StartTag startTag2 = null;
                SpecialTag specialTag = SpecialTag.get(source, n4);
                try {
                    if (specialTag != null) {
                        startTag2 = StartTag.newSpecialStartTag(source, n2, n4, specialTag);
                        if (startTag2 != null) {
                            StartTag startTag3 = startTag2;
                            source.getSearchCache().setTag(string2, startTag2);
                            return startTag3;
                        }
                        source.getSearchCache().setTag(string2, startTag2);
                        continue;
                    }
                    int n5 = source.getIdentifierEnd(n4, true);
                    if (n5 == -1) {
                        source.log("StartTag", null, n2, "rejected because it has an invalid first character in its name", -1);
                        source.getSearchCache().setTag(string2, startTag2);
                        continue;
                    }
                    string3 = string.substring(n4, n5);
                    startTag2 = StartTag.constructWithAttributes(source, n2, string3, null);
                    if (startTag2 != null) {
                        StartTag startTag4 = startTag2;
                        source.getSearchCache().setTag(string2, startTag2);
                        return startTag4;
                    }
                    source.getSearchCache().setTag(string2, startTag2);
                }
                catch (Throwable throwable) {
                    source.getSearchCache().setTag(string2, startTag2);
                    throw throwable;
                }
            } while (StartTag.inRange(source, n2 += bl ? -2 : 2));
            return null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static StartTag findNext(Source source, int n, String string, String string2, boolean bl) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        String string3 = string2.toLowerCase();
        String string4 = source.getParseTextLowerCase();
        while (n < source.end) {
            String string5;
            if ((n = string4.indexOf(string3, n)) == -1) {
                return null;
            }
            StartTag startTag = source.findEnclosingStartTag(n);
            if (startTag == null) {
                ++n;
                continue;
            }
            if (startTag.getAttributes() != null && (string5 = startTag.getAttributes().getValue(string)) != null) {
                if (string2.equals(string5)) {
                    return startTag;
                }
                if (string2.equalsIgnoreCase(string5)) {
                    if (!bl) {
                        return startTag;
                    }
                    source.log(n, string + " attribute value \"" + string5 + "\" ignored because case does not match search value \"" + string2 + '\"');
                }
            }
            n = startTag.end + 5;
        }
        return null;
    }

    private static StartTag newSpecialStartTag(Source source, int n, int n2, SpecialTag specialTag) {
        String string;
        int n3;
        int n4 = -1;
        String string2 = source.getParseTextLowerCase();
        if (specialTag == SpecialTag.COMMON_SERVER_TAG && (n3 = source.getIdentifierEnd(n2 + 1, true)) != -1) {
            string = string2.substring(n2, n3);
            n4 = source.findEnd(n3, SpecialTag.MASON_NAMED_BLOCK);
            if (n4 == -1) {
                source.log("StartTag", specialTag.getName(), n, "rejected because it has no matching end delimiter", -1);
                return null;
            }
            EndTag endTag = source.findNextEndTag(n4, string);
            if (endTag != null) {
                return new StartTag(source, n, n4, string, SpecialTag.MASON_NAMED_BLOCK, null);
            }
        }
        if ((n4 = source.findEnd(n2 + 1, specialTag)) == -1) {
            source.log("StartTag", specialTag.getName(), n, "rejected because it has no matching end delimiter", -1);
            return null;
        }
        string = specialTag.getName();
        if (specialTag == SpecialTag.XML_DECLARATION) {
            return StartTag.constructWithAttributes(source, n, string, specialTag);
        }
        return new StartTag(source, n, n4, string, specialTag, null);
    }

    private static boolean inRange(Source source, int n) {
        return n >= 0 && n <= source.length();
    }

    private Segment[] findEndTag(String string, EndTag endTag) {
        return this.findEndTag(string, this.end, this.source.findNextStartTag(this.end, this.name), endTag);
    }

    private Segment[] findEndTag(String string, int n, StartTag startTag, EndTag endTag) {
        if (endTag == null) {
            return null;
        }
        Segment[] segmentArray = new Segment[]{endTag, startTag};
        if (startTag == null || startTag.begin > endTag.begin) {
            return segmentArray;
        }
        Segment[] segmentArray2 = startTag.findEndTag(string, endTag);
        if (segmentArray2 == null) {
            return null;
        }
        EndTag endTag2 = (EndTag)segmentArray2[0];
        startTag = (StartTag)segmentArray2[1];
        endTag = this.source.findNextEndTag(endTag2.end, this.name);
        return this.findEndTag(string, endTag2.end, startTag, endTag);
    }
}

