/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.base;

import dori.jasper.engine.JRExpression;
import dori.jasper.engine.JRExpressionChunk;
import dori.jasper.engine.base.JRBaseObjectFactory;
import java.io.Serializable;
import java.util.Map;

public class JRBaseExpression
implements JRExpression,
Serializable {
    private static final long serialVersionUID = 500L;
    protected Class valueClass = null;
    protected String name = null;
    protected int id = 0;
    private JRExpressionChunk[] chunks = null;

    protected JRBaseExpression() {
    }

    protected JRBaseExpression(JRExpression expression, Map baseObjectsMap) {
        baseObjectsMap.put(expression, this);
        this.valueClass = expression.getValueClass();
        this.name = expression.getName();
        this.id = expression.getId();
        JRExpressionChunk[] jrChunks = expression.getChunks();
        if (jrChunks != null && jrChunks.length > 0) {
            this.chunks = new JRExpressionChunk[jrChunks.length];
            int i = 0;
            while (i < this.chunks.length) {
                this.chunks[i] = JRBaseObjectFactory.getExpressionChunk(jrChunks[i], baseObjectsMap);
                ++i;
            }
        }
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public JRExpressionChunk[] getChunks() {
        return this.chunks;
    }

    public String getText() {
        String text = "";
        JRExpressionChunk[] chunks = this.getChunks();
        if (chunks != null && chunks.length > 0) {
            StringBuffer sbuffer = new StringBuffer();
            int i = 0;
            while (i < chunks.length) {
                switch (chunks[i].getType()) {
                    case 2: {
                        sbuffer.append("$P{");
                        sbuffer.append(chunks[i].getText());
                        sbuffer.append("}");
                        break;
                    }
                    case 3: {
                        sbuffer.append("$F{");
                        sbuffer.append(chunks[i].getText());
                        sbuffer.append("}");
                        break;
                    }
                    case 4: {
                        sbuffer.append("$V{");
                        sbuffer.append(chunks[i].getText());
                        sbuffer.append("}");
                        break;
                    }
                    default: {
                        sbuffer.append(chunks[i].getText());
                    }
                }
                ++i;
            }
            text = sbuffer.toString();
        }
        return text;
    }
}

