/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MAttachment;
import org.compiere.model.MRequest;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.FileUpload;
import org.compiere.util.Msg;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;
import org.compiere.wstore.Info;
import org.compiere.wstore.JSPEnv;
import org.compiere.wstore.WebUser;

public class RequestServlet
extends HttpServlet {
    private static CLogger log = CLogger.getCLogger(RequestServlet.class);
    public static final String NAME = "requestServlet";
    public static final String P_FORWARDTO = "ForwardTo";
    public static final String P_SOURCE = "Source";
    public static final String P_INFO = "Info";
    public static final String P_SALESREP_ID = "SalesRep_ID";
    public static final String P_REQUESTTYPE_ID = "RequestType_ID";
    public static final String P_REF_ORDER_ID = "RefOrder_ID";
    public static final String P_CLOSE = "Close";
    public static final String P_ESCALATE = "Escalate";
    public static final String P_SUMMARY = "Summary";
    public static final String P_CONFIDENTIAL = "Confidential";
    public static final String P_REQUEST_ID = "R_Request_ID";
    public static final String P_ATTACHMENT_INDEX = "AttachmentIndex";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("RequestServlet.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Request Servlet";
    }

    public void destroy() {
        log.fine("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        String url = "/requestDetails.jsp";
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("info") == null) {
            url = "/login.jsp";
        } else {
            String msg;
            session.removeAttribute("hdrMessage");
            Info info = (Info)session.getAttribute("info");
            if (info != null) {
                info.setMessage("");
            }
            if ((msg = this.streamAttachment(request, response)) == null || msg.length() == 0) {
                return;
            }
            if (info != null) {
                info.setMessage(msg);
            }
        }
        log.info("Forward to " + url);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private String streamAttachment(HttpServletRequest request, HttpServletResponse response) {
        int R_Request_ID = WebUtil.getParameterAsInt(request, P_REQUEST_ID);
        if (R_Request_ID == 0) {
            log.fine("No R_Request_ID)");
            return "No Request ID";
        }
        int attachmentIndex = WebUtil.getParameterAsInt(request, P_ATTACHMENT_INDEX);
        if (attachmentIndex == 0) {
            log.fine("No index)");
            return "No Request Attachment index";
        }
        log.info("R_Request_ID=" + R_Request_ID + " / " + attachmentIndex);
        Properties ctx = JSPEnv.getCtx(request);
        MRequest doc = new MRequest(ctx, R_Request_ID, null);
        if (doc.getR_Request_ID() != R_Request_ID) {
            log.fine("Request not found - R_Request_ID=" + R_Request_ID);
            return "Request not found";
        }
        MAttachment attachment = doc.getAttachment(false);
        if (attachment == null) {
            log.fine("No Attachment for R_Request_ID=" + R_Request_ID);
            return "Request Attachment not found";
        }
        HttpSession session = request.getSession(true);
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu.getAD_User_ID() != doc.getAD_User_ID() && wu.getAD_User_ID() != doc.getSalesRep_ID()) {
            log.warning("R_Request_ID=" + R_Request_ID + " Web_User=" + wu.getAD_User_ID() + " <> AD_User_ID=" + doc.getAD_User_ID() + " | SalesRep_ID=" + doc.getSalesRep_ID());
            return "Your Request not found";
        }
        return WebUtil.streamAttachment(response, attachment, attachmentIndex);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String Summary;
        String contentType = request.getContentType();
        log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr() + " - " + contentType);
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        Properties ctx = JSPEnv.getCtx(request);
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu == null) {
            log.warning("No web user");
            response.sendRedirect("loginServlet?ForwardTo=request.jsp");
            return;
        }
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            this.uploadFile(request, response);
            return;
        }
        String requestURL = request.getRequestURL().toString();
        String requestRef = request.getHeader("referer");
        String source = WebUtil.getParameter(request, P_SOURCE);
        String info = WebUtil.getParameter(request, P_INFO);
        String forwardTo = WebUtil.getParameter(request, P_FORWARDTO);
        log.fine("Referer=" + requestRef + ", Source=" + source + ", ForwardTo=" + forwardTo);
        if (requestURL == null) {
            requestURL = "";
        }
        if (requestURL.equals(requestRef)) {
            requestRef = source;
            source = null;
        }
        int AD_Client_ID = Env.getContextAsInt(ctx, "AD_Client_ID");
        int R_RequestType_ID = WebUtil.getParameterAsInt(request, P_REQUESTTYPE_ID);
        int C_Order_ID = WebUtil.getParameterAsInt(request, P_REF_ORDER_ID);
        int R_Request_ID = WebUtil.getParameterAsInt(request, P_REQUEST_ID);
        int SalesRep_ID = WebUtil.getParameterAsInt(request, P_SALESREP_ID);
        if (SalesRep_ID != 0 && !MUser.isSalesRep(SalesRep_ID)) {
            log.warning("Invalid (set to 0) SalesRep_ID=" + SalesRep_ID);
            SalesRep_ID = 0;
        }
        if ((Summary = WebUtil.getParameter(request, P_SUMMARY)) == null || Summary.length() == 0) {
            WebUtil.createErrorPage(request, response, this, "No Data Received");
            return;
        }
        boolean IsConfidential = WebUtil.getParameterAsBoolean(request, P_CONFIDENTIAL);
        boolean IsClose = WebUtil.getParameterAsBoolean(request, P_CLOSE);
        boolean IsEscalate = WebUtil.getParameterAsBoolean(request, P_ESCALATE);
        MRequest req = null;
        if (R_Request_ID == 0) {
            req = new MRequest(ctx, SalesRep_ID, R_RequestType_ID, Summary, true, null);
            req.setC_BPartner_ID(wu.getC_BPartner_ID());
            req.setAD_User_ID(wu.getAD_User_ID());
            if (C_Order_ID > 0) {
                req.setC_Order_ID(C_Order_ID);
            }
            if (IsConfidential) {
                req.setConfidentialType("C");
            }
            StringBuffer sb = new StringBuffer();
            sb.append("From:").append(request.getRemoteHost()).append("-").append(request.getRemoteAddr());
            sb.append(", Request:").append(requestURL).append("-").append(requestRef);
            if (source != null) {
                sb.append("-").append(source);
            }
            sb.append("-").append(info);
            sb.append(", User=").append(request.getHeader("accept-language")).append("-").append(request.getHeader("user-agent"));
            req.setLastResult(sb.toString());
            if (!req.save()) {
                log.log(Level.SEVERE, "New Request NOT saved");
                WebUtil.createErrorPage(request, response, this, "Request Save Error. Shorten Text!");
                return;
            }
        } else {
            req = new MRequest(ctx, R_Request_ID, null);
            if (req.get_ID() == 0) {
                log.log(Level.SEVERE, "Request NOT found - R_Request_ID=" + R_Request_ID);
                WebUtil.createErrorPage(request, response, this, "Request Not found.");
                return;
            }
            if (C_Order_ID != 0 && req.getC_Order_ID() == 0) {
                req.setC_Order_ID(C_Order_ID);
            }
            if (!req.webUpdate(Summary)) {
                WebUtil.createErrorPage(request, response, this, "Request Cannot be updated.");
                return;
            }
            if (IsConfidential) {
                req.setConfidentialTypeEntry("C");
            }
            if (IsClose) {
                req.doClose();
            } else if (IsEscalate) {
                boolean isUser;
                boolean bl = isUser = req.getC_BPartner_ID() == wu.getC_BPartner_ID();
                if (isUser || wu.isSalesRep()) {
                    req.doEscalate(isUser);
                }
            }
            if (!req.save()) {
                log.log(Level.SEVERE, "Request Action Error");
                WebUtil.createErrorPage(request, response, this, "Request Process Error.");
                return;
            }
        }
        StringBuffer message = new StringBuffer(req.getSummary());
        String result = req.getResult();
        if (result != null && result.length() > 0) {
            message.append("\n----------\n").append(req.getResult());
        }
        JSPEnv.sendEMail(request, wu, "WR", new Object[]{req.getDocumentNo(), wu.getName(), message, "\n---------- " + req.getMailTag()});
        String webStoreURL = "http://" + request.getServerName() + request.getContextPath() + "/";
        if (forwardTo == null || forwardTo.length() == 0) {
            forwardTo = requestRef;
        }
        if (forwardTo != null && (forwardTo.indexOf("request.jsp") != -1 || forwardTo.indexOf("requestDetails.jsp") != -1)) {
            forwardTo = "requests.jsp";
        }
        if (forwardTo == null || forwardTo.length() == 0) {
            forwardTo = webStoreURL;
        }
        if (forwardTo.indexOf("Servlet") != -1) {
            forwardTo = webStoreURL;
        }
        WebUtil.createForwardPage(response, "Web Request Received - Thanks", forwardTo, 10);
    }

    private void uploadFile(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FileUpload upload = new FileUpload(request);
        String error = upload.getError();
        if (error != null) {
            WebUtil.createForwardPage(response, error, "requests.jsp", 10);
            return;
        }
        Properties ctx = JSPEnv.getCtx(request);
        int R_Request_ID = upload.getParameterAsInt(P_REQUEST_ID);
        PO req = null;
        if (R_Request_ID != 0) {
            req = new MRequest(ctx, R_Request_ID, null);
        }
        if (R_Request_ID == 0 || req == null || req.get_ID() != R_Request_ID) {
            WebUtil.createForwardPage(response, "Request not found", "requests.jsp", 10);
            return;
        }
        if (!((MRequest)req).isWebCanUpdate()) {
            WebUtil.createForwardPage(response, "Request cannot be updated", "requests.jsp", 10);
            return;
        }
        String fileName = upload.getFileName();
        log.fine("R_Request_ID=" + R_Request_ID + " - " + fileName);
        MAttachment attachment = req.createAttachment();
        attachment.addEntry(fileName, upload.getData());
        if (attachment.save()) {
            String msg = Msg.parseTranslation(ctx, "@Added@: @AD_Attachment_ID@ " + fileName);
            ((MRequest)req).webUpdate(msg);
            req.save();
            WebUtil.createForwardPage(response, msg, "requests.jsp", 10);
        } else {
            WebUtil.createForwardPage(response, "File Upload Error - Please try again", "requests.jsp", 10);
        }
        log.fine(attachment.toString());
    }
}

