/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MSession;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;
import org.compiere.wstore.Info;
import org.compiere.wstore.JSPEnv;
import org.compiere.wstore.WebUser;

public class LoginServlet
extends HttpServlet {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final String NAME = "loginServlet";
    public static final String P_ForwardTo = "ForwardTo";
    public static final String P_SalesRep_ID = "SalesRep_ID";
    public static final String LOGIN_JSP = "/login.jsp";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("LoginServlet.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Login Servlet";
    }

    public void destroy() {
        this.log.fine("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean logout;
        String salesRep;
        this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        String forward = WebUtil.getParameter(request, P_ForwardTo);
        if (forward != null) {
            session.setAttribute(P_ForwardTo, (Object)forward);
        }
        if ((salesRep = WebUtil.getParameter(request, P_SalesRep_ID)) != null) {
            session.setAttribute(P_SalesRep_ID, (Object)salesRep);
        }
        String url = LOGIN_JSP;
        String mode = WebUtil.getParameter(request, "mode");
        boolean deleteCookie = "deleteCookie".equals(mode);
        if (deleteCookie) {
            this.log.fine("** deleteCookie");
            JSPEnv.deleteCookieWebUser(request, response);
        }
        if ((logout = "logout".equals(mode)) || deleteCookie) {
            this.log.fine("** logout");
            if (session != null) {
                WebUser wu;
                Properties ctx = JSPEnv.getCtx(request);
                MSession cSession = MSession.get(ctx, false);
                if (cSession != null) {
                    cSession.logout();
                }
                if ((wu = (WebUser)session.getAttribute("webUser")) != null) {
                    wu.logout();
                }
                session.setMaxInactiveInterval(1);
                session.invalidate();
            }
            WebUtil.createForwardPage(response, "Logout", "http://" + request.getServerName() + "/", 2);
            return;
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        this.log.info("Forward to " + url);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        MSession cSession;
        this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        Properties ctx = JSPEnv.getCtx(request);
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        String url = WebUtil.getParameter(request, P_ForwardTo);
        String salesRep = WebUtil.getParameter(request, P_SalesRep_ID);
        if (salesRep != null) {
            session.setAttribute(P_SalesRep_ID, (Object)salesRep);
        }
        boolean checkOut = "Y".equals(session.getAttribute("CheckOut"));
        boolean addressConfirm = "Y".equals(WebUtil.getParameter(request, "AddressConfirm"));
        if (checkOut) {
            url = addressConfirm ? "/orderServlet" : "/addressInfo.jsp";
        } else {
            addressConfirm = false;
        }
        if (url == null || url.length() == 0) {
            url = (String)session.getAttribute(P_ForwardTo);
            if (url == null || url.length() == 0) {
                url = "/index.jsp";
            }
        } else {
            if (!url.startsWith("/")) {
                url = "/" + url;
            }
            session.setAttribute(P_ForwardTo, (Object)url);
        }
        if ((salesRep = (String)session.getAttribute(P_SalesRep_ID)) != null) {
            url = url + "?SalesRep_ID=" + salesRep;
        }
        String mode = WebUtil.getParameter(request, "Mode");
        this.log.fine("- targeting url=" + url + " - mode=" + mode);
        WebUser wu = WebUser.get(request);
        String email = WebUtil.getParameter(request, "EMail");
        if (email == null) {
            email = "";
        }
        email = email.trim();
        String password = WebUtil.getParameter(request, "Password");
        if (password == null) {
            password = "";
        }
        password = password.trim();
        if ("SendEMail".equals(mode)) {
            this.log.info("** send mail");
            wu = WebUser.get(ctx, email);
            if (!wu.isEMailValid()) {
                wu.setPasswordMessage("EMail not found in system");
            } else {
                wu.setPassword();
                String msg = JSPEnv.sendEMail(request, wu, "UP", new Object[]{request.getServerName(), wu.getName(), JSPEnv.getFrom(request), wu.getPassword()});
                if ("OK".equals(msg)) {
                    wu.setPasswordMessage("EMail sent");
                } else {
                    wu.setPasswordMessage("Problem sending EMail: " + msg);
                }
            }
            url = LOGIN_JSP;
        } else if ("Login".equals(mode)) {
            this.log.info("** login " + email + "/" + password);
            JSPEnv.addCookieWebUser(request, response, email);
            wu = WebUser.get(ctx, email, password, false);
            wu.login(password);
            if (wu.isLoggedIn()) {
                if (url.equals(LOGIN_JSP)) {
                    url = "/index.jsp";
                }
                if ((cSession = MSession.get(ctx, request.getRemoteAddr(), request.getRemoteHost(), session.getId())) != null) {
                    cSession.setWebStoreSession(true);
                }
            } else {
                url = LOGIN_JSP;
                this.log.fine("- PasswordMessage=" + wu.getPasswordMessage());
            }
            session.setAttribute("info", (Object)new Info(ctx, wu));
        } else if ("LoginNew".equals(mode)) {
            this.log.info("** loginNew");
            JSPEnv.addCookieWebUser(request, response, "");
            wu = WebUser.get(ctx, "");
            url = LOGIN_JSP;
        } else if ("Submit".equals(mode)) {
            this.log.info("** submit " + email + "/" + password + " - AddrConf=" + addressConfirm);
            if (wu == null || !wu.isLoggedIn() || !addressConfirm) {
                wu = WebUser.get(ctx, email, null, false);
            }
            if (wu.getAD_User_ID() != 0) {
                boolean passwordChange;
                String passwordNew = WebUtil.getParameter(request, "PasswordNew");
                if (passwordNew == null) {
                    passwordNew = "";
                }
                boolean bl = passwordChange = passwordNew.length() > 0 && !passwordNew.equals(password);
                if (addressConfirm || wu.login(password)) {
                    MSession cSession2;
                    if (wu.isLoggedIn() && (cSession2 = MSession.get(ctx, request.getRemoteAddr(), request.getRemoteHost(), session.getId())) != null) {
                        cSession2.setWebStoreSession(true);
                    }
                    if (passwordChange) {
                        this.log.fine("- update Pwd " + email + ", Old=" + password + ", DB=" + wu.getPassword() + ", New=" + passwordNew);
                    }
                    if (this.updateFields(request, wu, passwordChange)) {
                        if (passwordChange) {
                            session.setAttribute("hdrMessage", (Object)"Password changed");
                        }
                        session.setAttribute("info", (Object)new Info(ctx, wu));
                    } else {
                        url = LOGIN_JSP;
                        this.log.warning(" - update not done");
                    }
                } else {
                    url = LOGIN_JSP;
                    session.setAttribute("hdrMessage", (Object)"Email/Password not correct");
                    this.log.warning(" - update not confirmed");
                }
            } else {
                this.log.fine("** new " + email + "/" + password);
                wu.setEmail(email);
                wu.setPassword(password);
                if (this.updateFields(request, wu, true)) {
                    if (wu.login(password)) {
                        session.setAttribute("info", (Object)new Info(ctx, wu));
                        cSession = MSession.get(ctx, request.getRemoteAddr(), request.getRemoteHost(), session.getId());
                        if (cSession != null) {
                            cSession.setWebStoreSession(true);
                        }
                    } else {
                        url = LOGIN_JSP;
                    }
                } else {
                    this.log.fine("- failed - " + wu.getSaveErrorMessage() + " - " + wu.getPasswordMessage());
                    url = LOGIN_JSP;
                }
            }
        } else {
            this.log.log(Level.WARNING, "Unknown request='" + mode + "'");
        }
        session.setAttribute("webUser", (Object)wu);
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        this.log.info("doPost - Forward to " + url);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private boolean updateFields(HttpServletRequest request, WebUser wu, boolean updateEMailPwd) {
        if (updateEMailPwd) {
            String s = WebUtil.getParameter(request, "PasswordNew");
            wu.setPasswordMessage(null);
            wu.setPassword(s);
            if (wu.getPasswordMessage() != null) {
                return false;
            }
            s = WebUtil.getParameter(request, "EMail");
            if (!WebUtil.isEmailValid(s)) {
                wu.setPasswordMessage("EMail Invalid");
                return false;
            }
            wu.setEmail(s.trim());
        }
        StringBuffer mandatory = new StringBuffer();
        String s = WebUtil.getParameter(request, "Name");
        if (s != null && s.length() != 0) {
            wu.setName(s.trim());
        } else {
            mandatory.append(" - Name");
        }
        s = WebUtil.getParameter(request, "Company");
        if (s != null && s.length() != 0) {
            wu.setCompany(s);
        }
        if ((s = WebUtil.getParameter(request, "Title")) != null && s.length() != 0) {
            wu.setTitle(s);
        }
        if ((s = WebUtil.getParameter(request, "Address")) != null && s.length() != 0) {
            wu.setAddress(s);
        } else {
            mandatory.append(" - Address");
        }
        s = WebUtil.getParameter(request, "Address2");
        if (s != null && s.length() != 0) {
            wu.setAddress2(s);
        }
        if ((s = WebUtil.getParameter(request, "City")) != null && s.length() != 0) {
            wu.setCity(s);
        } else {
            mandatory.append(" - City");
        }
        s = WebUtil.getParameter(request, "Postal");
        if (s != null && s.length() != 0) {
            wu.setPostal(s);
        } else {
            mandatory.append(" - Postal");
        }
        s = WebUtil.getParameter(request, "C_Country_ID");
        if (s != null && s.length() != 0) {
            wu.setC_Country_ID(s);
        }
        if ((s = WebUtil.getParameter(request, "C_Region_ID")) != null && s.length() != 0) {
            wu.setC_Region_ID(s);
        }
        if ((s = WebUtil.getParameter(request, "RegionName")) != null && s.length() != 0) {
            wu.setRegionName(s);
        }
        if ((s = WebUtil.getParameter(request, "Phone")) != null && s.length() != 0) {
            wu.setPhone(s);
        }
        if ((s = WebUtil.getParameter(request, "Phone2")) != null && s.length() != 0) {
            wu.setPhone2(s);
        }
        if ((s = WebUtil.getParameter(request, "Fax")) != null && s.length() != 0) {
            wu.setFax(s);
        }
        if (mandatory.length() > 0) {
            mandatory.insert(0, "Enter Mandatory");
            wu.setSaveErrorMessage(mandatory.toString());
            return false;
        }
        return wu.save();
    }
}

