/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.util.Properties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MMailMsg;
import org.compiere.model.MStore;
import org.compiere.model.MUserMail;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.WebSessionCtx;
import org.compiere.wstore.WebUser;

public class JSPEnv {
    private static final String COOKIE_NAME = "CompiereWebUser";

    public static Properties getCtx(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        HttpSession session = request.getSession(true);
        WebUser wu = WebUser.get(request);
        if (wu != null) {
            int AD_User_ID = wu.getAD_User_ID();
            Env.setContext(wsc.ctx, "#AD_User_ID", AD_User_ID);
        }
        session.setMaxInactiveInterval(1800);
        String info = (String)wsc.ctx.get("hdrInfo");
        if (info != null) {
            session.setAttribute("hdrInfo", (Object)info);
        }
        return wsc.ctx;
    }

    public static String getCookieWebUser(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!COOKIE_NAME.equals(cookies[i].getName())) continue;
            return cookies[i].getValue();
        }
        return null;
    }

    public static void addCookieWebUser(HttpServletRequest request, HttpServletResponse response, String webUser) {
        Cookie cookie = new Cookie(COOKIE_NAME, webUser);
        cookie.setComment("Compiere Web User");
        cookie.setPath(request.getContextPath());
        cookie.setMaxAge(2592000);
        response.addCookie(cookie);
    }

    public static void deleteCookieWebUser(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie(COOKIE_NAME, " ");
        cookie.setComment("Compiere Web User");
        cookie.setPath(request.getContextPath());
        cookie.setMaxAge(1);
        response.addCookie(cookie);
    }

    public static String getFrom(HttpServletRequest request) {
        String host = request.getRemoteHost();
        if (!host.equals(request.getRemoteAddr())) {
            host = host + " (" + request.getRemoteAddr() + ")";
        }
        return host;
    }

    public static String sendEMail(HttpServletRequest request, WebUser to, String msgType, Object[] parameter) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        MStore wStore = wsc.wstore;
        MMailMsg mailMsg = wStore.getMailMsg(msgType);
        StringBuffer subject = new StringBuffer(mailMsg.getSubject());
        if (parameter.length > 0 && parameter[0] != null) {
            subject.append(parameter[0]);
        }
        StringBuffer message = new StringBuffer();
        String hdr = wStore.getEMailFooter();
        if (hdr != null && hdr.length() > 0) {
            message.append(hdr).append("\n");
        }
        message.append(mailMsg.getMessage());
        if (parameter.length > 1 && parameter[1] != null) {
            message.append(parameter[1]);
        }
        if (mailMsg.getMessage2() != null) {
            message.append("\n").append(mailMsg.getMessage2());
            if (parameter.length > 2 && parameter[2] != null) {
                message.append(parameter[2]);
            }
        }
        if (mailMsg.getMessage3() != null) {
            message.append("\n").append(mailMsg.getMessage3());
            if (parameter.length > 3 && parameter[3] != null) {
                message.append(parameter[3]);
            }
        }
        message.append("\n---------.----------.----------.----------.----------.----------\n").append("http://").append(request.getServerName()).append(request.getContextPath()).append("/ - ").append(wStore.getName()).append("\n").append("Request from: ").append(JSPEnv.getFrom(request)).append("\n");
        String ftr = wStore.getEMailFooter();
        if (ftr != null && ftr.length() > 0) {
            message.append(ftr);
        }
        EMail email = wStore.createEMail(to.getEmail(), subject.toString(), message.toString());
        if (msgType == "OA") {
            String orderEMail = wStore.getWebOrderEMail();
            String storeEMail = wStore.getWStoreEMail();
            if (orderEMail != null && orderEMail.length() > 0 && !orderEMail.equals(storeEMail)) {
                email.addBcc(orderEMail);
            }
        }
        String retValue = email.send();
        MUserMail um = new MUserMail(mailMsg, to.getAD_User_ID(), email);
        um.save();
        return retValue;
    }
}

