/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;
import org.compiere.wstore.WebUser;

public class EMailServlet
extends HttpServlet {
    private static CLogger log = CLogger.getCLogger(EMailServlet.class);
    public static final String NAME = "emailServlet";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("EMailServlet.init");
        }
    }

    public String getServletInfo() {
        return "Compiere EMail";
    }

    public void destroy() {
        log.info("");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Get from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebUser wu;
        log.info("Post from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        Properties ctx = JSPEnv.getCtx(request);
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        String url = WebUtil.getParameter(request, "ForwardTo");
        if (url == null || url.length() == 0) {
            url = "emailVerify.jsp";
        }
        if ((wu = (WebUser)session.getAttribute("webUser")) == null) {
            log.warning("No web user");
            response.sendRedirect("loginServlet?ForwardTo=" + url);
            return;
        }
        log.info(url + " - " + wu.toString());
        String cmd = WebUtil.getParameter(request, "ReSend");
        if (cmd != null && cmd.length() > 1) {
            this.resendCode(request, wu);
        } else {
            wu.setEMailVerifyCode(WebUtil.getParameter(request, "VerifyCode"), request.getRemoteAddr());
        }
        url = "/" + url;
        log.info("Forward to " + url);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void resendCode(HttpServletRequest request, WebUser wu) {
        String msg = JSPEnv.sendEMail(request, wu, "UV", new Object[]{request.getServerName(), wu.getName(), wu.getEMailVerifyCode()});
        if ("OK".equals(msg)) {
            wu.setPasswordMessage("EMail sent");
        } else {
            wu.setPasswordMessage("Problem sending EMail: " + msg);
        }
    }
}

