/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.resources.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.resources.ResourcesBase;
import org.apache.commons.resources.ResourcesException;
import org.apache.commons.resources.message.MessageResources;
import org.apache.commons.resources.message.MessageResourcesFactory;

public class FileResources
extends ResourcesBase {
    public static String ID_SEPARATOR = "_";
    protected static MessageResources messageResources = MessageResourcesFactory.createFactory().createResources("org.apache.commons.resources.LocalStrings");
    protected String name;
    protected String path = "";
    protected Map stringCache = new HashMap();
    protected Map streamCache = new HashMap();
    protected boolean cache = false;
    protected boolean ignoreNegativeFileSize = false;
    protected long maxCacheSize = 102400L;
    protected int bufferSize = 20480;

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public boolean getCache() {
        return this.cache;
    }

    public void init() throws ResourcesException {
    }

    public byte[] getBytes(String key, Locale locale, TimeZone timeZone) throws ResourcesException {
        try {
            InputStream stream = this.getInputStream(key, locale, timeZone);
            byte[] buffer = new byte[this.bufferSize];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int read = 0;
            while ((read = stream.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, read);
            }
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new ResourcesException(messageResources.getMessage("resources.file.data.ioexception"), ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(String key, Locale locale, TimeZone timeZone) throws ResourcesException {
        String cacheKey;
        block20: {
            String stringKey = this.toStringKey(key, locale, timeZone);
            cacheKey = null;
            if (this.stringCache.containsKey(stringKey)) {
                cacheKey = (String)this.stringCache.get(stringKey);
            } else if (!this.stringCache.containsKey(stringKey)) {
                Map map = this.stringCache;
                synchronized (map) {
                    if (!this.stringCache.containsKey(stringKey)) {
                        String validPath = this.findValidPath(key, locale, timeZone);
                        if (validPath != null) {
                            this.stringCache.put(stringKey, validPath);
                            cacheKey = validPath;
                        } else {
                            String localeString = null;
                            String timeZoneString = null;
                            if (locale != null) {
                                localeString = locale.toString();
                            }
                            if (timeZone != null) {
                                timeZoneString = timeZone.toString();
                            }
                            throw new ResourcesException(messageResources.getMessage("resources.file.nofilefound", (Object)key, (Object)localeString, (Object)timeZoneString));
                        }
                    }
                }
            }
            if (this.cache) {
                long size = this.getFileSize(cacheKey);
                if (!(this.maxCacheSize != -1L && size >= this.maxCacheSize || size <= -1L && !this.ignoreNegativeFileSize)) {
                    if (this.streamCache.containsKey(cacheKey)) {
                        return (InputStream)this.streamCache.get(cacheKey);
                    }
                    try {
                        if (this.streamCache.containsKey(cacheKey)) break block20;
                        String localeString = cacheKey;
                        synchronized (localeString) {
                            block21: {
                                if (this.streamCache.containsKey(cacheKey)) break block21;
                                InputStream stream = this.toStream(cacheKey);
                                byte[] data = new byte[(int)size];
                                stream.read(data, 0, (int)size);
                                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                                this.streamCache.put(cacheKey, bais);
                                ByteArrayInputStream byteArrayInputStream = bais;
                                return byteArrayInputStream;
                            }
                        }
                    }
                    catch (IOException ioe) {
                        throw new ResourcesException(messageResources.getMessage("resources.file.cache.ioexception", (Object)cacheKey), ioe);
                    }
                }
            }
        }
        return this.toStream(cacheKey);
    }

    protected InputStream toStream(String streamPath) throws ResourcesException {
        try {
            return new FileInputStream(streamPath);
        }
        catch (IOException ioe) {
            throw new ResourcesException(messageResources.getMessage("resources.file.tostream.ioexception", (Object)streamPath), ioe);
        }
    }

    public void setMaxCacheSize(long size) {
        this.maxCacheSize = size;
    }

    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    protected String toStringKey(String key, Locale locale, TimeZone timeZone) {
        StringBuffer keyString = new StringBuffer();
        keyString.append(key);
        keyString.append(ID_SEPARATOR);
        if (locale != null) {
            keyString.append(locale.getLanguage());
            keyString.append(ID_SEPARATOR);
            keyString.append(locale.getCountry());
        } else {
            keyString.append("null");
            keyString.append(ID_SEPARATOR);
            keyString.append("null");
        }
        keyString.append(ID_SEPARATOR);
        if (timeZone != null) {
            keyString.append(timeZone.getID());
        } else {
            keyString.append("null");
        }
        return keyString.toString();
    }

    protected String findValidPath(String key, Locale locale, TimeZone timeZone) {
        int eIndex;
        String language = null;
        String countryCode = null;
        String zoneID = null;
        String extension = null;
        if (locale != null) {
            language = locale.getLanguage();
            countryCode = locale.getCountry();
        }
        if (timeZone != null) {
            zoneID = timeZone.getID();
        }
        if ((eIndex = key.lastIndexOf(46)) != -1) {
            extension = key.substring(eIndex + 1, key.length());
            key = key.substring(0, eIndex);
        }
        String[] paths = this.getFileNames(key, language, countryCode, zoneID, extension, File.separatorChar);
        int i = 0;
        while (i < paths.length) {
            File file;
            if (paths[i] != null && (file = new File(paths[i])).exists()) {
                return paths[i];
            }
            ++i;
        }
        return null;
    }

    protected long getFileSize(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.length();
        }
        return -1L;
    }

    protected String[] getFileNames(String fileName, String language, String countryCode, String timeZone, String extension, char separator) {
        if (this.path == null) {
            this.path = "";
        }
        String base = this.path + separator + fileName;
        String[] names = new String[4];
        extension = extension != null && !"".equals(extension) ? "." + extension : "";
        names[3] = base + extension;
        if (language != null && !"".equals(language)) {
            names[2] = base + ID_SEPARATOR + language + extension;
            if (countryCode != null && !"".equals(countryCode)) {
                names[1] = base + ID_SEPARATOR + language + ID_SEPARATOR + countryCode + extension;
                if (timeZone != null && !"".equals(timeZone)) {
                    names[0] = base + ID_SEPARATOR + language + ID_SEPARATOR + countryCode + ID_SEPARATOR + timeZone + extension;
                }
            }
        }
        return names;
    }
}

