/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc;

import com.ibm.db2.jcc.DB2Binder;
import com.ibm.db2.jcc.a.ud;
import java.io.PrintWriter;

public class DB2LobTableCreator {
    protected String url_ = null;
    protected String user_ = null;
    protected String password_ = null;
    protected int traceLevel_ = 0;

    public void setUrl(String string) {
        this.url_ = string;
    }

    public void setUser(String string) {
        this.user_ = string;
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public void setTraceLevel(int n2) {
        this.traceLevel_ = n2;
    }

    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        ud ud2 = new ud();
        if (stringArray.length == 0) {
            DB2LobTableCreator.printUsage(printWriter);
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string;
            if ((string = stringArray[n2++]).equalsIgnoreCase("-help")) {
                DB2LobTableCreator.printUsage(printWriter);
                continue;
            }
            if (string.equalsIgnoreCase("-url")) {
                ud2.setUrl(stringArray[n2++]);
                continue;
            }
            if (string.equalsIgnoreCase("-user")) {
                ud2.setUser(stringArray[n2++]);
                continue;
            }
            if (string.equalsIgnoreCase("-password")) {
                ud2.setPassword(stringArray[n2++]);
                continue;
            }
            if (string.equalsIgnoreCase("-tracelevel")) {
                try {
                    ud2.setTraceLevel(DB2Binder.parseTraceLevel(stringArray[n2++]));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    printWriter.println(illegalArgumentException.getMessage());
                    DB2LobTableCreator.printUsage(printWriter);
                    return;
                }
            }
            printWriter.println("Unrecognized option " + string);
            DB2LobTableCreator.printUsage(printWriter);
            return;
        }
        try {
            Class.forName("com.ibm.db2.jcc.DB2Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            printWriter.println("Failure loading JDBC driver com.ibm.db2.jcc.DB2Driver.");
            printWriter.println("ClassNotFoundException: " + classNotFoundException.getMessage());
            return;
        }
        ud2.b(printWriter);
    }

    private static void printUsage(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println();
        printWriter.println("IBM DB2 JDBC Universal Driver Architecture, JDBC Lob Table Creator");
        printWriter.println("(c) Copyright IBM Corporation 2002");
        printWriter.println();
        printWriter.println("This utility is used to create special tables required on ZOS platform");
        printWriter.println("to fetch lob data from the database.");
        printWriter.println();
        printWriter.println("Usage:");
        printWriter.println();
        printWriter.println("  java com.ibm.db2.jcc.DB2LobTableCreator");
        printWriter.println("    -url jdbc:db2://<server name>:<port number>/<database name>");
        printWriter.println("    -user <userName>");
        printWriter.println("    -password <password>");
        printWriter.println("    [-help]");
        printWriter.println();
        printWriter.println("  -user");
        printWriter.println("    The user must have table creation authority.");
        printWriter.println("    Access to the JCC tables will be granted to public.");
        printWriter.println();
        printWriter.println("  -tracelevel");
        printWriter.println("    Used to turn tracing on or off, and to specify the granularity of tracing.");
        printWriter.println("    Trace level options are defined by the JCC JDBC driver traceLevel data source property.");
        printWriter.println("    See documentation for JCC DB2BaseDataSource.traceLevel for a complete description.");
        printWriter.println("    For complete tracing, use TRACE_ALL.");
        printWriter.println();
    }
}

