/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Principal;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.jboss.logging.Logger;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.AbstractServerLoginModule;

public class Util {
    static Group[] getRoleSets(String targetUser, Properties roles, char roleGroupSeperator, AbstractServerLoginModule aslm) {
        Enumeration<?> users = roles.propertyNames();
        SimpleGroup rolesGroup = new SimpleGroup("Roles");
        ArrayList<SimpleGroup> groups = new ArrayList<SimpleGroup>();
        groups.add(rolesGroup);
        while (users.hasMoreElements() && targetUser != null) {
            String user = (String)users.nextElement();
            String value = roles.getProperty(user);
            int index = user.indexOf(roleGroupSeperator);
            boolean isRoleGroup = false;
            boolean userMatch = false;
            if (index > 0 && targetUser.regionMatches(0, user, 0, index)) {
                isRoleGroup = true;
            } else {
                userMatch = targetUser.equals(user);
            }
            if (isRoleGroup) {
                String groupName = user.substring(index + 1);
                if (groupName.equals("Roles")) {
                    Util.parseGroupMembers(rolesGroup, value, aslm);
                    continue;
                }
                SimpleGroup group = new SimpleGroup(groupName);
                Util.parseGroupMembers(group, value, aslm);
                groups.add(group);
                continue;
            }
            if (!userMatch) continue;
            Util.parseGroupMembers(rolesGroup, value, aslm);
        }
        Group[] roleSets = new Group[groups.size()];
        groups.toArray(roleSets);
        return roleSets;
    }

    /*
     * Loose catch block
     */
    static Group[] getRoleSets(String username, String dsJndiName, String rolesQuery, AbstractServerLoginModule aslm) throws LoginException {
        HashMap<String, Group> setsMap;
        block39: {
            SQLException e222;
            ResultSet rs;
            Statement ps;
            Connection conn;
            block37: {
                block33: {
                    SQLException e222;
                    Group[] groupArray;
                    block34: {
                        Group[] roleSets;
                        conn = null;
                        setsMap = new HashMap<String, Group>();
                        ps = null;
                        rs = null;
                        InitialContext ctx = new InitialContext();
                        DataSource ds = (DataSource)ctx.lookup(dsJndiName);
                        conn = ds.getConnection();
                        ps = conn.prepareStatement(rolesQuery);
                        try {
                            ps.setString(1, username);
                        }
                        catch (ArrayIndexOutOfBoundsException ignore) {
                            // empty catch block
                        }
                        rs = ps.executeQuery();
                        if (rs.next()) break block33;
                        if (aslm.getUnauthenticatedIdentity() == null) {
                            throw new FailedLoginException("No matching username found in Roles");
                        }
                        groupArray = roleSets = new Group[]{new SimpleGroup("Roles")};
                        Object var15_17 = null;
                        if (rs == null) break block34;
                        try {
                            rs.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    return groupArray;
                }
                do {
                    Group group;
                    String name = rs.getString(1);
                    String groupName = rs.getString(2);
                    if (groupName == null || groupName.length() == 0) {
                        groupName = "Roles";
                    }
                    if ((group = (Group)setsMap.get(groupName)) == null) {
                        group = new SimpleGroup(groupName);
                        setsMap.put(groupName, group);
                    }
                    try {
                        Principal p = aslm.createIdentity(name);
                        aslm.log.trace((Object)("Assign user to role " + name));
                        group.addMember(p);
                    }
                    catch (Exception e3) {
                        aslm.log.debug((Object)("Failed to create principal: " + name), (Throwable)e3);
                    }
                } while (rs.next());
                Object var15_18 = null;
                if (rs == null) break block37;
                try {
                    rs.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
            break block39;
            {
                catch (NamingException ex) {
                    throw new LoginException(ex.toString(true));
                }
                catch (SQLException ex) {
                    aslm.log.error((Object)"SQL failure", (Throwable)ex);
                    throw new LoginException(ex.toString());
                }
            }
            catch (Throwable throwable) {
                SQLException e222;
                Object var15_19 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        Group[] roleSets = new Group[setsMap.size()];
        setsMap.values().toArray(roleSets);
        return roleSets;
    }

    static Properties loadProperties(String defaultsName, String propertiesName, Logger log) throws IOException {
        InputStream is;
        Properties bundle = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL defaultUrl = null;
        URL url = null;
        if (loader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)loader;
            defaultUrl = ucl.findResource(defaultsName);
            url = ucl.findResource(propertiesName);
            log.trace((Object)("findResource: " + url));
        }
        if (defaultUrl == null) {
            defaultUrl = loader.getResource(defaultsName);
        }
        if (url == null) {
            url = loader.getResource(propertiesName);
        }
        if (url == null && defaultUrl == null) {
            String msg = "No properties file: " + propertiesName + " or defaults: " + defaultsName + " found";
            throw new IOException(msg);
        }
        log.trace((Object)("Properties file=" + url + ", defaults=" + defaultUrl));
        Properties defaults = new Properties();
        if (defaultUrl != null) {
            try {
                is = defaultUrl.openStream();
                defaults.load(is);
                is.close();
                log.debug((Object)("Loaded defaults, users=" + defaults.keySet()));
            }
            catch (Throwable e) {
                log.debug((Object)"Failed to load defaults", e);
            }
        }
        bundle = new Properties(defaults);
        if (url != null) {
            is = url.openStream();
            if (is == null) {
                throw new IOException("Properties file " + propertiesName + " not avilable");
            }
            bundle.load(is);
            is.close();
            log.debug((Object)("Loaded properties, users=" + bundle.keySet()));
        }
        return bundle;
    }

    static void parseGroupMembers(Group group, String roles, AbstractServerLoginModule aslm) {
        StringTokenizer tokenizer = new StringTokenizer(roles, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                Principal p = aslm.createIdentity(token);
                group.addMember(p);
            }
            catch (Exception e) {
                aslm.log.warn((Object)("Failed to create principal for: " + token), (Throwable)e);
            }
        }
    }
}

