/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlet;

import com.ibm.websphere.pmi.RequestTracker;
import com.ibm.wps.portletcontainer.cache.CacheablePortlet;
import com.ibm.wps.services.log.Log;
import com.ibm.wps.servlet.request.CompatibilityHttpServletRequestProxy;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.portlet.PortletConfig;
import org.apache.jetspeed.portlet.PortletException;
import org.apache.jetspeed.portlet.PortletPageListener;
import org.apache.jetspeed.portlet.PortletRequest;
import org.apache.jetspeed.portlet.PortletResponse;
import org.apache.jetspeed.portlet.PortletSession;
import org.apache.jetspeed.portlet.PortletSessionListener;
import org.apache.jetspeed.portlet.PortletSettings;
import org.apache.jetspeed.portlet.PortletTitleListener;
import org.apache.jetspeed.portlet.UnavailableException;
import org.apache.jetspeed.portlet.spi.SPIPortletInterceptor;
import org.apache.jetspeed.portletcontainer.util.ThreadAttributesManager;

public abstract class Portlet
extends CacheablePortlet
implements PortletSessionListener {
    private PortletSettingsThreadContainer portletSettingsThreadContainer = new PortletSettingsThreadContainer();
    private boolean portletInitialized = false;
    private PortletConfig portletConfig = null;
    private SPIPortletInterceptor interceptor = null;
    private Vector concretePortlets = new Vector();

    public abstract void init(PortletConfig var1) throws UnavailableException;

    public abstract void destroy(PortletConfig var1);

    public abstract void initConcrete(PortletSettings var1) throws UnavailableException;

    public abstract void destroyConcrete(PortletSettings var1);

    public abstract void service(PortletRequest var1, PortletResponse var2) throws PortletException, IOException;

    public abstract long getLastModified(PortletRequest var1);

    public abstract PortletConfig getPortletConfig();

    protected PortletSettings getPortletSettings() {
        return this.portletSettingsThreadContainer.getSettings();
    }

    public abstract void login(PortletRequest var1) throws PortletException;

    public abstract void logout(PortletSession var1) throws PortletException;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.portletInitialized = false;
    }

    public void init() throws ServletException {
    }

    public final ServletConfig getServletConfig() {
        return super.getServletConfig();
    }

    public final String getInitParameter(String name) {
        return this.getServletConfig().getInitParameter(name);
    }

    public final Enumeration getInitParameterNames() {
        return this.getServletConfig().getInitParameterNames();
    }

    public ServletContext getServletContext() {
        return this.getServletConfig().getServletContext();
    }

    protected long getLastModified(HttpServletRequest req) {
        return -1L;
    }

    public String getServletInfo() {
        return "";
    }

    public final void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        RequestTracker req = (RequestTracker)request.getAttribute("com.ibm.wps.pmi.RequestTracker");
        if (req != null) {
            req.enterPortlet();
        }
        try {
            super.service(request, response);
        }
        catch (Throwable t) {
            if (req != null) {
                req.leavePortlet();
            }
            throw new PortletException(t);
        }
        if (req != null) {
            req.leavePortlet();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }

    private void dispatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServletRequest portalRequest = (HttpServletRequest)ThreadAttributesManager.getAttribute((String)"com.ibm.wps.servlet.request.CompatibilityHttpServletRequestProxy.PortalServletRequest");
        request = new CompatibilityHttpServletRequestProxy(request, portalRequest);
        Integer methodIdObject = (Integer)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portlet.Portlet.METHOD_ID");
        int methodId = methodIdObject;
        if (methodId == 125) {
            Log.debug((String)"portletcontainer", (String)"Portlet.service METHOD_PORTLET_LOGOUT ...");
            if (this instanceof PortletSessionListener) {
                String cpiid = (String)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portletcontainer.portlet.cpiid");
                PortletSession portletSession = (PortletSession)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portlet.Portlet.PORTLETSESSION");
                PortletSettings portletSettings = (PortletSettings)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portlet.Portlet.PORTLETSETTINGS");
                this.portletSettingsThreadContainer.setSettings(portletSettings);
                Log.debug((String)"portletcontainer", (String)"Portlet.service METHOD_PORTLET_LOGOUT called");
                this.logout(portletSession);
            }
            return;
        }
        if (!this.portletInitialized) {
            Portlet cpiid = this;
            synchronized (cpiid) {
                if (!this.portletInitialized) {
                    Log.debug((String)"portletcontainer", (String)"Portlet.service METHOD_PORTLET_INIT");
                    this.interceptor = (SPIPortletInterceptor)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portlet.Portlet.INTERCEPTOR");
                    if (this.interceptor == null) {
                        throw new UnavailableException("SPIPortletInterceptor was not provided!");
                    }
                    PortletConfig portletConfig = (PortletConfig)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portlet.Portlet.PORTLETCONFIG");
                    if (portletConfig == null) {
                        throw new UnavailableException("No PortletConfig provided.");
                    }
                    this.interceptor.init(this, portletConfig);
                    this.init(portletConfig);
                    this.portletConfig = portletConfig;
                    this.portletInitialized = true;
                }
            }
        }
        if (this.interceptor == null) {
            throw new UnavailableException(this, "SPIPortletInterceptor was not provided!");
        }
        this.interceptor.preService(request, response);
        methodIdObject = (Integer)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portlet.Portlet.METHOD_ID");
        methodId = methodIdObject;
        try {
            block29: {
                block28: {
                    if (methodId != 206 && methodId != 208) break block28;
                    this.interceptor.handleEvents(this, request);
                    break block29;
                }
                PortletRequest portletRequest = (PortletRequest)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portlet.Portlet.PORTLETREQUEST");
                PortletResponse portletResponse = (PortletResponse)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portlet.Portlet.PORTLETRESPONSE");
                PortletSettings portletSettings = portletRequest.getPortletSettings();
                this.portletSettingsThreadContainer.setSettings(portletSettings);
                if (!this.concretePortlets.contains(portletSettings)) {
                    Log.debug((String)"portletcontainer", (String)"Portlet.service METHOD_PORTLET_INIT_CONCRETE");
                    this.initConcrete(portletSettings);
                    this.concretePortlets.add(portletSettings);
                }
                switch (methodId) {
                    case 115: {
                        Log.debug((String)"portletcontainer", (String)"Portlet.service METHOD_PORTLET_LOGIN ...");
                        if (this instanceof PortletSessionListener) {
                            Log.debug((String)"portletcontainer", (String)"Portlet.service METHOD_PORTLET_LOGIN called");
                            this.login(portletRequest);
                        }
                        break;
                    }
                    case 118: {
                        Log.debug((String)"portletcontainer", (String)"Portlet.service METHOD_PORTLET_BEGINPAGE");
                        if (this instanceof PortletPageListener) {
                            ((PortletPageListener)((Object)this)).beginPage(portletRequest, portletResponse);
                        }
                        break;
                    }
                    case 120: {
                        Log.debug((String)"portletcontainer", (String)"Portlet.service METHOD_PORTLET_SERVICE");
                        this.service(portletRequest, portletResponse);
                        break;
                    }
                    case 122: {
                        Log.debug((String)"portletcontainer", (String)"Portlet.service METHOD_PORTLET_ENDPAGE");
                        if (this instanceof PortletPageListener) {
                            ((PortletPageListener)((Object)this)).endPage(portletRequest, portletResponse);
                        }
                        break;
                    }
                    case 127: {
                        Log.debug((String)"portletcontainer", (String)"Portlet.service METHOD_PORTLET_DESTROY_CONCRETE");
                        if (portletSettings == null) {
                            throw new UnavailableException("No PortletSettings provided.");
                        }
                        if (!this.concretePortlets.contains(portletSettings)) {
                            throw new UnavailableException("Concrete Portlet was not initialized.");
                        }
                        this.destroyConcrete(portletSettings);
                        this.concretePortlets.remove(portletSettings);
                        break;
                    }
                    case 100: {
                        Log.debug((String)"portletcontainer", (String)"Portlet.service METHOD_INCLUDE_PORTLET_TITLE");
                        if (this instanceof PortletTitleListener) {
                            ((PortletTitleListener)((Object)this)).doTitle(portletRequest, portletResponse);
                            break;
                        }
                        String title = (String)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portlet.Portlet.STATICTITLE");
                        PrintWriter writer = portletResponse.getWriter();
                        writer.print(title);
                        break;
                    }
                    case 200: 
                    case 202: 
                    case 204: {
                        this.interceptor.handleEvents(this, request);
                        break;
                    }
                    default: {
                        if (methodId < 200 || methodId > 300) break;
                        this.interceptor.handleEvents(this, request);
                    }
                }
            }
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            this.interceptor.postService(request, response);
            throw throwable;
        }
        this.interceptor.postService(request, response);
    }

    public void destroy() {
        if (this.portletInitialized) {
            Log.debug((String)"portletcontainer", (String)"Portlet.destroy METHOD_PORTLET_DESTROY");
            this.interceptor.destroy();
            Enumeration allConcretePortlets = this.concretePortlets.elements();
            while (allConcretePortlets.hasMoreElements()) {
                Log.debug((String)"portletcontainer", (String)"  Portlet.destroy METHOD_PORTLET_DESTROY_CONCRETE");
                PortletSettings portletSettings = (PortletSettings)allConcretePortlets.nextElement();
                this.destroyConcrete(portletSettings);
            }
            this.concretePortlets.clear();
            this.destroy(this.portletConfig);
            this.portletConfig = null;
            this.portletInitialized = false;
        }
        super.destroy();
    }

    private static class PortletSettingsThreadContainer
    extends ThreadLocal {
        private PortletSettingsThreadContainer() {
        }

        public PortletSettings getSettings() {
            return (PortletSettings)super.get();
        }

        public void setSettings(PortletSettings settings) {
            super.set(settings);
        }
    }

    public static class ModeModifier
    implements Serializable {
        public static final ModeModifier REQUESTED = new ModeModifier("Requested", 0);
        public static final ModeModifier CURRENT = new ModeModifier("Current", 1);
        public static final ModeModifier PREVIOUS = new ModeModifier("Previous", 2);
        private static final ModeModifier[] MODE_MODIFIERS = new ModeModifier[]{REQUESTED, CURRENT, PREVIOUS};
        private String identifier;
        private int value;

        private ModeModifier(String identifier, int value) {
            this.identifier = identifier;
            this.value = value;
        }

        public int getId() {
            return this.value;
        }

        public String toString() {
            return this.identifier;
        }

        public Object readResolve() throws ObjectStreamException {
            try {
                return MODE_MODIFIERS[this.value];
            }
            catch (IndexOutOfBoundsException e) {
                throw new InvalidObjectException("Unknown Portlet ModeModifier");
            }
        }
    }

    public static class Mode
    implements Serializable {
        public static final Mode VIEW = new Mode("View", 0);
        public static final Mode EDIT = new Mode("Edit", 1);
        public static final Mode HELP = new Mode("Help", 2);
        public static final Mode CONFIGURE = new Mode("Configure", 3);
        private static final Mode[] MODES = new Mode[]{VIEW, EDIT, HELP, CONFIGURE};
        private String identifier;
        private int value;

        private Mode(String identifier, int value) {
            this.identifier = identifier;
            this.value = value;
        }

        public int getId() {
            return this.value;
        }

        public String toString() {
            return this.identifier;
        }

        public Object readResolve() throws ObjectStreamException {
            try {
                return MODES[this.value];
            }
            catch (IndexOutOfBoundsException e) {
                throw new InvalidObjectException("Unknown Portlet Mode");
            }
        }
    }
}

