/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SubjectSecurityManager;
import org.jboss.util.CachePolicy;

public class SecurityDomainContext {
    static final String ACTIVE_SUBJECT = "subject";
    static final String AUTHENTICATION_MGR = "securityMgr";
    static final String AUTORIZATION_MGR = "realmMapping";
    static final String AUTH_CACHE = "authenticationCache";
    AuthenticationManager securityMgr;
    CachePolicy authenticationCache;

    public SecurityDomainContext(AuthenticationManager securityMgr, CachePolicy authenticationCache) {
        this.securityMgr = securityMgr;
        this.authenticationCache = authenticationCache;
    }

    public Object lookup(String name) throws NamingException {
        Object binding = null;
        if (name == null || name.length() == 0) {
            throw new InvalidNameException("name cannot be null or empty");
        }
        if (name.equals(ACTIVE_SUBJECT)) {
            binding = this.getSubject();
        } else if (name.equals(AUTHENTICATION_MGR)) {
            binding = this.securityMgr;
        } else if (name.equals(AUTORIZATION_MGR)) {
            binding = this.getRealmMapping();
        } else if (name.equals(AUTH_CACHE)) {
            binding = this.authenticationCache;
        }
        return binding;
    }

    public Subject getSubject() {
        Subject subject = null;
        if (this.securityMgr instanceof SubjectSecurityManager) {
            subject = ((SubjectSecurityManager)this.securityMgr).getActiveSubject();
        }
        return subject;
    }

    public AuthenticationManager getSecurityManager() {
        return this.securityMgr;
    }

    public RealmMapping getRealmMapping() {
        RealmMapping realmMapping = null;
        if (this.securityMgr instanceof RealmMapping) {
            realmMapping = (RealmMapping)((Object)this.securityMgr);
        }
        return realmMapping;
    }

    public CachePolicy getAuthenticationCache() {
        return this.authenticationCache;
    }
}

