/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.interfaces.IStockChartDataSet;
import org.jCharts.imageMap.CircleMapArea;
import org.jCharts.properties.StockChartProperties;
import org.jCharts.types.StockChartDataType;

abstract class StockChart {
    StockChart() {
    }

    static final void render(AxisChart axisChart, IStockChartDataSet iStockChartDataSet) {
        StockChartProperties stockChartProperties = (StockChartProperties)iStockChartDataSet.getChartTypeProperties();
        Graphics2D graphics2D = axisChart.getGraphics2D();
        float[][] fArray = new float[iStockChartDataSet.getNumberOfDataSets()][iStockChartDataSet.getNumberOfDataItems()];
        Line2D.Float float_ = new Line2D.Float(axisChart.getXAxis().getTickStartX(), 0.0f, axisChart.getXAxis().getTickStartX(), 0.0f);
        Line2D.Float float_2 = null;
        if (iStockChartDataSet.hasOpenValues()) {
            float_2 = new Line2D.Float(axisChart.getXAxis().getTickStartX() - (float)stockChartProperties.getOpenPixelLength() - 1.0f, 0.0f, axisChart.getXAxis().getTickStartX() - 1.0f, 0.0f);
        }
        Line2D.Float float_3 = null;
        if (iStockChartDataSet.hasCloseValues()) {
            float_3 = new Line2D.Float(axisChart.getXAxis().getTickStartX() + 1.0f, 0.0f, axisChart.getXAxis().getTickStartX() + (float)stockChartProperties.getClosePixelLength() + 1.0f, 0.0f);
        }
        int n = 0;
        while (n < iStockChartDataSet.getNumberOfDataItems()) {
            float_.y1 = axisChart.getYAxis().computeAxisCoordinate(iStockChartDataSet.getLowValue(n));
            float_.y2 = axisChart.getYAxis().computeAxisCoordinate(iStockChartDataSet.getHighValue(n));
            if (axisChart.getGenerateImageMapFlag()) {
                axisChart.getImageMap().addImageMapArea(new CircleMapArea(float_.x1, float_.y1, iStockChartDataSet.getLowValue(n), axisChart.getIDataSeries().getXAxisLabel(n), iStockChartDataSet.getLegendLabel(StockChartDataType.LOW.getInt())));
                axisChart.getImageMap().addImageMapArea(new CircleMapArea(float_.x2, float_.y2, iStockChartDataSet.getHighValue(n), axisChart.getIDataSeries().getXAxisLabel(n), iStockChartDataSet.getLegendLabel(StockChartDataType.HIGH.getInt())));
            }
            graphics2D.setPaint(iStockChartDataSet.getPaint(StockChartDataType.HIGH.getInt()));
            graphics2D.setStroke(stockChartProperties.getHiLowStroke());
            graphics2D.draw(float_);
            float_.x1 += axisChart.getXAxis().getScalePixelWidth();
            float_.x2 = float_.x1;
            if (float_2 != null && iStockChartDataSet.getOpenValue(n) != Double.NaN) {
                float_2.y2 = float_2.y1 = axisChart.getYAxis().computeAxisCoordinate(iStockChartDataSet.getOpenValue(n));
                graphics2D.setPaint(iStockChartDataSet.getPaint(StockChartDataType.OPEN.getInt()));
                graphics2D.setStroke(stockChartProperties.getOpenStroke());
                graphics2D.draw(float_2);
                if (axisChart.getGenerateImageMapFlag()) {
                    axisChart.getImageMap().addImageMapArea(new CircleMapArea(float_2.x1, float_2.y1, iStockChartDataSet.getOpenValue(n), axisChart.getIDataSeries().getXAxisLabel(n), iStockChartDataSet.getLegendLabel(StockChartDataType.OPEN.getInt())));
                }
                float_2.x1 += axisChart.getXAxis().getScalePixelWidth();
                float_2.x2 += axisChart.getXAxis().getScalePixelWidth();
            }
            if (float_3 != null && iStockChartDataSet.getOpenValue(n) != Double.NaN) {
                float_3.y2 = float_3.y1 = axisChart.getYAxis().computeAxisCoordinate(iStockChartDataSet.getCloseValue(n));
                graphics2D.setPaint(iStockChartDataSet.getPaint(StockChartDataType.CLOSE.getInt()));
                graphics2D.setStroke(stockChartProperties.getCloseStroke());
                graphics2D.draw(float_3);
                if (axisChart.getGenerateImageMapFlag()) {
                    axisChart.getImageMap().addImageMapArea(new CircleMapArea(float_3.x2, float_3.y2, iStockChartDataSet.getCloseValue(n), axisChart.getIDataSeries().getXAxisLabel(n), iStockChartDataSet.getLegendLabel(StockChartDataType.CLOSE.getInt())));
                }
                float_3.x1 += axisChart.getXAxis().getScalePixelWidth();
                float_3.x2 += axisChart.getXAxis().getScalePixelWidth();
            }
            ++n;
        }
    }
}

