/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.ssl;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.jtds.util.KnownLengthInputStream;

class TdsTlsInputStream
extends FilterInputStream {
    int bytesOutstanding = 0;
    byte[] readBuffer = new byte[17408];
    InputStream bufferStream = null;

    public TdsTlsInputStream(InputStream in) {
        super(in);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bufferStream == null) {
            this.primeBuffer();
        }
        int ret = this.bufferStream.read(b, off, len);
        this.bytesOutstanding -= ret;
        if (this.bytesOutstanding == 0) {
            this.bufferStream = null;
        }
        return ret;
    }

    private void primeBuffer() throws IOException {
        this.in.read(this.readBuffer, 0, 1);
        int len = this.readBuffer[0] == 4 ? this.readTDSPacket(this.readBuffer, 1) : this.readTLSRecord(this.readBuffer, 1);
        this.bufferStream = new ByteArrayInputStream(this.readBuffer, 0, len);
        this.bytesOutstanding = len;
    }

    private int readTLSRecord(byte[] buf, int off) throws IOException {
        this.in.read(buf, off, 4);
        short length = this.getShort(buf, 3);
        new KnownLengthInputStream(this.in).read(buf, off + 4, length);
        return length + 5;
    }

    private int readTDSPacket(byte[] buf, int off) throws IOException {
        this.in.read(buf, off, 7);
        short length = this.getShort(buf, 2);
        new KnownLengthInputStream(this.in).read(buf, 0, length - 8);
        return length - 8;
    }

    private short getShort(byte[] b, int off) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b, off, 2));
        return dis.readShort();
    }
}

