/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import net.sourceforge.jtds.jdbc.CachedResultSet;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.JtdsCallableStatement;
import net.sourceforge.jtds.jdbc.JtdsPreparedStatement;
import net.sourceforge.jtds.jdbc.JtdsResultSet;
import net.sourceforge.jtds.jdbc.MSCursorResultSet;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.ParamInfo;
import net.sourceforge.jtds.jdbc.SQLDiagnostic;
import net.sourceforge.jtds.jdbc.SQLParser;
import net.sourceforge.jtds.jdbc.TdsCore;

public class JtdsStatement
implements Statement {
    static final int RETURN_GENERATED_KEYS = 1;
    static final int NO_GENERATED_KEYS = 2;
    static final int CLOSE_CURRENT_RESULT = 1;
    static final int KEEP_CURRENT_RESULT = 2;
    static final int CLOSE_ALL_RESULTS = 3;
    static final int BOOLEAN = 16;
    static final int DATALINK = 70;
    static final Integer SUCCESS_NO_INFO = new Integer(-2);
    static final Integer EXECUTE_FAILED = new Integer(-3);
    protected ConnectionJDBC2 connection;
    protected TdsCore tds = null;
    protected int queryTimeout = 0;
    protected JtdsResultSet currentResult = null;
    protected int fetchDirection = 1000;
    protected int resultSetType = 1003;
    protected int resultSetConcurrency = 1007;
    protected int fetchSize = 100;
    protected String cursorName;
    protected boolean closed = false;
    protected int maxFieldSize = 0;
    protected int maxRows = 0;
    protected boolean escapeProcessing = true;
    protected SQLDiagnostic messages;
    protected ArrayList batchValues = null;
    protected JtdsResultSet genKeyResultSet;
    protected LinkedList resultQueue = new LinkedList();

    JtdsStatement(ConnectionJDBC2 connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            String method = this instanceof JtdsCallableStatement ? "prepareCall" : (this instanceof JtdsPreparedStatement ? "prepareStatement" : "createStatement");
            throw new SQLException(Messages.get("error.generic.badparam", "TYPE", method), "HY092");
        }
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            String method = this instanceof JtdsCallableStatement ? "prepareCall" : (this instanceof JtdsPreparedStatement ? "prepareStatement" : "createStatement");
            throw new SQLException(Messages.get("error.generic.badparam", "CONCURRENCY", method), "HY092");
        }
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.messages = new SQLDiagnostic(connection.getServerType());
        this.tds = new TdsCore(this.connection, this.messages);
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    TdsCore getTds() {
        return this.tds;
    }

    SQLDiagnostic getMessages() {
        return this.messages;
    }

    protected void checkOpen() throws SQLException {
        if (this.closed || this.connection == null || this.connection.isClosed()) {
            throw new SQLException(Messages.get("error.generic.closed", "Statement"), "HY010");
        }
    }

    void notImplemented(String method) throws SQLException {
        throw new SQLException(Messages.get("error.generic.notimp", method), "HYC00");
    }

    void closeCurrentResultSet() {
        try {
            block4: {
                try {
                    if (this.currentResult == null) break block4;
                    this.currentResult.close();
                }
                catch (SQLException e) {
                    Object var3_2 = null;
                    this.currentResult = null;
                }
            }
            Object var3_1 = null;
            this.currentResult = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.currentResult = null;
            throw throwable;
        }
    }

    void addWarning(SQLWarning w) {
        this.messages.addWarning(w);
    }

    protected void executeBatchOther(Object value, boolean last) throws SQLException {
        throw new SQLException(Messages.get("error.statement.badbatch", value.toString()), "HYC00");
    }

    protected ResultSet executeSQLQuery(String sql, String spName, ParamInfo[] params, boolean readAhead) throws SQLException {
        this.closeCurrentResultSet();
        this.resultQueue.clear();
        this.genKeyResultSet = null;
        String warningMessage = null;
        if (this.resultSetType != 1003 || this.resultSetConcurrency != 1007 || this.cursorName != null) {
            try {
                if (this.connection.getServerType() == 1) {
                    this.currentResult = new MSCursorResultSet(this, sql, spName, params, this.resultSetType, this.resultSetConcurrency);
                    return this.currentResult;
                }
                this.currentResult = new CachedResultSet(this, sql, spName, params, this.resultSetType, this.resultSetConcurrency);
                return this.currentResult;
            }
            catch (SQLException e) {
                if (this.connection == null || this.connection.isClosed()) {
                    throw e;
                }
                warningMessage = "[" + e.getSQLState() + "] " + e.getMessage();
            }
        }
        this.tds.executeSQL(sql, spName, params, false, this.queryTimeout, this.maxRows, true);
        while (!this.tds.getMoreResults() && !this.tds.isEndOfResponse()) {
        }
        if (!this.tds.isResultSet()) {
            throw new SQLException(Messages.get("error.statement.noresult"), "24000");
        }
        this.currentResult = new JtdsResultSet(this, 1003, 1007, this.tds.getColumns(), readAhead);
        if (warningMessage != null) {
            this.addWarning(new SQLWarning(Messages.get("warning.cursordowngraded", warningMessage), "01000"));
        }
        return this.currentResult;
    }

    protected boolean executeSQL(String sql, String spName, String sqlWord, ParamInfo[] params, boolean returnKeys, boolean update) throws SQLException {
        this.closeCurrentResultSet();
        this.resultQueue.clear();
        this.genKeyResultSet = null;
        String warningMessage = null;
        if (!(this.resultSetType == 1003 && this.resultSetConcurrency == 1007 && this.cursorName == null || returnKeys || !sqlWord.equals("select") && !sqlWord.startsWith("exec"))) {
            try {
                if (this.connection.getServerType() == 1) {
                    this.currentResult = new MSCursorResultSet(this, sql, spName, params, this.resultSetType, this.resultSetConcurrency);
                    return true;
                }
                this.currentResult = new CachedResultSet(this, sql, spName, params, this.resultSetType, this.resultSetConcurrency);
                return true;
            }
            catch (SQLException e) {
                if (this.connection == null || this.connection.isClosed()) {
                    throw e;
                }
                warningMessage = "[" + e.getSQLState() + "] " + e.getMessage();
            }
        }
        this.tds.executeSQL(sql, spName, params, false, this.queryTimeout, this.maxRows, true);
        if (warningMessage != null) {
            this.addWarning(new SQLWarning(Messages.get("warning.cursordowngraded", warningMessage), "01000"));
        }
        return this.processResults(returnKeys, update);
    }

    private boolean processResults(boolean returnKeys, boolean update) throws SQLException {
        while (!this.tds.isEndOfResponse()) {
            if (!this.tds.getMoreResults()) {
                if (!this.tds.isUpdateCount()) continue;
                if (update && this.connection.isLastUpdateCount()) {
                    this.resultQueue.clear();
                }
                this.resultQueue.addLast(new Integer(this.tds.getUpdateCount()));
                continue;
            }
            if (returnKeys) {
                if (!this.tds.getNextRow()) continue;
                this.genKeyResultSet = new CachedResultSet(this, this.tds.getColumns(), this.tds.getRowData());
                continue;
            }
            if (update && this.resultQueue.isEmpty()) {
                throw new SQLException(Messages.get("error.statement.nocount"), "07000");
            }
            JtdsResultSet rs = new JtdsResultSet(this, 1003, 1007, this.tds.getColumns(), false);
            if (this.resultQueue.isEmpty()) {
                this.currentResult = rs;
                return true;
            }
            this.resultQueue.add(rs);
            return false;
        }
        return false;
    }

    protected int getUpdateCount(int defaultValue) {
        return this.resultQueue.isEmpty() ? defaultValue : (Integer)this.resultQueue.getFirst();
    }

    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fetchSize;
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        this.checkOpen();
        return this.maxRows;
    }

    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this.queryTimeout;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        return 1;
    }

    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return this.resultSetType;
    }

    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return this.getUpdateCount(-1);
    }

    public void cancel() throws SQLException {
        this.checkOpen();
        if (this.tds != null) {
            this.tds.cancel();
        }
    }

    public synchronized void clearBatch() throws SQLException {
        this.checkOpen();
        if (this.batchValues != null) {
            this.batchValues.clear();
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this.messages.clearWarnings();
    }

    public void close() throws SQLException {
        if (!this.closed) {
            try {
                this.closeCurrentResultSet();
                if (!this.connection.isClosed()) {
                    this.tds.clearResponseQueue();
                    this.tds.close();
                }
                Object var2_1 = null;
                this.closed = true;
                this.tds = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.closed = true;
                this.tds = null;
                this.connection.removeStatement(this);
                this.connection = null;
                throw throwable;
            }
            this.connection.removeStatement(this);
            this.connection = null;
            {
            }
        }
    }

    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        return this.getMoreResults(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        Object value;
        this.checkOpen();
        if (this.batchValues == null) return new int[0];
        if (this.batchValues.size() == 0) {
            return new int[0];
        }
        int size = this.batchValues.size();
        try {
            try {
                this.tds.startBatch();
                int i = 0;
                while (true) {
                    if (i >= size) {
                        value = this.tds.getBatchCounts();
                        Object var5_6 = null;
                        break;
                    }
                    value = this.batchValues.get(i);
                    ++i;
                    if (value instanceof String) {
                        this.tds.executeSQL((String)value, null, null, true, 0, -1, i == size);
                        continue;
                    }
                    this.executeBatchOther(value, i == size);
                }
            }
            catch (BatchUpdateException ex) {
                throw ex;
            }
            catch (SQLException ex) {
                throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), this.tds.getBatchCounts());
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.clearBatch();
            throw throwable;
        }
        this.clearBatch();
        return value;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchDirection = direction;
                break;
            }
            default: {
                throw new SQLException(Messages.get("error.generic.badoption", Integer.toString(direction), "setFetchDirection"), "24000");
            }
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        if (rows < 0 || this.maxRows > 0 && rows > this.maxRows) {
            throw new SQLException(Messages.get("error.generic.optltzero", "setFetchSize"), "HY092");
        }
        this.fetchSize = rows;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        if (max < 0) {
            throw new SQLException(Messages.get("error.generic.optltzero", "setMaxFieldSize"), "HY092");
        }
        if (max == 0) {
            max = Integer.MAX_VALUE;
        }
        this.tds.submitSQL("set textsize " + max);
        this.maxFieldSize = max;
    }

    public void setMaxRows(int max) throws SQLException {
        this.checkOpen();
        if (max < 0) {
            throw new SQLException(Messages.get("error.generic.optltzero", "setMaxRows"), "HY092");
        }
        this.maxRows = max;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        if (seconds < 0) {
            throw new SQLException(Messages.get("error.generic.optltzero", "setQueryTimeout"), "HY092");
        }
        this.queryTimeout = seconds;
    }

    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        switch (current) {
            case 1: 
            case 3: {
                this.closeCurrentResultSet();
                break;
            }
            case 2: {
                throw new SQLException(Messages.get("error.generic.optvalue", "KEEP_CURRENT_RESULT", "getMoreResults"), "HYC00");
            }
            default: {
                throw new SQLException(Messages.get("error.generic.badoption", Integer.toString(current), "getMoreResults"), "HY092");
            }
        }
        if (!this.resultQueue.isEmpty()) {
            this.resultQueue.removeFirst();
            if (!this.resultQueue.isEmpty()) {
                Object nextResult = this.resultQueue.getFirst();
                if (nextResult instanceof Integer) {
                    return false;
                }
                this.currentResult = (JtdsResultSet)nextResult;
                this.resultQueue.removeFirst();
                return true;
            }
        }
        return this.processResults(false, false);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        this.escapeProcessing = enable;
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, 2);
    }

    public synchronized void addBatch(String sql) throws SQLException {
        this.checkOpen();
        if (sql == null) {
            throw new NullPointerException();
        }
        if (this.batchValues == null) {
            this.batchValues = new ArrayList();
        }
        this.batchValues.add(sql);
    }

    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
        this.cursorName = name;
        if (name != null) {
            this.resultSetType = 1003;
            this.fetchSize = 1;
        }
    }

    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, 2);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        boolean returnKeys;
        this.checkOpen();
        if (sql == null || sql.length() == 0) {
            throw new SQLException(Messages.get("error.generic.nosql"), "HY000");
        }
        String sqlWord = "";
        if (this.escapeProcessing) {
            ArrayList params = new ArrayList();
            String[] tmp = new SQLParser(sql, params, this.connection).parse(false);
            if (tmp[1].length() != 0 || params.size() > 0) {
                throw new SQLException(Messages.get("error.statement.badsql"), "07000");
            }
            sql = tmp[0];
            sqlWord = tmp[2];
        } else if ((sql = sql.trim()).length() > 5) {
            sqlWord = sql.substring(0, 6).toLowerCase();
        }
        if (autoGeneratedKeys == 1) {
            returnKeys = sqlWord.equals("insert");
            if (returnKeys) {
                sql = this.connection.getServerType() == 1 && this.connection.getDatabaseMajorVersion() >= 8 ? sql + " SELECT SCOPE_IDENTITY() AS ID" : sql + " SELECT @@IDENTITY AS ID";
            }
        } else if (autoGeneratedKeys == 2) {
            returnKeys = false;
        } else {
            throw new SQLException(Messages.get("error.generic.badoption", Integer.toString(autoGeneratedKeys), "executeUpdate"), "HY092");
        }
        this.executeSQL(sql, null, sqlWord, null, returnKeys, true);
        return this.getUpdateCount(0);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean returnKeys;
        this.checkOpen();
        if (sql == null || sql.length() == 0) {
            throw new SQLException(Messages.get("error.generic.nosql"), "HY000");
        }
        String sqlWord = "";
        if (this.escapeProcessing) {
            ArrayList params = new ArrayList();
            String[] tmp = new SQLParser(sql, params, this.connection).parse(false);
            if (tmp[1].length() != 0 || params.size() > 0) {
                throw new SQLException(Messages.get("error.statement.badsql"), "07000");
            }
            sql = tmp[0];
            sqlWord = tmp[2];
        } else if ((sql = sql.trim()).length() > 5) {
            sqlWord = sql.substring(0, 6).toLowerCase();
        }
        if (autoGeneratedKeys == 1) {
            returnKeys = sqlWord.equals("insert");
        } else if (autoGeneratedKeys == 2) {
            returnKeys = false;
        } else {
            throw new SQLException(Messages.get("error.generic.badoption", Integer.toString(autoGeneratedKeys), "execute"), "HY092");
        }
        if (returnKeys) {
            sql = this.connection.getServerType() == 1 && this.connection.getDatabaseMajorVersion() >= 8 ? sql + " SELECT SCOPE_IDENTITY() AS ID" : sql + " SELECT @@IDENTITY AS ID";
        }
        return this.executeSQL(sql, null, sqlWord, null, returnKeys, false);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        if (columnIndexes == null) {
            throw new SQLException(Messages.get("error.generic.nullparam", "executeUpdate"), "HY092");
        }
        if (columnIndexes.length != 1) {
            throw new SQLException(Messages.get("error.generic.needcolindex", "executeUpdate"), "HY092");
        }
        return this.executeUpdate(sql, 1);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        if (columnIndexes == null) {
            throw new SQLException(Messages.get("error.generic.nullparam", "execute"), "HY092");
        }
        if (columnIndexes.length != 1) {
            throw new SQLException(Messages.get("error.generic.needcolindex", "execute"), "HY092");
        }
        return this.execute(sql, 1);
    }

    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this.connection;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        if (this.genKeyResultSet == null) {
            String[] colNames = new String[]{"ID"};
            int[] colTypes = new int[]{4};
            CachedResultSet rs = new CachedResultSet(this, colNames, colTypes);
            rs.setConcurrency(1007);
            this.genKeyResultSet = rs;
        }
        return this.genKeyResultSet;
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return this.currentResult;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this.messages.getWarnings();
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        if (columnNames == null) {
            throw new SQLException(Messages.get("error.generic.nullparam", "executeUpdate"), "HY092");
        }
        if (columnNames.length != 1) {
            throw new SQLException(Messages.get("error.generic.needcolname", "executeUpdate"), "HY092");
        }
        return this.executeUpdate(sql, 1);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null) {
            throw new SQLException(Messages.get("error.generic.nullparam", "execute"), "HY092");
        }
        if (columnNames.length != 1) {
            throw new SQLException(Messages.get("error.generic.needcolname", "execute"), "HY092");
        }
        return this.execute(sql, 1);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        if (sql == null || sql.length() == 0) {
            throw new SQLException(Messages.get("error.generic.nosql"), "HY000");
        }
        if (this.escapeProcessing) {
            ArrayList params = new ArrayList();
            String[] tmp = new SQLParser(sql, params, this.connection).parse(false);
            if (tmp[1].length() != 0 || params.size() > 0) {
                throw new SQLException(Messages.get("error.statement.badsql"), "07000");
            }
            sql = tmp[0];
        }
        return this.executeSQLQuery(sql, null, null, false);
    }
}

