/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.services;

import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.monitor.alarm.AlarmManager;
import org.jboss.monitor.alarm.MBeanImplAccess;
import org.jboss.monitor.services.MemoryMonitorMBean;
import org.jboss.system.ServiceMBeanSupport;

public class MemoryMonitor
extends ServiceMBeanSupport
implements MemoryMonitorMBean {
    public static final String MEMORY_LOW = "jboss.alarm.memory.low";
    public static final String FREE_MEMORY_KEY = "freeMemory";
    public static final String DEFAULT_WARNING_THRESHOLD = "5m";
    public static final int DEFAULT_WARNING_MEASUREMENTS = 3;
    public static final String DEFAULT_CRITICAL_THRESHOLD = "2m";
    public static final String DEFAULT_SAMPLING_PERIOD = "5sec";
    public static final long KILO = 1024L;
    public static final long MEGA = 0x100000L;
    public static final long GIGA = 0x40000000L;
    public static final long SECS = 1000L;
    public static final long MINS = 60000L;
    public static final long HOUR = 3600000L;
    private long wThreshold;
    private String wThresholdString;
    private int wMeasurements;
    private long cThreshold;
    private String cThresholdString;
    private long samplingPeriod;
    private String samplingPeriodString;
    private boolean isStopRequested;
    private long freeMemory;
    private int warningSamples;
    AlarmManager alm = new AlarmManager(new MBeanImplAccess(){

        public ObjectName getMBeanName() {
            return MemoryMonitor.this.getServiceName();
        }

        public long getSequenceNumber() {
            return MemoryMonitor.this.getNextNotificationSequenceNumber();
        }

        public void emitNotification(Notification n) {
            MemoryMonitor.this.sendNotification(n);
        }
    });

    public MemoryMonitor() {
        this.setFreeMemoryWarningThreshold(DEFAULT_WARNING_THRESHOLD);
        this.setFreeMemoryCriticalThreshold(DEFAULT_CRITICAL_THRESHOLD);
        this.setSamplingPeriod(DEFAULT_SAMPLING_PERIOD);
        this.wMeasurements = 3;
    }

    public void setTriggeringWarningMeasurements(int measurements) {
        if (measurements > 0) {
            this.wMeasurements = measurements;
        }
    }

    public int getTriggeringWarningMeasurements() {
        return this.wMeasurements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFreeMemoryWarningThreshold(String s) {
        MemoryMonitor memoryMonitor = this;
        synchronized (memoryMonitor) {
            this.wThreshold = MemoryMonitor.parseMemorySpec(s);
            this.wThresholdString = s;
        }
    }

    public String getFreeMemoryWarningThreshold() {
        return this.wThresholdString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFreeMemoryCriticalThreshold(String s) {
        MemoryMonitor memoryMonitor = this;
        synchronized (memoryMonitor) {
            this.cThreshold = MemoryMonitor.parseMemorySpec(s);
            this.cThresholdString = s;
        }
    }

    public String getFreeMemoryCriticalThreshold() {
        return this.cThresholdString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSamplingPeriod(String s) {
        MemoryMonitor memoryMonitor = this;
        synchronized (memoryMonitor) {
            this.samplingPeriod = MemoryMonitor.parseTimePeriod(s);
            this.samplingPeriodString = s;
        }
    }

    public String getSamplingPeriod() {
        return this.samplingPeriodString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFreeMemorySample() {
        MemoryMonitor memoryMonitor = this;
        synchronized (memoryMonitor) {
            return this.freeMemory;
        }
    }

    public String getSeverity() {
        return this.alm.getSeverityAsString(MEMORY_LOW);
    }

    public void startService() throws Exception {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                long samplingPeriod;
                long cThreshold;
                long wThreshold;
                MemoryMonitor.this.log.info((Object)("Starting memory monitor thread, samplingPeriod=" + MemoryMonitor.this.samplingPeriodString + ", warningThreshold=" + MemoryMonitor.this.wThresholdString + ", criticalThreshold=" + MemoryMonitor.this.cThresholdString));
                MemoryMonitor memoryMonitor = MemoryMonitor.this;
                synchronized (memoryMonitor) {
                    wThreshold = MemoryMonitor.this.wThreshold;
                    cThreshold = MemoryMonitor.this.cThreshold;
                    samplingPeriod = MemoryMonitor.this.samplingPeriod;
                }
                MemoryMonitor.this.warningSamples = MemoryMonitor.this.wMeasurements;
                while (!MemoryMonitor.this.isStopRequested) {
                    MemoryMonitor.this.sampleMemory(wThreshold, cThreshold);
                    if (MemoryMonitor.this.isStopRequested) continue;
                    try {
                        Thread.sleep(samplingPeriod);
                    }
                    catch (InterruptedException e) {}
                }
                MemoryMonitor.this.log.info((Object)"Stopping memory monitor thread");
            }
        };
        if (this.cThreshold > this.wThreshold) {
            throw new Exception("FreeMemoryWarningThreshold (" + this.wThreshold + ") set lower than FreeMemoryCriticalThreshold (" + this.cThreshold + ")");
        }
        this.isStopRequested = false;
        Thread t = new Thread(r, "Memory monitor thread of \"" + this.getServiceName() + "\"");
        t.start();
    }

    public void stopService() {
        this.isStopRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sampleMemory(long wThreshold, long cThreshold) {
        long freeMemory = Runtime.getRuntime().freeMemory();
        MemoryMonitor memoryMonitor = this;
        synchronized (memoryMonitor) {
            this.freeMemory = freeMemory;
        }
        if (freeMemory <= cThreshold) {
            this.alm.setAlarm(MEMORY_LOW, 4, "Free memory in critical state!", FREE_MEMORY_KEY, new Long(freeMemory));
            this.warningSamples = this.wMeasurements;
        } else if (freeMemory <= wThreshold) {
            if (this.warningSamples > 0) {
                --this.warningSamples;
            }
            if (this.warningSamples == 0 || this.alm.getSeverity(MEMORY_LOW) == 4) {
                this.alm.setAlarm(MEMORY_LOW, 1, "Free memory getting low!", FREE_MEMORY_KEY, new Long(freeMemory));
            }
        } else {
            this.alm.setAlarm(MEMORY_LOW, 0, "Free memory at normal levels!", FREE_MEMORY_KEY, new Long(freeMemory));
            this.warningSamples = this.wMeasurements;
        }
    }

    private static long parseMemorySpec(String s) {
        try {
            int len = s.length();
            long factor = 0L;
            switch (s.charAt(len - 1)) {
                case 'K': 
                case 'k': {
                    factor = 1024L;
                    s = s.substring(0, len - 1);
                    break;
                }
                case 'M': 
                case 'm': {
                    factor = 0x100000L;
                    s = s.substring(0, len - 1);
                    break;
                }
                case 'G': 
                case 'g': {
                    factor = 0x40000000L;
                    s = s.substring(0, len - 1);
                    break;
                }
                default: {
                    factor = 1L;
                }
            }
            long retval = Long.parseLong(s) * factor;
            if (retval < 0L) {
                throw new NumberFormatException();
            }
            return retval;
        }
        catch (RuntimeException e) {
            throw new NumberFormatException("Not a valid memory specification: " + s);
        }
    }

    private static long parseTimePeriod(String s) {
        try {
            s = s.toLowerCase();
            long factor = 0L;
            if (s.endsWith("sec")) {
                s = s.substring(0, s.lastIndexOf("sec"));
                factor = 1000L;
            } else if (s.endsWith("min")) {
                s = s.substring(0, s.lastIndexOf("min"));
                factor = 60000L;
            } else if (s.endsWith("h")) {
                s = s.substring(0, s.lastIndexOf("h"));
                factor = 3600000L;
            } else {
                factor = 1L;
            }
            long retval = Long.parseLong(s) * factor;
            if (retval < 0L) {
                throw new NumberFormatException();
            }
            return retval;
        }
        catch (RuntimeException e) {
            throw new NumberFormatException("Not a valid time period specification: " + s);
        }
    }
}

