/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.http;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import twitter4j.http.Authorization;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.http.RequestMethod;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpRequest
implements Serializable {
    final RequestMethod requestMethod;
    final String url;
    final HttpParameter[] httpParams;
    final Authorization authorization;
    Map<String, String> requestHeaders;
    private static final long serialVersionUID = -3463594029098858381L;
    private static final HttpParameter[] NULL_PARAMETERS = new HttpParameter[0];

    public HttpRequest(RequestMethod method, String url, HttpParameter[] httpParams, Authorization authorization, Map<String, String> requestHeaders) {
        this.requestMethod = method;
        if (method != RequestMethod.POST && null != httpParams && httpParams.length != 0) {
            this.url = new StringBuffer().append(url).append("?").append(HttpParameter.encodeParameters(httpParams)).toString();
            this.httpParams = NULL_PARAMETERS;
        } else {
            this.url = url;
            this.httpParams = httpParams;
        }
        this.authorization = authorization;
        this.requestHeaders = requestHeaders;
    }

    public String getURL() {
        return this.url;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequest that = (HttpRequest)o;
        if (this.authorization != null ? !this.authorization.equals(that.authorization) : that.authorization != null) {
            return false;
        }
        if (!Arrays.equals(this.httpParams, that.httpParams)) {
            return false;
        }
        if (this.requestHeaders != null ? !((Object)this.requestHeaders).equals(that.requestHeaders) : that.requestHeaders != null) {
            return false;
        }
        if (this.requestMethod != null ? !this.requestMethod.equals(that.requestMethod) : that.requestMethod != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.requestMethod != null ? this.requestMethod.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.httpParams != null ? Arrays.hashCode(this.httpParams) : 0);
        result = 31 * result + (this.authorization != null ? this.authorization.hashCode() : 0);
        result = 31 * result + (this.requestHeaders != null ? ((Object)this.requestHeaders).hashCode() : 0);
        return result;
    }

    public String toString() {
        return new StringBuffer().append("HttpRequest{requestMethod=").append(this.requestMethod).append(", url='").append(this.url).append('\'').append(", postParams=").append(this.httpParams == null ? null : Arrays.asList(this.httpParams)).append(", authentication=").append(this.authorization).append(", requestHeaders=").append(this.requestHeaders).append('}').toString();
    }
}

