/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.conf;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import twitter4j.Version;
import twitter4j.conf.Configuration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationBase
implements Configuration,
Serializable {
    private boolean debug;
    private String source;
    private String userAgent;
    private String user;
    private String password;
    private boolean useSSL;
    private String httpProxyHost;
    private String httpProxyUser;
    private String httpProxyPassword;
    private int httpProxyPort;
    private int httpConnectionTimeout;
    private int httpReadTimeout;
    private int httpStreamingReadTimeout;
    private int httpRetryCount;
    private int httpRetryIntervalSeconds;
    private String oAuthConsumerKey;
    private String oAuthConsumerSecret;
    private String oAuthAccessToken;
    private String oAuthAccessTokenSecret;
    private String oAuthRequestTokenURL;
    private String oAuthAuthorizationURL;
    private String oAuthAccessTokenURL;
    private String oAuthAuthenticationURL;
    private String restBaseURL;
    private String searchBaseURL;
    private String streamBaseURL;
    private int asyncNumThreads;
    private String clientVersion;
    private String clientURL;
    public static final String DALVIK = "twitter4j.dalvik";
    private boolean IS_DALVIK;
    private static final long serialVersionUID = -6610497517837844232L;
    Map<String, String> requestHeaders;

    protected ConfigurationBase() {
        String dalvikDetected;
        this.setDebug(false);
        this.setSource("Twitter4J");
        this.setUser(null);
        this.setPassword(null);
        this.setUseSSL(true);
        this.setHttpProxyHost(null);
        this.setHttpProxyUser(null);
        this.setHttpProxyPassword(null);
        this.setHttpProxyPort(-1);
        this.setHttpConnectionTimeout(20000);
        this.setHttpReadTimeout(120000);
        this.setHttpStreamingReadTimeout(300000);
        this.setHttpRetryCount(0);
        this.setHttpRetryIntervalSeconds(5);
        this.setOAuthConsumerKey(null);
        this.setOAuthConsumerSecret(null);
        this.setOAuthAccessToken(null);
        this.setOAuthAccessTokenSecret(null);
        this.setAsyncNumThreads(1);
        this.setClientVersion(Version.getVersion());
        this.setClientURL(new StringBuffer().append("http://twitter4j.org/en/twitter4j-").append(Version.getVersion()).append(".xml").toString());
        this.setUserAgent(new StringBuffer().append("twitter4j http://twitter4j.org/ /").append(Version.getVersion()).toString());
        this.setOAuthRequestTokenURL("http://twitter.com/oauth/request_token");
        this.setOAuthAuthorizationURL("http://twitter.com/oauth/authorize");
        this.setOAuthAccessTokenURL("http://twitter.com/oauth/access_token");
        this.setOAuthAuthenticationURL("http://twitter.com/oauth/authenticate");
        this.setRestBaseURL("http://api.twitter.com/1/");
        this.setSearchBaseURL("http://search.twitter.com/");
        this.setStreamBaseURL("http://stream.twitter.com/1/");
        try {
            Class.forName("dalvik.system.VMRuntime");
            dalvikDetected = "true";
        }
        catch (ClassNotFoundException cnfe) {
            dalvikDetected = "false";
        }
        this.IS_DALVIK = Boolean.valueOf(System.getProperty(DALVIK, dalvikDetected));
    }

    @Override
    public final boolean isDalvik() {
        return this.IS_DALVIK;
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.debug;
    }

    protected final void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public final String getUserAgent() {
        return this.userAgent;
    }

    protected final void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.initRequestHeaders();
    }

    @Override
    public final String getSource() {
        return this.source;
    }

    protected final void setSource(String source) {
        this.source = source;
        this.initRequestHeaders();
    }

    @Override
    public final String getUser() {
        return this.user;
    }

    protected final void setUser(String user) {
        this.user = user;
    }

    @Override
    public final String getPassword() {
        return this.password;
    }

    protected final void setPassword(String password) {
        this.password = password;
    }

    protected final void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
        this.setRestBaseURL(this.getRestBaseURL());
        this.setSearchBaseURL(this.getSearchBaseURL());
        this.setStreamBaseURL(this.getStreamBaseURL());
        this.setOAuthRequestTokenURL(this.getOAuthRequestTokenURL());
        this.setOAuthAuthorizationURL(this.getOAuthAuthorizationURL());
        this.setOAuthAccessTokenURL(this.getOAuthAccessTokenURL());
        this.setOAuthAuthenticationURL(this.getOAuthAuthenticationURL());
    }

    private void initRequestHeaders() {
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("X-Twitter-Client-Version", this.getClientVersion());
        this.requestHeaders.put("X-Twitter-Client-URL", this.getClientURL());
        this.requestHeaders.put("X-Twitter-Client", this.getSource());
        this.requestHeaders.put("User-Agent", this.getUserAgent());
        this.requestHeaders.put("Accept-Encoding", "gzip");
        this.requestHeaders.put("Connection", "close");
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public final String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    protected final void setHttpProxyHost(String proxyHost) {
        this.httpProxyHost = proxyHost;
    }

    @Override
    public final String getHttpProxyUser() {
        return this.httpProxyUser;
    }

    protected final void setHttpProxyUser(String proxyUser) {
        this.httpProxyUser = proxyUser;
    }

    @Override
    public final String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    protected final void setHttpProxyPassword(String proxyPassword) {
        this.httpProxyPassword = proxyPassword;
    }

    @Override
    public final int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    protected final void setHttpProxyPort(int proxyPort) {
        this.httpProxyPort = proxyPort;
    }

    @Override
    public final int getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    protected final void setHttpConnectionTimeout(int connectionTimeout) {
        this.httpConnectionTimeout = connectionTimeout;
    }

    @Override
    public final int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    protected final void setHttpReadTimeout(int readTimeout) {
        this.httpReadTimeout = readTimeout;
    }

    @Override
    public int getHttpStreamingReadTimeout() {
        return this.httpStreamingReadTimeout;
    }

    protected final void setHttpStreamingReadTimeout(int httpStreamingReadTimeout) {
        this.httpStreamingReadTimeout = httpStreamingReadTimeout;
    }

    @Override
    public final int getHttpRetryCount() {
        return this.httpRetryCount;
    }

    protected final void setHttpRetryCount(int retryCount) {
        this.httpRetryCount = retryCount;
    }

    @Override
    public final int getHttpRetryIntervalSeconds() {
        return this.httpRetryIntervalSeconds;
    }

    protected final void setHttpRetryIntervalSeconds(int retryIntervalSeconds) {
        this.httpRetryIntervalSeconds = retryIntervalSeconds;
    }

    @Override
    public final String getOAuthConsumerKey() {
        return this.oAuthConsumerKey;
    }

    protected final void setOAuthConsumerKey(String oAuthConsumerKey) {
        this.oAuthConsumerKey = oAuthConsumerKey;
    }

    @Override
    public final String getOAuthConsumerSecret() {
        return this.oAuthConsumerSecret;
    }

    protected final void setOAuthConsumerSecret(String oAuthConsumerSecret) {
        this.oAuthConsumerSecret = oAuthConsumerSecret;
    }

    @Override
    public String getOAuthAccessToken() {
        return this.oAuthAccessToken;
    }

    protected final void setOAuthAccessToken(String oAuthAccessToken) {
        this.oAuthAccessToken = oAuthAccessToken;
    }

    @Override
    public String getOAuthAccessTokenSecret() {
        return this.oAuthAccessTokenSecret;
    }

    protected final void setOAuthAccessTokenSecret(String oAuthAccessTokenSecret) {
        this.oAuthAccessTokenSecret = oAuthAccessTokenSecret;
    }

    @Override
    public final int getAsyncNumThreads() {
        return this.asyncNumThreads;
    }

    protected final void setAsyncNumThreads(int asyncNumThreads) {
        this.asyncNumThreads = asyncNumThreads;
    }

    @Override
    public final String getClientVersion() {
        return this.clientVersion;
    }

    protected final void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
        this.initRequestHeaders();
    }

    @Override
    public final String getClientURL() {
        return this.clientURL;
    }

    protected final void setClientURL(String clientURL) {
        this.clientURL = clientURL;
        this.initRequestHeaders();
    }

    @Override
    public String getRestBaseURL() {
        return this.restBaseURL;
    }

    protected final void setRestBaseURL(String restBaseURL) {
        this.restBaseURL = ConfigurationBase.fixURL(this.useSSL, restBaseURL);
    }

    @Override
    public String getSearchBaseURL() {
        return this.searchBaseURL;
    }

    protected final void setSearchBaseURL(String searchBaseURL) {
        this.searchBaseURL = ConfigurationBase.fixURL(false, searchBaseURL);
    }

    @Override
    public String getStreamBaseURL() {
        return this.streamBaseURL;
    }

    protected final void setStreamBaseURL(String streamBaseURL) {
        this.streamBaseURL = ConfigurationBase.fixURL(false, streamBaseURL);
    }

    @Override
    public String getOAuthRequestTokenURL() {
        return this.oAuthRequestTokenURL;
    }

    protected final void setOAuthRequestTokenURL(String oAuthRequestTokenURL) {
        this.oAuthRequestTokenURL = ConfigurationBase.fixURL(this.useSSL, oAuthRequestTokenURL);
    }

    @Override
    public String getOAuthAuthorizationURL() {
        return this.oAuthAuthorizationURL;
    }

    protected final void setOAuthAuthorizationURL(String oAuthAuthorizationURL) {
        this.oAuthAuthorizationURL = ConfigurationBase.fixURL(this.useSSL, oAuthAuthorizationURL);
    }

    @Override
    public String getOAuthAccessTokenURL() {
        return this.oAuthAccessTokenURL;
    }

    protected final void setOAuthAccessTokenURL(String oAuthAccessTokenURL) {
        this.oAuthAccessTokenURL = ConfigurationBase.fixURL(this.useSSL, oAuthAccessTokenURL);
    }

    @Override
    public String getOAuthAuthenticationURL() {
        return this.oAuthAuthenticationURL;
    }

    protected final void setOAuthAuthenticationURL(String oAuthAuthenticationURL) {
        this.oAuthAuthenticationURL = ConfigurationBase.fixURL(this.useSSL, oAuthAuthenticationURL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurationBase)) {
            return false;
        }
        ConfigurationBase that = (ConfigurationBase)o;
        if (this.IS_DALVIK != that.IS_DALVIK) {
            return false;
        }
        if (this.asyncNumThreads != that.asyncNumThreads) {
            return false;
        }
        if (this.httpConnectionTimeout != that.httpConnectionTimeout) {
            return false;
        }
        if (this.debug != that.debug) {
            return false;
        }
        if (this.httpProxyPort != that.httpProxyPort) {
            return false;
        }
        if (this.httpReadTimeout != that.httpReadTimeout) {
            return false;
        }
        if (this.httpRetryCount != that.httpRetryCount) {
            return false;
        }
        if (this.httpRetryIntervalSeconds != that.httpRetryIntervalSeconds) {
            return false;
        }
        if (this.useSSL != that.useSSL) {
            return false;
        }
        if (this.clientURL != null ? !this.clientURL.equals(that.clientURL) : that.clientURL != null) {
            return false;
        }
        if (this.clientVersion != null ? !this.clientVersion.equals(that.clientVersion) : that.clientVersion != null) {
            return false;
        }
        if (this.oAuthAccessToken != null ? !this.oAuthAccessToken.equals(that.oAuthAccessToken) : that.oAuthAccessToken != null) {
            return false;
        }
        if (this.oAuthAccessTokenSecret != null ? !this.oAuthAccessTokenSecret.equals(that.oAuthAccessTokenSecret) : that.oAuthAccessTokenSecret != null) {
            return false;
        }
        if (this.oAuthAccessTokenURL != null ? !this.oAuthAccessTokenURL.equals(that.oAuthAccessTokenURL) : that.oAuthAccessTokenURL != null) {
            return false;
        }
        if (this.oAuthAuthenticationURL != null ? !this.oAuthAuthenticationURL.equals(that.oAuthAuthenticationURL) : that.oAuthAuthenticationURL != null) {
            return false;
        }
        if (this.oAuthAuthorizationURL != null ? !this.oAuthAuthorizationURL.equals(that.oAuthAuthorizationURL) : that.oAuthAuthorizationURL != null) {
            return false;
        }
        if (this.oAuthConsumerKey != null ? !this.oAuthConsumerKey.equals(that.oAuthConsumerKey) : that.oAuthConsumerKey != null) {
            return false;
        }
        if (this.oAuthConsumerSecret != null ? !this.oAuthConsumerSecret.equals(that.oAuthConsumerSecret) : that.oAuthConsumerSecret != null) {
            return false;
        }
        if (this.oAuthRequestTokenURL != null ? !this.oAuthRequestTokenURL.equals(that.oAuthRequestTokenURL) : that.oAuthRequestTokenURL != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.httpProxyHost != null ? !this.httpProxyHost.equals(that.httpProxyHost) : that.httpProxyHost != null) {
            return false;
        }
        if (this.httpProxyPassword != null ? !this.httpProxyPassword.equals(that.httpProxyPassword) : that.httpProxyPassword != null) {
            return false;
        }
        if (this.httpProxyUser != null ? !this.httpProxyUser.equals(that.httpProxyUser) : that.httpProxyUser != null) {
            return false;
        }
        if (this.restBaseURL != null ? !this.restBaseURL.equals(that.restBaseURL) : that.restBaseURL != null) {
            return false;
        }
        if (this.searchBaseURL != null ? !this.searchBaseURL.equals(that.searchBaseURL) : that.searchBaseURL != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.streamBaseURL != null ? !this.streamBaseURL.equals(that.streamBaseURL) : that.streamBaseURL != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        return !(this.userAgent != null ? !this.userAgent.equals(that.userAgent) : that.userAgent != null);
    }

    public String toString() {
        return new StringBuffer().append("ConfigurationBase{debug=").append(this.debug).append(", source='").append(this.source).append('\'').append(", userAgent='").append(this.userAgent).append('\'').append(", user='").append(this.user).append('\'').append(", password='").append(this.password).append('\'').append(", useSSL=").append(this.useSSL).append(", httpProxyHost='").append(this.httpProxyHost).append('\'').append(", httpProxyUser='").append(this.httpProxyUser).append('\'').append(", httpProxyPassword='").append(this.httpProxyPassword).append('\'').append(", httpProxyPort=").append(this.httpProxyPort).append(", httpConnectionTimeout=").append(this.httpConnectionTimeout).append(", httpReadTimeout=").append(this.httpReadTimeout).append(", httpRetryCount=").append(this.httpRetryCount).append(", httpRetryIntervalMilliSecs=").append(this.httpRetryIntervalSeconds).append(", oAuthConsumerKey='").append(this.oAuthConsumerKey).append('\'').append(", oAuthConsumerSecret='").append(this.oAuthConsumerSecret).append('\'').append(", oAuthAccessToken='").append(this.oAuthAccessToken).append('\'').append(", oAuthAccessTokenSecret='").append(this.oAuthAccessTokenSecret).append('\'').append(", oAuthRequestTokenURL='").append(this.oAuthRequestTokenURL).append('\'').append(", oAuthAuthorizationURL='").append(this.oAuthAuthorizationURL).append('\'').append(", oAuthAccessTokenURL='").append(this.oAuthAccessTokenURL).append('\'').append(", oAuthAuthenticationURL='").append(this.oAuthAuthenticationURL).append('\'').append(", restBaseURL='").append(this.restBaseURL).append('\'').append(", searchBaseURL='").append(this.searchBaseURL).append('\'').append(", streamBaseURL='").append(this.streamBaseURL).append('\'').append(", asyncNumThreads=").append(this.asyncNumThreads).append(", clientVersion='").append(this.clientVersion).append('\'').append(", clientURL='").append(this.clientURL).append('\'').append(", IS_DALVIK=").append(this.IS_DALVIK).append('}').toString();
    }

    static String fixURL(boolean useSSL, String url) {
        if (null == url) {
            return null;
        }
        int index = url.indexOf("://");
        if (-1 == index) {
            throw new IllegalArgumentException("url should contain '://'");
        }
        String hostAndLater = url.substring(index + 3);
        if (useSSL) {
            return new StringBuffer().append("https://").append(hostAndLater).toString();
        }
        return new StringBuffer().append("http://").append(hostAndLater).toString();
    }
}

