/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.StatusListener;
import twitter4j.TwitterStream;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.Authorization;
import twitter4j.http.AuthorizationFactory;

public final class TwitterStreamFactory
implements Serializable {
    private static final long serialVersionUID = 8146074704915782233L;
    private final StatusListener listener;
    private final Configuration conf;

    public TwitterStreamFactory() {
        this((StatusListener)null);
    }

    public TwitterStreamFactory(Configuration conf) {
        this(conf, null);
    }

    public TwitterStreamFactory(StatusListener listener) {
        this(ConfigurationContext.getInstance(), listener);
    }

    public TwitterStreamFactory(String configTreePath) {
        this(configTreePath, null);
    }

    public TwitterStreamFactory(String configTreePath, StatusListener listener) {
        this(ConfigurationContext.getInstance(configTreePath), listener);
    }

    public TwitterStreamFactory(Configuration conf, StatusListener listener) {
        if (conf == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.conf = conf;
        this.listener = listener;
    }

    public TwitterStream getInstance() {
        return this.getInstance(this.conf);
    }

    public TwitterStream getInstance(String screenName, String password) {
        return this.getInstance(AuthorizationFactory.getBasicAuthorizationInstance(screenName, password));
    }

    public TwitterStream getInstance(Authorization auth) {
        return this.getInstance(this.conf, auth);
    }

    private TwitterStream getInstance(Configuration conf, Authorization auth) {
        return new TwitterStream(conf, auth, this.listener);
    }

    private TwitterStream getInstance(Configuration conf) {
        return new TwitterStream(conf, AuthorizationFactory.getInstance(conf, false), this.listener);
    }
}

