package hayashi.yuu.tools.properties;

import java.util.Vector;

/**
 * Hayashiライブラリ専用のプロパティファイル
 * 特定の項目（パスワードなど）を暗号化してファイルに記録する。
 * 読み出し時には復号化します。
 * その他の項目は通常のPropertiesと同じ処理のままです。
 * @author Hayashi,Yuu
 * @version 2010/02/07
 * @since 2009/01/27
 */
@SuppressWarnings("serial")
public class Properties extends java.util.Properties
{
	private Vector<String> passwords = new Vector<String>();

	public Properties() {
		super();
		passwords.add("MAIL_PASSWORD");
	}

	public Properties(Properties defaults) {
		super(defaults);
		passwords.add("MAIL_PASSWORD");
	}
	
	/**
	 * 暗号化処理を行うプロパティ項目を指定する。
	 * @param itemStr	プロパティ項目名
	 */
	public void setPasswordItem(String itemStr) {
		passwords.add(itemStr);
	}

	/**
	 * プロパティ値を設定する
	 * @param key プロパティ項目名
	 * @param value 設定値
	 * @return プロパティインスタンス
	 */
	@Override
	public synchronized Object setProperty(String key, String value) {
		try {
			for (String pwItem : passwords) {
				if (key.equals(pwItem)) {
					return super.setProperty(key, Encrypt.encrypt(value));
				}
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		return super.setProperty(key, value);
	}

	/**
	 * 指定されたキーを持つプロパティを、プロパティリストから探します。そのキーがプロパティリストにないと、
	 * デフォルトのプロパティリスト、さらにそのデフォルト値が繰り返し調べられます。
	 * そのプロパティが見つからない場合は、デフォルト値の引数が返されます。
	 * @param key プロパティ項目名
	 * @param defaultValue 指定されたプロパティ項目に値が設定されていなかったときに代わりに得られる値
	 * @return 値。値が設定されていなかった時にはdefaultValue。
	 */
	@Override
	public String getProperty(String key, String defaultValue) {
		try {
			for (String pwItem : passwords) {
				if (key.equals(pwItem)) {
					return Encrypt.decode(super.getProperty(key, Encrypt.encrypt(defaultValue)));
				}
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		return super.getProperty(key, defaultValue);
	}

	/**
	 * 指定されたキーを持つプロパティを、プロパティリストから探します。そのキーがプロパティリストにないと、
	 * デフォルトのプロパティリスト、さらにそのデフォルト値が繰り返し調べられます。そのプロパティが見つから
	 * ない場合は、null が返されます
	 * @param key プロパティ項目名
	 * @return 値。値が設定されていなかった時にはnull。
	 */
	@Override
	public String getProperty(String key) {
		try {
			for (String pwItem : passwords) {
				if (key.equals(pwItem)) {
					return Encrypt.decode(super.getProperty(key));
				}
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		return super.getProperty(key);
	}
}
