#cs #INDEX# --------------------------------------------------------------------

 Title         : autest_option
 Author        : Takazumi Shirayanagi

 Copyright (C) 2013, Takazumi Shirayanagi
 The new BSD License is applied to this software.
 see LICENSE

#ce ----------------------------------------------------------------------------

#include-once

#cs #CURRENT# -----------------------------------------------------------------
 * @brief	ASSETION OPTIONS FUNCTION
 * @public
 * AutestOpt_GetOutputCompilerFileLocation
 * AutestOpt_SetOutputCompilerFileLocation
 * AutestOpt_GetFilter
 * AutestOpt_SetFilter
 * AutestOpt_GetOutput
 * AutestOpt_SetOutput
 * AutestOpt_GetShowHelp
 * AutestOpt_SetShowHelp
#ce ----------------------------------------------------------------------------

; output file location type
; 0 = gcc
; 1 = Visual Studio

Func AutestOpt_GetOutputCompilerFileLocation()
	IF Not IsDeclared("autest_output_compilerfilelocation") Then
		Global $autest_output_compilerfilelocation = 0
	EndIf
	Return Eval("autest_output_compilerfilelocation")
EndFunc

Func AutestOpt_SetOutputCompilerFileLocation($val)
	IF Not IsDeclared("autest_output_compilerfilelocation") Then
		Global $autest_output_compilerfilelocation = 0
	EndIf
	Assign("autest_output_compilerfilelocation", $val)
EndFunc

;
; Filter
;
Func AutestOpt_GetFilter()
	IF Not IsDeclared("autest_option_filter") Then
		Global $autest_option_filter = ".*"
	EndIf
	Return $autest_option_filter
EndFunc

Func AutestOpt_SetFilter($filter)
	IF Not IsDeclared("autest_option_filter") Then
		Global $autest_option_filter = $filter
	EndIf
	$autest_option_filter = $filter
EndFunc

;
; Output File
;
Func AutestOpt_GetOutput()
	IF Not IsDeclared("autest_output_path") Then
		Global $autest_output_path = ""
	EndIf
	Return $autest_output_path
EndFunc

Func AutestOpt_SetOutput($output)
	IF Not IsDeclared("autest_output_path") Then
		Global $autest_output_path = $output
	EndIf
	$autest_output_path = $output
EndFunc

;
; ShowHelp
;
Func AutestOpt_GetShowHelp()
	IF Not IsDeclared("autest_output_showhelp") Then
		Global $autest_output_showhelp = False
	EndIf
	Return Eval("autest_output_showhelp")
EndFunc

Func AutestOpt_SetShowHelp($val)
	IF Not IsDeclared("autest_output_showhelp") Then
		Global $autest_output_showhelp = False
	EndIf
	Assign("autest_output_showhelp", $val)
EndFunc
