#cs #INDEX# --------------------------------------------------------------------

 Title         : autest_console
 Author        : Takazumi Shirayanagi

 Copyright (C) 2013, Takazumi Shirayanagi
 The new BSD License is applied to this software.
 see LICENSE

#ce ----------------------------------------------------------------------------

#include-once

#cs #CURRENT# -----------------------------------------------------------------
 * @brief	ASSETION Console FUNCTION
 * @public
 * Autest_ConsolePrintLn
 * Autest_ConsoleColorPrint
#ce ----------------------------------------------------------------------------

;
; Autest_ConsolePrintLn
;
Func Autest_ConsolePrintLn($str)
	ConsoleWrite($str)
	ConsoleWrite(@CRLF)
EndFunc

; COLOR
Enum $AUTEST_COLOR_BLACK, $AUTEST_COLOR_RED, $AUTEST_COLOR_GREEN, $AUTEST_COLOR_YELLOW, $AUTEST_COLOR_BLUE, $AUTEST_COLOR_MAGENTA, $AUTEST_COLOR_CYAN, $AUTEST_COLOR_WHITE

;
; Autest_ConsoleColorPrint
;
Func Autest_ConsoleColorPrint($color, $str)
	Local $hOut = Autest_GetStdHandle($STD_OUTPUT_HANDLE)
	Local $wPreAttribute = Autest_GetConsoleTextAttribute($hOut)
	Local $wAttribute = 0
	Switch $color
		Case $AUTEST_COLOR_BLACK
			$wAttribute = 0
		Case $AUTEST_COLOR_BLUE
			$wAttribute = 1
		Case $AUTEST_COLOR_GREEN
			$wAttribute = 2
		Case $AUTEST_COLOR_RED
			$wAttribute = 4
		Case $AUTEST_COLOR_CYAN
			$wAttribute = 3
		Case $AUTEST_COLOR_YELLOW
			$wAttribute = 6
		Case $AUTEST_COLOR_MAGENTA
			$wAttribute = 5
	EndSwitch
	$wAttribute = BitOR($wAttribute, 8)
	Autest_SetConsoleTextAttribute($hOut, $wAttribute)
	ConsoleWrite($str)
	Autest_SetConsoleTextAttribute($hOut, $wPreAttribute)
EndFunc

#cs #INTERNAL_USE_ONLY# --------------------------------------------------------
 * @private
 * Autest_GetStdHandle
 * Autest_SetConsoleTextAttribute
 * Autest_GetConsoleTextAttribute
#ce ----------------------------------------------------------------------------

Enum $STD_INPUT_HANDLE = -10, $STD_OUTPUT_HANDLE = -11, $STD_ERROR_HANDLE = -12
;
; Autest_GetStdHandle
;
Func Autest_GetStdHandle($nStdHandle)
	Local $ret = DllCall("Kernel32.dll", "handle", "GetStdHandle", "dword", $nStdHandle)
	IF @error Or (Not IsArray($ret)) Then Return SetError(@error, @extended, 0)
	Return $ret[0]
EndFunc

;
; Autest_SetConsoleTextAttribute
;
Func Autest_SetConsoleTextAttribute($hCosole, $wAttribute)
	Local $ret = DllCall("Kernel32.dll", "bool", "SetConsoleTextAttribute", "handle", $hCosole, "word", $wAttribute)
	IF @error Or (Not IsArray($ret)) Then Return SetError(@error, @extended, 0)
	Return $ret[0]
EndFunc

;
; Autest_GetConsoleTextAttribute
;
Func Autest_GetConsoleTextAttribute($hCosole)
	Local $csbi = DllStructCreate("short; short; short; short; short wAttribute; short; short; short; short; short; short;")
	Local $ret = DllCall("Kernel32.dll", "bool", "GetConsoleScreenBufferInfo", "handle", $hCosole, "ptr", DllStructGetPtr($csbi))
	IF @error Or (Not IsArray($ret)) Then Return SetError(@error, @extended, 0)
	Return DllStructGetData($csbi, "wAttribute")
EndFunc

