// -*- C++ -*-
#ifndef _packet_h_included_
#define _packet_h_included_

#include <list>

#define BYTEORDER_UNKNOWN 0
#define LSB_FIRST 1
#define MSB_FIRST 2

typedef unsigned char C8;
typedef unsigned short C16;
typedef int CHAR;
typedef unsigned int C32;
typedef unsigned long long C64;

typedef std::list<CHAR> STRING;

class TxPacket{
public:
    virtual ~TxPacket(){};

    virtual int get_length()=0;
    virtual int write_to_buf(unsigned char *buf,int buflen,int byte_order)=0;

    virtual void dump(int byte_order)=0;
    virtual int getOpCode()=0;

    virtual int pushC8(unsigned int)=0;
    virtual int pushC16(unsigned int )=0;
    virtual int pushC32(unsigned int )=0;
    virtual int pushSTRING(STRING )=0;
    virtual int pushBytes(char *,int)=0;

    virtual int pop_back()=0;
};

class RxPacket{
public:

    virtual void rewind()=0;
    virtual C8 getC8()=0;
    virtual C16 getC16()=0;
    virtual C32 getC32()=0;

    virtual STRING getSTRING()=0;

    virtual int getOpCode()=0;
    virtual bool isOverRun()=0;

    virtual void dump()=0;
    static int get_len(unsigned char *,int len,int byte_order);
};

TxPacket *createTxPacket(int opcode);
RxPacket *createRxPacket(void *buf,int len,int byte_order);

STRING createSTRING(char *);
int getSTRINGlen(STRING *);

int pad4(int );

#endif
/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 */
