// Process input context
#include <stdio.h>

#include "imic.h"
#include "imconn.h"
#include "impn.h"
#include "packet.h"

IMIC::IMIC(IMConn *conn,int imid,int icid)
{
  mConn = conn;
  mICid = icid;
  mIMid = imid;
  mPrevPeLen = 0;
  mIsActive = false;
}

void IMIC::forward_event(RxPacket *p)
{
  int t;
  t = p->getC32();
  switch(t){
  case 0:// STRING
    printf("STRING forwarded\n");
    break;
  case 1:// TEXT
    printf("TEXT forwarded\n");
    break;
  case 2:// KEYEVENT
    int nr = p->getC32();
    proc_key_event(p);
    break;
  }
}

void IMIC::trigger_notify(bool b)
{
  mIsActive = b;
  update_status();
}

void IMIC::proc_key_event(RxPacket *p)
{
}

void IMIC::update_status()
{
  TxPacket *t = createTxPacket(IM_STATUS_START);
  t->pushC16(mIMid);
  t->pushC16(mICid);
  mConn->pushTxPacket(t);
}

void IMIC::preedit_draw(int l)
{
  TxPacket *t = createTxPacket(IM_PREEDIT_DRAW);
  t->pushC16(mIMid);
  t->pushC16(mICid);
  t->pushC32(0);//caret
  t->pushC32(0);//first
  t->pushC32(mPrevPeLen);//prev len
  composePreedit(t);
  mConn->pushTxPacket(t);
}

//IM_PREEDIT_DRAWCONTENTSʬ롣
void IMIC::composePreedit(TxPacket *t)
{
}

void IMIC::preedit_done()
{
  TxPacket *t = createTxPacket(IM_PREEDIT_DONE);
  t->pushC16(mIMid);
  t->pushC16(mICid);
  mConn->pushTxPacket(t);
}

void IMIC::status_draw()
{
  TxPacket *t = createTxPacket(IM_STATUS_DRAW);
  t->pushC16(mIMid);
  t->pushC16(mICid);

  t->pushC32(0);//STRING
  STRING str;
  str = createSTRING("");
  t->pushSTRING(str);

  mConn->pushTxPacket(t);
}

void IMIC::status_done()
{
  TxPacket *t = createTxPacket(IM_STATUS_DONE);
  t->pushC16(mIMid);
  t->pushC16(mICid);
  mConn->pushTxPacket(t);
}

void keyEvent::print()
{
  printf("code = %d,char = %d,mod = %d,stamp = %d\n",
         keycode,keychar,modifier,timestamp);
}
