/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CustomHashtable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeEditorImpl;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeViewer
extends AbstractTreeViewer {
    private TreeEditorImpl treeViewerImpl;
    private Tree tree;
    private TreeEditor treeEditor;
    private TreeColorAndFontCollector treeColorAndFont = new TreeColorAndFontCollector();
    private boolean treeIsDisposed = false;

    public TreeViewer(Composite parent) {
        this(parent, 2818);
    }

    public TreeViewer(Composite parent, int style) {
        this(new Tree(parent, style));
    }

    public TreeViewer(Tree tree) {
        this.tree = tree;
        this.hookControl((Control)tree);
        this.treeEditor = new TreeEditor(tree);
        this.initTreeViewerImpl();
    }

    protected void addTreeListener(Control c, TreeListener listener) {
        ((Tree)c).addTreeListener(listener);
    }

    public void cancelEditing() {
        this.treeViewerImpl.cancelEditing();
    }

    protected void doUpdateItem(Item item, Object element) {
        int columnCount;
        if (!(item instanceof TreeItem)) {
            return;
        }
        TreeItem treeItem = (TreeItem)item;
        if (treeItem.isDisposed()) {
            this.unmapElement(element, (Widget)treeItem);
            return;
        }
        this.getColorAndFontCollector().setFontsAndColors(element);
        IBaseLabelProvider prov = this.getLabelProvider();
        ITableLabelProvider tprov = null;
        ILabelProvider lprov = null;
        IViewerLabelProvider vprov = null;
        ITreePathLabelProvider pprov = null;
        if (prov instanceof ILabelProvider) {
            lprov = (ILabelProvider)prov;
        }
        if (prov instanceof IViewerLabelProvider) {
            vprov = (IViewerLabelProvider)prov;
        }
        if (prov instanceof ITableLabelProvider) {
            tprov = (ITableLabelProvider)prov;
        }
        if (prov instanceof ITreePathLabelProvider) {
            pprov = (ITreePathLabelProvider)prov;
        }
        if ((columnCount = this.tree.getColumnCount()) == 0) {
            ViewerLabel updateLabel = new ViewerLabel(treeItem.getText(), treeItem.getImage());
            if (pprov != null) {
                TreePath path = this.getTreePathFromItem(item);
                this.buildLabel(updateLabel, path, pprov);
            } else if (vprov != null) {
                this.buildLabel(updateLabel, element, vprov);
            } else if (lprov != null) {
                this.buildLabel(updateLabel, element, lprov);
            }
            if (treeItem.isDisposed()) {
                this.unmapElement(element, (Widget)treeItem);
                return;
            }
            if (updateLabel.hasNewText()) {
                treeItem.setText(updateLabel.getText());
            }
            if (updateLabel.hasNewImage()) {
                treeItem.setImage(updateLabel.getImage());
            }
            if (!updateLabel.hasPendingDecorations()) {
                this.getColorAndFontCollector().applyFontsAndColors(treeItem);
            }
        } else {
            int column = 0;
            while (column < columnCount) {
                String text = "";
                Image image = null;
                this.treeColorAndFont.setFontsAndColors(treeItem, element, column);
                if (tprov == null) {
                    if (column == 0) {
                        ViewerLabel updateLabel = new ViewerLabel(treeItem.getText(), treeItem.getImage());
                        if (vprov != null) {
                            this.buildLabel(updateLabel, element, vprov);
                        } else if (lprov != null) {
                            this.buildLabel(updateLabel, element, lprov);
                        }
                        if (treeItem.isDisposed()) {
                            this.unmapElement(element, (Widget)treeItem);
                            return;
                        }
                        text = updateLabel.getText();
                        image = updateLabel.getImage();
                    }
                } else {
                    text = tprov.getColumnText(element, column);
                    image = tprov.getColumnImage(element, column);
                }
                if (text == null) {
                    text = "";
                }
                treeItem.setText(column, text);
                if (treeItem.getImage(column) != image) {
                    treeItem.setImage(column, image);
                }
                ++column;
            }
            this.getColorAndFontCollector().applyFontsAndColors(treeItem);
        }
    }

    protected void buildLabel(ViewerLabel updateLabel, Object elementOrPath) {
        Object element;
        if (elementOrPath instanceof TreePath) {
            TreePath path = (TreePath)elementOrPath;
            IBaseLabelProvider provider = this.getLabelProvider();
            if (provider instanceof ITreePathLabelProvider) {
                ITreePathLabelProvider pprov = (ITreePathLabelProvider)provider;
                this.buildLabel(updateLabel, path, pprov);
                return;
            }
            element = path.getLastSegment();
        } else {
            element = elementOrPath;
        }
        super.buildLabel(updateLabel, element);
    }

    public void editElement(Object element, int column) {
        this.treeViewerImpl.editElement(element, column);
    }

    public CellEditor[] getCellEditors() {
        return this.treeViewerImpl.getCellEditors();
    }

    public ICellModifier getCellModifier() {
        return this.treeViewerImpl.getCellModifier();
    }

    protected Item[] getChildren(Widget o) {
        if (o instanceof TreeItem) {
            return ((TreeItem)o).getItems();
        }
        if (o instanceof Tree) {
            return ((Tree)o).getItems();
        }
        return null;
    }

    public Object[] getColumnProperties() {
        return this.treeViewerImpl.getColumnProperties();
    }

    public Control getControl() {
        return this.tree;
    }

    protected boolean getExpanded(Item item) {
        return ((TreeItem)item).getExpanded();
    }

    protected Item getItem(int x, int y) {
        return this.getTree().getItem(this.getTree().toControl(new Point(x, y)));
    }

    protected int getItemCount(Control widget) {
        return ((Tree)widget).getItemCount();
    }

    protected int getItemCount(Item item) {
        return ((TreeItem)item).getItemCount();
    }

    protected Item[] getItems(Item item) {
        return ((TreeItem)item).getItems();
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected Item getParentItem(Item item) {
        return ((TreeItem)item).getParentItem();
    }

    protected Item[] getSelection(Control widget) {
        return ((Tree)widget).getSelection();
    }

    public Tree getTree() {
        return this.tree;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        Tree treeControl = (Tree)control;
        treeControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TreeViewer.this.treeViewerImpl.handleMouseDown(e);
            }
        });
        if ((treeControl.getStyle() & 0x10000000) != 0) {
            treeControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    TreeViewer.this.treeIsDisposed = true;
                    TreeViewer.this.unmapAllElements();
                }
            });
            treeControl.addListener(36, new Listener(){

                public void handleEvent(Event event) {
                    if (TreeViewer.this.getContentProvider() instanceof ILazyTreeContentProvider) {
                        int index;
                        Object parent;
                        ILazyTreeContentProvider lazyContentProvider = (ILazyTreeContentProvider)TreeViewer.this.getContentProvider();
                        TreeItem item = (TreeItem)event.item;
                        TreeItem parentItem = item.getParentItem();
                        if (parentItem != null) {
                            parent = parentItem.getData();
                            index = parentItem.indexOf(item);
                        } else {
                            parent = TreeViewer.this.getInput();
                            index = TreeViewer.this.getTree().indexOf(item);
                        }
                        lazyContentProvider.updateElement(parent, index);
                    }
                }
            });
        }
    }

    private void initTreeViewerImpl() {
        this.treeViewerImpl = new TreeEditorImpl(this){

            Rectangle getBounds(Item item, int columnNumber) {
                return ((TreeItem)item).getBounds(columnNumber);
            }

            int getColumnCount() {
                return TreeViewer.this.getTree().getColumnCount();
            }

            Item[] getSelection() {
                return TreeViewer.this.getTree().getSelection();
            }

            void setEditor(Control w, Item item, int columnNumber) {
                TreeViewer.this.treeEditor.setEditor(w, (TreeItem)item, columnNumber);
            }

            void setSelection(IStructuredSelection selection, boolean b) {
                TreeViewer.this.setSelection(selection, b);
            }

            void showSelection() {
                TreeViewer.this.getTree().showSelection();
            }

            void setLayoutData(CellEditor.LayoutData layoutData) {
                ((TreeViewer)TreeViewer.this).treeEditor.grabHorizontal = layoutData.grabHorizontal;
                ((TreeViewer)TreeViewer.this).treeEditor.horizontalAlignment = layoutData.horizontalAlignment;
                ((TreeViewer)TreeViewer.this).treeEditor.minimumWidth = layoutData.minimumWidth;
            }

            void handleDoubleClickEvent() {
                StructuredViewer viewer = this.getViewer();
                TreeViewer.this.fireDoubleClick(new DoubleClickEvent(viewer, ((Viewer)viewer).getSelection()));
                TreeViewer.this.fireOpen(new OpenEvent(viewer, ((Viewer)viewer).getSelection()));
            }
        };
    }

    public boolean isCellEditorActive() {
        return this.treeViewerImpl.isCellEditorActive();
    }

    protected Item newItem(Widget parent, int flags, int ix) {
        TreeItem item = ix >= 0 ? (parent instanceof TreeItem ? new TreeItem((TreeItem)parent, flags, ix) : new TreeItem((Tree)parent, flags, ix)) : (parent instanceof TreeItem ? new TreeItem((TreeItem)parent, flags) : new TreeItem((Tree)parent, flags));
        return item;
    }

    protected void removeAll(Control widget) {
        ((Tree)widget).removeAll();
    }

    public void setCellEditors(CellEditor[] editors) {
        this.treeViewerImpl.setCellEditors(editors);
    }

    public void setCellModifier(ICellModifier modifier) {
        this.treeViewerImpl.setCellModifier(modifier);
    }

    public void setColumnProperties(String[] columnProperties) {
        this.treeViewerImpl.setColumnProperties(columnProperties);
    }

    protected void setExpanded(Item node, boolean expand) {
        ((TreeItem)node).setExpanded(expand);
        if (this.getContentProvider() instanceof ILazyTreeContentProvider) {
            this.getControl().update();
        }
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue(labelProvider instanceof ITableLabelProvider || labelProvider instanceof ILabelProvider);
        super.setLabelProvider(labelProvider);
        this.treeColorAndFont = new TreeColorAndFontCollector(labelProvider);
    }

    protected void setSelection(List items) {
        Item[] current = this.getSelection((Control)this.getTree());
        if (this.isSameSelection(items, current)) {
            return;
        }
        TreeItem[] newItems = new TreeItem[items.size()];
        items.toArray(newItems);
        this.getTree().setSelection(newItems);
    }

    protected boolean isSameSelection(List items, Item[] current) {
        int n = items.size();
        if (n != current.length) {
            return false;
        }
        CustomHashtable itemSet = this.newHashtable(n * 2 + 1);
        Iterator i = items.iterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            Object element = item.getData();
            itemSet.put(element, element);
        }
        int i2 = 0;
        while (i2 < current.length) {
            if (current[i2].getData() == null || !itemSet.containsKey(current[i2].getData())) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    protected void showItem(Item item) {
        this.getTree().showItem((TreeItem)item);
    }

    protected Item getChild(Widget widget, int index) {
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getItem(index);
        }
        if (widget instanceof Tree) {
            return ((Tree)widget).getItem(index);
        }
        return null;
    }

    protected void assertContentProviderType(IContentProvider provider) {
        if (provider instanceof ILazyTreeContentProvider) {
            return;
        }
        super.assertContentProviderType(provider);
    }

    protected Object[] getRawChildren(Object parent) {
        if (this.getContentProvider() instanceof ILazyTreeContentProvider) {
            return new Object[0];
        }
        return super.getRawChildren(parent);
    }

    public void setChildCount(Object element, int count) {
        Tree tree = (Tree)this.doFindInputItem(element);
        if (tree != null) {
            tree.setItemCount(count);
            return;
        }
        Widget[] items = this.findItems(element);
        int i = 0;
        while (i < items.length) {
            TreeItem treeItem = (TreeItem)items[i];
            treeItem.setItemCount(count);
            ++i;
        }
    }

    public void replace(Object parent, int index, Object element) {
        if (parent.equals(this.getInput())) {
            if (index < this.tree.getItemCount()) {
                this.updateItem((Widget)this.tree.getItem(index), element);
            }
        } else {
            Widget[] parentItems = this.findItems(parent);
            int i = 0;
            while (i < parentItems.length) {
                TreeItem parentItem = (TreeItem)parentItems[i];
                if (index < parentItem.getItemCount()) {
                    this.updateItem((Widget)parentItem.getItem(index), element);
                }
                ++i;
            }
        }
    }

    public boolean isExpandable(Object element) {
        if (this.getContentProvider() instanceof ILazyTreeContentProvider) {
            TreeItem treeItem = (TreeItem)this.internalExpand(element, false);
            if (treeItem == null) {
                return false;
            }
            this.virtualMaterializeItem(treeItem);
            return treeItem.getItemCount() > 0;
        }
        return super.isExpandable(element);
    }

    protected Object getParentElement(Object element) {
        if (!(element instanceof TreePath) && this.getContentProvider() instanceof ILazyTreeContentProvider) {
            ILazyTreeContentProvider lazyTreeContentProvider = (ILazyTreeContentProvider)this.getContentProvider();
            return lazyTreeContentProvider.getParent(element);
        }
        return super.getParentElement(element);
    }

    protected void createChildren(Widget widget) {
        if (this.getContentProvider() instanceof ILazyTreeContentProvider) {
            Item[] tis = this.getChildren(widget);
            if (tis != null && tis.length > 0) {
                int i = 0;
                while (i < tis.length) {
                    tis[i].getText();
                    ++i;
                }
                return;
            }
            ILazyTreeContentProvider lazyTreeContentProvider = (ILazyTreeContentProvider)this.getContentProvider();
            Object element = widget.getData();
            if (element == null && widget instanceof TreeItem) {
                this.virtualMaterializeItem((TreeItem)widget);
                element = widget.getData();
            }
            TreeItem[] children = widget instanceof Tree ? ((Tree)widget).getItems() : ((TreeItem)widget).getItems();
            if (element != null && children.length > 0) {
                int i = 0;
                while (i < children.length) {
                    lazyTreeContentProvider.updateElement(element, i);
                    ++i;
                }
            }
            return;
        }
        super.createChildren(widget);
    }

    protected void internalAdd(Widget widget, Object parentElement, Object[] childElements) {
        if (this.getContentProvider() instanceof ILazyTreeContentProvider) {
            if (widget instanceof TreeItem) {
                TreeItem ti = (TreeItem)widget;
                int count = ti.getItemCount() + childElements.length;
                ti.setItemCount(count);
                ti.clearAll(false);
            } else {
                Tree t = (Tree)widget;
                t.setItemCount(t.getItemCount() + childElements.length);
                t.clearAll(false);
            }
            return;
        }
        super.internalAdd(widget, parentElement, childElements);
    }

    private void virtualMaterializeItem(TreeItem treeItem) {
        Object parentElement;
        if (treeItem.getData() != null) {
            return;
        }
        if (!(this.getContentProvider() instanceof ILazyTreeContentProvider)) {
            return;
        }
        ILazyTreeContentProvider lazyTreeContentProvider = (ILazyTreeContentProvider)this.getContentProvider();
        TreeItem parent = treeItem.getParentItem();
        if (parent == null) {
            parent = treeItem.getParent();
        }
        if ((parentElement = parent.getData()) != null) {
            int index = parent instanceof Tree ? ((Tree)parent).indexOf(treeItem) : parent.indexOf(treeItem);
            lazyTreeContentProvider.updateElement(parentElement, index);
        }
    }

    protected void internalRefreshStruct(Widget widget, Object element, boolean updateLabels) {
        if (this.getContentProvider() instanceof ILazyTreeContentProvider) {
            this.virtualRefreshChildCounts(widget, element);
            if (updateLabels) {
                if (widget instanceof Tree) {
                    ((Tree)widget).clearAll(true);
                } else if (widget instanceof TreeItem) {
                    ((TreeItem)widget).clearAll(true);
                }
            }
            return;
        }
        super.internalRefreshStruct(widget, element, updateLabels);
    }

    private void virtualRefreshChildCounts(Widget widget, Object element) {
        ILazyTreeContentProvider lazyTreeContentProvider = (ILazyTreeContentProvider)this.getContentProvider();
        if (widget instanceof Tree || ((TreeItem)widget).getExpanded()) {
            if (element != null) {
                lazyTreeContentProvider.updateChildCount(element, this.getChildren(widget).length);
            } else if (widget instanceof Tree) {
                ((Tree)widget).setItemCount(0);
            } else {
                ((TreeItem)widget).setItemCount(0);
            }
            Item[] items = this.getChildren(widget);
            int i = 0;
            while (i < items.length) {
                Item item = items[i];
                Object data = item.getData();
                if (data != null) {
                    this.virtualRefreshChildCounts((Widget)item, data);
                }
                ++i;
            }
        }
    }

    protected void mapElement(Object element, final Widget item) {
        super.mapElement(element, item);
        if ((this.getTree().getStyle() & 0x10000000) != 0) {
            item.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (!TreeViewer.this.treeIsDisposed) {
                        Object data = item.getData();
                        if (TreeViewer.this.usingElementMap() && data != null) {
                            TreeViewer.this.unmapElement(data, item);
                        }
                    }
                }
            });
        }
    }

    private class TreeColorAndFontCollector {
        ITableFontProvider fontProvider = null;
        ITableColorProvider colorProvider = null;

        public TreeColorAndFontCollector(IBaseLabelProvider provider) {
            if (provider instanceof ITableFontProvider) {
                this.fontProvider = (ITableFontProvider)((Object)provider);
            }
            if (provider instanceof ITableColorProvider) {
                this.colorProvider = (ITableColorProvider)((Object)provider);
            }
        }

        public TreeColorAndFontCollector() {
        }

        public void setFontsAndColors(TreeItem treeItem, Object element, int column) {
            if (this.colorProvider != null) {
                treeItem.setBackground(column, this.colorProvider.getBackground(element, column));
                treeItem.setForeground(column, this.colorProvider.getForeground(element, column));
            }
            if (this.fontProvider != null) {
                treeItem.setFont(column, this.fontProvider.getFont(element, column));
            }
        }
    }
}

