/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

class StateReader {
    public static final String STATE_FILE = ".state";
    public static final String LAZY_FILE = ".lazy";
    private static final int BUFFER_SIZE_LAZY = 4096;
    private static final int BUFFER_SIZE_FULLYREAD = 16384;
    private static final SecureAction secureAction = new SecureAction();
    protected Map objectTable = new HashMap();
    private File stateFile;
    private File lazyFile;
    private boolean lazyLoad = true;
    private int numBundles;
    private boolean accessedFlag = false;
    public static final byte STATE_CACHE_VERSION = 25;
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    public static final byte INDEX = 2;
    private WeakHashMap stringCache = new WeakHashMap();
    static /* synthetic */ Class class$0;

    public StateReader() {
        this.lazyLoad = false;
    }

    public StateReader(File stateDirectory) {
        if (!stateDirectory.exists()) {
            stateDirectory.mkdirs();
        }
        this.stateFile = new File(stateDirectory, STATE_FILE);
        this.lazyFile = new File(stateDirectory, LAZY_FILE);
        this.lazyLoad = false;
    }

    public StateReader(File stateFile, File lazyFile, boolean lazyLoad) {
        this.stateFile = stateFile;
        this.lazyFile = lazyFile;
        this.lazyLoad = lazyLoad;
    }

    private void addToObjectTable(Object object, int index) {
        this.objectTable.put(new Integer(index), object);
    }

    private Object getFromObjectTable(int index) {
        return this.objectTable.get(new Integer(index));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readState(StateImpl state, long expectedTimestamp) throws IOException {
        block21: {
            block20: {
                block19: {
                    in = new DataInputStream(new BufferedInputStream(StateReader.secureAction.getFileInputStream(this.stateFile), 16384));
                    lazyIn = null;
                    try {
                        if (in.readByte() != 25) {
lbl6:
                            // 3 sources

                            while (true) {
                                var17_5 = null;
                                break block19;
                                break;
                            }
                        }
                        tag = this.readTag(in);
                        if (tag != 1) ** GOTO lbl6
                        index = in.readInt();
                        timestampRead = in.readLong();
                        if (expectedTimestamp < 0L || timestampRead == expectedTimestamp) ** break;
                        ** continue;
                        this.addToObjectTable(state, index);
                        numSets = in.readInt();
                        platformProps = new Dictionary[numSets];
                        i = 0;
                        block9: while (true) {
                            if (i >= numSets) {
                                state.setPlatformProperties(platformProps, false);
                                this.numBundles = in.readInt();
                                if (this.numBundles != 0) break;
                                break block20;
                            }
                            props = new Hashtable<String, Object>(StateImpl.PROPS.length);
                            numProps = in.readInt();
                            j = 0;
                            while (true) {
                                if (j >= numProps) {
                                    platformProps[i] = props;
                                    ++i;
                                    continue block9;
                                }
                                value = this.readPlatformProp(in);
                                if (value != null && j < StateImpl.PROPS.length) {
                                    props.put(StateImpl.PROPS[j], value);
                                }
                                ++j;
                            }
                            break;
                        }
                        i = 0;
                        while (true) {
                            if (i >= this.numBundles) {
                                state.setTimeStamp(timestampRead);
                                state.setResolved(in.readBoolean());
                                if (!this.lazyLoad) break;
                                break block20;
                            }
                            bundle = this.readBundleDescription(in);
                            state.basicAddBundle(bundle);
                            if (bundle.isResolved()) {
                                state.addResolvedBundle(bundle);
                            }
                            ++i;
                        }
                        lazyIn = new DataInputStream(new BufferedInputStream(StateReader.secureAction.getFileInputStream(this.lazyFile), 16384));
                        i = 0;
                        while (i < this.numBundles) {
                            this.readBundleDescriptionLazyData((DataInputStream)lazyIn, 0);
                            ++i;
                        }
                        break block21;
                    }
                    catch (Throwable var18_19) {
                        var17_7 = null;
                        in.close();
                        if (lazyIn == null) throw var18_19;
                        try {
                            lazyIn.close();
                            throw var18_19;
                        }
                        catch (IOException v0) {}
                        throw var18_19;
                    }
                }
                in.close();
                if (lazyIn == null) return false;
                try {}
                catch (IOException v1) {}
                lazyIn.close();
                return false;
                return false;
            }
            var17_6 = null;
            in.close();
            if (lazyIn == null) return true;
            try {}
            catch (IOException v2) {}
            lazyIn.close();
            return true;
            return true;
        }
        var17_8 = null;
        in.close();
        if (lazyIn == null) return true;
        try {}
        catch (IOException v3) {
            return true;
        }
        lazyIn.close();
        return true;
    }

    private boolean readStateDeprecated(StateImpl state, DataInputStream in, long expectedTimestamp) throws IOException {
        if (in.readByte() != 25) {
            return false;
        }
        byte tag = this.readTag(in);
        if (tag != 1) {
            return false;
        }
        int index = in.readInt();
        long timestampRead = in.readLong();
        if (expectedTimestamp >= 0L && timestampRead != expectedTimestamp) {
            return false;
        }
        this.addToObjectTable(state, index);
        int numSets = in.readInt();
        Dictionary[] platformProps = new Dictionary[numSets];
        int i = 0;
        while (i < numSets) {
            Hashtable<String, Object> props = new Hashtable<String, Object>(StateImpl.PROPS.length);
            int numProps = in.readInt();
            int j = 0;
            while (j < numProps) {
                Object value = this.readPlatformProp(in);
                if (value != null && j < StateImpl.PROPS.length) {
                    props.put(StateImpl.PROPS[j], value);
                }
                ++j;
            }
            platformProps[i] = props;
            ++i;
        }
        state.setPlatformProperties(platformProps);
        this.numBundles = in.readInt();
        if (this.numBundles == 0) {
            return true;
        }
        i = 0;
        while (i < this.numBundles) {
            BundleDescriptionImpl bundle = this.readBundleDescription(in);
            state.basicAddBundle(bundle);
            if (bundle.isResolved()) {
                state.addResolvedBundle(bundle);
            }
            ++i;
        }
        state.setTimeStamp(timestampRead);
        state.setResolved(in.readBoolean());
        in.readInt();
        if (this.lazyLoad) {
            return true;
        }
        i = 0;
        while (i < this.numBundles) {
            this.readBundleDescriptionLazyData(in, 0);
            ++i;
        }
        return true;
    }

    private Object readPlatformProp(DataInputStream in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        int num = in.readInt();
        if (num == 1) {
            return this.readString(in, false);
        }
        String[] result = new String[num];
        int i = 0;
        while (i < result.length) {
            result[i] = this.readString(in, false);
            ++i;
        }
        return result;
    }

    private BundleDescriptionImpl readBundleDescription(DataInputStream in) throws IOException {
        BundleDescription[] hosts;
        HostSpecificationImpl hostSpec;
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        if (tag == 2) {
            return (BundleDescriptionImpl)this.getFromObjectTable(in.readInt());
        }
        BundleDescriptionImpl result = new BundleDescriptionImpl();
        this.addToObjectTable(result, in.readInt());
        result.setBundleId(in.readLong());
        this.readBaseDescription(result, in);
        result.setLazyDataOffset(in.readInt());
        result.setLazyDataSize(in.readInt());
        result.setStateBit(1, in.readBoolean());
        result.setStateBit(2, in.readBoolean());
        result.setStateBit(32, in.readBoolean());
        result.setStateBit(64, in.readBoolean());
        result.setStateBit(128, in.readBoolean());
        result.setHost(this.readHostSpec(in));
        int numDeps = in.readInt();
        if (numDeps > 0) {
            BaseDescription[] deps = new BundleDescription[numDeps];
            int i = 0;
            while (i < numDeps) {
                deps[i] = this.readBundleDescription(in);
                ++i;
            }
            result.addDependencies(deps, false);
        }
        if ((hostSpec = (HostSpecificationImpl)result.getHost()) != null && (hosts = hostSpec.getHosts()) != null) {
            int i = 0;
            while (i < hosts.length) {
                ((BundleDescriptionImpl)hosts[i]).addDependency(result, false);
                ++i;
            }
        }
        result.setFullyLoaded(false);
        return result;
    }

    private BundleDescriptionImpl readBundleDescriptionLazyData(DataInputStream in, int skip) throws IOException {
        int genericReqCnt;
        int genericCapCnt;
        int dynamicPkgCnt;
        int eeCount;
        int resolvedRequiredCount;
        int resolvedCount;
        int selectedCount;
        int requiredBundleCount;
        int importCount;
        int index;
        BundleDescriptionImpl result;
        if (skip > 0) {
            in.skipBytes(skip);
        }
        if ((result = (BundleDescriptionImpl)this.getFromObjectTable(index = in.readInt())).isFullyLoaded()) {
            in.skipBytes(result.getLazyDataSize() - 4);
            return result;
        }
        result.setLocation(this.readString(in, false));
        result.setPlatformFilter(this.readString(in, false));
        int exportCount = in.readInt();
        if (exportCount > 0) {
            ExportPackageDescription[] exports = new ExportPackageDescription[exportCount];
            int i = 0;
            while (i < exports.length) {
                exports[i] = this.readExportPackageDesc(in);
                ++i;
            }
            result.setExportPackages(exports);
        }
        if ((importCount = in.readInt()) > 0) {
            ImportPackageSpecification[] imports = new ImportPackageSpecification[importCount];
            int i = 0;
            while (i < imports.length) {
                imports[i] = this.readImportPackageSpec(in);
                ++i;
            }
            result.setImportPackages(imports);
        }
        if ((requiredBundleCount = in.readInt()) > 0) {
            BundleSpecification[] requiredBundles = new BundleSpecification[requiredBundleCount];
            int i = 0;
            while (i < requiredBundles.length) {
                requiredBundles[i] = this.readBundleSpec(in);
                ++i;
            }
            result.setRequiredBundles(requiredBundles);
        }
        if ((selectedCount = in.readInt()) > 0) {
            ExportPackageDescription[] selected = new ExportPackageDescription[selectedCount];
            int i = 0;
            while (i < selected.length) {
                selected[i] = this.readExportPackageDesc(in);
                ++i;
            }
            result.setSelectedExports(selected);
        }
        if ((resolvedCount = in.readInt()) > 0) {
            ExportPackageDescription[] resolved = new ExportPackageDescription[resolvedCount];
            int i = 0;
            while (i < resolved.length) {
                resolved[i] = this.readExportPackageDesc(in);
                ++i;
            }
            result.setResolvedImports(resolved);
        }
        if ((resolvedRequiredCount = in.readInt()) > 0) {
            BundleDescription[] resolved = new BundleDescription[resolvedRequiredCount];
            int i = 0;
            while (i < resolved.length) {
                resolved[i] = this.readBundleDescription(in);
                ++i;
            }
            result.setResolvedRequires(resolved);
        }
        if ((eeCount = in.readInt()) > 0) {
            String[] ee = new String[eeCount];
            int i = 0;
            while (i < ee.length) {
                ee[i] = this.readString(in, false);
                ++i;
            }
            result.setExecutionEnvironments(ee);
        }
        if ((dynamicPkgCnt = in.readInt()) > 0) {
            HashMap<String, Long> dynamicStamps = new HashMap<String, Long>(dynamicPkgCnt);
            int i = 0;
            while (i < dynamicPkgCnt) {
                String pkg = this.readString(in, false);
                Long stamp = new Long(in.readLong());
                dynamicStamps.put(pkg, stamp);
                ++i;
            }
            result.setDynamicStamps(dynamicStamps);
        }
        if ((genericCapCnt = in.readInt()) > 0) {
            GenericDescription[] capabilities = new GenericDescription[genericCapCnt];
            int i = 0;
            while (i < capabilities.length) {
                capabilities[i] = this.readGenericDescription(in);
                ++i;
            }
            result.setGenericCapabilities(capabilities);
        }
        if ((genericReqCnt = in.readInt()) > 0) {
            GenericSpecification[] reqs = new GenericSpecification[genericReqCnt];
            int i = 0;
            while (i < reqs.length) {
                reqs[i] = this.readGenericSpecification(in);
                ++i;
            }
            result.setGenericRequires(reqs);
        }
        result.setFullyLoaded(true);
        return result;
    }

    private BundleSpecificationImpl readBundleSpec(DataInputStream in) throws IOException {
        BundleSpecificationImpl result = new BundleSpecificationImpl();
        this.readVersionConstraint(result, in);
        result.setSupplier(this.readBundleDescription(in));
        result.setExported(in.readBoolean());
        result.setOptional(in.readBoolean());
        return result;
    }

    private ExportPackageDescriptionImpl readExportPackageDesc(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        if (tag == 2) {
            return (ExportPackageDescriptionImpl)this.getFromObjectTable(in.readInt());
        }
        ExportPackageDescriptionImpl exportPackageDesc = new ExportPackageDescriptionImpl();
        int tableIndex = in.readInt();
        this.addToObjectTable(exportPackageDesc, tableIndex);
        exportPackageDesc.setTableIndex(tableIndex);
        this.readBaseDescription(exportPackageDesc, in);
        exportPackageDesc.setRoot(in.readBoolean());
        exportPackageDesc.setAttributes(this.readMap(in));
        exportPackageDesc.setDirectives(this.readMap(in));
        return exportPackageDesc;
    }

    private Map readMap(DataInputStream in) throws IOException {
        int count = in.readInt();
        if (count == 0) {
            return null;
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>(count);
        int i = 0;
        while (i < count) {
            String key = this.readString(in, false);
            Object value = null;
            byte type = in.readByte();
            if (type == 0) {
                value = this.readString(in, false);
            } else if (type == 1) {
                value = this.readList(in);
            } else if (type == 2) {
                value = in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            } else if (type == 3) {
                value = new Integer(in.readInt());
            } else if (type == 4) {
                value = new Long(in.readLong());
            } else if (type == 5) {
                value = new Double(in.readDouble());
            } else if (type == 6) {
                value = this.readVersion(in);
            } else if (type == 7) {
                value = this.readString(in, false);
                try {
                    Class<?> uriClazz = Class.forName("java.net.URI");
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Constructor<?> constructor = uriClazz.getConstructor(classArray);
                    value = constructor.newInstance(value);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e.getMessage());
                }
            }
            result.put(key, (String[])value);
            ++i;
        }
        return result;
    }

    private String[] readList(DataInputStream in) throws IOException {
        int count = in.readInt();
        if (count == 0) {
            return null;
        }
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = this.readString(in, false);
            ++i;
        }
        return result;
    }

    private void readBaseDescription(BaseDescriptionImpl root, DataInputStream in) throws IOException {
        root.setName(this.readString(in, false));
        root.setVersion(this.readVersion(in));
    }

    private ImportPackageSpecificationImpl readImportPackageSpec(DataInputStream in) throws IOException {
        ImportPackageSpecificationImpl result = new ImportPackageSpecificationImpl();
        this.readVersionConstraint(result, in);
        result.setSupplier(this.readExportPackageDesc(in));
        result.setBundleSymbolicName(this.readString(in, false));
        result.setBundleVersionRange(this.readVersionRange(in));
        result.setAttributes(this.readMap(in));
        result.setDirectives(this.readMap(in));
        return result;
    }

    private HostSpecificationImpl readHostSpec(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        HostSpecificationImpl result = new HostSpecificationImpl();
        this.readVersionConstraint(result, in);
        int hostCount = in.readInt();
        if (hostCount > 0) {
            BundleDescription[] hosts = new BundleDescription[hostCount];
            int i = 0;
            while (i < hosts.length) {
                hosts[i] = this.readBundleDescription(in);
                ++i;
            }
            result.setHosts(hosts);
        }
        return result;
    }

    private GenericDescription readGenericDescription(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        if (tag == 2) {
            return (GenericDescription)this.getFromObjectTable(in.readInt());
        }
        int tableIndex = in.readInt();
        GenericDescriptionImpl result = new GenericDescriptionImpl();
        this.addToObjectTable(result, tableIndex);
        this.readBaseDescription(result, in);
        result.setType(this.readString(in, false));
        Map mapAttrs = this.readMap(in);
        Hashtable attrs = new Hashtable();
        if (mapAttrs != null) {
            Iterator keys = mapAttrs.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                ((Dictionary)attrs).put(key, mapAttrs.get(key));
            }
        }
        result.setAttributes(attrs);
        return result;
    }

    private GenericSpecification readGenericSpecification(DataInputStream in) throws IOException {
        GenericSpecificationImpl result = new GenericSpecificationImpl();
        this.readVersionConstraint(result, in);
        result.setType(this.readString(in, false));
        int num = in.readInt();
        GenericDescription[] suppliers = num == 0 ? null : new GenericDescription[num];
        int i = 0;
        while (i < num) {
            suppliers[i] = this.readGenericDescription(in);
            ++i;
        }
        result.setSupplers(suppliers);
        result.setResolution(in.readInt());
        try {
            result.setMatchingFilter(this.readString(in, false));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return result;
    }

    private void readVersionConstraint(VersionConstraintImpl version, DataInputStream in) throws IOException {
        version.setName(this.readString(in, false));
        version.setVersionRange(this.readVersionRange(in));
    }

    private Version readVersion(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return Version.emptyVersion;
        }
        int majorComponent = in.readInt();
        int minorComponent = in.readInt();
        int serviceComponent = in.readInt();
        String qualifierComponent = this.readString(in, false);
        Version result = new Version(majorComponent, minorComponent, serviceComponent, qualifierComponent);
        return result;
    }

    private VersionRange readVersionRange(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        return new VersionRange(this.readVersion(in), in.readBoolean(), this.readVersion(in), in.readBoolean());
    }

    public final boolean loadStateDeprecated(StateImpl state, DataInputStream input, long expectedTimestamp) throws IOException {
        boolean bl;
        try {
            bl = this.readStateDeprecated(state, input, expectedTimestamp);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            input.close();
            throw throwable;
        }
        input.close();
        return bl;
    }

    public final boolean loadState(StateImpl state, long expectedTimestamp) throws IOException {
        return this.readState(state, expectedTimestamp);
    }

    private String readString(DataInputStream in, boolean intern) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        String result = intern ? in.readUTF().intern() : in.readUTF();
        WeakReference ref = (WeakReference)this.stringCache.get(result);
        if (ref != null) {
            String refString = (String)ref.get();
            if (refString != null) {
                result = refString;
            }
        } else {
            this.stringCache.put(result, new WeakReference<String>(result));
        }
        return result;
    }

    private byte readTag(DataInputStream in) throws IOException {
        return in.readByte();
    }

    private DataInputStream openLazyFile() throws IOException {
        if (this.lazyFile == null) {
            throw new IOException();
        }
        return new DataInputStream(new BufferedInputStream(secureAction.getFileInputStream(this.lazyFile), 4096));
    }

    boolean isLazyLoaded() {
        return this.lazyLoad;
    }

    boolean getAccessedFlag() {
        return this.accessedFlag;
    }

    void setAccessedFlag(boolean accessedFlag) {
        this.accessedFlag = accessedFlag;
    }

    /*
     * Exception decompiling
     */
    synchronized void fullyLoad() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 70->74)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    synchronized void fullyLoad(BundleDescriptionImpl target) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 84->88)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addDependencies(BundleDescriptionImpl target, List toLoad) {
        if (toLoad.contains(target) || target.isFullyLoaded()) {
            return;
        }
        Iterator load = toLoad.iterator();
        int i = 0;
        while (load.hasNext()) {
            BundleDescriptionImpl bundle = (BundleDescriptionImpl)load.next();
            if (target.getLazyDataOffset() < bundle.getLazyDataOffset()) break;
            ++i;
        }
        if (i >= toLoad.size()) {
            toLoad.add(target);
        } else {
            toLoad.add(i, target);
        }
        List deps = target.getBundleDependencies();
        Iterator iter = deps.iterator();
        while (iter.hasNext()) {
            this.addDependencies((BundleDescriptionImpl)iter.next(), toLoad);
        }
    }

    private int[] getSkipBytes(ArrayList toLoad) {
        int[] skipBytes = new int[toLoad.size()];
        int i = 0;
        while (i < skipBytes.length) {
            BundleDescriptionImpl current = (BundleDescriptionImpl)toLoad.get(i);
            if (i == 0) {
                skipBytes[i] = current.getLazyDataOffset();
            } else {
                BundleDescriptionImpl previous = (BundleDescriptionImpl)toLoad.get(i - 1);
                skipBytes[i] = current.getLazyDataOffset() - previous.getLazyDataOffset() - previous.getLazyDataSize();
            }
            ++i;
        }
        return skipBytes;
    }
}

