/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import jp.sourceforge.akjrcp.util.PrintStreamProcessPrinter;
import jp.sourceforge.akjrcp.util.ProcessMonitor;

public class FileCopy {
    private static int MAX_COPY = 0x400000;
    private File srcFile;
    private File destFile;
    private boolean canceling;
    Process process;

    public FileCopy(File srcFile, File destFile) {
        this.srcFile = srcFile;
        this.destFile = destFile;
    }

    public boolean isCanceling() {
        return this.canceling;
    }

    public void setCanceling(boolean canceling) {
        this.canceling = canceling;
        if (canceling && this.process != null) {
            this.process.destroy();
        }
    }

    public File getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(File srcFile) {
        this.srcFile = srcFile;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public int exec() throws IOException {
        String[] command = new String[]{"cmd.exe", "/c", "copy", "/b", this.getSrcFile().getAbsolutePath(), this.getDestFile().getAbsolutePath()};
        Runtime r = Runtime.getRuntime();
        try {
            PrintStreamProcessPrinter s = new PrintStreamProcessPrinter(new PrintWriter(System.out));
            this.process = r.exec(command);
            ProcessMonitor monitor = new ProcessMonitor(this.process, s);
            monitor.startMonitor();
            try {
                this.process.waitFor();
                int result = this.process.exitValue();
                if (result != 0) {
                    return result;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.canceling) {
            return 1;
        }
        return 0;
    }
}

