/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.psp.commands;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.psp.PSPSyncView;
import jp.sourceforge.akjrcp.psp.commands.AbstractIOCommand;
import jp.sourceforge.akjrcp.util.FileCopy;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import org.apache.commons.io.FileUtils;

public class PSPCopyCommand
extends AbstractIOCommand {
    FileCopy fileCopy;

    public PSPCopyCommand(File src, File dest, boolean overwrite) {
        this.setSrcFile(src);
        this.setDestFile(dest);
        this.setOverwrite(overwrite);
    }

    public void setCanceld(boolean canceld) {
        super.setCanceld(canceld);
        if (this.fileCopy != null) {
            this.fileCopy.setCanceling(canceld);
        }
    }

    public int execCommand() {
        int ret = 0;
        if (!this.getSrcFile().exists()) {
            ret = 1;
        }
        try {
            if (!PSPCopyCommand.canWrite(this.getDestFile())) {
                ret = 2;
                return ret;
            }
            this.fileCopy = new FileCopy(this.getSrcFile(), this.getDestFile());
            int result = this.fileCopy.exec();
            if (result != 0) {
                if (this.getDestFile().exists()) {
                    this.getDestFile().delete();
                }
                ret = 4;
                return ret;
            }
            PSPSyncView.log.info((Object)"copied-movie");
        }
        catch (IOException e) {
            e.printStackTrace();
            ret = 2;
            return ret;
        }
        File imgFile = new File(FileNameUtils.getChangedExtensionName(this.getSrcFile(), "jpg", true));
        if (imgFile.exists()) {
            File newFile = new File(FileNameUtils.getChangedExtensionName(this.getDestFile(), "jpg", true));
            try {
                FileUtils.copyFile((File)imgFile, (File)newFile);
                PSPSyncView.log.info((Object)"copied-image");
            }
            catch (IOException e) {
                PSPSyncView.log.warn((Object)"image copy faild:+imgFile");
                e.printStackTrace();
            }
        }
        return ret;
    }

    public String toString() {
        String label = this.isOverwrite() ? "Copy_Overwrite:" + this.getSrcFile() + "," + this.getDestFile() : "Copy:" + this.getSrcFile() + "," + this.getDestFile();
        return label;
    }
}

