/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;

public class JpegPipeWriter {
    OutputStream outputStream;
    private float quality = 1.0f;

    public JpegPipeWriter(OutputStream output) {
        this.outputStream = output;
    }

    public void writeJpeg(BufferedImage image) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        JpegPipeWriter.writeJpegWithQuality(image, bout, this.quality);
        bout.close();
        byte[] jpegbyte = bout.toByteArray();
        this.outputStream.write(jpegbyte);
    }

    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    public void writeJpeg(InputStream input) throws IOException {
        int b;
        while ((b = input.read()) != -1) {
            this.outputStream.write(b);
        }
        input.close();
    }

    private static void writeJpegWithQuality(BufferedImage image, OutputStream output, float quality) throws IOException {
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> imageWriterIterator = ImageIO.getImageWritersByFormatName("jpeg");
        if (imageWriterIterator.hasNext()) {
            imageWriter = imageWriterIterator.next();
        }
        if (imageWriter == null) {
            throw new IOException("imageWriter not found");
        }
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(output);
        imageWriter.setOutput(imageOutputStream);
        IIOImage iioImage = new IIOImage(image, null, null);
        JPEGImageWriteParam imageWriteParam = new JPEGImageWriteParam(null);
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(quality);
        imageWriter.write(null, iioImage, imageWriteParam);
        imageOutputStream.flush();
    }
}

